/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.area;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaLayerModelImpl;
import de.datomino.peppergis.client.model.area.DetaillessLevelModel;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.area.DetaillessLevelFullDto;
import de.datomino.peppergis.dto.area.DetaillessLevelProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class DetaillessLevelModelImpl
extends AbstractModel<DetaillessLevelFullDto, DetaillessLevelProxyDto>
implements DetaillessLevelModel {
    private AreaLayerModel areaLayer;
    private Double fromScale;
    private Double tolerance;

    public DetaillessLevelModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public DetaillessLevelModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public AreaLayerModel getAreaLayer() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.areaLayer;
    }

    @Override
    public void setAreaLayer(AreaLayerModel areaLayer) {
        this.setAreaLayer(areaLayer, true);
    }

    private void setAreaLayer(AreaLayerModel areaLayer, boolean setDirty) {
        AreaLayerModel oldAreaLayer = this.getAreaLayer();
        if (oldAreaLayer == areaLayer) {
            return;
        }
        if (oldAreaLayer != null) {
            oldAreaLayer.removeDetaillessLevel(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DetaillessLevelModelEnum.AREA_LAYER.getPropertyName());
        }
        this.areaLayer = areaLayer;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DetaillessLevelModelEnum.AREA_LAYER, areaLayer, oldAreaLayer);
        if (this.areaLayer != null) {
            this.areaLayer.addDetaillessLevel(this);
        }
    }

    @Override
    public Double getFromScale() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.fromScale;
    }

    @Override
    public void setFromScale(Double fromScale) {
        this.setFromScale(fromScale, true);
    }

    private void setFromScale(Double fromScale, boolean setDirty) {
        Double oldFromScale = this.getFromScale();
        if (new EqualsBuilder().append(oldFromScale, fromScale).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DetaillessLevelModelEnum.FROM_SCALE.getPropertyName());
        }
        this.fromScale = fromScale;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DetaillessLevelModelEnum.FROM_SCALE, fromScale, oldFromScale);
    }

    @Override
    public Double getTolerance() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.tolerance;
    }

    @Override
    public void setTolerance(Double tolerance) {
        this.setTolerance(tolerance, true);
    }

    private void setTolerance(Double tolerance, boolean setDirty) {
        Double oldTolerance = this.getTolerance();
        if (new EqualsBuilder().append(oldTolerance, tolerance).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DetaillessLevelModelEnum.TOLERANCE.getPropertyName());
        }
        this.tolerance = tolerance;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DetaillessLevelModelEnum.TOLERANCE, tolerance, oldTolerance);
    }

    @Override
    protected void updateByDto(DetaillessLevelFullDto detaillessLevelDto) {
        this.areaLayer = (AreaLayerModel)this.getModelCache().getModel(detaillessLevelDto.getAreaLayer());
        this.fromScale = detaillessLevelDto.getFromScale();
        this.tolerance = detaillessLevelDto.getTolerance();
    }

    @Override
    protected void updateMasterRelationsByDto(DetaillessLevelFullDto detaillessLevelDto) {
    }

    @Override
    protected void checkStaleByDto(DetaillessLevelFullDto detaillessLevelDto) throws StaleStateException {
        AreaLayerModelImpl areaLayerModel;
        AreaLayerDto areaLayerDto = detaillessLevelDto.getAreaLayer();
        if (areaLayerDto != null && areaLayerDto.getId() != null && (areaLayerModel = (AreaLayerModelImpl)this.getModelCache().getModel(AreaLayerModel.class, areaLayerDto.getId())) != null) {
            areaLayerModel.checkStaleState(areaLayerDto);
        }
    }

    @Override
    public DetaillessLevelFullDto createDto() {
        Long id = this.getId();
        DetaillessLevelFullDto detaillessLevelDto = id == null ? new DetaillessLevelFullDto(this.getTempUUID()) : new DetaillessLevelFullDto(id, this.getVersion());
        AreaLayerModelImpl areaLayer = (AreaLayerModelImpl)this.getAreaLayer();
        if (areaLayer != null) {
            detaillessLevelDto.setAreaLayer(areaLayer.createProxy());
        }
        detaillessLevelDto.setFromScale(this.getFromScale());
        detaillessLevelDto.setTolerance(this.getTolerance());
        return detaillessLevelDto;
    }

    @Override
    public DetaillessLevelProxyDto createProxy() {
        Long id = this.getId();
        DetaillessLevelProxyDto detaillessLevelDto = id == null ? new DetaillessLevelProxyDto(this.getTempUUID()) : new DetaillessLevelProxyDto(id, this.getVersion());
        return detaillessLevelDto;
    }

    public static enum DetaillessLevelModelEnum {
        AREA_LAYER("areaLayer"),
        FROM_SCALE("fromScale"),
        TOLERANCE("tolerance");

        private String propertyName;

        private DetaillessLevelModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

