/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.area;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModel;
import de.datomino.peppergis.client.model.area.ParcelSortOrderModel;
import de.datomino.peppergis.client.model.area.ParcelSortOrderModelImpl;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.ParcelModelImpl;
import de.datomino.peppergis.dto.area.AreaObjectDto;
import de.datomino.peppergis.dto.area.AreaObjectParcelRelFullDto;
import de.datomino.peppergis.dto.area.AreaObjectParcelRelProxyDto;
import de.datomino.peppergis.dto.area.ParcelSortOrderDto;
import de.datomino.peppergis.dto.map.ParcelDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class AreaObjectParcelRelModelImpl
extends AbstractModel<AreaObjectParcelRelFullDto, AreaObjectParcelRelProxyDto>
implements AreaObjectParcelRelModel {
    private AreaObjectModel areaObject;
    private ParcelModel parcel;
    private Set<ParcelSortOrderModel> sortOrders = null;

    public AreaObjectParcelRelModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public AreaObjectParcelRelModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public AreaObjectModel getAreaObject() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.areaObject;
    }

    @Override
    public void setAreaObject(AreaObjectModel areaObject) {
        this.setAreaObject(areaObject, true);
    }

    private void setAreaObject(AreaObjectModel areaObject, boolean setDirty) {
        AreaObjectModel oldAreaObject = this.getAreaObject();
        if (oldAreaObject == areaObject) {
            return;
        }
        if (oldAreaObject != null) {
            oldAreaObject.removeAAreaObjectParcelRel(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaObjectParcelRelModelEnum.AREA_OBJECT.getPropertyName());
        }
        this.areaObject = areaObject;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaObjectParcelRelModelEnum.AREA_OBJECT, areaObject, oldAreaObject);
        if (this.areaObject != null) {
            this.areaObject.addAAreaObjectParcelRel(this);
        }
    }

    @Override
    public ParcelModel getParcel() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.parcel;
    }

    @Override
    public void setParcel(ParcelModel parcel) {
        this.setParcel(parcel, true);
    }

    private void setParcel(ParcelModel parcel, boolean setDirty) {
        ParcelModel oldParcel = this.getParcel();
        if (oldParcel == parcel) {
            return;
        }
        if (oldParcel != null) {
            oldParcel.removeAAreaObjectParcelRel(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaObjectParcelRelModelEnum.PARCEL.getPropertyName());
        }
        this.parcel = parcel;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaObjectParcelRelModelEnum.PARCEL, parcel, oldParcel);
        if (this.parcel != null) {
            this.parcel.addAAreaObjectParcelRel(this);
        }
    }

    @Override
    public int countSortOrders() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.sortOrders == null) {
            this.sortOrders = new LinkedHashSet<ParcelSortOrderModel>();
            if (this.getId() != null) {
                Collection sortOrdersCollection = this.commonCaller.fetchChildren(this, AreaObjectParcelRelModelEnum.SORT_ORDERS.getPropertyName());
                this.sortOrders.addAll(sortOrdersCollection);
            }
        }
        return this.sortOrders.size();
    }

    @Override
    public Iterator<ParcelSortOrderModel> iterateSortOrders() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.sortOrders == null) {
            this.sortOrders = new LinkedHashSet<ParcelSortOrderModel>();
            if (this.getId() != null) {
                Collection sortOrdersCollection = this.commonCaller.fetchChildren(this, AreaObjectParcelRelModelEnum.SORT_ORDERS.getPropertyName());
                this.sortOrders.addAll(sortOrdersCollection);
            }
        }
        return new ImmutableIterator<ParcelSortOrderModel>(this.sortOrders);
    }

    @Override
    public Iterable<ParcelSortOrderModel> iterableSortOrders() {
        return new IteratorIterable<ParcelSortOrderModel>(this.iterateSortOrders());
    }

    @Override
    public void addSortOrder(ParcelSortOrderModel sortOrder) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.sortOrders == null) {
            this.sortOrders = new LinkedHashSet<ParcelSortOrderModel>();
            if (this.getId() != null) {
                Collection sortOrdersCollection = this.commonCaller.fetchChildren(this, AreaObjectParcelRelModelEnum.SORT_ORDERS.getPropertyName());
                this.sortOrders.addAll(sortOrdersCollection);
            }
        }
        if (this.sortOrders.contains(sortOrder)) {
            return;
        }
        this.sortOrders.add(sortOrder);
        this.fireValueChanged(AreaObjectParcelRelModelEnum.SORT_ORDERS, sortOrder, null);
        if (sortOrder != null) {
            sortOrder.setAreaObjectParcelRel(this);
        }
    }

    @Override
    public void removeSortOrder(ParcelSortOrderModel sortOrder) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.sortOrders == null) {
            this.sortOrders = new LinkedHashSet<ParcelSortOrderModel>();
            if (this.getId() != null) {
                Collection sortOrdersCollection = this.commonCaller.fetchChildren(this, AreaObjectParcelRelModelEnum.SORT_ORDERS.getPropertyName());
                this.sortOrders.addAll(sortOrdersCollection);
            }
        }
        if (!this.sortOrders.contains(sortOrder)) {
            return;
        }
        this.sortOrders.remove(sortOrder);
        this.fireValueChanged(AreaObjectParcelRelModelEnum.SORT_ORDERS, sortOrder, null);
        if (sortOrder != null) {
            sortOrder.setAreaObjectParcelRel(null);
        }
    }

    @Override
    public void clearSortOrders() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.sortOrders == null) {
            this.sortOrders = new LinkedHashSet<ParcelSortOrderModel>();
            if (this.getId() != null) {
                Collection sortOrdersCollection = this.commonCaller.fetchChildren(this, AreaObjectParcelRelModelEnum.SORT_ORDERS.getPropertyName());
                this.sortOrders.addAll(sortOrdersCollection);
            }
        }
        ArrayList<ParcelSortOrderModel> oldSortOrders = new ArrayList<ParcelSortOrderModel>(this.sortOrders);
        this.sortOrders.clear();
        this.fireValueChanged(AreaObjectParcelRelModelEnum.SORT_ORDERS, null, null);
        for (ParcelSortOrderModel oldSortOrder : oldSortOrders) {
            if (oldSortOrder == null) continue;
            oldSortOrder.setAreaObjectParcelRel(null);
        }
    }

    @Override
    public boolean isSortOrdersEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.sortOrders == null) {
            this.sortOrders = new LinkedHashSet<ParcelSortOrderModel>();
            if (this.getId() != null) {
                Collection sortOrdersCollection = this.commonCaller.fetchChildren(this, AreaObjectParcelRelModelEnum.SORT_ORDERS.getPropertyName());
                this.sortOrders.addAll(sortOrdersCollection);
            }
        }
        return this.sortOrders.isEmpty();
    }

    @Override
    public boolean containsSortOrder(ParcelSortOrderModel sortOrder) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.sortOrders == null) {
            this.sortOrders = new LinkedHashSet<ParcelSortOrderModel>();
            if (this.getId() != null) {
                Collection sortOrdersCollection = this.commonCaller.fetchChildren(this, AreaObjectParcelRelModelEnum.SORT_ORDERS.getPropertyName());
                this.sortOrders.addAll(sortOrdersCollection);
            }
        }
        return this.sortOrders.contains(sortOrder);
    }

    @Override
    public boolean isSortOrdersInitialized() {
        return this.sortOrders != null;
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.sortOrders = null;
        }
    }

    @Override
    protected void updateByDto(AreaObjectParcelRelFullDto areaObjectParcelRelDto) {
        this.areaObject = (AreaObjectModel)this.getModelCache().getModel(areaObjectParcelRelDto.getAreaObject());
        this.parcel = (ParcelModel)this.getModelCache().getModel(areaObjectParcelRelDto.getParcel());
        ParcelSortOrderDto[] sortOrders = areaObjectParcelRelDto.getSortOrders();
        if (sortOrders != null) {
            if (this.sortOrders == null) {
                this.sortOrders = new LinkedHashSet<ParcelSortOrderModel>();
            } else {
                this.sortOrders.clear();
            }
        }
    }

    @Override
    protected void updateMasterRelationsByDto(AreaObjectParcelRelFullDto areaObjectParcelRelDto) {
        ParcelSortOrderDto[] sortOrders = areaObjectParcelRelDto.getSortOrders();
        if (sortOrders != null) {
            if (this.sortOrders == null) {
                this.sortOrders = new LinkedHashSet<ParcelSortOrderModel>();
            } else {
                this.sortOrders.clear();
            }
            for (ParcelSortOrderDto sortOrderDto : sortOrders) {
                ParcelSortOrderModel sortOrderModel = (ParcelSortOrderModel)this.getModelCache().getModel(sortOrderDto);
                this.sortOrders.add(sortOrderModel);
            }
        } else {
            this.sortOrders = null;
        }
    }

    @Override
    protected void checkStaleByDto(AreaObjectParcelRelFullDto areaObjectParcelRelDto) throws StaleStateException {
        ParcelSortOrderDto[] sortOrderDtos;
        ParcelModelImpl parcelModel;
        ParcelDto parcelDto;
        AreaObjectModelImpl areaObjectModel;
        AreaObjectDto areaObjectDto = areaObjectParcelRelDto.getAreaObject();
        if (areaObjectDto != null && areaObjectDto.getId() != null && (areaObjectModel = (AreaObjectModelImpl)this.getModelCache().getModel(AreaObjectModel.class, areaObjectDto.getId())) != null) {
            areaObjectModel.checkStaleState(areaObjectDto);
        }
        if ((parcelDto = areaObjectParcelRelDto.getParcel()) != null && parcelDto.getId() != null && (parcelModel = (ParcelModelImpl)this.getModelCache().getModel(ParcelModel.class, parcelDto.getId())) != null) {
            parcelModel.checkStaleState(parcelDto);
        }
        if ((sortOrderDtos = areaObjectParcelRelDto.getSortOrders()) != null) {
            for (ParcelSortOrderDto sortOrderDto : sortOrderDtos) {
                ParcelSortOrderModelImpl sortOrderModel = (ParcelSortOrderModelImpl)this.getModelCache().getModel(ParcelSortOrderModel.class, sortOrderDto.getId());
                if (sortOrderModel == null) continue;
                sortOrderModel.checkStaleState(sortOrderDto);
            }
        }
    }

    @Override
    public AreaObjectParcelRelFullDto createDto() {
        ParcelModelImpl parcel;
        Long id = this.getId();
        AreaObjectParcelRelFullDto areaObjectParcelRelDto = id == null ? new AreaObjectParcelRelFullDto(this.getTempUUID()) : new AreaObjectParcelRelFullDto(id, this.getVersion());
        AreaObjectModelImpl areaObject = (AreaObjectModelImpl)this.getAreaObject();
        if (areaObject != null) {
            areaObjectParcelRelDto.setAreaObject(areaObject.createProxy());
        }
        if ((parcel = (ParcelModelImpl)this.getParcel()) != null) {
            areaObjectParcelRelDto.setParcel(parcel.createProxy());
        }
        return areaObjectParcelRelDto;
    }

    @Override
    public AreaObjectParcelRelProxyDto createProxy() {
        Long id = this.getId();
        AreaObjectParcelRelProxyDto areaObjectParcelRelDto = id == null ? new AreaObjectParcelRelProxyDto(this.getTempUUID()) : new AreaObjectParcelRelProxyDto(id, this.getVersion());
        return areaObjectParcelRelDto;
    }

    public static enum AreaObjectParcelRelModelEnum {
        AREA_OBJECT("areaObject"),
        PARCEL("parcel"),
        SORT_ORDERS("sortOrders");

        private String propertyName;

        private AreaObjectParcelRelModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

