/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.area;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.area.AreaAttributeValueModel;
import de.datomino.peppergis.client.model.area.AreaAttributeValueModelImpl;
import de.datomino.peppergis.client.model.area.AreaDeliveryRoundModel;
import de.datomino.peppergis.client.model.area.AreaDeliveryRoundModelImpl;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaLayerModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectGenInfoModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenInfoModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModelImpl;
import de.datomino.peppergis.client.model.area.DetaillessAreaObjectGeometryModel;
import de.datomino.peppergis.client.model.area.DetaillessAreaObjectGeometryModelImpl;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.LetterModelImpl;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.PoiModelImpl;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.wage.WageHolidaySetModel;
import de.datomino.peppergis.client.model.wage.WageHolidaySetModelImpl;
import de.datomino.peppergis.client.model.wage.WageParameterModel;
import de.datomino.peppergis.client.model.wage.WageParameterModelImpl;
import de.datomino.peppergis.dto.area.AreaAttributeValueDto;
import de.datomino.peppergis.dto.area.AreaDeliveryRoundDto;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.area.AreaObjectFullDto;
import de.datomino.peppergis.dto.area.AreaObjectGenInfoDto;
import de.datomino.peppergis.dto.area.AreaObjectParcelRelDto;
import de.datomino.peppergis.dto.area.AreaObjectProxyDto;
import de.datomino.peppergis.dto.area.DetaillessAreaObjectGeometryDto;
import de.datomino.peppergis.dto.base.LetterDto;
import de.datomino.peppergis.dto.base.PoiDto;
import de.datomino.peppergis.dto.base.SubscriptionDto;
import de.datomino.peppergis.dto.wage.WageHolidaySetDto;
import de.datomino.peppergis.dto.wage.WageParameterDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.dto.ImmutablePolygonKindDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;
import org.ktde.util.datatypes.Holder;

public class AreaObjectModelImpl
extends AbstractModel<AreaObjectFullDto, AreaObjectProxyDto>
implements AreaObjectModel {
    private String displayname;
    private String shortcut;
    private AreaLayerModel areaLayer;
    private Holder<AreaObjectGenInfoModel> genInfo;
    private ImmutablePolygonKind geom;
    private Set<AreaAttributeValueModel> areaAttributeValues = null;
    private Set<AreaObjectParcelRelModel> areaObjectParcelRel = null;
    private PoiModel poi;
    private Set<DetaillessAreaObjectGeometryModel> detaillessAreaObjectGeometries = null;
    private WageParameterModel wageParameter;
    private Set<SubscriptionModel> subscriptions = null;
    private Date lastExportedTimestamp;
    private PoiModel firstPickPoint;
    private PoiModel lastPickPoint;
    private WageHolidaySetModel wageHolidaySet;
    private Set<LetterModel> letters = null;
    private Set<AreaDeliveryRoundModel> areaDeliveryRounds = null;

    public AreaObjectModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public AreaObjectModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getDisplayname() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.displayname;
    }

    @Override
    public void setDisplayname(String displayname) {
        this.setDisplayname(displayname, true);
    }

    private void setDisplayname(String displayname, boolean setDirty) {
        String oldDisplayname = this.getDisplayname();
        if (new EqualsBuilder().append(oldDisplayname, displayname).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaObjectModelEnum.DISPLAYNAME.getPropertyName());
        }
        this.displayname = displayname;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaObjectModelEnum.DISPLAYNAME, displayname, oldDisplayname);
    }

    @Override
    public String getShortcut() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.shortcut;
    }

    @Override
    public void setShortcut(String shortcut) {
        this.setShortcut(shortcut, true);
    }

    private void setShortcut(String shortcut, boolean setDirty) {
        String oldShortcut = this.getShortcut();
        if (new EqualsBuilder().append(oldShortcut, shortcut).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaObjectModelEnum.SHORTCUT.getPropertyName());
        }
        this.shortcut = shortcut;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaObjectModelEnum.SHORTCUT, shortcut, oldShortcut);
    }

    @Override
    public AreaLayerModel getAreaLayer() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.areaLayer;
    }

    @Override
    public void setAreaLayer(AreaLayerModel areaLayer) {
        this.setAreaLayer(areaLayer, true);
    }

    private void setAreaLayer(AreaLayerModel areaLayer, boolean setDirty) {
        AreaLayerModel oldAreaLayer = this.getAreaLayer();
        if (oldAreaLayer == areaLayer) {
            return;
        }
        if (oldAreaLayer != null) {
            oldAreaLayer.removeAreaObject(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaObjectModelEnum.AREA_LAYER.getPropertyName());
        }
        this.areaLayer = areaLayer;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaObjectModelEnum.AREA_LAYER, areaLayer, oldAreaLayer);
        if (this.areaLayer != null) {
            this.areaLayer.addAreaObject(this);
        }
    }

    @Override
    public AreaObjectGenInfoModel getGenInfo() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.genInfo == null) {
            this.genInfo = new Holder();
            if (this.getId() != null) {
                this.genInfo.setElement((AreaObjectGenInfoModel)this.commonCaller.fetchChild(this, AreaObjectModelEnum.GEN_INFO.getPropertyName()));
            }
        }
        return this.genInfo.getElement();
    }

    @Override
    public void setGenInfo(AreaObjectGenInfoModel genInfo) {
        AreaObjectGenInfoModel oldGenInfo = this.getGenInfo();
        if (oldGenInfo == genInfo) {
            return;
        }
        this.genInfo.setElement(genInfo);
        this.fireValueChanged(AreaObjectModelEnum.GEN_INFO, genInfo, oldGenInfo);
        if (oldGenInfo != null) {
            oldGenInfo.setAreaObject(null);
        }
        if (genInfo != null) {
            genInfo.setAreaObject(this);
        }
    }

    @Override
    public ImmutablePolygonKind getGeom() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.geom;
    }

    @Override
    public void setGeom(ImmutablePolygonKind geom) {
        this.setGeom(geom, true);
    }

    private void setGeom(ImmutablePolygonKind geom, boolean setDirty) {
        ImmutablePolygonKind oldGeom = this.getGeom();
        if (new EqualsBuilder().append(oldGeom, geom).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaObjectModelEnum.GEOM.getPropertyName());
        }
        this.geom = geom;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaObjectModelEnum.GEOM, geom, oldGeom);
    }

    @Override
    public int countAreaAttributeValues() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaAttributeValues == null) {
            this.areaAttributeValues = new LinkedHashSet<AreaAttributeValueModel>();
            if (this.getId() != null) {
                Collection areaAttributeValuesCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.AREA_ATTRIBUTE_VALUES.getPropertyName());
                this.areaAttributeValues.addAll(areaAttributeValuesCollection);
            }
        }
        return this.areaAttributeValues.size();
    }

    @Override
    public Iterator<AreaAttributeValueModel> iterateAreaAttributeValues() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaAttributeValues == null) {
            this.areaAttributeValues = new LinkedHashSet<AreaAttributeValueModel>();
            if (this.getId() != null) {
                Collection areaAttributeValuesCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.AREA_ATTRIBUTE_VALUES.getPropertyName());
                this.areaAttributeValues.addAll(areaAttributeValuesCollection);
            }
        }
        return new ImmutableIterator<AreaAttributeValueModel>(this.areaAttributeValues);
    }

    @Override
    public Iterable<AreaAttributeValueModel> iterableAreaAttributeValues() {
        return new IteratorIterable<AreaAttributeValueModel>(this.iterateAreaAttributeValues());
    }

    @Override
    public void addAreaAttributeValue(AreaAttributeValueModel areaAttributeValue) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaAttributeValues == null) {
            this.areaAttributeValues = new LinkedHashSet<AreaAttributeValueModel>();
            if (this.getId() != null) {
                Collection areaAttributeValuesCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.AREA_ATTRIBUTE_VALUES.getPropertyName());
                this.areaAttributeValues.addAll(areaAttributeValuesCollection);
            }
        }
        if (this.areaAttributeValues.contains(areaAttributeValue)) {
            return;
        }
        this.areaAttributeValues.add(areaAttributeValue);
        this.fireValueChanged(AreaObjectModelEnum.AREA_ATTRIBUTE_VALUES, areaAttributeValue, null);
        if (areaAttributeValue != null) {
            areaAttributeValue.setAreaObject(this);
        }
    }

    @Override
    public void removeAreaAttributeValue(AreaAttributeValueModel areaAttributeValue) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaAttributeValues == null) {
            this.areaAttributeValues = new LinkedHashSet<AreaAttributeValueModel>();
            if (this.getId() != null) {
                Collection areaAttributeValuesCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.AREA_ATTRIBUTE_VALUES.getPropertyName());
                this.areaAttributeValues.addAll(areaAttributeValuesCollection);
            }
        }
        if (!this.areaAttributeValues.contains(areaAttributeValue)) {
            return;
        }
        this.areaAttributeValues.remove(areaAttributeValue);
        this.fireValueChanged(AreaObjectModelEnum.AREA_ATTRIBUTE_VALUES, areaAttributeValue, null);
        if (areaAttributeValue != null) {
            areaAttributeValue.setAreaObject(null);
        }
    }

    @Override
    public void clearAreaAttributeValues() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaAttributeValues == null) {
            this.areaAttributeValues = new LinkedHashSet<AreaAttributeValueModel>();
            if (this.getId() != null) {
                Collection areaAttributeValuesCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.AREA_ATTRIBUTE_VALUES.getPropertyName());
                this.areaAttributeValues.addAll(areaAttributeValuesCollection);
            }
        }
        ArrayList<AreaAttributeValueModel> oldAreaAttributeValues = new ArrayList<AreaAttributeValueModel>(this.areaAttributeValues);
        this.areaAttributeValues.clear();
        this.fireValueChanged(AreaObjectModelEnum.AREA_ATTRIBUTE_VALUES, null, null);
        for (AreaAttributeValueModel oldAreaAttributeValue : oldAreaAttributeValues) {
            if (oldAreaAttributeValue == null) continue;
            oldAreaAttributeValue.setAreaObject(null);
        }
    }

    @Override
    public boolean isAreaAttributeValuesEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaAttributeValues == null) {
            this.areaAttributeValues = new LinkedHashSet<AreaAttributeValueModel>();
            if (this.getId() != null) {
                Collection areaAttributeValuesCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.AREA_ATTRIBUTE_VALUES.getPropertyName());
                this.areaAttributeValues.addAll(areaAttributeValuesCollection);
            }
        }
        return this.areaAttributeValues.isEmpty();
    }

    @Override
    public boolean containsAreaAttributeValue(AreaAttributeValueModel areaAttributeValue) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaAttributeValues == null) {
            this.areaAttributeValues = new LinkedHashSet<AreaAttributeValueModel>();
            if (this.getId() != null) {
                Collection areaAttributeValuesCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.AREA_ATTRIBUTE_VALUES.getPropertyName());
                this.areaAttributeValues.addAll(areaAttributeValuesCollection);
            }
        }
        return this.areaAttributeValues.contains(areaAttributeValue);
    }

    @Override
    public boolean isAreaAttributeValuesInitialized() {
        return this.areaAttributeValues != null;
    }

    @Override
    public int countAreaObjectParcelRel() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjectParcelRel == null) {
            this.areaObjectParcelRel = new LinkedHashSet<AreaObjectParcelRelModel>();
            if (this.getId() != null) {
                Collection areaObjectParcelRelCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.AREA_OBJECT_PARCEL_REL.getPropertyName());
                this.areaObjectParcelRel.addAll(areaObjectParcelRelCollection);
            }
        }
        return this.areaObjectParcelRel.size();
    }

    @Override
    public Iterator<AreaObjectParcelRelModel> iterateAreaObjectParcelRel() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjectParcelRel == null) {
            this.areaObjectParcelRel = new LinkedHashSet<AreaObjectParcelRelModel>();
            if (this.getId() != null) {
                Collection areaObjectParcelRelCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.AREA_OBJECT_PARCEL_REL.getPropertyName());
                this.areaObjectParcelRel.addAll(areaObjectParcelRelCollection);
            }
        }
        return new ImmutableIterator<AreaObjectParcelRelModel>(this.areaObjectParcelRel);
    }

    @Override
    public Iterable<AreaObjectParcelRelModel> iterableAreaObjectParcelRel() {
        return new IteratorIterable<AreaObjectParcelRelModel>(this.iterateAreaObjectParcelRel());
    }

    @Override
    public void addAAreaObjectParcelRel(AreaObjectParcelRelModel aAreaObjectParcelRel) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjectParcelRel == null) {
            this.areaObjectParcelRel = new LinkedHashSet<AreaObjectParcelRelModel>();
            if (this.getId() != null) {
                Collection areaObjectParcelRelCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.AREA_OBJECT_PARCEL_REL.getPropertyName());
                this.areaObjectParcelRel.addAll(areaObjectParcelRelCollection);
            }
        }
        if (this.areaObjectParcelRel.contains(aAreaObjectParcelRel)) {
            return;
        }
        this.areaObjectParcelRel.add(aAreaObjectParcelRel);
        this.fireValueChanged(AreaObjectModelEnum.AREA_OBJECT_PARCEL_REL, aAreaObjectParcelRel, null);
        if (aAreaObjectParcelRel != null) {
            aAreaObjectParcelRel.setAreaObject(this);
        }
    }

    @Override
    public void removeAAreaObjectParcelRel(AreaObjectParcelRelModel aAreaObjectParcelRel) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjectParcelRel == null) {
            this.areaObjectParcelRel = new LinkedHashSet<AreaObjectParcelRelModel>();
            if (this.getId() != null) {
                Collection areaObjectParcelRelCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.AREA_OBJECT_PARCEL_REL.getPropertyName());
                this.areaObjectParcelRel.addAll(areaObjectParcelRelCollection);
            }
        }
        if (!this.areaObjectParcelRel.contains(aAreaObjectParcelRel)) {
            return;
        }
        this.areaObjectParcelRel.remove(aAreaObjectParcelRel);
        this.fireValueChanged(AreaObjectModelEnum.AREA_OBJECT_PARCEL_REL, aAreaObjectParcelRel, null);
        if (aAreaObjectParcelRel != null) {
            aAreaObjectParcelRel.setAreaObject(null);
        }
    }

    @Override
    public void clearAreaObjectParcelRel() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjectParcelRel == null) {
            this.areaObjectParcelRel = new LinkedHashSet<AreaObjectParcelRelModel>();
            if (this.getId() != null) {
                Collection areaObjectParcelRelCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.AREA_OBJECT_PARCEL_REL.getPropertyName());
                this.areaObjectParcelRel.addAll(areaObjectParcelRelCollection);
            }
        }
        ArrayList<AreaObjectParcelRelModel> oldAreaObjectParcelRel = new ArrayList<AreaObjectParcelRelModel>(this.areaObjectParcelRel);
        this.areaObjectParcelRel.clear();
        this.fireValueChanged(AreaObjectModelEnum.AREA_OBJECT_PARCEL_REL, null, null);
        for (AreaObjectParcelRelModel oldAAreaObjectParcelRel : oldAreaObjectParcelRel) {
            if (oldAAreaObjectParcelRel == null) continue;
            oldAAreaObjectParcelRel.setAreaObject(null);
        }
    }

    @Override
    public boolean isAreaObjectParcelRelEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjectParcelRel == null) {
            this.areaObjectParcelRel = new LinkedHashSet<AreaObjectParcelRelModel>();
            if (this.getId() != null) {
                Collection areaObjectParcelRelCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.AREA_OBJECT_PARCEL_REL.getPropertyName());
                this.areaObjectParcelRel.addAll(areaObjectParcelRelCollection);
            }
        }
        return this.areaObjectParcelRel.isEmpty();
    }

    @Override
    public boolean containsAAreaObjectParcelRel(AreaObjectParcelRelModel aAreaObjectParcelRel) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjectParcelRel == null) {
            this.areaObjectParcelRel = new LinkedHashSet<AreaObjectParcelRelModel>();
            if (this.getId() != null) {
                Collection areaObjectParcelRelCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.AREA_OBJECT_PARCEL_REL.getPropertyName());
                this.areaObjectParcelRel.addAll(areaObjectParcelRelCollection);
            }
        }
        return this.areaObjectParcelRel.contains(aAreaObjectParcelRel);
    }

    @Override
    public boolean isAreaObjectParcelRelInitialized() {
        return this.areaObjectParcelRel != null;
    }

    @Override
    public PoiModel getPoi() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.poi;
    }

    @Override
    public void setPoi(PoiModel poi) {
        this.setPoi(poi, true);
    }

    private void setPoi(PoiModel poi, boolean setDirty) {
        PoiModel oldPoi = this.getPoi();
        if (oldPoi == poi) {
            return;
        }
        if (oldPoi != null) {
            oldPoi.removeAreaObject(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaObjectModelEnum.POI.getPropertyName());
        }
        this.poi = poi;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaObjectModelEnum.POI, poi, oldPoi);
        if (this.poi != null) {
            this.poi.addAreaObject(this);
        }
    }

    @Override
    public int countDetaillessAreaObjectGeometries() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.detaillessAreaObjectGeometries == null) {
            this.detaillessAreaObjectGeometries = new LinkedHashSet<DetaillessAreaObjectGeometryModel>();
            if (this.getId() != null) {
                Collection detaillessAreaObjectGeometriesCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.DETAILLESS_AREA_OBJECT_GEOMETRIES.getPropertyName());
                this.detaillessAreaObjectGeometries.addAll(detaillessAreaObjectGeometriesCollection);
            }
        }
        return this.detaillessAreaObjectGeometries.size();
    }

    @Override
    public Iterator<DetaillessAreaObjectGeometryModel> iterateDetaillessAreaObjectGeometries() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.detaillessAreaObjectGeometries == null) {
            this.detaillessAreaObjectGeometries = new LinkedHashSet<DetaillessAreaObjectGeometryModel>();
            if (this.getId() != null) {
                Collection detaillessAreaObjectGeometriesCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.DETAILLESS_AREA_OBJECT_GEOMETRIES.getPropertyName());
                this.detaillessAreaObjectGeometries.addAll(detaillessAreaObjectGeometriesCollection);
            }
        }
        return new ImmutableIterator<DetaillessAreaObjectGeometryModel>(this.detaillessAreaObjectGeometries);
    }

    @Override
    public Iterable<DetaillessAreaObjectGeometryModel> iterableDetaillessAreaObjectGeometries() {
        return new IteratorIterable<DetaillessAreaObjectGeometryModel>(this.iterateDetaillessAreaObjectGeometries());
    }

    @Override
    public void addDetaillessAreaObjectGeometrie(DetaillessAreaObjectGeometryModel detaillessAreaObjectGeometrie) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.detaillessAreaObjectGeometries == null) {
            this.detaillessAreaObjectGeometries = new LinkedHashSet<DetaillessAreaObjectGeometryModel>();
            if (this.getId() != null) {
                Collection detaillessAreaObjectGeometriesCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.DETAILLESS_AREA_OBJECT_GEOMETRIES.getPropertyName());
                this.detaillessAreaObjectGeometries.addAll(detaillessAreaObjectGeometriesCollection);
            }
        }
        if (this.detaillessAreaObjectGeometries.contains(detaillessAreaObjectGeometrie)) {
            return;
        }
        this.detaillessAreaObjectGeometries.add(detaillessAreaObjectGeometrie);
        this.fireValueChanged(AreaObjectModelEnum.DETAILLESS_AREA_OBJECT_GEOMETRIES, detaillessAreaObjectGeometrie, null);
        if (detaillessAreaObjectGeometrie != null) {
            detaillessAreaObjectGeometrie.setAreaObject(this);
        }
    }

    @Override
    public void removeDetaillessAreaObjectGeometrie(DetaillessAreaObjectGeometryModel detaillessAreaObjectGeometrie) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.detaillessAreaObjectGeometries == null) {
            this.detaillessAreaObjectGeometries = new LinkedHashSet<DetaillessAreaObjectGeometryModel>();
            if (this.getId() != null) {
                Collection detaillessAreaObjectGeometriesCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.DETAILLESS_AREA_OBJECT_GEOMETRIES.getPropertyName());
                this.detaillessAreaObjectGeometries.addAll(detaillessAreaObjectGeometriesCollection);
            }
        }
        if (!this.detaillessAreaObjectGeometries.contains(detaillessAreaObjectGeometrie)) {
            return;
        }
        this.detaillessAreaObjectGeometries.remove(detaillessAreaObjectGeometrie);
        this.fireValueChanged(AreaObjectModelEnum.DETAILLESS_AREA_OBJECT_GEOMETRIES, detaillessAreaObjectGeometrie, null);
        if (detaillessAreaObjectGeometrie != null) {
            detaillessAreaObjectGeometrie.setAreaObject(null);
        }
    }

    @Override
    public void clearDetaillessAreaObjectGeometries() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.detaillessAreaObjectGeometries == null) {
            this.detaillessAreaObjectGeometries = new LinkedHashSet<DetaillessAreaObjectGeometryModel>();
            if (this.getId() != null) {
                Collection detaillessAreaObjectGeometriesCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.DETAILLESS_AREA_OBJECT_GEOMETRIES.getPropertyName());
                this.detaillessAreaObjectGeometries.addAll(detaillessAreaObjectGeometriesCollection);
            }
        }
        ArrayList<DetaillessAreaObjectGeometryModel> oldDetaillessAreaObjectGeometries = new ArrayList<DetaillessAreaObjectGeometryModel>(this.detaillessAreaObjectGeometries);
        this.detaillessAreaObjectGeometries.clear();
        this.fireValueChanged(AreaObjectModelEnum.DETAILLESS_AREA_OBJECT_GEOMETRIES, null, null);
        for (DetaillessAreaObjectGeometryModel oldDetaillessAreaObjectGeometrie : oldDetaillessAreaObjectGeometries) {
            if (oldDetaillessAreaObjectGeometrie == null) continue;
            oldDetaillessAreaObjectGeometrie.setAreaObject(null);
        }
    }

    @Override
    public boolean isDetaillessAreaObjectGeometriesEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.detaillessAreaObjectGeometries == null) {
            this.detaillessAreaObjectGeometries = new LinkedHashSet<DetaillessAreaObjectGeometryModel>();
            if (this.getId() != null) {
                Collection detaillessAreaObjectGeometriesCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.DETAILLESS_AREA_OBJECT_GEOMETRIES.getPropertyName());
                this.detaillessAreaObjectGeometries.addAll(detaillessAreaObjectGeometriesCollection);
            }
        }
        return this.detaillessAreaObjectGeometries.isEmpty();
    }

    @Override
    public boolean containsDetaillessAreaObjectGeometrie(DetaillessAreaObjectGeometryModel detaillessAreaObjectGeometrie) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.detaillessAreaObjectGeometries == null) {
            this.detaillessAreaObjectGeometries = new LinkedHashSet<DetaillessAreaObjectGeometryModel>();
            if (this.getId() != null) {
                Collection detaillessAreaObjectGeometriesCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.DETAILLESS_AREA_OBJECT_GEOMETRIES.getPropertyName());
                this.detaillessAreaObjectGeometries.addAll(detaillessAreaObjectGeometriesCollection);
            }
        }
        return this.detaillessAreaObjectGeometries.contains(detaillessAreaObjectGeometrie);
    }

    @Override
    public boolean isDetaillessAreaObjectGeometriesInitialized() {
        return this.detaillessAreaObjectGeometries != null;
    }

    @Override
    public WageParameterModel getWageParameter() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.wageParameter;
    }

    @Override
    public void setWageParameter(WageParameterModel wageParameter) {
        this.setWageParameter(wageParameter, true);
    }

    private void setWageParameter(WageParameterModel wageParameter, boolean setDirty) {
        WageParameterModel oldWageParameter = this.getWageParameter();
        if (oldWageParameter == wageParameter) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaObjectModelEnum.WAGE_PARAMETER.getPropertyName());
        }
        this.wageParameter = wageParameter;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaObjectModelEnum.WAGE_PARAMETER, wageParameter, oldWageParameter);
    }

    @Override
    public int countSubscriptions() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subscriptions == null) {
            this.subscriptions = new LinkedHashSet<SubscriptionModel>();
            if (this.getId() != null) {
                Collection subscriptionsCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.SUBSCRIPTIONS.getPropertyName());
                this.subscriptions.addAll(subscriptionsCollection);
            }
        }
        return this.subscriptions.size();
    }

    @Override
    public Iterator<SubscriptionModel> iterateSubscriptions() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subscriptions == null) {
            this.subscriptions = new LinkedHashSet<SubscriptionModel>();
            if (this.getId() != null) {
                Collection subscriptionsCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.SUBSCRIPTIONS.getPropertyName());
                this.subscriptions.addAll(subscriptionsCollection);
            }
        }
        return new ImmutableIterator<SubscriptionModel>(this.subscriptions);
    }

    @Override
    public Iterable<SubscriptionModel> iterableSubscriptions() {
        return new IteratorIterable<SubscriptionModel>(this.iterateSubscriptions());
    }

    @Override
    public void addSubscription(SubscriptionModel subscription) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subscriptions == null) {
            this.subscriptions = new LinkedHashSet<SubscriptionModel>();
            if (this.getId() != null) {
                Collection subscriptionsCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.SUBSCRIPTIONS.getPropertyName());
                this.subscriptions.addAll(subscriptionsCollection);
            }
        }
        if (this.subscriptions.contains(subscription)) {
            return;
        }
        this.subscriptions.add(subscription);
        this.fireValueChanged(AreaObjectModelEnum.SUBSCRIPTIONS, subscription, null);
        if (subscription != null) {
            subscription.setAreaObject(this);
        }
    }

    @Override
    public void removeSubscription(SubscriptionModel subscription) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subscriptions == null) {
            this.subscriptions = new LinkedHashSet<SubscriptionModel>();
            if (this.getId() != null) {
                Collection subscriptionsCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.SUBSCRIPTIONS.getPropertyName());
                this.subscriptions.addAll(subscriptionsCollection);
            }
        }
        if (!this.subscriptions.contains(subscription)) {
            return;
        }
        this.subscriptions.remove(subscription);
        this.fireValueChanged(AreaObjectModelEnum.SUBSCRIPTIONS, subscription, null);
        if (subscription != null) {
            subscription.setAreaObject(null);
        }
    }

    @Override
    public void clearSubscriptions() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subscriptions == null) {
            this.subscriptions = new LinkedHashSet<SubscriptionModel>();
            if (this.getId() != null) {
                Collection subscriptionsCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.SUBSCRIPTIONS.getPropertyName());
                this.subscriptions.addAll(subscriptionsCollection);
            }
        }
        ArrayList<SubscriptionModel> oldSubscriptions = new ArrayList<SubscriptionModel>(this.subscriptions);
        this.subscriptions.clear();
        this.fireValueChanged(AreaObjectModelEnum.SUBSCRIPTIONS, null, null);
        for (SubscriptionModel oldSubscription : oldSubscriptions) {
            if (oldSubscription == null) continue;
            oldSubscription.setAreaObject(null);
        }
    }

    @Override
    public boolean isSubscriptionsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subscriptions == null) {
            this.subscriptions = new LinkedHashSet<SubscriptionModel>();
            if (this.getId() != null) {
                Collection subscriptionsCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.SUBSCRIPTIONS.getPropertyName());
                this.subscriptions.addAll(subscriptionsCollection);
            }
        }
        return this.subscriptions.isEmpty();
    }

    @Override
    public boolean containsSubscription(SubscriptionModel subscription) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subscriptions == null) {
            this.subscriptions = new LinkedHashSet<SubscriptionModel>();
            if (this.getId() != null) {
                Collection subscriptionsCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.SUBSCRIPTIONS.getPropertyName());
                this.subscriptions.addAll(subscriptionsCollection);
            }
        }
        return this.subscriptions.contains(subscription);
    }

    @Override
    public boolean isSubscriptionsInitialized() {
        return this.subscriptions != null;
    }

    @Override
    public Date getLastExportedTimestamp() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.lastExportedTimestamp;
    }

    @Override
    public void setLastExportedTimestamp(Date lastExportedTimestamp) {
        this.setLastExportedTimestamp(lastExportedTimestamp, true);
    }

    private void setLastExportedTimestamp(Date lastExportedTimestamp, boolean setDirty) {
        Date oldLastExportedTimestamp = this.getLastExportedTimestamp();
        if (new EqualsBuilder().append(oldLastExportedTimestamp, lastExportedTimestamp).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaObjectModelEnum.LAST_EXPORTED_TIMESTAMP.getPropertyName());
        }
        this.lastExportedTimestamp = lastExportedTimestamp;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaObjectModelEnum.LAST_EXPORTED_TIMESTAMP, lastExportedTimestamp, oldLastExportedTimestamp);
    }

    @Override
    public PoiModel getFirstPickPoint() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.firstPickPoint;
    }

    @Override
    public void setFirstPickPoint(PoiModel firstPickPoint) {
        this.setFirstPickPoint(firstPickPoint, true);
    }

    private void setFirstPickPoint(PoiModel firstPickPoint, boolean setDirty) {
        PoiModel oldFirstPickPoint = this.getFirstPickPoint();
        if (oldFirstPickPoint == firstPickPoint) {
            return;
        }
        if (oldFirstPickPoint != null) {
            oldFirstPickPoint.removeFirstThrowAreaObject(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaObjectModelEnum.FIRST_PICK_POINT.getPropertyName());
        }
        this.firstPickPoint = firstPickPoint;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaObjectModelEnum.FIRST_PICK_POINT, firstPickPoint, oldFirstPickPoint);
        if (this.firstPickPoint != null) {
            this.firstPickPoint.addFirstThrowAreaObject(this);
        }
    }

    @Override
    public PoiModel getLastPickPoint() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.lastPickPoint;
    }

    @Override
    public void setLastPickPoint(PoiModel lastPickPoint) {
        this.setLastPickPoint(lastPickPoint, true);
    }

    private void setLastPickPoint(PoiModel lastPickPoint, boolean setDirty) {
        PoiModel oldLastPickPoint = this.getLastPickPoint();
        if (oldLastPickPoint == lastPickPoint) {
            return;
        }
        if (oldLastPickPoint != null) {
            oldLastPickPoint.removeLastThrowAreaObject(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaObjectModelEnum.LAST_PICK_POINT.getPropertyName());
        }
        this.lastPickPoint = lastPickPoint;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaObjectModelEnum.LAST_PICK_POINT, lastPickPoint, oldLastPickPoint);
        if (this.lastPickPoint != null) {
            this.lastPickPoint.addLastThrowAreaObject(this);
        }
    }

    @Override
    public WageHolidaySetModel getWageHolidaySet() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.wageHolidaySet;
    }

    @Override
    public void setWageHolidaySet(WageHolidaySetModel wageHolidaySet) {
        this.setWageHolidaySet(wageHolidaySet, true);
    }

    private void setWageHolidaySet(WageHolidaySetModel wageHolidaySet, boolean setDirty) {
        WageHolidaySetModel oldWageHolidaySet = this.getWageHolidaySet();
        if (oldWageHolidaySet == wageHolidaySet) {
            return;
        }
        if (oldWageHolidaySet != null) {
            oldWageHolidaySet.removeAreaObject(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaObjectModelEnum.WAGE_HOLIDAY_SET.getPropertyName());
        }
        this.wageHolidaySet = wageHolidaySet;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaObjectModelEnum.WAGE_HOLIDAY_SET, wageHolidaySet, oldWageHolidaySet);
        if (this.wageHolidaySet != null) {
            this.wageHolidaySet.addAreaObject(this);
        }
    }

    @Override
    public int countLetters() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.letters == null) {
            this.letters = new LinkedHashSet<LetterModel>();
            if (this.getId() != null) {
                Collection lettersCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.LETTERS.getPropertyName());
                this.letters.addAll(lettersCollection);
            }
        }
        return this.letters.size();
    }

    @Override
    public Iterator<LetterModel> iterateLetters() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.letters == null) {
            this.letters = new LinkedHashSet<LetterModel>();
            if (this.getId() != null) {
                Collection lettersCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.LETTERS.getPropertyName());
                this.letters.addAll(lettersCollection);
            }
        }
        return new ImmutableIterator<LetterModel>(this.letters);
    }

    @Override
    public Iterable<LetterModel> iterableLetters() {
        return new IteratorIterable<LetterModel>(this.iterateLetters());
    }

    @Override
    public void addLetter(LetterModel letter) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.letters == null) {
            this.letters = new LinkedHashSet<LetterModel>();
            if (this.getId() != null) {
                Collection lettersCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.LETTERS.getPropertyName());
                this.letters.addAll(lettersCollection);
            }
        }
        if (this.letters.contains(letter)) {
            return;
        }
        this.letters.add(letter);
        this.fireValueChanged(AreaObjectModelEnum.LETTERS, letter, null);
        if (letter != null) {
            letter.setAreaObject(this);
        }
    }

    @Override
    public void removeLetter(LetterModel letter) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.letters == null) {
            this.letters = new LinkedHashSet<LetterModel>();
            if (this.getId() != null) {
                Collection lettersCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.LETTERS.getPropertyName());
                this.letters.addAll(lettersCollection);
            }
        }
        if (!this.letters.contains(letter)) {
            return;
        }
        this.letters.remove(letter);
        this.fireValueChanged(AreaObjectModelEnum.LETTERS, letter, null);
        if (letter != null) {
            letter.setAreaObject(null);
        }
    }

    @Override
    public void clearLetters() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.letters == null) {
            this.letters = new LinkedHashSet<LetterModel>();
            if (this.getId() != null) {
                Collection lettersCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.LETTERS.getPropertyName());
                this.letters.addAll(lettersCollection);
            }
        }
        ArrayList<LetterModel> oldLetters = new ArrayList<LetterModel>(this.letters);
        this.letters.clear();
        this.fireValueChanged(AreaObjectModelEnum.LETTERS, null, null);
        for (LetterModel oldLetter : oldLetters) {
            if (oldLetter == null) continue;
            oldLetter.setAreaObject(null);
        }
    }

    @Override
    public boolean isLettersEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.letters == null) {
            this.letters = new LinkedHashSet<LetterModel>();
            if (this.getId() != null) {
                Collection lettersCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.LETTERS.getPropertyName());
                this.letters.addAll(lettersCollection);
            }
        }
        return this.letters.isEmpty();
    }

    @Override
    public boolean containsLetter(LetterModel letter) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.letters == null) {
            this.letters = new LinkedHashSet<LetterModel>();
            if (this.getId() != null) {
                Collection lettersCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.LETTERS.getPropertyName());
                this.letters.addAll(lettersCollection);
            }
        }
        return this.letters.contains(letter);
    }

    @Override
    public boolean isLettersInitialized() {
        return this.letters != null;
    }

    @Override
    public int countAreaDeliveryRounds() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaDeliveryRounds == null) {
            this.areaDeliveryRounds = new LinkedHashSet<AreaDeliveryRoundModel>();
            if (this.getId() != null) {
                Collection areaDeliveryRoundsCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.AREA_DELIVERY_ROUNDS.getPropertyName());
                this.areaDeliveryRounds.addAll(areaDeliveryRoundsCollection);
            }
        }
        return this.areaDeliveryRounds.size();
    }

    @Override
    public Iterator<AreaDeliveryRoundModel> iterateAreaDeliveryRounds() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaDeliveryRounds == null) {
            this.areaDeliveryRounds = new LinkedHashSet<AreaDeliveryRoundModel>();
            if (this.getId() != null) {
                Collection areaDeliveryRoundsCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.AREA_DELIVERY_ROUNDS.getPropertyName());
                this.areaDeliveryRounds.addAll(areaDeliveryRoundsCollection);
            }
        }
        return new ImmutableIterator<AreaDeliveryRoundModel>(this.areaDeliveryRounds);
    }

    @Override
    public Iterable<AreaDeliveryRoundModel> iterableAreaDeliveryRounds() {
        return new IteratorIterable<AreaDeliveryRoundModel>(this.iterateAreaDeliveryRounds());
    }

    @Override
    public void addAreaDeliveryRound(AreaDeliveryRoundModel areaDeliveryRound) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaDeliveryRounds == null) {
            this.areaDeliveryRounds = new LinkedHashSet<AreaDeliveryRoundModel>();
            if (this.getId() != null) {
                Collection areaDeliveryRoundsCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.AREA_DELIVERY_ROUNDS.getPropertyName());
                this.areaDeliveryRounds.addAll(areaDeliveryRoundsCollection);
            }
        }
        if (this.areaDeliveryRounds.contains(areaDeliveryRound)) {
            return;
        }
        this.areaDeliveryRounds.add(areaDeliveryRound);
        this.fireValueChanged(AreaObjectModelEnum.AREA_DELIVERY_ROUNDS, areaDeliveryRound, null);
        if (areaDeliveryRound != null) {
            areaDeliveryRound.setAreaObject(this);
        }
    }

    @Override
    public void removeAreaDeliveryRound(AreaDeliveryRoundModel areaDeliveryRound) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaDeliveryRounds == null) {
            this.areaDeliveryRounds = new LinkedHashSet<AreaDeliveryRoundModel>();
            if (this.getId() != null) {
                Collection areaDeliveryRoundsCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.AREA_DELIVERY_ROUNDS.getPropertyName());
                this.areaDeliveryRounds.addAll(areaDeliveryRoundsCollection);
            }
        }
        if (!this.areaDeliveryRounds.contains(areaDeliveryRound)) {
            return;
        }
        this.areaDeliveryRounds.remove(areaDeliveryRound);
        this.fireValueChanged(AreaObjectModelEnum.AREA_DELIVERY_ROUNDS, areaDeliveryRound, null);
        if (areaDeliveryRound != null) {
            areaDeliveryRound.setAreaObject(null);
        }
    }

    @Override
    public void clearAreaDeliveryRounds() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaDeliveryRounds == null) {
            this.areaDeliveryRounds = new LinkedHashSet<AreaDeliveryRoundModel>();
            if (this.getId() != null) {
                Collection areaDeliveryRoundsCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.AREA_DELIVERY_ROUNDS.getPropertyName());
                this.areaDeliveryRounds.addAll(areaDeliveryRoundsCollection);
            }
        }
        ArrayList<AreaDeliveryRoundModel> oldAreaDeliveryRounds = new ArrayList<AreaDeliveryRoundModel>(this.areaDeliveryRounds);
        this.areaDeliveryRounds.clear();
        this.fireValueChanged(AreaObjectModelEnum.AREA_DELIVERY_ROUNDS, null, null);
        for (AreaDeliveryRoundModel oldAreaDeliveryRound : oldAreaDeliveryRounds) {
            if (oldAreaDeliveryRound == null) continue;
            oldAreaDeliveryRound.setAreaObject(null);
        }
    }

    @Override
    public boolean isAreaDeliveryRoundsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaDeliveryRounds == null) {
            this.areaDeliveryRounds = new LinkedHashSet<AreaDeliveryRoundModel>();
            if (this.getId() != null) {
                Collection areaDeliveryRoundsCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.AREA_DELIVERY_ROUNDS.getPropertyName());
                this.areaDeliveryRounds.addAll(areaDeliveryRoundsCollection);
            }
        }
        return this.areaDeliveryRounds.isEmpty();
    }

    @Override
    public boolean containsAreaDeliveryRound(AreaDeliveryRoundModel areaDeliveryRound) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaDeliveryRounds == null) {
            this.areaDeliveryRounds = new LinkedHashSet<AreaDeliveryRoundModel>();
            if (this.getId() != null) {
                Collection areaDeliveryRoundsCollection = this.commonCaller.fetchChildren(this, AreaObjectModelEnum.AREA_DELIVERY_ROUNDS.getPropertyName());
                this.areaDeliveryRounds.addAll(areaDeliveryRoundsCollection);
            }
        }
        return this.areaDeliveryRounds.contains(areaDeliveryRound);
    }

    @Override
    public boolean isAreaDeliveryRoundsInitialized() {
        return this.areaDeliveryRounds != null;
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.genInfo = null;
            this.areaAttributeValues = null;
            this.areaObjectParcelRel = null;
            this.detaillessAreaObjectGeometries = null;
            this.subscriptions = null;
            this.letters = null;
            this.areaDeliveryRounds = null;
        }
    }

    @Override
    protected void updateByDto(AreaObjectFullDto areaObjectDto) {
        AreaDeliveryRoundDto[] areaDeliveryRounds;
        AreaObjectParcelRelDto[] areaObjectParcelRel;
        ImmutablePolygonKindDto geom;
        this.displayname = areaObjectDto.getDisplayname();
        this.shortcut = areaObjectDto.getShortcut();
        this.areaLayer = (AreaLayerModel)this.getModelCache().getModel(areaObjectDto.getAreaLayer());
        AreaObjectGenInfoDto genInfoDto = areaObjectDto.getGenInfo();
        if (genInfoDto != null && this.genInfo == null) {
            this.genInfo = new Holder();
        }
        this.geom = (geom = areaObjectDto.getGeom()) == null ? null : (ImmutablePolygonKind)geom.getGeoObject();
        AreaAttributeValueDto[] areaAttributeValues = areaObjectDto.getAreaAttributeValues();
        if (areaAttributeValues != null) {
            if (this.areaAttributeValues == null) {
                this.areaAttributeValues = new LinkedHashSet<AreaAttributeValueModel>();
            } else {
                this.areaAttributeValues.clear();
            }
        }
        if ((areaObjectParcelRel = areaObjectDto.getAreaObjectParcelRel()) != null) {
            if (this.areaObjectParcelRel == null) {
                this.areaObjectParcelRel = new LinkedHashSet<AreaObjectParcelRelModel>();
            } else {
                this.areaObjectParcelRel.clear();
            }
        }
        this.poi = (PoiModel)this.getModelCache().getModel(areaObjectDto.getPoi());
        DetaillessAreaObjectGeometryDto[] detaillessAreaObjectGeometries = areaObjectDto.getDetaillessAreaObjectGeometries();
        if (detaillessAreaObjectGeometries != null) {
            if (this.detaillessAreaObjectGeometries == null) {
                this.detaillessAreaObjectGeometries = new LinkedHashSet<DetaillessAreaObjectGeometryModel>();
            } else {
                this.detaillessAreaObjectGeometries.clear();
            }
        }
        this.wageParameter = (WageParameterModel)this.getModelCache().getModel(areaObjectDto.getWageParameter());
        SubscriptionDto[] subscriptions = areaObjectDto.getSubscriptions();
        if (subscriptions != null) {
            if (this.subscriptions == null) {
                this.subscriptions = new LinkedHashSet<SubscriptionModel>();
            } else {
                this.subscriptions.clear();
            }
        }
        this.lastExportedTimestamp = areaObjectDto.getLastExportedTimestamp();
        this.firstPickPoint = (PoiModel)this.getModelCache().getModel(areaObjectDto.getFirstPickPoint());
        this.lastPickPoint = (PoiModel)this.getModelCache().getModel(areaObjectDto.getLastPickPoint());
        this.wageHolidaySet = (WageHolidaySetModel)this.getModelCache().getModel(areaObjectDto.getWageHolidaySet());
        LetterDto[] letters = areaObjectDto.getLetters();
        if (letters != null) {
            if (this.letters == null) {
                this.letters = new LinkedHashSet<LetterModel>();
            } else {
                this.letters.clear();
            }
        }
        if ((areaDeliveryRounds = areaObjectDto.getAreaDeliveryRounds()) != null) {
            if (this.areaDeliveryRounds == null) {
                this.areaDeliveryRounds = new LinkedHashSet<AreaDeliveryRoundModel>();
            } else {
                this.areaDeliveryRounds.clear();
            }
        }
    }

    @Override
    protected void updateMasterRelationsByDto(AreaObjectFullDto areaObjectDto) {
        AreaDeliveryRoundDto[] areaDeliveryRounds;
        LetterDto[] letters;
        SubscriptionDto[] subscriptions;
        DetaillessAreaObjectGeometryDto[] detaillessAreaObjectGeometries;
        AreaObjectParcelRelDto[] areaObjectParcelRel;
        AreaAttributeValueDto[] areaAttributeValues;
        AreaObjectGenInfoDto genInfoDto = areaObjectDto.getGenInfo();
        if (genInfoDto != null) {
            this.genInfo.setElement((AreaObjectGenInfoModel)this.getModelCache().getModel(genInfoDto));
        }
        if ((areaAttributeValues = areaObjectDto.getAreaAttributeValues()) != null) {
            if (this.areaAttributeValues == null) {
                this.areaAttributeValues = new LinkedHashSet<AreaAttributeValueModel>();
            } else {
                this.areaAttributeValues.clear();
            }
            for (AreaAttributeValueDto areaAttributeValueDto : areaAttributeValues) {
                AreaAttributeValueModel areaAttributeValueModel = (AreaAttributeValueModel)this.getModelCache().getModel(areaAttributeValueDto);
                this.areaAttributeValues.add(areaAttributeValueModel);
            }
        } else {
            this.areaAttributeValues = null;
        }
        if ((areaObjectParcelRel = areaObjectDto.getAreaObjectParcelRel()) != null) {
            if (this.areaObjectParcelRel == null) {
                this.areaObjectParcelRel = new LinkedHashSet<AreaObjectParcelRelModel>();
            } else {
                this.areaObjectParcelRel.clear();
            }
            for (AreaObjectParcelRelDto aAreaObjectParcelRelDto : areaObjectParcelRel) {
                AreaObjectParcelRelModel aAreaObjectParcelRelModel = (AreaObjectParcelRelModel)this.getModelCache().getModel(aAreaObjectParcelRelDto);
                this.areaObjectParcelRel.add(aAreaObjectParcelRelModel);
            }
        } else {
            this.areaObjectParcelRel = null;
        }
        if ((detaillessAreaObjectGeometries = areaObjectDto.getDetaillessAreaObjectGeometries()) != null) {
            if (this.detaillessAreaObjectGeometries == null) {
                this.detaillessAreaObjectGeometries = new LinkedHashSet<DetaillessAreaObjectGeometryModel>();
            } else {
                this.detaillessAreaObjectGeometries.clear();
            }
            for (DetaillessAreaObjectGeometryDto detaillessAreaObjectGeometrieDto : detaillessAreaObjectGeometries) {
                DetaillessAreaObjectGeometryModel detaillessAreaObjectGeometrieModel = (DetaillessAreaObjectGeometryModel)this.getModelCache().getModel(detaillessAreaObjectGeometrieDto);
                this.detaillessAreaObjectGeometries.add(detaillessAreaObjectGeometrieModel);
            }
        } else {
            this.detaillessAreaObjectGeometries = null;
        }
        if ((subscriptions = areaObjectDto.getSubscriptions()) != null) {
            if (this.subscriptions == null) {
                this.subscriptions = new LinkedHashSet<SubscriptionModel>();
            } else {
                this.subscriptions.clear();
            }
            for (SubscriptionDto subscriptionDto : subscriptions) {
                SubscriptionModel subscriptionModel = (SubscriptionModel)this.getModelCache().getModel(subscriptionDto);
                this.subscriptions.add(subscriptionModel);
            }
        } else {
            this.subscriptions = null;
        }
        if ((letters = areaObjectDto.getLetters()) != null) {
            if (this.letters == null) {
                this.letters = new LinkedHashSet<LetterModel>();
            } else {
                this.letters.clear();
            }
            for (LetterDto letterDto : letters) {
                LetterModel letterModel = (LetterModel)this.getModelCache().getModel(letterDto);
                this.letters.add(letterModel);
            }
        } else {
            this.letters = null;
        }
        if ((areaDeliveryRounds = areaObjectDto.getAreaDeliveryRounds()) != null) {
            if (this.areaDeliveryRounds == null) {
                this.areaDeliveryRounds = new LinkedHashSet<AreaDeliveryRoundModel>();
            } else {
                this.areaDeliveryRounds.clear();
            }
            for (AreaDeliveryRoundDto areaDeliveryRoundDto : areaDeliveryRounds) {
                AreaDeliveryRoundModel areaDeliveryRoundModel = (AreaDeliveryRoundModel)this.getModelCache().getModel(areaDeliveryRoundDto);
                this.areaDeliveryRounds.add(areaDeliveryRoundModel);
            }
        } else {
            this.areaDeliveryRounds = null;
        }
    }

    @Override
    protected void checkStaleByDto(AreaObjectFullDto areaObjectDto) throws StaleStateException {
        AreaDeliveryRoundDto[] areaDeliveryRoundDtos;
        LetterDto[] letterDtos;
        WageHolidaySetModelImpl wageHolidaySetModel;
        WageHolidaySetDto wageHolidaySetDto;
        PoiModelImpl lastPickPointModel;
        PoiDto lastPickPointDto;
        PoiModelImpl firstPickPointModel;
        PoiDto firstPickPointDto;
        SubscriptionDto[] subscriptionDtos;
        WageParameterModelImpl wageParameterModel;
        WageParameterDto wageParameterDto;
        DetaillessAreaObjectGeometryDto[] detaillessAreaObjectGeometrieDtos;
        PoiModelImpl poiModel;
        PoiDto poiDto;
        AreaObjectParcelRelDto[] aAreaObjectParcelRelDtos;
        AreaAttributeValueDto[] areaAttributeValueDtos;
        AreaObjectGenInfoModelImpl genInfoModel;
        AreaObjectGenInfoDto genInfoDto;
        AreaLayerModelImpl areaLayerModel;
        AreaLayerDto areaLayerDto = areaObjectDto.getAreaLayer();
        if (areaLayerDto != null && areaLayerDto.getId() != null && (areaLayerModel = (AreaLayerModelImpl)this.getModelCache().getModel(AreaLayerModel.class, areaLayerDto.getId())) != null) {
            areaLayerModel.checkStaleState(areaLayerDto);
        }
        if ((genInfoDto = areaObjectDto.getGenInfo()) != null && genInfoDto.getId() != null && (genInfoModel = (AreaObjectGenInfoModelImpl)this.getModelCache().getModel(AreaObjectGenInfoModel.class, genInfoDto.getId())) != null) {
            genInfoModel.checkStaleState(genInfoDto);
        }
        if ((areaAttributeValueDtos = areaObjectDto.getAreaAttributeValues()) != null) {
            for (AreaAttributeValueDto areaAttributeValueDto : areaAttributeValueDtos) {
                AreaAttributeValueModelImpl areaAttributeValueModel = (AreaAttributeValueModelImpl)this.getModelCache().getModel(AreaAttributeValueModel.class, areaAttributeValueDto.getId());
                if (areaAttributeValueModel == null) continue;
                areaAttributeValueModel.checkStaleState(areaAttributeValueDto);
            }
        }
        if ((aAreaObjectParcelRelDtos = areaObjectDto.getAreaObjectParcelRel()) != null) {
            for (AreaObjectParcelRelDto aAreaObjectParcelRelDto : aAreaObjectParcelRelDtos) {
                AreaObjectParcelRelModelImpl aAreaObjectParcelRelModel = (AreaObjectParcelRelModelImpl)this.getModelCache().getModel(AreaObjectParcelRelModel.class, aAreaObjectParcelRelDto.getId());
                if (aAreaObjectParcelRelModel == null) continue;
                aAreaObjectParcelRelModel.checkStaleState(aAreaObjectParcelRelDto);
            }
        }
        if ((poiDto = areaObjectDto.getPoi()) != null && poiDto.getId() != null && (poiModel = (PoiModelImpl)this.getModelCache().getModel(PoiModel.class, poiDto.getId())) != null) {
            poiModel.checkStaleState(poiDto);
        }
        if ((detaillessAreaObjectGeometrieDtos = areaObjectDto.getDetaillessAreaObjectGeometries()) != null) {
            for (DetaillessAreaObjectGeometryDto detaillessAreaObjectGeometrieDto : detaillessAreaObjectGeometrieDtos) {
                DetaillessAreaObjectGeometryModelImpl detaillessAreaObjectGeometrieModel = (DetaillessAreaObjectGeometryModelImpl)this.getModelCache().getModel(DetaillessAreaObjectGeometryModel.class, detaillessAreaObjectGeometrieDto.getId());
                if (detaillessAreaObjectGeometrieModel == null) continue;
                detaillessAreaObjectGeometrieModel.checkStaleState(detaillessAreaObjectGeometrieDto);
            }
        }
        if ((wageParameterDto = areaObjectDto.getWageParameter()) != null && wageParameterDto.getId() != null && (wageParameterModel = (WageParameterModelImpl)this.getModelCache().getModel(WageParameterModel.class, wageParameterDto.getId())) != null) {
            wageParameterModel.checkStaleState(wageParameterDto);
        }
        if ((subscriptionDtos = areaObjectDto.getSubscriptions()) != null) {
            for (SubscriptionDto subscriptionDto : subscriptionDtos) {
                LetterDto[] subscriptionModel = (LetterDto[])this.getModelCache().getModel(SubscriptionModel.class, subscriptionDto.getId());
                if (subscriptionModel == null) continue;
                subscriptionModel.checkStaleState(subscriptionDto);
            }
        }
        if ((firstPickPointDto = areaObjectDto.getFirstPickPoint()) != null && firstPickPointDto.getId() != null && (firstPickPointModel = (PoiModelImpl)this.getModelCache().getModel(PoiModel.class, firstPickPointDto.getId())) != null) {
            firstPickPointModel.checkStaleState(firstPickPointDto);
        }
        if ((lastPickPointDto = areaObjectDto.getLastPickPoint()) != null && lastPickPointDto.getId() != null && (lastPickPointModel = (PoiModelImpl)this.getModelCache().getModel(PoiModel.class, lastPickPointDto.getId())) != null) {
            lastPickPointModel.checkStaleState(lastPickPointDto);
        }
        if ((wageHolidaySetDto = areaObjectDto.getWageHolidaySet()) != null && wageHolidaySetDto.getId() != null && (wageHolidaySetModel = (WageHolidaySetModelImpl)this.getModelCache().getModel(WageHolidaySetModel.class, wageHolidaySetDto.getId())) != null) {
            wageHolidaySetModel.checkStaleState(wageHolidaySetDto);
        }
        if ((letterDtos = areaObjectDto.getLetters()) != null) {
            for (LetterDto letterDto : letterDtos) {
                LetterModelImpl letterModel = (LetterModelImpl)this.getModelCache().getModel(LetterModel.class, letterDto.getId());
                if (letterModel == null) continue;
                letterModel.checkStaleState(letterDto);
            }
        }
        if ((areaDeliveryRoundDtos = areaObjectDto.getAreaDeliveryRounds()) != null) {
            for (AreaDeliveryRoundDto areaDeliveryRoundDto : areaDeliveryRoundDtos) {
                AreaDeliveryRoundModelImpl areaDeliveryRoundModel = (AreaDeliveryRoundModelImpl)this.getModelCache().getModel(AreaDeliveryRoundModel.class, areaDeliveryRoundDto.getId());
                if (areaDeliveryRoundModel == null) continue;
                areaDeliveryRoundModel.checkStaleState(areaDeliveryRoundDto);
            }
        }
    }

    @Override
    public AreaObjectFullDto createDto() {
        WageHolidaySetModelImpl wageHolidaySet;
        PoiModelImpl lastPickPoint;
        WageParameterModelImpl wageParameter;
        Long id = this.getId();
        AreaObjectFullDto areaObjectDto = id == null ? new AreaObjectFullDto(this.getTempUUID()) : new AreaObjectFullDto(id, this.getVersion());
        areaObjectDto.setDisplayname(this.getDisplayname());
        areaObjectDto.setShortcut(this.getShortcut());
        AreaLayerModelImpl areaLayer = (AreaLayerModelImpl)this.getAreaLayer();
        if (areaLayer != null) {
            areaObjectDto.setAreaLayer(areaLayer.createProxy());
        }
        ImmutablePolygonKind geom = this.getGeom();
        areaObjectDto.setGeom(ImmutablePolygonKindDto.create(geom));
        PoiModelImpl poi = (PoiModelImpl)this.getPoi();
        if (poi != null) {
            areaObjectDto.setPoi(poi.createProxy());
        }
        if ((wageParameter = (WageParameterModelImpl)this.getWageParameter()) != null) {
            areaObjectDto.setWageParameter(wageParameter.createProxy());
        }
        areaObjectDto.setLastExportedTimestamp(this.getLastExportedTimestamp());
        PoiModelImpl firstPickPoint = (PoiModelImpl)this.getFirstPickPoint();
        if (firstPickPoint != null) {
            areaObjectDto.setFirstPickPoint(firstPickPoint.createProxy());
        }
        if ((lastPickPoint = (PoiModelImpl)this.getLastPickPoint()) != null) {
            areaObjectDto.setLastPickPoint(lastPickPoint.createProxy());
        }
        if ((wageHolidaySet = (WageHolidaySetModelImpl)this.getWageHolidaySet()) != null) {
            areaObjectDto.setWageHolidaySet(wageHolidaySet.createProxy());
        }
        return areaObjectDto;
    }

    @Override
    public AreaObjectProxyDto createProxy() {
        Long id = this.getId();
        AreaObjectProxyDto areaObjectDto = id == null ? new AreaObjectProxyDto(this.getTempUUID()) : new AreaObjectProxyDto(id, this.getVersion());
        return areaObjectDto;
    }

    public static enum AreaObjectModelEnum {
        DISPLAYNAME("displayname"),
        SHORTCUT("shortcut"),
        AREA_LAYER("areaLayer"),
        GEN_INFO("genInfo"),
        GEOM("geom"),
        AREA_ATTRIBUTE_VALUES("areaAttributeValues"),
        AREA_OBJECT_PARCEL_REL("areaObjectParcelRel"),
        POI("poi"),
        DETAILLESS_AREA_OBJECT_GEOMETRIES("detaillessAreaObjectGeometries"),
        WAGE_PARAMETER("wageParameter"),
        SUBSCRIPTIONS("subscriptions"),
        LAST_EXPORTED_TIMESTAMP("lastExportedTimestamp"),
        FIRST_PICK_POINT("firstPickPoint"),
        LAST_PICK_POINT("lastPickPoint"),
        WAGE_HOLIDAY_SET("wageHolidaySet"),
        LETTERS("letters"),
        AREA_DELIVERY_ROUNDS("areaDeliveryRounds");

        private String propertyName;

        private AreaObjectModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

