/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.area;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.area.AreaFilterPatternParameterModel;
import de.datomino.peppergis.client.model.area.AreaFilterPatternParameterModelImpl;
import de.datomino.peppergis.client.model.area.AreaFilterPatternRelationModel;
import de.datomino.peppergis.client.model.area.AreaFilterPatternSetupModel;
import de.datomino.peppergis.client.model.area.AreaFilterPatternSetupModelImpl;
import de.datomino.peppergis.dto.area.AreaFilterPatternParameterDto;
import de.datomino.peppergis.dto.area.AreaFilterPatternRelationFullDto;
import de.datomino.peppergis.dto.area.AreaFilterPatternRelationProxyDto;
import de.datomino.peppergis.dto.area.AreaFilterPatternSetupDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.RendererType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class AreaFilterPatternRelationModelImpl
extends AbstractModel<AreaFilterPatternRelationFullDto, AreaFilterPatternRelationProxyDto>
implements AreaFilterPatternRelationModel {
    private AreaFilterPatternSetupModel patternSetup;
    private RendererType rendererType;
    private Integer sortOrder;
    private List<AreaFilterPatternParameterModel> parameters = null;

    public AreaFilterPatternRelationModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public AreaFilterPatternRelationModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public AreaFilterPatternSetupModel getPatternSetup() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.patternSetup;
    }

    @Override
    public void setPatternSetup(AreaFilterPatternSetupModel patternSetup) {
        this.setPatternSetup(patternSetup, true);
    }

    private void setPatternSetup(AreaFilterPatternSetupModel patternSetup, boolean setDirty) {
        AreaFilterPatternSetupModel oldPatternSetup = this.getPatternSetup();
        if (oldPatternSetup == patternSetup) {
            return;
        }
        if (oldPatternSetup != null) {
            oldPatternSetup.removeRelation(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaFilterPatternRelationModelEnum.PATTERN_SETUP.getPropertyName());
        }
        this.patternSetup = patternSetup;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaFilterPatternRelationModelEnum.PATTERN_SETUP, patternSetup, oldPatternSetup);
        if (this.patternSetup != null) {
            this.patternSetup.addRelation(this);
        }
    }

    @Override
    public RendererType getRendererType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.rendererType;
    }

    @Override
    public void setRendererType(RendererType rendererType) {
        this.setRendererType(rendererType, true);
    }

    private void setRendererType(RendererType rendererType, boolean setDirty) {
        RendererType oldRendererType = this.getRendererType();
        if (new EqualsBuilder().append((Object)oldRendererType, (Object)rendererType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaFilterPatternRelationModelEnum.RENDERER_TYPE.getPropertyName());
        }
        this.rendererType = rendererType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaFilterPatternRelationModelEnum.RENDERER_TYPE, (Object)rendererType, (Object)oldRendererType);
    }

    @Override
    public Integer getSortOrder() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.sortOrder;
    }

    @Override
    public void setSortOrder(Integer sortOrder) {
        this.setSortOrder(sortOrder, true);
    }

    private void setSortOrder(Integer sortOrder, boolean setDirty) {
        Integer oldSortOrder = this.getSortOrder();
        if (new EqualsBuilder().append(oldSortOrder, sortOrder).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaFilterPatternRelationModelEnum.SORT_ORDER.getPropertyName());
        }
        this.sortOrder = sortOrder;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaFilterPatternRelationModelEnum.SORT_ORDER, sortOrder, oldSortOrder);
    }

    @Override
    public int countParameters() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<AreaFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, AreaFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        return this.parameters.size();
    }

    @Override
    public Iterator<AreaFilterPatternParameterModel> iterateParameters() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<AreaFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, AreaFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        return new ImmutableIterator<AreaFilterPatternParameterModel>(this.parameters);
    }

    @Override
    public Iterable<AreaFilterPatternParameterModel> iterableParameters() {
        return new IteratorIterable<AreaFilterPatternParameterModel>(this.iterateParameters());
    }

    @Override
    public void addParameter(AreaFilterPatternParameterModel parameter) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<AreaFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, AreaFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        if (this.parameters.contains(parameter)) {
            return;
        }
        this.parameters.add(parameter);
        this.fireValueChanged(AreaFilterPatternRelationModelEnum.PARAMETERS, parameter, null);
        if (parameter != null) {
            parameter.setRelation(this);
            parameter.setSortOrder(this.parameters.size() - 1);
        }
    }

    @Override
    public void removeParameter(AreaFilterPatternParameterModel parameter) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<AreaFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, AreaFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        if (!this.parameters.contains(parameter)) {
            return;
        }
        this.parameters.remove(parameter);
        this.fireValueChanged(AreaFilterPatternRelationModelEnum.PARAMETERS, parameter, null);
        if (parameter != null) {
            parameter.setRelation(null);
            parameter.setSortOrder(null);
        }
        this.reorderParameters(0);
    }

    @Override
    public AreaFilterPatternParameterModel getParameterAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<AreaFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, AreaFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        return this.parameters.get(index);
    }

    @Override
    public void insertParameter(AreaFilterPatternParameterModel parameter, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<AreaFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, AreaFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        if (this.parameters.contains(parameter)) {
            this.removeParameter(parameter);
        }
        this.parameters.add(index, parameter);
        this.fireValueChanged(AreaFilterPatternRelationModelEnum.PARAMETERS, parameter, null);
        if (parameter != null) {
            parameter.setRelation(this);
        }
        this.reorderParameters(index);
    }

    @Override
    public void removeParameterAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<AreaFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, AreaFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        AreaFilterPatternParameterModel oldParameter = this.parameters.get(index);
        this.parameters.remove(index);
        this.fireValueChanged(AreaFilterPatternRelationModelEnum.PARAMETERS, oldParameter, null);
        if (oldParameter != null) {
            oldParameter.setRelation(null);
            oldParameter.setSortOrder(null);
        }
        this.reorderParameters(index);
    }

    @Override
    public void setParameterAt(AreaFilterPatternParameterModel parameter, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<AreaFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, AreaFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        AreaFilterPatternParameterModel oldParameter = this.parameters.get(index);
        this.parameters.set(index, parameter);
        this.fireValueChanged(AreaFilterPatternRelationModelEnum.PARAMETERS, parameter, oldParameter);
        if (oldParameter != null) {
            oldParameter.setRelation(null);
            oldParameter.setSortOrder(null);
        }
        if (parameter != null) {
            parameter.setRelation(this);
            parameter.setSortOrder(index);
        }
    }

    @Override
    public void clearParameters() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<AreaFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, AreaFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        ArrayList<AreaFilterPatternParameterModel> oldParameters = new ArrayList<AreaFilterPatternParameterModel>(this.parameters);
        this.parameters.clear();
        this.fireValueChanged(AreaFilterPatternRelationModelEnum.PARAMETERS, null, null);
        for (AreaFilterPatternParameterModel oldParameter : oldParameters) {
            if (oldParameter == null) continue;
            oldParameter.setRelation(null);
            oldParameter.setSortOrder(null);
        }
    }

    @Override
    public boolean isParametersEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<AreaFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, AreaFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        return this.parameters.isEmpty();
    }

    @Override
    public boolean containsParameter(AreaFilterPatternParameterModel parameter) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<AreaFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, AreaFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        return this.parameters.contains(parameter);
    }

    @Override
    public int indexOfParameter(AreaFilterPatternParameterModel parameter) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<AreaFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, AreaFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        return this.parameters.indexOf(parameter);
    }

    @Override
    public boolean isParametersInitialized() {
        return this.parameters != null;
    }

    private void reorderParameters(int startIndex) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<AreaFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, AreaFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        ListIterator<AreaFilterPatternParameterModel> listIterator = this.parameters.listIterator(startIndex);
        int index = startIndex;
        while (listIterator.hasNext()) {
            AreaFilterPatternParameterModel parameter = listIterator.next();
            parameter.setSortOrder(index++);
        }
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.parameters = null;
        }
    }

    @Override
    protected void updateByDto(AreaFilterPatternRelationFullDto areaFilterPatternRelationDto) {
        this.patternSetup = (AreaFilterPatternSetupModel)this.getModelCache().getModel(areaFilterPatternRelationDto.getPatternSetup());
        this.rendererType = areaFilterPatternRelationDto.getRendererType();
        this.sortOrder = areaFilterPatternRelationDto.getSortOrder();
        AreaFilterPatternParameterDto[] parameters = areaFilterPatternRelationDto.getParameters();
        if (parameters != null) {
            if (this.parameters == null) {
                this.parameters = new ArrayList<AreaFilterPatternParameterModel>();
            } else {
                this.parameters.clear();
            }
        }
    }

    @Override
    protected void updateMasterRelationsByDto(AreaFilterPatternRelationFullDto areaFilterPatternRelationDto) {
        AreaFilterPatternParameterDto[] parameters = areaFilterPatternRelationDto.getParameters();
        if (parameters != null) {
            if (this.parameters == null) {
                this.parameters = new ArrayList<AreaFilterPatternParameterModel>();
            } else {
                this.parameters.clear();
            }
            for (AreaFilterPatternParameterDto parameterDto : parameters) {
                AreaFilterPatternParameterModel parameterModel = (AreaFilterPatternParameterModel)this.getModelCache().getModel(parameterDto);
                this.parameters.add(parameterModel);
            }
        } else {
            this.parameters = null;
        }
    }

    @Override
    protected void checkStaleByDto(AreaFilterPatternRelationFullDto areaFilterPatternRelationDto) throws StaleStateException {
        AreaFilterPatternParameterDto[] parameterDtos;
        AreaFilterPatternSetupModelImpl patternSetupModel;
        AreaFilterPatternSetupDto patternSetupDto = areaFilterPatternRelationDto.getPatternSetup();
        if (patternSetupDto != null && patternSetupDto.getId() != null && (patternSetupModel = (AreaFilterPatternSetupModelImpl)this.getModelCache().getModel(AreaFilterPatternSetupModel.class, patternSetupDto.getId())) != null) {
            patternSetupModel.checkStaleState(patternSetupDto);
        }
        if ((parameterDtos = areaFilterPatternRelationDto.getParameters()) != null) {
            for (AreaFilterPatternParameterDto parameterDto : parameterDtos) {
                AreaFilterPatternParameterModelImpl parameterModel = (AreaFilterPatternParameterModelImpl)this.getModelCache().getModel(AreaFilterPatternParameterModel.class, parameterDto.getId());
                if (parameterModel == null) continue;
                parameterModel.checkStaleState(parameterDto);
            }
        }
    }

    @Override
    public AreaFilterPatternRelationFullDto createDto() {
        Long id = this.getId();
        AreaFilterPatternRelationFullDto areaFilterPatternRelationDto = id == null ? new AreaFilterPatternRelationFullDto(this.getTempUUID()) : new AreaFilterPatternRelationFullDto(id, this.getVersion());
        AreaFilterPatternSetupModelImpl patternSetup = (AreaFilterPatternSetupModelImpl)this.getPatternSetup();
        if (patternSetup != null) {
            areaFilterPatternRelationDto.setPatternSetup(patternSetup.createProxy());
        }
        areaFilterPatternRelationDto.setRendererType(this.getRendererType());
        areaFilterPatternRelationDto.setSortOrder(this.getSortOrder());
        return areaFilterPatternRelationDto;
    }

    @Override
    public AreaFilterPatternRelationProxyDto createProxy() {
        Long id = this.getId();
        AreaFilterPatternRelationProxyDto areaFilterPatternRelationDto = id == null ? new AreaFilterPatternRelationProxyDto(this.getTempUUID()) : new AreaFilterPatternRelationProxyDto(id, this.getVersion());
        return areaFilterPatternRelationDto;
    }

    public static enum AreaFilterPatternRelationModelEnum {
        PATTERN_SETUP("patternSetup"),
        RENDERER_TYPE("rendererType"),
        SORT_ORDER("sortOrder"),
        PARAMETERS("parameters");

        private String propertyName;

        private AreaFilterPatternRelationModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

