/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.area;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.area.AreaDeliveryRoundModel;
import de.datomino.peppergis.client.model.area.AreaDeliveryRoundReplacementModel;
import de.datomino.peppergis.client.model.area.AreaDeliveryRoundReplacementModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectModelImpl;
import de.datomino.peppergis.client.model.area.DeliveryRoundRelationModel;
import de.datomino.peppergis.client.model.area.DeliveryRoundRelationModelImpl;
import de.datomino.peppergis.dto.area.AreaDeliveryRoundFullDto;
import de.datomino.peppergis.dto.area.AreaDeliveryRoundProxyDto;
import de.datomino.peppergis.dto.area.AreaDeliveryRoundReplacementDto;
import de.datomino.peppergis.dto.area.AreaObjectDto;
import de.datomino.peppergis.dto.area.DeliveryRoundRelationDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class AreaDeliveryRoundModelImpl
extends AbstractModel<AreaDeliveryRoundFullDto, AreaDeliveryRoundProxyDto>
implements AreaDeliveryRoundModel {
    private DeliveryRoundRelationModel monday;
    private DeliveryRoundRelationModel tuesday;
    private DeliveryRoundRelationModel wednesday;
    private DeliveryRoundRelationModel thursday;
    private DeliveryRoundRelationModel friday;
    private DeliveryRoundRelationModel saturday;
    private DeliveryRoundRelationModel sunday;
    private Set<AreaDeliveryRoundReplacementModel> replacements = null;
    private AreaObjectModel areaObject;

    public AreaDeliveryRoundModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public AreaDeliveryRoundModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public DeliveryRoundRelationModel getMonday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.monday;
    }

    @Override
    public void setMonday(DeliveryRoundRelationModel monday) {
        this.setMonday(monday, true);
    }

    private void setMonday(DeliveryRoundRelationModel monday, boolean setDirty) {
        DeliveryRoundRelationModel oldMonday = this.getMonday();
        if (oldMonday == monday) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDeliveryRoundModelEnum.MONDAY.getPropertyName());
        }
        this.monday = monday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDeliveryRoundModelEnum.MONDAY, monday, oldMonday);
    }

    @Override
    public DeliveryRoundRelationModel getTuesday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.tuesday;
    }

    @Override
    public void setTuesday(DeliveryRoundRelationModel tuesday) {
        this.setTuesday(tuesday, true);
    }

    private void setTuesday(DeliveryRoundRelationModel tuesday, boolean setDirty) {
        DeliveryRoundRelationModel oldTuesday = this.getTuesday();
        if (oldTuesday == tuesday) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDeliveryRoundModelEnum.TUESDAY.getPropertyName());
        }
        this.tuesday = tuesday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDeliveryRoundModelEnum.TUESDAY, tuesday, oldTuesday);
    }

    @Override
    public DeliveryRoundRelationModel getWednesday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.wednesday;
    }

    @Override
    public void setWednesday(DeliveryRoundRelationModel wednesday) {
        this.setWednesday(wednesday, true);
    }

    private void setWednesday(DeliveryRoundRelationModel wednesday, boolean setDirty) {
        DeliveryRoundRelationModel oldWednesday = this.getWednesday();
        if (oldWednesday == wednesday) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDeliveryRoundModelEnum.WEDNESDAY.getPropertyName());
        }
        this.wednesday = wednesday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDeliveryRoundModelEnum.WEDNESDAY, wednesday, oldWednesday);
    }

    @Override
    public DeliveryRoundRelationModel getThursday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.thursday;
    }

    @Override
    public void setThursday(DeliveryRoundRelationModel thursday) {
        this.setThursday(thursday, true);
    }

    private void setThursday(DeliveryRoundRelationModel thursday, boolean setDirty) {
        DeliveryRoundRelationModel oldThursday = this.getThursday();
        if (oldThursday == thursday) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDeliveryRoundModelEnum.THURSDAY.getPropertyName());
        }
        this.thursday = thursday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDeliveryRoundModelEnum.THURSDAY, thursday, oldThursday);
    }

    @Override
    public DeliveryRoundRelationModel getFriday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.friday;
    }

    @Override
    public void setFriday(DeliveryRoundRelationModel friday) {
        this.setFriday(friday, true);
    }

    private void setFriday(DeliveryRoundRelationModel friday, boolean setDirty) {
        DeliveryRoundRelationModel oldFriday = this.getFriday();
        if (oldFriday == friday) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDeliveryRoundModelEnum.FRIDAY.getPropertyName());
        }
        this.friday = friday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDeliveryRoundModelEnum.FRIDAY, friday, oldFriday);
    }

    @Override
    public DeliveryRoundRelationModel getSaturday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.saturday;
    }

    @Override
    public void setSaturday(DeliveryRoundRelationModel saturday) {
        this.setSaturday(saturday, true);
    }

    private void setSaturday(DeliveryRoundRelationModel saturday, boolean setDirty) {
        DeliveryRoundRelationModel oldSaturday = this.getSaturday();
        if (oldSaturday == saturday) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDeliveryRoundModelEnum.SATURDAY.getPropertyName());
        }
        this.saturday = saturday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDeliveryRoundModelEnum.SATURDAY, saturday, oldSaturday);
    }

    @Override
    public DeliveryRoundRelationModel getSunday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.sunday;
    }

    @Override
    public void setSunday(DeliveryRoundRelationModel sunday) {
        this.setSunday(sunday, true);
    }

    private void setSunday(DeliveryRoundRelationModel sunday, boolean setDirty) {
        DeliveryRoundRelationModel oldSunday = this.getSunday();
        if (oldSunday == sunday) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDeliveryRoundModelEnum.SUNDAY.getPropertyName());
        }
        this.sunday = sunday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDeliveryRoundModelEnum.SUNDAY, sunday, oldSunday);
    }

    @Override
    public int countReplacements() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.replacements == null) {
            this.replacements = new LinkedHashSet<AreaDeliveryRoundReplacementModel>();
            if (this.getId() != null) {
                Collection replacementsCollection = this.commonCaller.fetchChildren(this, AreaDeliveryRoundModelEnum.REPLACEMENTS.getPropertyName());
                this.replacements.addAll(replacementsCollection);
            }
        }
        return this.replacements.size();
    }

    @Override
    public Iterator<AreaDeliveryRoundReplacementModel> iterateReplacements() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.replacements == null) {
            this.replacements = new LinkedHashSet<AreaDeliveryRoundReplacementModel>();
            if (this.getId() != null) {
                Collection replacementsCollection = this.commonCaller.fetchChildren(this, AreaDeliveryRoundModelEnum.REPLACEMENTS.getPropertyName());
                this.replacements.addAll(replacementsCollection);
            }
        }
        return new ImmutableIterator<AreaDeliveryRoundReplacementModel>(this.replacements);
    }

    @Override
    public Iterable<AreaDeliveryRoundReplacementModel> iterableReplacements() {
        return new IteratorIterable<AreaDeliveryRoundReplacementModel>(this.iterateReplacements());
    }

    @Override
    public void addReplacement(AreaDeliveryRoundReplacementModel replacement) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.replacements == null) {
            this.replacements = new LinkedHashSet<AreaDeliveryRoundReplacementModel>();
            if (this.getId() != null) {
                Collection replacementsCollection = this.commonCaller.fetchChildren(this, AreaDeliveryRoundModelEnum.REPLACEMENTS.getPropertyName());
                this.replacements.addAll(replacementsCollection);
            }
        }
        if (this.replacements.contains(replacement)) {
            return;
        }
        this.replacements.add(replacement);
        this.fireValueChanged(AreaDeliveryRoundModelEnum.REPLACEMENTS, replacement, null);
        if (replacement != null) {
            replacement.setAreaDeliveryRound(this);
        }
    }

    @Override
    public void removeReplacement(AreaDeliveryRoundReplacementModel replacement) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.replacements == null) {
            this.replacements = new LinkedHashSet<AreaDeliveryRoundReplacementModel>();
            if (this.getId() != null) {
                Collection replacementsCollection = this.commonCaller.fetchChildren(this, AreaDeliveryRoundModelEnum.REPLACEMENTS.getPropertyName());
                this.replacements.addAll(replacementsCollection);
            }
        }
        if (!this.replacements.contains(replacement)) {
            return;
        }
        this.replacements.remove(replacement);
        this.fireValueChanged(AreaDeliveryRoundModelEnum.REPLACEMENTS, replacement, null);
        if (replacement != null) {
            replacement.setAreaDeliveryRound(null);
        }
    }

    @Override
    public void clearReplacements() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.replacements == null) {
            this.replacements = new LinkedHashSet<AreaDeliveryRoundReplacementModel>();
            if (this.getId() != null) {
                Collection replacementsCollection = this.commonCaller.fetchChildren(this, AreaDeliveryRoundModelEnum.REPLACEMENTS.getPropertyName());
                this.replacements.addAll(replacementsCollection);
            }
        }
        ArrayList<AreaDeliveryRoundReplacementModel> oldReplacements = new ArrayList<AreaDeliveryRoundReplacementModel>(this.replacements);
        this.replacements.clear();
        this.fireValueChanged(AreaDeliveryRoundModelEnum.REPLACEMENTS, null, null);
        for (AreaDeliveryRoundReplacementModel oldReplacement : oldReplacements) {
            if (oldReplacement == null) continue;
            oldReplacement.setAreaDeliveryRound(null);
        }
    }

    @Override
    public boolean isReplacementsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.replacements == null) {
            this.replacements = new LinkedHashSet<AreaDeliveryRoundReplacementModel>();
            if (this.getId() != null) {
                Collection replacementsCollection = this.commonCaller.fetchChildren(this, AreaDeliveryRoundModelEnum.REPLACEMENTS.getPropertyName());
                this.replacements.addAll(replacementsCollection);
            }
        }
        return this.replacements.isEmpty();
    }

    @Override
    public boolean containsReplacement(AreaDeliveryRoundReplacementModel replacement) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.replacements == null) {
            this.replacements = new LinkedHashSet<AreaDeliveryRoundReplacementModel>();
            if (this.getId() != null) {
                Collection replacementsCollection = this.commonCaller.fetchChildren(this, AreaDeliveryRoundModelEnum.REPLACEMENTS.getPropertyName());
                this.replacements.addAll(replacementsCollection);
            }
        }
        return this.replacements.contains(replacement);
    }

    @Override
    public boolean isReplacementsInitialized() {
        return this.replacements != null;
    }

    @Override
    public AreaObjectModel getAreaObject() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.areaObject;
    }

    @Override
    public void setAreaObject(AreaObjectModel areaObject) {
        this.setAreaObject(areaObject, true);
    }

    private void setAreaObject(AreaObjectModel areaObject, boolean setDirty) {
        AreaObjectModel oldAreaObject = this.getAreaObject();
        if (oldAreaObject == areaObject) {
            return;
        }
        if (oldAreaObject != null) {
            oldAreaObject.removeAreaDeliveryRound(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDeliveryRoundModelEnum.AREA_OBJECT.getPropertyName());
        }
        this.areaObject = areaObject;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDeliveryRoundModelEnum.AREA_OBJECT, areaObject, oldAreaObject);
        if (this.areaObject != null) {
            this.areaObject.addAreaDeliveryRound(this);
        }
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.replacements = null;
        }
    }

    @Override
    protected void updateByDto(AreaDeliveryRoundFullDto areaDeliveryRoundDto) {
        this.monday = (DeliveryRoundRelationModel)this.getModelCache().getModel(areaDeliveryRoundDto.getMonday());
        this.tuesday = (DeliveryRoundRelationModel)this.getModelCache().getModel(areaDeliveryRoundDto.getTuesday());
        this.wednesday = (DeliveryRoundRelationModel)this.getModelCache().getModel(areaDeliveryRoundDto.getWednesday());
        this.thursday = (DeliveryRoundRelationModel)this.getModelCache().getModel(areaDeliveryRoundDto.getThursday());
        this.friday = (DeliveryRoundRelationModel)this.getModelCache().getModel(areaDeliveryRoundDto.getFriday());
        this.saturday = (DeliveryRoundRelationModel)this.getModelCache().getModel(areaDeliveryRoundDto.getSaturday());
        this.sunday = (DeliveryRoundRelationModel)this.getModelCache().getModel(areaDeliveryRoundDto.getSunday());
        AreaDeliveryRoundReplacementDto[] replacements = areaDeliveryRoundDto.getReplacements();
        if (replacements != null) {
            if (this.replacements == null) {
                this.replacements = new LinkedHashSet<AreaDeliveryRoundReplacementModel>();
            } else {
                this.replacements.clear();
            }
        }
        this.areaObject = (AreaObjectModel)this.getModelCache().getModel(areaDeliveryRoundDto.getAreaObject());
    }

    @Override
    protected void updateMasterRelationsByDto(AreaDeliveryRoundFullDto areaDeliveryRoundDto) {
        AreaDeliveryRoundReplacementDto[] replacements = areaDeliveryRoundDto.getReplacements();
        if (replacements != null) {
            if (this.replacements == null) {
                this.replacements = new LinkedHashSet<AreaDeliveryRoundReplacementModel>();
            } else {
                this.replacements.clear();
            }
            for (AreaDeliveryRoundReplacementDto replacementDto : replacements) {
                AreaDeliveryRoundReplacementModel replacementModel = (AreaDeliveryRoundReplacementModel)this.getModelCache().getModel(replacementDto);
                this.replacements.add(replacementModel);
            }
        } else {
            this.replacements = null;
        }
    }

    @Override
    protected void checkStaleByDto(AreaDeliveryRoundFullDto areaDeliveryRoundDto) throws StaleStateException {
        AreaObjectModelImpl areaObjectModel;
        AreaObjectDto areaObjectDto;
        AreaDeliveryRoundReplacementDto[] replacementDtos;
        DeliveryRoundRelationModelImpl sundayModel;
        DeliveryRoundRelationDto sundayDto;
        DeliveryRoundRelationModelImpl saturdayModel;
        DeliveryRoundRelationDto saturdayDto;
        DeliveryRoundRelationModelImpl fridayModel;
        DeliveryRoundRelationDto fridayDto;
        DeliveryRoundRelationModelImpl thursdayModel;
        DeliveryRoundRelationDto thursdayDto;
        DeliveryRoundRelationModelImpl wednesdayModel;
        DeliveryRoundRelationDto wednesdayDto;
        DeliveryRoundRelationModelImpl tuesdayModel;
        DeliveryRoundRelationDto tuesdayDto;
        DeliveryRoundRelationModelImpl mondayModel;
        DeliveryRoundRelationDto mondayDto = areaDeliveryRoundDto.getMonday();
        if (mondayDto != null && mondayDto.getId() != null && (mondayModel = (DeliveryRoundRelationModelImpl)this.getModelCache().getModel(DeliveryRoundRelationModel.class, mondayDto.getId())) != null) {
            mondayModel.checkStaleState(mondayDto);
        }
        if ((tuesdayDto = areaDeliveryRoundDto.getTuesday()) != null && tuesdayDto.getId() != null && (tuesdayModel = (DeliveryRoundRelationModelImpl)this.getModelCache().getModel(DeliveryRoundRelationModel.class, tuesdayDto.getId())) != null) {
            tuesdayModel.checkStaleState(tuesdayDto);
        }
        if ((wednesdayDto = areaDeliveryRoundDto.getWednesday()) != null && wednesdayDto.getId() != null && (wednesdayModel = (DeliveryRoundRelationModelImpl)this.getModelCache().getModel(DeliveryRoundRelationModel.class, wednesdayDto.getId())) != null) {
            wednesdayModel.checkStaleState(wednesdayDto);
        }
        if ((thursdayDto = areaDeliveryRoundDto.getThursday()) != null && thursdayDto.getId() != null && (thursdayModel = (DeliveryRoundRelationModelImpl)this.getModelCache().getModel(DeliveryRoundRelationModel.class, thursdayDto.getId())) != null) {
            thursdayModel.checkStaleState(thursdayDto);
        }
        if ((fridayDto = areaDeliveryRoundDto.getFriday()) != null && fridayDto.getId() != null && (fridayModel = (DeliveryRoundRelationModelImpl)this.getModelCache().getModel(DeliveryRoundRelationModel.class, fridayDto.getId())) != null) {
            fridayModel.checkStaleState(fridayDto);
        }
        if ((saturdayDto = areaDeliveryRoundDto.getSaturday()) != null && saturdayDto.getId() != null && (saturdayModel = (DeliveryRoundRelationModelImpl)this.getModelCache().getModel(DeliveryRoundRelationModel.class, saturdayDto.getId())) != null) {
            saturdayModel.checkStaleState(saturdayDto);
        }
        if ((sundayDto = areaDeliveryRoundDto.getSunday()) != null && sundayDto.getId() != null && (sundayModel = (DeliveryRoundRelationModelImpl)this.getModelCache().getModel(DeliveryRoundRelationModel.class, sundayDto.getId())) != null) {
            sundayModel.checkStaleState(sundayDto);
        }
        if ((replacementDtos = areaDeliveryRoundDto.getReplacements()) != null) {
            for (AreaDeliveryRoundReplacementDto replacementDto : replacementDtos) {
                AreaDeliveryRoundReplacementModelImpl replacementModel = (AreaDeliveryRoundReplacementModelImpl)this.getModelCache().getModel(AreaDeliveryRoundReplacementModel.class, replacementDto.getId());
                if (replacementModel == null) continue;
                replacementModel.checkStaleState(replacementDto);
            }
        }
        if ((areaObjectDto = areaDeliveryRoundDto.getAreaObject()) != null && areaObjectDto.getId() != null && (areaObjectModel = (AreaObjectModelImpl)this.getModelCache().getModel(AreaObjectModel.class, areaObjectDto.getId())) != null) {
            areaObjectModel.checkStaleState(areaObjectDto);
        }
    }

    @Override
    public AreaDeliveryRoundFullDto createDto() {
        AreaObjectModelImpl areaObject;
        DeliveryRoundRelationModelImpl sunday;
        DeliveryRoundRelationModelImpl saturday;
        DeliveryRoundRelationModelImpl friday;
        DeliveryRoundRelationModelImpl thursday;
        DeliveryRoundRelationModelImpl wednesday;
        DeliveryRoundRelationModelImpl tuesday;
        Long id = this.getId();
        AreaDeliveryRoundFullDto areaDeliveryRoundDto = id == null ? new AreaDeliveryRoundFullDto(this.getTempUUID()) : new AreaDeliveryRoundFullDto(id, this.getVersion());
        DeliveryRoundRelationModelImpl monday = (DeliveryRoundRelationModelImpl)this.getMonday();
        if (monday != null) {
            areaDeliveryRoundDto.setMonday(monday.createProxy());
        }
        if ((tuesday = (DeliveryRoundRelationModelImpl)this.getTuesday()) != null) {
            areaDeliveryRoundDto.setTuesday(tuesday.createProxy());
        }
        if ((wednesday = (DeliveryRoundRelationModelImpl)this.getWednesday()) != null) {
            areaDeliveryRoundDto.setWednesday(wednesday.createProxy());
        }
        if ((thursday = (DeliveryRoundRelationModelImpl)this.getThursday()) != null) {
            areaDeliveryRoundDto.setThursday(thursday.createProxy());
        }
        if ((friday = (DeliveryRoundRelationModelImpl)this.getFriday()) != null) {
            areaDeliveryRoundDto.setFriday(friday.createProxy());
        }
        if ((saturday = (DeliveryRoundRelationModelImpl)this.getSaturday()) != null) {
            areaDeliveryRoundDto.setSaturday(saturday.createProxy());
        }
        if ((sunday = (DeliveryRoundRelationModelImpl)this.getSunday()) != null) {
            areaDeliveryRoundDto.setSunday(sunday.createProxy());
        }
        if ((areaObject = (AreaObjectModelImpl)this.getAreaObject()) != null) {
            areaDeliveryRoundDto.setAreaObject(areaObject.createProxy());
        }
        return areaDeliveryRoundDto;
    }

    @Override
    public AreaDeliveryRoundProxyDto createProxy() {
        Long id = this.getId();
        AreaDeliveryRoundProxyDto areaDeliveryRoundDto = id == null ? new AreaDeliveryRoundProxyDto(this.getTempUUID()) : new AreaDeliveryRoundProxyDto(id, this.getVersion());
        return areaDeliveryRoundDto;
    }

    public static enum AreaDeliveryRoundModelEnum {
        MONDAY("monday"),
        TUESDAY("tuesday"),
        WEDNESDAY("wednesday"),
        THURSDAY("thursday"),
        FRIDAY("friday"),
        SATURDAY("saturday"),
        SUNDAY("sunday"),
        REPLACEMENTS("replacements"),
        AREA_OBJECT("areaObject");

        private String propertyName;

        private AreaDeliveryRoundModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

