/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.admin;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.client.model.admin.UserModelImpl;
import de.datomino.peppergis.client.model.admin.UserPropertyModel;
import de.datomino.peppergis.dto.admin.UserDto;
import de.datomino.peppergis.dto.admin.UserPropertyFullDto;
import de.datomino.peppergis.dto.admin.UserPropertyProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class UserPropertyModelImpl
extends AbstractModel<UserPropertyFullDto, UserPropertyProxyDto>
implements UserPropertyModel {
    private String key;
    private String value;
    private UserModel user;

    public UserPropertyModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public UserPropertyModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getKey() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.setKey(key, true);
    }

    private void setKey(String key, boolean setDirty) {
        String oldKey = this.getKey();
        if (new EqualsBuilder().append(oldKey, key).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, UserPropertyModelEnum.KEY.getPropertyName());
        }
        this.key = key;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(UserPropertyModelEnum.KEY, key, oldKey);
    }

    @Override
    public String getValue() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.setValue(value, true);
    }

    private void setValue(String value, boolean setDirty) {
        String oldValue = this.getValue();
        if (new EqualsBuilder().append(oldValue, value).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, UserPropertyModelEnum.VALUE.getPropertyName());
        }
        this.value = value;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(UserPropertyModelEnum.VALUE, value, oldValue);
    }

    @Override
    public UserModel getUser() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.user;
    }

    @Override
    public void setUser(UserModel user) {
        this.setUser(user, true);
    }

    private void setUser(UserModel user, boolean setDirty) {
        UserModel oldUser = this.getUser();
        if (oldUser == user) {
            return;
        }
        if (oldUser != null) {
            oldUser.removeUserPropertie(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, UserPropertyModelEnum.USER.getPropertyName());
        }
        this.user = user;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(UserPropertyModelEnum.USER, user, oldUser);
        if (this.user != null) {
            this.user.addUserPropertie(this);
        }
    }

    @Override
    protected void updateByDto(UserPropertyFullDto userPropertyDto) {
        this.key = userPropertyDto.getKey();
        this.value = userPropertyDto.getValue();
        this.user = (UserModel)this.getModelCache().getModel(userPropertyDto.getUser());
    }

    @Override
    protected void updateMasterRelationsByDto(UserPropertyFullDto userPropertyDto) {
    }

    @Override
    protected void checkStaleByDto(UserPropertyFullDto userPropertyDto) throws StaleStateException {
        UserModelImpl userModel;
        UserDto userDto = userPropertyDto.getUser();
        if (userDto != null && userDto.getId() != null && (userModel = (UserModelImpl)this.getModelCache().getModel(UserModel.class, userDto.getId())) != null) {
            userModel.checkStaleState(userDto);
        }
    }

    @Override
    public UserPropertyFullDto createDto() {
        Long id = this.getId();
        UserPropertyFullDto userPropertyDto = id == null ? new UserPropertyFullDto(this.getTempUUID()) : new UserPropertyFullDto(id, this.getVersion());
        userPropertyDto.setKey(this.getKey());
        userPropertyDto.setValue(this.getValue());
        UserModelImpl user = (UserModelImpl)this.getUser();
        if (user != null) {
            userPropertyDto.setUser(user.createProxy());
        }
        return userPropertyDto;
    }

    @Override
    public UserPropertyProxyDto createProxy() {
        Long id = this.getId();
        UserPropertyProxyDto userPropertyDto = id == null ? new UserPropertyProxyDto(this.getTempUUID()) : new UserPropertyProxyDto(id, this.getVersion());
        return userPropertyDto;
    }

    public static enum UserPropertyModelEnum {
        KEY("key"),
        VALUE("value"),
        USER("user");

        private String propertyName;

        private UserPropertyModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

