/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.admin;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.client.model.admin.UserPropertyModel;
import de.datomino.peppergis.client.model.admin.UserPropertyModelImpl;
import de.datomino.peppergis.client.model.admin.UserRoleObjectModel;
import de.datomino.peppergis.client.model.admin.UserRoleObjectModelImpl;
import de.datomino.peppergis.client.model.admin.UserSessionModel;
import de.datomino.peppergis.client.model.admin.UserSessionModelImpl;
import de.datomino.peppergis.dto.admin.UserFullDto;
import de.datomino.peppergis.dto.admin.UserPropertyDto;
import de.datomino.peppergis.dto.admin.UserProxyDto;
import de.datomino.peppergis.dto.admin.UserRoleObjectDto;
import de.datomino.peppergis.dto.admin.UserSessionDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class UserModelImpl
extends AbstractModel<UserFullDto, UserProxyDto>
implements UserModel {
    private String login;
    private String name;
    private String md5Password;
    private String salt;
    private Set<UserRoleObjectModel> userRoleObjects = null;
    private Set<UserSessionModel> userSessions = null;
    private Set<UserPropertyModel> userProperties = null;

    public UserModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public UserModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getLogin() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.login;
    }

    @Override
    public void setLogin(String login) {
        this.setLogin(login, true);
    }

    private void setLogin(String login, boolean setDirty) {
        String oldLogin = this.getLogin();
        if (new EqualsBuilder().append(oldLogin, login).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, UserModelEnum.LOGIN.getPropertyName());
        }
        this.login = login;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(UserModelEnum.LOGIN, login, oldLogin);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, UserModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(UserModelEnum.NAME, name, oldName);
    }

    @Override
    public String getMd5Password() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.md5Password;
    }

    @Override
    public void setMd5Password(String md5Password) {
        this.setMd5Password(md5Password, true);
    }

    private void setMd5Password(String md5Password, boolean setDirty) {
        String oldMd5Password = this.getMd5Password();
        if (new EqualsBuilder().append(oldMd5Password, md5Password).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, UserModelEnum.MD5_PASSWORD.getPropertyName());
        }
        this.md5Password = md5Password;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(UserModelEnum.MD5_PASSWORD, md5Password, oldMd5Password);
    }

    @Override
    public String getSalt() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.salt;
    }

    @Override
    public void setSalt(String salt) {
        this.setSalt(salt, true);
    }

    private void setSalt(String salt, boolean setDirty) {
        String oldSalt = this.getSalt();
        if (new EqualsBuilder().append(oldSalt, salt).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, UserModelEnum.SALT.getPropertyName());
        }
        this.salt = salt;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(UserModelEnum.SALT, salt, oldSalt);
    }

    @Override
    public int countUserRoleObjects() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.userRoleObjects == null) {
            this.userRoleObjects = new LinkedHashSet<UserRoleObjectModel>();
            if (this.getId() != null) {
                Collection userRoleObjectsCollection = this.commonCaller.fetchChildren(this, UserModelEnum.USER_ROLE_OBJECTS.getPropertyName());
                this.userRoleObjects.addAll(userRoleObjectsCollection);
            }
        }
        return this.userRoleObjects.size();
    }

    @Override
    public Iterator<UserRoleObjectModel> iterateUserRoleObjects() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.userRoleObjects == null) {
            this.userRoleObjects = new LinkedHashSet<UserRoleObjectModel>();
            if (this.getId() != null) {
                Collection userRoleObjectsCollection = this.commonCaller.fetchChildren(this, UserModelEnum.USER_ROLE_OBJECTS.getPropertyName());
                this.userRoleObjects.addAll(userRoleObjectsCollection);
            }
        }
        return new ImmutableIterator<UserRoleObjectModel>(this.userRoleObjects);
    }

    @Override
    public Iterable<UserRoleObjectModel> iterableUserRoleObjects() {
        return new IteratorIterable<UserRoleObjectModel>(this.iterateUserRoleObjects());
    }

    @Override
    public void addUserRoleObject(UserRoleObjectModel userRoleObject) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.userRoleObjects == null) {
            this.userRoleObjects = new LinkedHashSet<UserRoleObjectModel>();
            if (this.getId() != null) {
                Collection userRoleObjectsCollection = this.commonCaller.fetchChildren(this, UserModelEnum.USER_ROLE_OBJECTS.getPropertyName());
                this.userRoleObjects.addAll(userRoleObjectsCollection);
            }
        }
        if (this.userRoleObjects.contains(userRoleObject)) {
            return;
        }
        this.userRoleObjects.add(userRoleObject);
        this.fireValueChanged(UserModelEnum.USER_ROLE_OBJECTS, userRoleObject, null);
        if (userRoleObject != null) {
            userRoleObject.setUser(this);
        }
    }

    @Override
    public void removeUserRoleObject(UserRoleObjectModel userRoleObject) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.userRoleObjects == null) {
            this.userRoleObjects = new LinkedHashSet<UserRoleObjectModel>();
            if (this.getId() != null) {
                Collection userRoleObjectsCollection = this.commonCaller.fetchChildren(this, UserModelEnum.USER_ROLE_OBJECTS.getPropertyName());
                this.userRoleObjects.addAll(userRoleObjectsCollection);
            }
        }
        if (!this.userRoleObjects.contains(userRoleObject)) {
            return;
        }
        this.userRoleObjects.remove(userRoleObject);
        this.fireValueChanged(UserModelEnum.USER_ROLE_OBJECTS, userRoleObject, null);
        if (userRoleObject != null) {
            userRoleObject.setUser(null);
        }
    }

    @Override
    public void clearUserRoleObjects() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.userRoleObjects == null) {
            this.userRoleObjects = new LinkedHashSet<UserRoleObjectModel>();
            if (this.getId() != null) {
                Collection userRoleObjectsCollection = this.commonCaller.fetchChildren(this, UserModelEnum.USER_ROLE_OBJECTS.getPropertyName());
                this.userRoleObjects.addAll(userRoleObjectsCollection);
            }
        }
        ArrayList<UserRoleObjectModel> oldUserRoleObjects = new ArrayList<UserRoleObjectModel>(this.userRoleObjects);
        this.userRoleObjects.clear();
        this.fireValueChanged(UserModelEnum.USER_ROLE_OBJECTS, null, null);
        for (UserRoleObjectModel oldUserRoleObject : oldUserRoleObjects) {
            if (oldUserRoleObject == null) continue;
            oldUserRoleObject.setUser(null);
        }
    }

    @Override
    public boolean isUserRoleObjectsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.userRoleObjects == null) {
            this.userRoleObjects = new LinkedHashSet<UserRoleObjectModel>();
            if (this.getId() != null) {
                Collection userRoleObjectsCollection = this.commonCaller.fetchChildren(this, UserModelEnum.USER_ROLE_OBJECTS.getPropertyName());
                this.userRoleObjects.addAll(userRoleObjectsCollection);
            }
        }
        return this.userRoleObjects.isEmpty();
    }

    @Override
    public boolean containsUserRoleObject(UserRoleObjectModel userRoleObject) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.userRoleObjects == null) {
            this.userRoleObjects = new LinkedHashSet<UserRoleObjectModel>();
            if (this.getId() != null) {
                Collection userRoleObjectsCollection = this.commonCaller.fetchChildren(this, UserModelEnum.USER_ROLE_OBJECTS.getPropertyName());
                this.userRoleObjects.addAll(userRoleObjectsCollection);
            }
        }
        return this.userRoleObjects.contains(userRoleObject);
    }

    @Override
    public boolean isUserRoleObjectsInitialized() {
        return this.userRoleObjects != null;
    }

    @Override
    public int countUserSessions() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.userSessions == null) {
            this.userSessions = new LinkedHashSet<UserSessionModel>();
            if (this.getId() != null) {
                Collection userSessionsCollection = this.commonCaller.fetchChildren(this, UserModelEnum.USER_SESSIONS.getPropertyName());
                this.userSessions.addAll(userSessionsCollection);
            }
        }
        return this.userSessions.size();
    }

    @Override
    public Iterator<UserSessionModel> iterateUserSessions() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.userSessions == null) {
            this.userSessions = new LinkedHashSet<UserSessionModel>();
            if (this.getId() != null) {
                Collection userSessionsCollection = this.commonCaller.fetchChildren(this, UserModelEnum.USER_SESSIONS.getPropertyName());
                this.userSessions.addAll(userSessionsCollection);
            }
        }
        return new ImmutableIterator<UserSessionModel>(this.userSessions);
    }

    @Override
    public Iterable<UserSessionModel> iterableUserSessions() {
        return new IteratorIterable<UserSessionModel>(this.iterateUserSessions());
    }

    @Override
    public void addUserSession(UserSessionModel userSession) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.userSessions == null) {
            this.userSessions = new LinkedHashSet<UserSessionModel>();
            if (this.getId() != null) {
                Collection userSessionsCollection = this.commonCaller.fetchChildren(this, UserModelEnum.USER_SESSIONS.getPropertyName());
                this.userSessions.addAll(userSessionsCollection);
            }
        }
        if (this.userSessions.contains(userSession)) {
            return;
        }
        this.userSessions.add(userSession);
        this.fireValueChanged(UserModelEnum.USER_SESSIONS, userSession, null);
        if (userSession != null) {
            userSession.setUser(this);
        }
    }

    @Override
    public void removeUserSession(UserSessionModel userSession) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.userSessions == null) {
            this.userSessions = new LinkedHashSet<UserSessionModel>();
            if (this.getId() != null) {
                Collection userSessionsCollection = this.commonCaller.fetchChildren(this, UserModelEnum.USER_SESSIONS.getPropertyName());
                this.userSessions.addAll(userSessionsCollection);
            }
        }
        if (!this.userSessions.contains(userSession)) {
            return;
        }
        this.userSessions.remove(userSession);
        this.fireValueChanged(UserModelEnum.USER_SESSIONS, userSession, null);
        if (userSession != null) {
            userSession.setUser(null);
        }
    }

    @Override
    public void clearUserSessions() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.userSessions == null) {
            this.userSessions = new LinkedHashSet<UserSessionModel>();
            if (this.getId() != null) {
                Collection userSessionsCollection = this.commonCaller.fetchChildren(this, UserModelEnum.USER_SESSIONS.getPropertyName());
                this.userSessions.addAll(userSessionsCollection);
            }
        }
        ArrayList<UserSessionModel> oldUserSessions = new ArrayList<UserSessionModel>(this.userSessions);
        this.userSessions.clear();
        this.fireValueChanged(UserModelEnum.USER_SESSIONS, null, null);
        for (UserSessionModel oldUserSession : oldUserSessions) {
            if (oldUserSession == null) continue;
            oldUserSession.setUser(null);
        }
    }

    @Override
    public boolean isUserSessionsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.userSessions == null) {
            this.userSessions = new LinkedHashSet<UserSessionModel>();
            if (this.getId() != null) {
                Collection userSessionsCollection = this.commonCaller.fetchChildren(this, UserModelEnum.USER_SESSIONS.getPropertyName());
                this.userSessions.addAll(userSessionsCollection);
            }
        }
        return this.userSessions.isEmpty();
    }

    @Override
    public boolean containsUserSession(UserSessionModel userSession) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.userSessions == null) {
            this.userSessions = new LinkedHashSet<UserSessionModel>();
            if (this.getId() != null) {
                Collection userSessionsCollection = this.commonCaller.fetchChildren(this, UserModelEnum.USER_SESSIONS.getPropertyName());
                this.userSessions.addAll(userSessionsCollection);
            }
        }
        return this.userSessions.contains(userSession);
    }

    @Override
    public boolean isUserSessionsInitialized() {
        return this.userSessions != null;
    }

    @Override
    public int countUserProperties() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.userProperties == null) {
            this.userProperties = new LinkedHashSet<UserPropertyModel>();
            if (this.getId() != null) {
                Collection userPropertiesCollection = this.commonCaller.fetchChildren(this, UserModelEnum.USER_PROPERTIES.getPropertyName());
                this.userProperties.addAll(userPropertiesCollection);
            }
        }
        return this.userProperties.size();
    }

    @Override
    public Iterator<UserPropertyModel> iterateUserProperties() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.userProperties == null) {
            this.userProperties = new LinkedHashSet<UserPropertyModel>();
            if (this.getId() != null) {
                Collection userPropertiesCollection = this.commonCaller.fetchChildren(this, UserModelEnum.USER_PROPERTIES.getPropertyName());
                this.userProperties.addAll(userPropertiesCollection);
            }
        }
        return new ImmutableIterator<UserPropertyModel>(this.userProperties);
    }

    @Override
    public Iterable<UserPropertyModel> iterableUserProperties() {
        return new IteratorIterable<UserPropertyModel>(this.iterateUserProperties());
    }

    @Override
    public void addUserPropertie(UserPropertyModel userPropertie) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.userProperties == null) {
            this.userProperties = new LinkedHashSet<UserPropertyModel>();
            if (this.getId() != null) {
                Collection userPropertiesCollection = this.commonCaller.fetchChildren(this, UserModelEnum.USER_PROPERTIES.getPropertyName());
                this.userProperties.addAll(userPropertiesCollection);
            }
        }
        if (this.userProperties.contains(userPropertie)) {
            return;
        }
        this.userProperties.add(userPropertie);
        this.fireValueChanged(UserModelEnum.USER_PROPERTIES, userPropertie, null);
        if (userPropertie != null) {
            userPropertie.setUser(this);
        }
    }

    @Override
    public void removeUserPropertie(UserPropertyModel userPropertie) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.userProperties == null) {
            this.userProperties = new LinkedHashSet<UserPropertyModel>();
            if (this.getId() != null) {
                Collection userPropertiesCollection = this.commonCaller.fetchChildren(this, UserModelEnum.USER_PROPERTIES.getPropertyName());
                this.userProperties.addAll(userPropertiesCollection);
            }
        }
        if (!this.userProperties.contains(userPropertie)) {
            return;
        }
        this.userProperties.remove(userPropertie);
        this.fireValueChanged(UserModelEnum.USER_PROPERTIES, userPropertie, null);
        if (userPropertie != null) {
            userPropertie.setUser(null);
        }
    }

    @Override
    public void clearUserProperties() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.userProperties == null) {
            this.userProperties = new LinkedHashSet<UserPropertyModel>();
            if (this.getId() != null) {
                Collection userPropertiesCollection = this.commonCaller.fetchChildren(this, UserModelEnum.USER_PROPERTIES.getPropertyName());
                this.userProperties.addAll(userPropertiesCollection);
            }
        }
        ArrayList<UserPropertyModel> oldUserProperties = new ArrayList<UserPropertyModel>(this.userProperties);
        this.userProperties.clear();
        this.fireValueChanged(UserModelEnum.USER_PROPERTIES, null, null);
        for (UserPropertyModel oldUserPropertie : oldUserProperties) {
            if (oldUserPropertie == null) continue;
            oldUserPropertie.setUser(null);
        }
    }

    @Override
    public boolean isUserPropertiesEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.userProperties == null) {
            this.userProperties = new LinkedHashSet<UserPropertyModel>();
            if (this.getId() != null) {
                Collection userPropertiesCollection = this.commonCaller.fetchChildren(this, UserModelEnum.USER_PROPERTIES.getPropertyName());
                this.userProperties.addAll(userPropertiesCollection);
            }
        }
        return this.userProperties.isEmpty();
    }

    @Override
    public boolean containsUserPropertie(UserPropertyModel userPropertie) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.userProperties == null) {
            this.userProperties = new LinkedHashSet<UserPropertyModel>();
            if (this.getId() != null) {
                Collection userPropertiesCollection = this.commonCaller.fetchChildren(this, UserModelEnum.USER_PROPERTIES.getPropertyName());
                this.userProperties.addAll(userPropertiesCollection);
            }
        }
        return this.userProperties.contains(userPropertie);
    }

    @Override
    public boolean isUserPropertiesInitialized() {
        return this.userProperties != null;
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.userRoleObjects = null;
            this.userSessions = null;
            this.userProperties = null;
        }
    }

    @Override
    protected void updateByDto(UserFullDto userDto) {
        UserPropertyDto[] userProperties;
        UserSessionDto[] userSessions;
        this.login = userDto.getLogin();
        this.name = userDto.getName();
        this.md5Password = userDto.getMd5Password();
        this.salt = userDto.getSalt();
        UserRoleObjectDto[] userRoleObjects = userDto.getUserRoleObjects();
        if (userRoleObjects != null) {
            if (this.userRoleObjects == null) {
                this.userRoleObjects = new LinkedHashSet<UserRoleObjectModel>();
            } else {
                this.userRoleObjects.clear();
            }
        }
        if ((userSessions = userDto.getUserSessions()) != null) {
            if (this.userSessions == null) {
                this.userSessions = new LinkedHashSet<UserSessionModel>();
            } else {
                this.userSessions.clear();
            }
        }
        if ((userProperties = userDto.getUserProperties()) != null) {
            if (this.userProperties == null) {
                this.userProperties = new LinkedHashSet<UserPropertyModel>();
            } else {
                this.userProperties.clear();
            }
        }
    }

    @Override
    protected void updateMasterRelationsByDto(UserFullDto userDto) {
        UserPropertyDto[] userProperties;
        UserSessionDto[] userSessions;
        UserRoleObjectDto[] userRoleObjects = userDto.getUserRoleObjects();
        if (userRoleObjects != null) {
            if (this.userRoleObjects == null) {
                this.userRoleObjects = new LinkedHashSet<UserRoleObjectModel>();
            } else {
                this.userRoleObjects.clear();
            }
            for (UserRoleObjectDto userRoleObjectDto : userRoleObjects) {
                UserRoleObjectModel userRoleObjectModel = (UserRoleObjectModel)this.getModelCache().getModel(userRoleObjectDto);
                this.userRoleObjects.add(userRoleObjectModel);
            }
        } else {
            this.userRoleObjects = null;
        }
        if ((userSessions = userDto.getUserSessions()) != null) {
            if (this.userSessions == null) {
                this.userSessions = new LinkedHashSet<UserSessionModel>();
            } else {
                this.userSessions.clear();
            }
            for (UserSessionDto userSessionDto : userSessions) {
                UserSessionModel userSessionModel = (UserSessionModel)this.getModelCache().getModel(userSessionDto);
                this.userSessions.add(userSessionModel);
            }
        } else {
            this.userSessions = null;
        }
        if ((userProperties = userDto.getUserProperties()) != null) {
            if (this.userProperties == null) {
                this.userProperties = new LinkedHashSet<UserPropertyModel>();
            } else {
                this.userProperties.clear();
            }
            for (UserPropertyDto userPropertieDto : userProperties) {
                UserPropertyModel userPropertieModel = (UserPropertyModel)this.getModelCache().getModel(userPropertieDto);
                this.userProperties.add(userPropertieModel);
            }
        } else {
            this.userProperties = null;
        }
    }

    @Override
    protected void checkStaleByDto(UserFullDto userDto) throws StaleStateException {
        UserPropertyDto[] userPropertieDtos;
        UserSessionDto[] userSessionDtos;
        UserRoleObjectDto[] userRoleObjectDtos = userDto.getUserRoleObjects();
        if (userRoleObjectDtos != null) {
            for (UserRoleObjectDto userRoleObjectDto : userRoleObjectDtos) {
                UserRoleObjectModelImpl userRoleObjectModel = (UserRoleObjectModelImpl)this.getModelCache().getModel(UserRoleObjectModel.class, userRoleObjectDto.getId());
                if (userRoleObjectModel == null) continue;
                userRoleObjectModel.checkStaleState(userRoleObjectDto);
            }
        }
        if ((userSessionDtos = userDto.getUserSessions()) != null) {
            for (UserSessionDto userSessionDto : userSessionDtos) {
                UserSessionModelImpl userSessionModel = (UserSessionModelImpl)this.getModelCache().getModel(UserSessionModel.class, userSessionDto.getId());
                if (userSessionModel == null) continue;
                userSessionModel.checkStaleState(userSessionDto);
            }
        }
        if ((userPropertieDtos = userDto.getUserProperties()) != null) {
            for (UserPropertyDto userPropertieDto : userPropertieDtos) {
                UserPropertyModelImpl userPropertieModel = (UserPropertyModelImpl)this.getModelCache().getModel(UserPropertyModel.class, userPropertieDto.getId());
                if (userPropertieModel == null) continue;
                userPropertieModel.checkStaleState(userPropertieDto);
            }
        }
    }

    @Override
    public UserFullDto createDto() {
        Long id = this.getId();
        UserFullDto userDto = id == null ? new UserFullDto(this.getTempUUID()) : new UserFullDto(id, this.getVersion());
        userDto.setLogin(this.getLogin());
        userDto.setName(this.getName());
        userDto.setMd5Password(this.getMd5Password());
        userDto.setSalt(this.getSalt());
        return userDto;
    }

    @Override
    public UserProxyDto createProxy() {
        Long id = this.getId();
        UserProxyDto userDto = id == null ? new UserProxyDto(this.getTempUUID()) : new UserProxyDto(id, this.getVersion());
        return userDto;
    }

    public static enum UserModelEnum {
        LOGIN("login"),
        NAME("name"),
        MD5_PASSWORD("md5Password"),
        SALT("salt"),
        USER_ROLE_OBJECTS("userRoleObjects"),
        USER_SESSIONS("userSessions"),
        USER_PROPERTIES("userProperties");

        private String propertyName;

        private UserModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

