/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.admin;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.admin.SubSessionModel;
import de.datomino.peppergis.client.model.admin.UserSessionModel;
import de.datomino.peppergis.client.model.admin.UserSessionModelImpl;
import de.datomino.peppergis.dto.admin.SubSessionFullDto;
import de.datomino.peppergis.dto.admin.SubSessionProxyDto;
import de.datomino.peppergis.dto.admin.UserSessionDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.license.LicenseType;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class SubSessionModelImpl
extends AbstractModel<SubSessionFullDto, SubSessionProxyDto>
implements SubSessionModel {
    private UserSessionModel userSession;
    private Date activationTime;
    private Date heartBeatTime;
    private LicenseType licenseType;

    public SubSessionModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public SubSessionModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public UserSessionModel getUserSession() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.userSession;
    }

    @Override
    public void setUserSession(UserSessionModel userSession) {
        this.setUserSession(userSession, true);
    }

    private void setUserSession(UserSessionModel userSession, boolean setDirty) {
        UserSessionModel oldUserSession = this.getUserSession();
        if (oldUserSession == userSession) {
            return;
        }
        if (oldUserSession != null) {
            oldUserSession.removeSubSession(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubSessionModelEnum.USER_SESSION.getPropertyName());
        }
        this.userSession = userSession;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubSessionModelEnum.USER_SESSION, userSession, oldUserSession);
        if (this.userSession != null) {
            this.userSession.addSubSession(this);
        }
    }

    @Override
    public Date getActivationTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.activationTime;
    }

    @Override
    public void setActivationTime(Date activationTime) {
        this.setActivationTime(activationTime, true);
    }

    private void setActivationTime(Date activationTime, boolean setDirty) {
        Date oldActivationTime = this.getActivationTime();
        if (new EqualsBuilder().append(oldActivationTime, activationTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubSessionModelEnum.ACTIVATION_TIME.getPropertyName());
        }
        this.activationTime = activationTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubSessionModelEnum.ACTIVATION_TIME, activationTime, oldActivationTime);
    }

    @Override
    public Date getHeartBeatTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.heartBeatTime;
    }

    @Override
    public void setHeartBeatTime(Date heartBeatTime) {
        this.setHeartBeatTime(heartBeatTime, true);
    }

    private void setHeartBeatTime(Date heartBeatTime, boolean setDirty) {
        Date oldHeartBeatTime = this.getHeartBeatTime();
        if (new EqualsBuilder().append(oldHeartBeatTime, heartBeatTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubSessionModelEnum.HEART_BEAT_TIME.getPropertyName());
        }
        this.heartBeatTime = heartBeatTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubSessionModelEnum.HEART_BEAT_TIME, heartBeatTime, oldHeartBeatTime);
    }

    @Override
    public LicenseType getLicenseType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.licenseType;
    }

    @Override
    public void setLicenseType(LicenseType licenseType) {
        this.setLicenseType(licenseType, true);
    }

    private void setLicenseType(LicenseType licenseType, boolean setDirty) {
        LicenseType oldLicenseType = this.getLicenseType();
        if (new EqualsBuilder().append((Object)oldLicenseType, (Object)licenseType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubSessionModelEnum.LICENSE_TYPE.getPropertyName());
        }
        this.licenseType = licenseType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubSessionModelEnum.LICENSE_TYPE, (Object)licenseType, (Object)oldLicenseType);
    }

    @Override
    protected void updateByDto(SubSessionFullDto subSessionDto) {
        this.userSession = (UserSessionModel)this.getModelCache().getModel(subSessionDto.getUserSession());
        this.activationTime = subSessionDto.getActivationTime();
        this.heartBeatTime = subSessionDto.getHeartBeatTime();
        this.licenseType = subSessionDto.getLicenseType();
    }

    @Override
    protected void updateMasterRelationsByDto(SubSessionFullDto subSessionDto) {
    }

    @Override
    protected void checkStaleByDto(SubSessionFullDto subSessionDto) throws StaleStateException {
        UserSessionModelImpl userSessionModel;
        UserSessionDto userSessionDto = subSessionDto.getUserSession();
        if (userSessionDto != null && userSessionDto.getId() != null && (userSessionModel = (UserSessionModelImpl)this.getModelCache().getModel(UserSessionModel.class, userSessionDto.getId())) != null) {
            userSessionModel.checkStaleState(userSessionDto);
        }
    }

    @Override
    public SubSessionFullDto createDto() {
        Long id = this.getId();
        SubSessionFullDto subSessionDto = id == null ? new SubSessionFullDto(this.getTempUUID()) : new SubSessionFullDto(id, this.getVersion());
        UserSessionModelImpl userSession = (UserSessionModelImpl)this.getUserSession();
        if (userSession != null) {
            subSessionDto.setUserSession(userSession.createProxy());
        }
        subSessionDto.setActivationTime(this.getActivationTime());
        subSessionDto.setHeartBeatTime(this.getHeartBeatTime());
        subSessionDto.setLicenseType(this.getLicenseType());
        return subSessionDto;
    }

    @Override
    public SubSessionProxyDto createProxy() {
        Long id = this.getId();
        SubSessionProxyDto subSessionDto = id == null ? new SubSessionProxyDto(this.getTempUUID()) : new SubSessionProxyDto(id, this.getVersion());
        return subSessionDto;
    }

    public static enum SubSessionModelEnum {
        USER_SESSION("userSession"),
        ACTIVATION_TIME("activationTime"),
        HEART_BEAT_TIME("heartBeatTime"),
        LICENSE_TYPE("licenseType");

        private String propertyName;

        private SubSessionModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

