/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.admin;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.admin.JobScheduleModel;
import de.datomino.peppergis.dto.admin.JobScheduleFullDto;
import de.datomino.peppergis.dto.admin.JobScheduleProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class JobScheduleModelImpl
extends AbstractModel<JobScheduleFullDto, JobScheduleProxyDto>
implements JobScheduleModel {
    private String name;
    private String jobBeanName;
    private String cronExpression;
    private byte[] parameters;

    public JobScheduleModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public JobScheduleModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, JobScheduleModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(JobScheduleModelEnum.NAME, name, oldName);
    }

    @Override
    public String getJobBeanName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.jobBeanName;
    }

    @Override
    public void setJobBeanName(String jobBeanName) {
        this.setJobBeanName(jobBeanName, true);
    }

    private void setJobBeanName(String jobBeanName, boolean setDirty) {
        String oldJobBeanName = this.getJobBeanName();
        if (new EqualsBuilder().append(oldJobBeanName, jobBeanName).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, JobScheduleModelEnum.JOB_BEAN_NAME.getPropertyName());
        }
        this.jobBeanName = jobBeanName;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(JobScheduleModelEnum.JOB_BEAN_NAME, jobBeanName, oldJobBeanName);
    }

    @Override
    public String getCronExpression() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.cronExpression;
    }

    @Override
    public void setCronExpression(String cronExpression) {
        this.setCronExpression(cronExpression, true);
    }

    private void setCronExpression(String cronExpression, boolean setDirty) {
        String oldCronExpression = this.getCronExpression();
        if (new EqualsBuilder().append(oldCronExpression, cronExpression).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, JobScheduleModelEnum.CRON_EXPRESSION.getPropertyName());
        }
        this.cronExpression = cronExpression;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(JobScheduleModelEnum.CRON_EXPRESSION, cronExpression, oldCronExpression);
    }

    @Override
    public byte[] getParameters() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.parameters;
    }

    @Override
    public void setParameters(byte[] parameters) {
        this.setParameters(parameters, true);
    }

    private void setParameters(byte[] parameters, boolean setDirty) {
        byte[] oldParameters = this.getParameters();
        if (new EqualsBuilder().append(oldParameters, parameters).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, JobScheduleModelEnum.PARAMETERS.getPropertyName());
        }
        this.parameters = parameters;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(JobScheduleModelEnum.PARAMETERS, parameters, oldParameters);
    }

    @Override
    protected void updateByDto(JobScheduleFullDto jobScheduleDto) {
        this.name = jobScheduleDto.getName();
        this.jobBeanName = jobScheduleDto.getJobBeanName();
        this.cronExpression = jobScheduleDto.getCronExpression();
        this.parameters = jobScheduleDto.getParameters();
    }

    @Override
    protected void updateMasterRelationsByDto(JobScheduleFullDto jobScheduleDto) {
    }

    @Override
    protected void checkStaleByDto(JobScheduleFullDto jobScheduleDto) throws StaleStateException {
    }

    @Override
    public JobScheduleFullDto createDto() {
        Long id = this.getId();
        JobScheduleFullDto jobScheduleDto = id == null ? new JobScheduleFullDto(this.getTempUUID()) : new JobScheduleFullDto(id, this.getVersion());
        jobScheduleDto.setName(this.getName());
        jobScheduleDto.setJobBeanName(this.getJobBeanName());
        jobScheduleDto.setCronExpression(this.getCronExpression());
        jobScheduleDto.setParameters(this.getParameters());
        return jobScheduleDto;
    }

    @Override
    public JobScheduleProxyDto createProxy() {
        Long id = this.getId();
        JobScheduleProxyDto jobScheduleDto = id == null ? new JobScheduleProxyDto(this.getTempUUID()) : new JobScheduleProxyDto(id, this.getVersion());
        return jobScheduleDto;
    }

    public static enum JobScheduleModelEnum {
        NAME("name"),
        JOB_BEAN_NAME("jobBeanName"),
        CRON_EXPRESSION("cronExpression"),
        PARAMETERS("parameters");

        private String propertyName;

        private JobScheduleModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

