/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model;

import de.datomino.peppergis.client.model.CustomUndoEditable;
import de.datomino.peppergis.client.model.UndoManagerEvent;
import de.datomino.peppergis.client.model.UndoManagerListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.undo.CannotUndoException;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.cache.ChangeSetUndoEditable;

public class MovingUndoEditable
extends ChangeSetUndoEditable {
    private Collection<UndoManagerListener> listeners;
    private List<? extends CustomUndoEditable> customUndoEditables;

    public MovingUndoEditable(String name, List<ChangeSet> changes, Collection<UndoManagerListener> listeners, List<? extends CustomUndoEditable> customUndoEditables) {
        super(name, changes);
        this.listeners = listeners;
        this.customUndoEditables = customUndoEditables;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        if (this.customUndoEditables != null) {
            ArrayList<? extends CustomUndoEditable> rev = new ArrayList<CustomUndoEditable>(this.customUndoEditables);
            Collections.reverse(rev);
            for (CustomUndoEditable customUndoEditable : rev) {
                customUndoEditable.undo();
            }
        }
        this.fireUndoEvent();
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        if (this.customUndoEditables != null) {
            for (CustomUndoEditable customUndoEditable : this.customUndoEditables) {
                customUndoEditable.redo();
            }
        }
        this.fireRedoEvent();
    }

    protected void fireUndoEvent() {
        UndoManagerEvent event = new UndoManagerEvent(this, this.getUndoPresentationName(), this.getChanges());
        for (UndoManagerListener undoManagerListener : this.listeners) {
            undoManagerListener.undone(event);
        }
    }

    protected void fireRedoEvent() {
        UndoManagerEvent event = new UndoManagerEvent(this, this.getRedoPresentationName(), this.getChanges());
        for (UndoManagerListener undoManagerListener : this.listeners) {
            undoManagerListener.undone(event);
        }
    }
}

