/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.communication.CommonCallerImpl;
import de.datomino.peppergis.client.communication.GeoServerStub;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.ModelClassMapper;
import de.datomino.peppergis.dto.AbstractProxyDto;
import de.datomino.peppergis.dto.Dto;
import de.datomino.peppergis.exception.DataCorruptException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.ktde.model.ValueChangeEvent;
import org.ktde.util.ElementConstraint;
import org.ktde.util.StringUtil;
import org.ktde.util.cache.Cache;
import org.ktde.util.cache.TwoLevelCache;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelCache.class);
    private TwoLevelCache<Class<?>, Long, Model> cache = new TwoLevelCache();
    private final CommonCaller commonCaller;
    private final ModelClassMapper modelClassMapper;

    public ModelCache(GeoServerStub geoServerStub) {
        this.commonCaller = new CommonCallerImpl(geoServerStub, this);
        this.modelClassMapper = new ModelClassMapper();
    }

    public CommonCaller getCommonCaller() {
        return this.commonCaller;
    }

    public <T extends Model> T getModel(Class<T> clazz, Long id) {
        Model result = this.cache.getInstance(clazz, id);
        return (T)result;
    }

    public <T extends Model, U extends Dto> T getModel(U dto) {
        T t = this.getModel(dto, true);
        return t;
    }

    public <T extends Model, U extends Dto> T getModel(U dto, boolean update) {
        if (dto == null || dto.getId() == null) {
            return null;
        }
        Class<? extends Model> modelClass = this.modelClassMapper.getModelClassForDto(dto);
        Long id = dto.getId();
        Long replaceId = dto.getReplaceId();
        Tupel<? extends Model, Boolean> tupel = this.getCachedInstance(modelClass, id, replaceId, true);
        AbstractModel cachedInstance = (AbstractModel)tupel.getElement1();
        if (update || tupel.getElement2().booleanValue()) {
            cachedInstance.updateByDto(dto);
        }
        AbstractModel t = cachedInstance;
        return (T)t;
    }

    private <T extends Model> Tupel<T, Boolean> getCachedInstance(Class<T> modelClass, Long id, Long replaceId, boolean create) {
        Model cachedInstance = null;
        boolean isNew = false;
        if (this.cache != null) {
            if (replaceId != null) {
                Model t = this.cache.getInstance(modelClass, replaceId);
                cachedInstance = t;
                if (cachedInstance != null) {
                    ((AbstractModel)cachedInstance).replaceId(id);
                    this.cache.removeInstance(modelClass, replaceId);
                    this.cache.setInstance(modelClass, id, cachedInstance);
                }
            } else {
                Model t;
                cachedInstance = t = this.cache.getInstance(modelClass, id);
            }
        }
        if (create && cachedInstance == null) {
            cachedInstance = (Model)this.createInstance(modelClass, id);
            isNew = true;
        }
        return new Tupel<Object, Boolean>(cachedInstance, isNew);
    }

    private <T extends Model> T createInstance(Class<T> modelClass, Long id) {
        try {
            Class<AbstractModel<?, ?>> modelImplClass = this.modelClassMapper.getImplClassForModel(modelClass);
            LOGGER.debug("create new instance " + modelClass + " (implemented by " + modelImplClass + ") id " + id);
            Model t = modelImplClass.getConstructor(Long.class, CommonCaller.class).newInstance(id, this.commonCaller);
            if (this.cache != null) {
                this.cache.setInstance(modelClass, id, t);
            }
            return (T)t;
        }
        catch (Exception e) {
            throw new DataCorruptException(e);
        }
    }

    public void addModel(Model model) {
        Class clazz = this.getModelClass(model);
        this.cache.setInstance(clazz, model.getTempUUID(), model);
    }

    private <T> Class<T> getModelClass(Model model) {
        Class<?> clazz = model.getClass();
        String clazzName = clazz.getName();
        if (clazzName.endsWith("Impl")) {
            clazzName = StringUtil.substringFromBehind(clazzName, 4);
            try {
                clazz = Class.forName(clazzName);
            }
            catch (ClassNotFoundException e) {
                throw new DataCorruptException(e);
            }
        }
        return clazz;
    }

    public void evictModel(Model model) {
        Class clazz = this.getModelClass(model);
        if (this.cache != null) {
            this.cache.removeInstance(clazz, model.getTempUUID());
        }
    }

    public ModelClassMapper getModelClassMapper() {
        return this.modelClassMapper;
    }

    public void refreshAfterUpdate(Collection<AbstractProxyDto> proxyDtos, Collection<AbstractModel<?, ?>> todoDelete) {
        for (AbstractProxyDto abstractProxyDto : proxyDtos) {
            AbstractModel model = (AbstractModel)this.getModel(abstractProxyDto, false);
            model.setDirty(false);
            model.setVersion(abstractProxyDto.getVersion());
        }
        for (AbstractModel abstractModel : todoDelete) {
            this.evictModel(abstractModel);
        }
    }

    public void close() {
        this.cache = null;
    }

    public <T extends Model> Collection<T> getCachedModels(Class<T> modelClass) {
        Cache<Long, Model> subCache = this.cache.getCache(modelClass);
        return subCache.getAllInstances();
    }

    public Map<Class<?>, Collection<? extends Model>> getAllDirtyModels() {
        return this.cache.getAllInstances(new ElementConstraint<Model>(){

            @Override
            public boolean checkConstraint(Model t) {
                return t.isDirty();
            }
        });
    }

    public <T extends Model> void refresh() {
        Collection<Class<?>> keys = this.cache.getAllKeys();
        for (Class<?> key : keys) {
            this.refresh(key);
        }
    }

    public <T extends Model> void refresh(Class<T> key) {
        Collection<Model> models = this.cache.getAllInstances(key);
        this.commonCaller.fetchModels(models, true);
    }

    public <T extends Model> void refreshRek(Class<T> clazz, Long id) {
        this.refreshRek(clazz, id, false);
    }

    public <T extends Model> void refreshRek(Class<T> clazz, Long id, boolean fireValueChangeEvent) {
        Model instance = this.cache.getInstance(clazz, id);
        if (instance != null) {
            this.refreshRek(instance, fireValueChangeEvent);
        }
    }

    public void refreshRek(Model model) {
        this.refreshRek(model, false);
    }

    public void refreshRek(Model model, boolean fireValueChangeEvent) {
        HashSet<Model> models = new HashSet<Model>();
        try {
            this.refreshRek(model, models);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.commonCaller.fetchModels(models, true);
        if (fireValueChangeEvent) {
            for (Model m : models) {
                m.fireModelValueChangeEvent(new ValueChangeEvent(m, ValueChangeEvent.Type.UPDATE, null, null, null));
            }
        }
    }

    private void refreshRek(Model model, Set<Model> models) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (model != null && !models.contains(model) && !model.isProxy()) {
            Method[] methods;
            if (model instanceof AbstractModel) {
                AbstractModel aModel = (AbstractModel)model;
                models.add(aModel);
            }
            for (Method method : methods = model.getClass().getMethods()) {
                String methodName = method.getName();
                Class<Model> returnType = method.getReturnType();
                if (methodName.startsWith("get") && returnType.isAssignableFrom(Model.class)) {
                    Model childModel = (Model)method.invoke((Object)model, new Object[0]);
                    this.refreshRek(childModel, models);
                    continue;
                }
                if (!methodName.startsWith("iterate")) continue;
                Iterator iterator = (Iterator)method.invoke((Object)model, new Object[0]);
                while (iterator.hasNext()) {
                    Model childModel = (Model)iterator.next();
                    this.refreshRek(childModel, models);
                }
            }
        }
    }
}

