/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.printer;

import de.datomino.logistic.dto.LogisticStopDto;
import de.datomino.pdf.engine.Format;
import de.datomino.pdf.printer.PrinterInformation;
import de.datomino.pdf.printer.PrintingObject;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.legend.LegendObject;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.print.DefaultPrintingInformation;
import de.datomino.peppergis.client.print.HeaderType;
import de.datomino.peppergis.helper.PointEntityId;
import de.datomino.peppergis.print.LegendNamePrintType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.ktde.util.datatypes.Tripel;

public class AreaLegendPrintingInformation
extends DefaultPrintingInformation<LegendObject<Object>> {
    private HeaderType headerType;
    private String headInfo;

    public AreaLegendPrintingInformation(List<LegendObject<Object>> models, String imagePath, Format imageFormat, HeaderType headerType, ModelEnviroment modelEnviroment) {
        super(models, imagePath, imageFormat, modelEnviroment);
        this.headerType = headerType;
    }

    public void initialize(PrinterInformation printerInformation, String info) {
        LegendNamePrintType legendNamePrintType = (LegendNamePrintType)printerInformation.getNamePrintType();
        PrintingObject printingObject = new PrintingObject(null, null);
        PrinterInformation.LineGroupType lineGroupType = printerInformation.getLineGroupType();
        switch (lineGroupType) {
            case ADDRESS: {
                if (this.headerType != HeaderType.PARCEL && this.headerType != HeaderType.MIXED) break;
                lineGroupType = PrinterInformation.LineGroupType.NORMAL;
                break;
            }
            case STREET: {
                if (this.headerType != HeaderType.SUBSCRIPTION && this.headerType != HeaderType.LETTER && this.headerType != HeaderType.MIXED) break;
                lineGroupType = PrinterInformation.LineGroupType.NORMAL;
                break;
            }
        }
        printerInformation.setLineGroupType(lineGroupType);
        List<Tripel<Integer, String, Color>> header = super.getPrintingTableHeader(this.headerType, lineGroupType);
        DefaultPrintingInformation.LineGroupIndex streetGroupIndex = super.getLineGroupIndex(header, printerInformation, this.headerType);
        ArrayList<Tripel<List<String>, List<String>, Color>> table = new ArrayList<Tripel<List<String>, List<String>, Color>>();
        int objectIndex = 1;
        for (LegendObject legendObject : super.getOs()) {
            PointEntityId pei;
            Object id;
            Object model = legendObject.getM();
            boolean isPoi = false;
            if (model instanceof PoiModel) {
                isPoi = true;
            } else if (model instanceof LogisticStopDto && (id = ((LogisticStopDto)model).getId()) instanceof PointEntityId && (pei = (PointEntityId)id).getPointEnityType() != null && pei.getPointEnityType() == PointEntityId.PointEnityType.POI) {
                isPoi = true;
            }
            Tripel<List<String>, List<String>, Color> row = super.getRow(legendObject, lineGroupType, this.headerType == HeaderType.MIXED);
            objectIndex = super.addRow(table, row, objectIndex, isPoi, lineGroupType, streetGroupIndex, this.headerType);
            super.checkRow(header, row);
        }
        switch (legendNamePrintType) {
            case TOP: {
                super.setTop(true);
                printingObject.setText(info);
                printingObject.setHeader(header);
                printingObject.setTable(table);
                break;
            }
            case DOWN: {
                super.setDown(true);
                printingObject.setText(info);
                printingObject.setHeader(header);
                printingObject.setTable(table);
                break;
            }
            case NONE: {
                printingObject.setHeader(null);
                printingObject.setTable(null);
                break;
            }
            case NO_LIST: {
                printingObject.setText(info);
                printingObject.setHeader(null);
                printingObject.setTable(null);
                break;
            }
            case ONLY_LIST: {
                printingObject.setHeader(header);
                printingObject.setTable(table);
            }
        }
        this.printingObjects.add(printingObject);
    }

    public void setHeadInfo(String headInfo) {
        this.headInfo = headInfo;
    }

    public String getHeadInfo() {
        return this.headInfo;
    }
}

