/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.printer;

import de.datomino.pdf.engine.Format;
import de.datomino.pdf.engine.PdfCreatorImpl;
import de.datomino.pdf.printer.ImageInfoBox;
import de.datomino.pdf.printer.PrintRenderer;
import de.datomino.pdf.printer.PrinterInformation;
import de.datomino.pdf.printer.SvgHandler;
import de.datomino.peppergis.client.communication.BaseCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.osm.AbstractOsmSvgExportFetcherException;
import de.datomino.peppergis.client.gui.osm.NotThreadingOsmNavigatorRenderer;
import de.datomino.peppergis.client.gui.osm.OsmSvgExportFetcher;
import de.datomino.peppergis.client.gui.osm.ThreadingOsmNavigatorRenderer;
import de.datomino.peppergis.client.gui.renderer.MapScaleRenderer;
import de.datomino.peppergis.client.manager.filter.AllObjectFilterLayerRenderer;
import de.datomino.peppergis.client.manager.legend.LegendObject;
import de.datomino.peppergis.client.manager.legend.LegendType;
import de.datomino.peppergis.client.manager.printer.LegendPrintingInformation;
import de.datomino.peppergis.client.manager.printer.ManagerPrinter;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.ImageModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.print.HeaderType;
import de.datomino.peppergis.client.print.PlaceNameRenderer;
import de.datomino.peppergis.client.print.ScreenShotType;
import de.datomino.peppergis.client.print.StreetNameRenderer;
import de.datomino.peppergis.client.print.WhiteRectangleScreenShotRenderer;
import de.datomino.peppergis.client.util.AreaTourInfoObject;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.LetterModelUtil;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.client.util.SubscriptionModelUtil;
import de.datomino.peppergis.print.PrintContentValue;
import de.datomino.peppergis.print.PrintProperties;
import de.datomino.peppergis.print.PrintPropertyKey;
import de.datomino.peppergis.type.PrintContentKey;
import de.datomino.peppergis.type.PrintParameterKey;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.util.GeoUtils;
import de.datomino.util.swing.ImagePosition;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JTextPane;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.http.HttpException;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.swing.navigator.MapNavigatorRenderer;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractManagerPrinter<M>
implements ManagerPrinter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagerPrinter.class);
    protected ModelEnviroment modelEnviroment;
    private String screenshotTemplate;
    protected String legendTemplate;
    private static final SAXParserFactory SAX_FACTORY;
    protected static final SimpleDateFormat sm;
    protected String footInfoPattern;

    public AbstractManagerPrinter(ModelEnviroment modelEnviroment, String screenshotTemplate, String legendTemplate) {
        this.modelEnviroment = modelEnviroment;
        this.screenshotTemplate = screenshotTemplate;
        this.legendTemplate = legendTemplate;
        this.footInfoPattern = ModelEnviroment.getProperties().getProperty("print.footInfo.pattern");
    }

    protected abstract Tupel<AreaLayerModel, AreaObjectModel> getAreaObject();

    protected abstract Tupel<SVGGraphics2D, Double> renderSvg(NavigatorPanel var1, Map<M, Color> var2, int var3, int var4, Coordinate var5, Coordinate var6, PrinterInformation var7);

    @Override
    public void rebuildRenderers(NavigatorPanel navigatorPanel) {
        for (NavigatorRenderer navigatorRenderer : navigatorPanel.getRenderers()) {
            if (navigatorRenderer instanceof ThreadingOsmNavigatorRenderer) continue;
            navigatorRenderer.setNavigatorPanel(navigatorPanel);
        }
    }

    @Override
    public InputStream printLegend(NavigatorPanel navigatorPanel, List<List<Object>> superList, LegendType legendType, PrinterInformation printerInformation, byte[] layerLogoImage) throws Exception {
        HashMap<String, Object> inputDatas = new HashMap<String, Object>();
        Double footerHeight = this.setFootAndGetAdditionalLineHeightInCm(inputDatas, printerInformation);
        this.getAddressString();
        Tupel<Integer, Integer> rectangle = this.setParameter(printerInformation, inputDatas, layerLogoImage, footerHeight);
        ArrayList<LegendPrintingInformation> legendPrintingInformations = new ArrayList<LegendPrintingInformation>(superList.size());
        for (List<Object> list : superList) {
            LinkedList<LegendObject<Model>> models = new LinkedList<LegendObject<Model>>();
            for (Object object : list) {
                if (!(object instanceof LegendObject)) continue;
                models.add((LegendObject)object);
            }
            HeaderType headerType = null;
            if (legendType != null) {
                switch (legendType) {
                    case STOP: 
                    case UNSORTEDSTOP: {
                        headerType = HeaderType.STOP;
                        break;
                    }
                    case SUBSCRIPTION: {
                        headerType = HeaderType.SUBSCRIPTION;
                        break;
                    }
                    case PARCEL: {
                        headerType = HeaderType.PARCEL;
                        break;
                    }
                    case LETTER: {
                        headerType = HeaderType.LETTER;
                        break;
                    }
                    case MIXED: {
                        headerType = HeaderType.MIXED;
                        break;
                    }
                }
            }
            System.err.println("Creating print legend information");
            LegendPrintingInformation legendPrintingInformation = new LegendPrintingInformation(models, null, (Format)inputDatas.get("format"), headerType, this.modelEnviroment);
            Map<PrintPropertyKey, Serializable> areaTourProperties = this.modelEnviroment.getPrintProperties().getAreaTourProperties();
            String poiMaxDistanceString = String.valueOf(areaTourProperties.get(PrintParameterKey.POI_MAX_DISTANCE));
            Model firstModel = models.size() < 2 ? null : (Model)((LegendObject)models.get(0)).getM();
            ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
            boolean addFirst = true;
            if (!StringUtil.isBlank(poiMaxDistanceString) && firstModel != null && firstModel instanceof PoiModel) {
                try {
                    int poiMaxDistance = Integer.parseInt(poiMaxDistanceString);
                    ImmutablePoint geom0 = LocationModelUtil.getGeom(((PoiModel)firstModel).getLocation());
                    Model m1 = (Model)((LegendObject)models.get(1)).getM();
                    ImmutablePoint geom1 = null;
                    if (m1 instanceof StopModel) {
                        geom1 = StopModelUtil.getGeom((StopModel)m1);
                    } else if (m1 instanceof SubscriptionModel) {
                        geom1 = SubscriptionModelUtil.getGeom((SubscriptionModel)m1);
                    } else if (m1 instanceof ParcelModel) {
                        geom1 = ((ParcelModel)m1).getGeom();
                    } else if (m1 instanceof PoiModel) {
                        geom1 = LocationModelUtil.getGeom(((PoiModel)m1).getLocation());
                    } else if (m1 instanceof LetterModel) {
                        geom1 = LetterModelUtil.getGeom((LetterModel)m1);
                    }
                    double fromPoi = GeoUtils.getDistanceInMeter(geom0, geom1);
                    boolean withPoi = (double)poiMaxDistance > fromPoi;
                    printerInformation.setWithPoi(withPoi);
                    if (withPoi && geom0 != null) {
                        coordinates.add(geom0.getCoordinate());
                    }
                    addFirst = false;
                }
                catch (Exception e) {
                    System.err.println("failed poi max distance - " + poiMaxDistanceString);
                }
            }
            Iterator iter = models.iterator();
            if (!addFirst && iter.hasNext()) {
                iter.next();
            }
            while (iter.hasNext()) {
                Model model = (Model)((LegendObject)iter.next()).getM();
                ImmutablePoint geom = null;
                if (model instanceof StopModel) {
                    geom = StopModelUtil.getGeom((StopModel)model);
                } else if (model instanceof SubscriptionModel) {
                    geom = SubscriptionModelUtil.getGeom((SubscriptionModel)model);
                } else if (model instanceof ParcelModel) {
                    geom = ((ParcelModel)model).getGeom();
                } else if (model instanceof PoiModel) {
                    geom = LocationModelUtil.getGeom(((PoiModel)model).getLocation());
                } else if (model instanceof LetterModel) {
                    geom = LetterModelUtil.getGeom((LetterModel)model);
                }
                if (geom == null) continue;
                coordinates.add(geom.getCoordinate());
            }
            System.err.println("Creating panel");
            Tupel<NavigatorPanel, List<NavigatorRenderer>> printNavigatorPanelTupel = this.createPrintNavigatorPanel(navigatorPanel, coordinates, rectangle.getElement1(), rectangle.getElement2(), printerInformation, false, true);
            NavigatorPanel printNavigatorPanel = printNavigatorPanelTupel.getElement1();
            if (printerInformation.isUseVector()) {
                String fetchSvg = this.createSvgForScreenshot(printerInformation, inputDatas, printNavigatorPanel, navigatorPanel);
                legendPrintingInformation.setImagePath(fetchSvg);
            } else {
                Image image = this.getImageFromNavigatorPanel(printNavigatorPanel, coordinates, printerInformation.isOptimalZoom());
                Image logoImage = (Image)inputDatas.get("logoImage");
                int logoWidth = 0;
                int logoHeight = 0;
                if (logoImage != null) {
                    float f;
                    int w;
                    String s = (String)inputDatas.get("logoWidth");
                    try {
                        w = Integer.parseInt(s);
                    }
                    catch (Exception ex) {
                        f = Float.parseFloat(s);
                        w = Math.round(f);
                    }
                    logoWidth = (int)((double)w * printerInformation.getScale());
                    s = (String)inputDatas.get("logoHeight");
                    try {
                        w = Integer.parseInt(s);
                    }
                    catch (Exception ex) {
                        f = Float.parseFloat(s);
                        w = Math.round(f);
                    }
                    logoHeight = (int)((double)w * printerInformation.getScale() / 1.2);
                }
                Image imageWithLogo = logoImage == null ? image : ClientSwingUtil.addLogoOnImage(image, logoImage, logoWidth, logoHeight, printerInformation.getPosition());
                legendPrintingInformation.setImagePath(PdfCreatorImpl.saveImageToTempFile(imageWithLogo));
                double widthMM = (double)imageWithLogo.getWidth(null) / ((double)printerInformation.getDpi().intValue() / PdfCreatorImpl.INCH_PER_CM) * 10.0 / printerInformation.getScale();
                double heightMM = (double)imageWithLogo.getHeight(null) / ((double)printerInformation.getDpi().intValue() / PdfCreatorImpl.INCH_PER_CM) * 10.0 / printerInformation.getScale();
                String heightString = heightMM + "mm";
                inputDatas.put("imageHeight", heightString);
                String widthString = widthMM + "mm";
                inputDatas.put("imageWidth", widthString);
            }
            String info = "";
            if (list.get(0) instanceof JTextPane) {
                info = ((JTextPane)list.get(0)).getText();
            } else if (list.get(0) instanceof String) {
                info = list.get(0).toString();
            } else if (list.get(0) instanceof AreaTourInfoObject) {
                info = ((AreaTourInfoObject)list.get(0)).getString(printerInformation.getNameRenderingType());
            }
            List<String> lines = this.extractLines(printerInformation.getSpecialMessage());
            if (lines != null) {
                info = info + "\n" + ModelEnviroment.getMessageResolver().resolveMessage("gui.print.message.special", new Serializable[0]) + "\n";
                for (String line : lines) {
                    info = info + line + "\n";
                }
                info = info + "\n";
            }
            AreaObjectModel areaObject = this.getAreaObject().getElement2();
            System.err.println("Initializing");
            legendPrintingInformation.initialize(printerInformation, info);
            ImageInfoBox imageInfoBox = (ImageInfoBox)inputDatas.get("imageInfoBox");
            if (imageInfoBox.isActive() && areaObject != null) {
                ImageInfoBox currentImageInfoBox = imageInfoBox.clone();
                String imageInfo = currentImageInfoBox.getInfo().replaceAll("%%%shortcut%%%", areaObject.getShortcut());
                imageInfo = imageInfo.replaceAll("%%%displayname%%%", areaObject.getDisplayname());
                currentImageInfoBox.setInfo(imageInfo);
                legendPrintingInformation.setImageInfoBox(currentImageInfoBox);
            }
            if (areaObject != null) {
                String headInfo = (String)inputDatas.get("headInfoArea");
                headInfo = headInfo.replaceAll("%%%shortcut%%%", areaObject.getShortcut());
                headInfo = headInfo.replaceAll("%%%displayname%%%", areaObject.getDisplayname());
                legendPrintingInformation.setHeadInfo(headInfo);
            }
            legendPrintingInformations.add(legendPrintingInformation);
        }
        inputDatas.put("legends", legendPrintingInformations);
        Map<PrintPropertyKey, Serializable> commonProperties = this.modelEnviroment.getPrintProperties().getCommonProperties();
        inputDatas.put("lineSpace", commonProperties.get(PrintParameterKey.LINE_SPACING));
        boolean showDate = ((PrintContentValue)commonProperties.get(PrintContentKey.PRINTING_DATE)).isPrint();
        if (showDate) {
            inputDatas.put("showDate", showDate);
        } else {
            inputDatas.put("showDate", null);
        }
        inputDatas.put("currentDate", sm.format(new Date()));
        PdfCreatorImpl pdfCreator = new PdfCreatorImpl();
        System.err.println("Creating pdf");
        return pdfCreator.createPdf(this.legendTemplate, inputDatas, null, ModelEnviroment.getMessageResolver());
    }

    private String getAddressString() {
        PrintProperties printProperties = this.modelEnviroment.getPrintProperties();
        Map<PrintPropertyKey, Serializable> commonProperties = printProperties.getCommonProperties();
        String address = null;
        AreaLayerModel areaLayer = this.getAreaObject().getElement1();
        if (areaLayer != null) {
            address = ModelEnviroment.getProperties().getProperty("print.company.address." + areaLayer.getId());
        }
        if (address == null) {
            Serializable s = commonProperties.get(PrintParameterKey.COMPANY_ADDRESS);
            String string = address = s == null ? "" : String.valueOf(s);
        }
        if (address == null) {
            address = ModelEnviroment.getProperties().getProperty("datomino.address");
        }
        return address;
    }

    protected Double setFootAndGetAdditionalLineHeightInCm(Map<String, Object> inputDatas, PrinterInformation printerInformation) {
        Double footHeight = null;
        Font font = printerInformation.getFooterFont();
        double lineHeight = ((double)font.getSize() + 1.0) * 0.0352778;
        String footExtent = "0.2";
        String bodyMarginBottom = "0.2";
        AreaLayerModel layer = this.getAreaObject().getElement1();
        String layerInfo = layer == null || layer.getPrintInfo() == null ? "" : layer.getPrintInfo();
        String address = "";
        address = !StringUtil.isBlank(layerInfo) && !StringUtil.isBlank(this.footInfoPattern) ? this.footInfoPattern.replaceAll("%%%layerInfo%%%", layerInfo).trim() : this.getAddressString().trim();
        int lineCount = StringUtil.countChar(address, '\n');
        lineCount = Math.max(4, Math.max(StringUtil.countChar("Copyright\u00a9 datomino GmbH, powered by OpenStreetMap", '\n'), lineCount));
        footHeight = lineHeight * (double)lineCount;
        String baseRegionFootD = Long.toString(Math.round(Math.ceil((footHeight + 0.5) * 10.0)));
        footExtent = baseRegionFootD.substring(0, baseRegionFootD.length() - 1) + "." + baseRegionFootD.charAt(baseRegionFootD.length() - 1);
        String baseMarginBottomD = Long.toString(Math.round(Math.ceil((footHeight + 0.5) * 10.0)));
        bodyMarginBottom = baseMarginBottomD.substring(0, baseMarginBottomD.length() - 1) + "." + baseMarginBottomD.charAt(baseMarginBottomD.length() - 1);
        inputDatas.put("address", address);
        inputDatas.put("footExtent", footExtent);
        inputDatas.put("bodyMarginBottom", bodyMarginBottom);
        inputDatas.put("footMarginTop", "0");
        return footHeight;
    }

    @Override
    public InputStream printScreenshot(NavigatorPanel navigatorPanel, PrinterInformation printerInformation) throws Exception {
        ScreenShotType screenShotType = ScreenShotType.APPEND_TO_FORMAT;
        try {
            screenShotType = ScreenShotType.valueOf(ModelEnviroment.getProperties().getProperty("print.screenshot.type"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Format format = printerInformation.getFormat();
        Tupel<Double, Double> dim = format.getSizes(printerInformation.getDpi(), 10.0, 10.0);
        double width = dim.getElement1();
        double lineHeight = (double)printerInformation.getDpi().intValue() / (printerInformation.isUseVector() ? 4.0 : 8.0);
        double height = dim.getElement2() - lineHeight;
        int iWidth = (int)Math.round(width);
        int iHeight = (int)Math.round(height);
        if (!printerInformation.isUseVector()) {
            double f = 1.0 / ((double)printerInformation.getDpi().intValue() / 150.0);
            iWidth = (int)((double)iWidth * f);
            iHeight = (int)((double)iHeight * f);
        }
        HashMap<String, Image> inputImages = new HashMap<String, Image>();
        HashMap<String, Object> inputDatas = new HashMap<String, Object>();
        this.setParameter(printerInformation, inputDatas, null, null);
        Tupel<NavigatorPanel, List<NavigatorRenderer>> printNavigatorPanelTupel = this.createPrintNavigatorPanel(navigatorPanel, null, iWidth, iHeight, printerInformation, true, true);
        NavigatorPanel printNavigatorPanel = printNavigatorPanelTupel.getElement1();
        if (printerInformation.isUseVector()) {
            String fetchSvg = this.createSvgForScreenshot(printerInformation, inputDatas, printNavigatorPanel, navigatorPanel);
            inputDatas.put("fetchSvg", fetchSvg);
        } else {
            Image image;
            Point2D.Double realBottomLeft = navigatorPanel.getRealBoundaryBottomLeft() == null ? printNavigatorPanel.getRealBoundaryBottomLeft() : navigatorPanel.getRealBoundaryBottomLeft();
            Point2D.Double realTopRight = navigatorPanel.getRealBoundaryTopRight() == null ? printNavigatorPanel.getRealBoundaryTopRight() : navigatorPanel.getRealBoundaryTopRight();
            CoordinateFactory coordinateFactory = navigatorPanel.getCoordinateFactory();
            printNavigatorPanel.center(CollectionUtil.buildArrayList(coordinateFactory.createCoordinate(realBottomLeft), coordinateFactory.createCoordinate(realTopRight)), 0);
            if (screenShotType == ScreenShotType.EQUAL_DIMENSION) {
                WhiteRectangleScreenShotRenderer whiteRectangleScreenShotRenderer = new WhiteRectangleScreenShotRenderer(navigatorPanel.getCoordinateFactory().createCoordinate(realTopRight), navigatorPanel.getCoordinateFactory().createCoordinate(realBottomLeft));
                whiteRectangleScreenShotRenderer.setNavigatorPanel(printNavigatorPanel);
                printNavigatorPanel.addRenderer(whiteRectangleScreenShotRenderer);
            }
            Image imageWithLogo = image = printNavigatorPanel.paintImage();
            Image logoImage = (Image)inputDatas.get("logoImage");
            if (logoImage != null) {
                int logoWidth = (int)((double)NumberUtils.toFloat((String)inputDatas.get("logoWidth")) * printerInformation.getScale());
                int logoHeight = (int)((double)NumberUtils.toFloat((String)inputDatas.get("logoHeight")) * printerInformation.getScale() / 1.2);
                imageWithLogo = ClientSwingUtil.addLogoOnImage(image, logoImage, logoWidth, logoHeight, printerInformation.getPosition());
            }
            inputImages.put("image", imageWithLogo);
        }
        for (NavigatorRenderer renderer : printNavigatorPanelTupel.getElement2()) {
            renderer.setNavigatorPanel(navigatorPanel);
        }
        Map<PrintPropertyKey, Serializable> commonProperties = this.modelEnviroment.getPrintProperties().getCommonProperties();
        boolean showDate = ((PrintContentValue)commonProperties.get(PrintContentKey.PRINTING_DATE)).isPrint();
        if (showDate) {
            inputDatas.put("showDate", showDate);
        } else {
            inputDatas.put("showDate", null);
        }
        inputDatas.put("currentDate", sm.format(new Date()));
        PdfCreatorImpl pdfCreator = new PdfCreatorImpl();
        return pdfCreator.createPdf(this.screenshotTemplate, inputDatas, inputImages, null, ModelEnviroment.getMessageResolver(), PdfCreatorImpl.DPI);
    }

    protected NavigatorPanel creatEmptyPrintNavigatorPanel(NavigatorPanel navigatorPanel, Integer width, int height, PrinterInformation printerInformation) {
        NavigatorPanel printNavigatorPanel = new NavigatorPanel(null, navigatorPanel.getCoordinateFactory(), null);
        printNavigatorPanel.setSize((int)((double)width.intValue() * printerInformation.getScale()), (int)(((double)height - 0.8 * ((double)PdfCreatorImpl.DPI.intValue() / PdfCreatorImpl.INCH_PER_CM)) * printerInformation.getScale()));
        printNavigatorPanel.forceCalcTransform();
        return printNavigatorPanel;
    }

    protected List<String> extractLines(String specialMessageText) {
        List<String> lines;
        List<String> list = lines = StringUtil.isBlank(specialMessageText) ? null : StringUtil.explode(specialMessageText, '\n');
        if (lines != null) {
            ArrayList<String> transformed = new ArrayList<String>(lines.size());
            for (String line : lines) {
                if (line.isEmpty()) {
                    transformed.add("\n");
                    continue;
                }
                transformed.add(line);
            }
            return transformed;
        }
        return lines;
    }

    protected Tupel<NavigatorPanel, List<NavigatorRenderer>> createPrintNavigatorPanel(NavigatorPanel navigatorPanel, Collection<Coordinate> coordinates, int width, int height, PrinterInformation printerInformation, boolean screenshot, boolean withObjects) throws IOException {
        NavigatorPanel printNavigatorPanel = new NavigatorPanel(null, navigatorPanel.getCoordinateFactory(), null);
        printNavigatorPanel.setSize((int)((double)width * printerInformation.getScale()), (int)(((double)height - 0.8 * ((double)PdfCreatorImpl.DPI.intValue() / PdfCreatorImpl.INCH_PER_CM)) * printerInformation.getScale()));
        printNavigatorPanel.forceCalcTransform();
        LinkedList<NavigatorRenderer> switchedRenderers = new LinkedList<NavigatorRenderer>();
        for (NavigatorRenderer navigatorRenderer : navigatorPanel.getRenderers()) {
            if (withObjects && navigatorRenderer instanceof AllObjectFilterLayerRenderer && navigatorRenderer.isActive()) {
                AllObjectFilterLayerRenderer allObjectFilterLayerRenderer = (AllObjectFilterLayerRenderer)navigatorRenderer;
                AllObjectFilterLayerRenderer renderer = allObjectFilterLayerRenderer.createClone(true);
                renderer.setNavigatorPanel(printNavigatorPanel);
                renderer.setWithIndex(true);
                printNavigatorPanel.addRenderer(renderer);
                if (coordinates == null) continue;
                coordinates.addAll(renderer.getAreaRectangles(!printerInformation.isWithPoi()));
                continue;
            }
            if (navigatorRenderer instanceof ThreadingOsmNavigatorRenderer) {
                NotThreadingOsmNavigatorRenderer osmrenderer = new NotThreadingOsmNavigatorRenderer(ModelEnviroment.getProperties());
                osmrenderer.setNavigatorPanel(printNavigatorPanel);
                printNavigatorPanel.addRenderer(osmrenderer);
                try {
                    if (printerInformation.getPrintPlacesFont() != null) {
                        PlaceNameRenderer placeNameRenderer = new PlaceNameRenderer(this.modelEnviroment, printerInformation.getPrintPlacesFont());
                        placeNameRenderer.setNavigatorPanel(printNavigatorPanel);
                        printNavigatorPanel.addRenderer(placeNameRenderer);
                    }
                }
                catch (Exception placeNameRenderer) {
                    // empty catch block
                }
                try {
                    if (printerInformation.getPrintStreetsFont() == null) continue;
                    StreetNameRenderer streetNameRenderer = new StreetNameRenderer(this.modelEnviroment, printerInformation.getPrintStreetsFont());
                    streetNameRenderer.setNavigatorPanel(printNavigatorPanel);
                    printNavigatorPanel.addRenderer(streetNameRenderer);
                }
                catch (Exception exception) {}
                continue;
            }
            if (navigatorRenderer instanceof MapScaleRenderer) {
                try {
                    MapScaleRenderer clone = (MapScaleRenderer)navigatorRenderer.clone();
                    clone.setActive(true);
                    clone.setFontFactor(2.0f);
                    clone.setThickness(6.0);
                    clone.setDrawWhiteBackGround(printerInformation.isWhiteBackgroundForScale());
                    clone.setNavigatorPanel(printNavigatorPanel);
                    printNavigatorPanel.addRenderer(clone);
                    continue;
                }
                catch (CloneNotSupportedException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!screenshot) continue;
            navigatorRenderer.setNavigatorPanel(printNavigatorPanel);
            printNavigatorPanel.addRenderer(navigatorRenderer);
            switchedRenderers.add(navigatorRenderer);
        }
        return new Tupel<NavigatorPanel, List<NavigatorRenderer>>(printNavigatorPanel, switchedRenderers);
    }

    protected Tupel<Integer, Integer> setParameter(PrinterInformation printerInformation, Map<String, Object> inputDatas, byte[] layerLogoImage, Double footerHeight) throws Exception {
        String imageInfoPattern;
        Tupel<Double, Double> dim = printerInformation.getFormat().getSizes(printerInformation.getDpi(), 10.0, 10.0);
        double width = dim.getElement1();
        double lineHeight = (double)printerInformation.getDpi().intValue() / (printerInformation.isUseVector() ? 4.0 : 8.0);
        double height = dim.getElement2() - lineHeight;
        double footerHeightInPixel = footerHeight == null ? 0.0 : footerHeight * ((double)printerInformation.getDpi().intValue() / PdfCreatorImpl.INCH_PER_CM);
        double widthMM = width / ((double)printerInformation.getDpi().intValue() / PdfCreatorImpl.INCH_PER_CM) * 10.0;
        double heightMM = (height -= footerHeightInPixel) / ((double)printerInformation.getDpi().intValue() / PdfCreatorImpl.INCH_PER_CM) * 10.0 - (footerHeight == null ? 0.0 : footerHeight * 20.0);
        BaseCaller baseCaller = this.modelEnviroment.getAllCaller().getBaseCaller();
        inputDatas.put("copyright", "Copyright\u00a9 datomino GmbH, powered by OpenStreetMap");
        PrintProperties printProperties = this.modelEnviroment.getPrintProperties();
        Map<PrintPropertyKey, Serializable> commonProperties = printProperties.getCommonProperties();
        Map<PrintPropertyKey, Serializable> areaTourProperties = printProperties.getAreaTourProperties();
        byte[] imageByte = layerLogoImage;
        if (imageByte == null) {
            String logoName = (String)((Object)commonProperties.get(PrintParameterKey.LOGO_IMAGE));
            if (logoName != null) {
                ImageModel logo = baseCaller.getImageByName(logoName);
                if (logo == null) {
                    LOGGER.error("Das Logo wurde nicht gefunden.");
                    imageByte = baseCaller.getDefaultImage();
                } else {
                    imageByte = logo.getData();
                }
            } else {
                imageByte = baseCaller.getDefaultImage();
            }
        }
        if (imageByte != null) {
            ImageIcon logoImage = new ImageIcon(imageByte);
            inputDatas.put("logoImage", logoImage.getImage());
            try {
                inputDatas.put("logo", PdfCreatorImpl.saveImageToTempFile(logoImage.getImage()));
            }
            catch (Exception e) {
                inputDatas.put("logo", null);
            }
            String logoWidth = String.valueOf(commonProperties.get(PrintParameterKey.LOGO_WIDTH));
            if (logoWidth == null) {
                logoWidth = Integer.toString(logoImage.getImage().getWidth(null));
            }
            inputDatas.put("logoWidth", logoWidth);
            String logoHeight = String.valueOf(commonProperties.get(PrintParameterKey.LOGO_HEIGHT));
            if (logoHeight == null) {
                logoHeight = Integer.toString(logoImage.getImage().getHeight(null));
            }
            inputDatas.put("logoHeight", logoHeight);
        }
        if (inputDatas.get("address") == null) {
            inputDatas.put("address", this.getAddressString().replaceAll("\"", ""));
        }
        inputDatas.put("font", printerInformation.getFont());
        inputDatas.put("underline", printerInformation.isUnderline());
        inputDatas.put("format", printerInformation.getFormat());
        inputDatas.put("isSvg", printerInformation.isUseVector());
        inputDatas.put("imageScale", Math.round(100.0 / printerInformation.getScale()));
        if (printerInformation.isUseVector()) {
            String heightString = heightMM + "mm";
            inputDatas.put("imageHeight", heightString);
            String widthString = widthMM + "mm";
            inputDatas.put("imageWidth", widthString);
        }
        ImageInfoBox imageInfoBox = new ImageInfoBox("", 100.0, 30.0, 14, ImagePosition.TOP_LEFT);
        String imageInfoBoxFontSize = String.valueOf(commonProperties.get(PrintParameterKey.IMAGE_INFO_FONT_SIZE));
        if (imageInfoBoxFontSize != null) {
            imageInfoBox.setFontSize(Integer.parseInt(imageInfoBoxFontSize.trim()));
        }
        imageInfoBox.setHeight((Double)commonProperties.get(PrintParameterKey.IMAGE_INFO_HEIGHT));
        imageInfoBox.setWidth((Double)commonProperties.get(PrintParameterKey.IMAGE_INFO_WIDTH));
        ImagePosition imageInfoBoxPosition = (ImagePosition)((Object)commonProperties.get(PrintParameterKey.IMAGE_INFO_POSITION));
        if (imageInfoBoxPosition != null) {
            imageInfoBox.setPosition(imageInfoBoxPosition);
        }
        if (!StringUtil.isBlank(imageInfoPattern = String.valueOf(areaTourProperties.get(PrintParameterKey.IMAGE_INFO_PATTERN)))) {
            imageInfoBox.setInfo(imageInfoPattern);
            imageInfoBox.setActive(true);
        }
        inputDatas.put("imageInfoBox", imageInfoBox);
        printerInformation.setLogoPosition((ImagePosition)((Object)commonProperties.get(PrintParameterKey.LOGO_POSITION)));
        Map<PrintPropertyKey, Serializable> areaProperties = printProperties.getAreaProperties();
        String headInfo = (String)((Object)areaProperties.get(PrintParameterKey.PAGE_HEAD_PATTERN));
        inputDatas.put("headInfoArea", headInfo == null ? "" : headInfo);
        return new Tupel<Integer, Integer>((int)Math.round(width), (int)Math.round(height));
    }

    protected String createSvgForScreenshot(PrinterInformation printerInformation, Map<String, Object> inputDatas, NavigatorPanel printNavigatorPanel, NavigatorPanel navigatorPanel) throws IOException, HttpException, AbstractOsmSvgExportFetcherException, SVGGraphics2DIOException, ParserConfigurationException, SAXException {
        List<String> lines = this.extractLines(printerInformation.getSpecialMessage());
        Tupel<Double, Double> dim = printerInformation.getFormat().getSizes(printerInformation.getDpi(), 10.0, 10.0);
        double width = dim.getElement1();
        double lineHeight = (double)printerInformation.getDpi().intValue() / (printerInformation.isUseVector() ? 4.0 : 8.0);
        double height = dim.getElement2() - lineHeight - (lines == null ? 0.0 : (double)lines.size() * lineHeight);
        double widthMM = width / ((double)printerInformation.getDpi().intValue() / PdfCreatorImpl.INCH_PER_CM) * 10.0;
        double heightMM = height / ((double)printerInformation.getDpi().intValue() / PdfCreatorImpl.INCH_PER_CM) * 10.0;
        Point2D.Double realBottomLeft = navigatorPanel.getRealBoundaryBottomLeft() == null ? printNavigatorPanel.getRealBoundaryBottomLeft() : navigatorPanel.getRealBoundaryBottomLeft();
        Point2D.Double realTopRight = navigatorPanel.getRealBoundaryTopRight() == null ? printNavigatorPanel.getRealBoundaryTopRight() : navigatorPanel.getRealBoundaryTopRight();
        Coordinate bottomLeft = printNavigatorPanel.getCoordinateFactory().createCoordinate(realBottomLeft);
        Coordinate topRight = printNavigatorPanel.getCoordinateFactory().createCoordinate(realTopRight);
        Coordinate topLeft = printNavigatorPanel.getCoordinateFactory().createCoordinate(bottomLeft.getX(), topRight.getY());
        Coordinate bottomRight = printNavigatorPanel.getCoordinateFactory().createCoordinate(topRight.getX(), bottomLeft.getY());
        OsmSvgExportFetcher osmSvgExportFetcher = new OsmSvgExportFetcher();
        Tripel<String, Coordinate, Coordinate> tripel = osmSvgExportFetcher.fetchSvg(topLeft, bottomRight, widthMM, heightMM, printerInformation.getMarginX(), printerInformation.getMarginY(), true);
        String fetchSvg = tripel.getElement1();
        topLeft = tripel.getElement2();
        bottomRight = tripel.getElement3();
        Tupel<Integer, Integer> tupel = this.extractWidthAndHeightFromSvg(fetchSvg);
        int rWidth = tupel.getElement1();
        int rHeight = tupel.getElement2();
        StringBuilder sb = new StringBuilder();
        for (NavigatorRenderer navigatorRenderer : printNavigatorPanel.getRenderers()) {
            PrintRenderer printRenderer;
            Tupel<SVGGraphics2D, Double> svg;
            SVGGraphics2D element1;
            String removeSvgAndEnrich;
            if (navigatorRenderer instanceof MapNavigatorRenderer || !navigatorRenderer.isActive() || (removeSvgAndEnrich = this.removeSvgAndEnrich(element1 = (svg = (printRenderer = new PrintRenderer(printNavigatorPanel, navigatorRenderer, topLeft, bottomRight, printNavigatorPanel.getUpp())).render(rWidth, rHeight)).getElement1(), svg.getElement2())) == null) continue;
            sb.append(removeSvgAndEnrich);
        }
        String toImport = sb.toString();
        FileUtils.writeStringToFile(new File("/tmp/s.svg"), toImport);
        sb = null;
        return this.includeIntoSvg(fetchSvg, toImport);
    }

    protected Image getImageFromNavigatorPanel(NavigatorPanel printNavigatorPanel, Collection<Coordinate> coordinates, boolean optimalZoom) throws InterruptedException {
        HashSet<Coordinate> withoutNull = new HashSet<Coordinate>();
        for (Coordinate c : coordinates) {
            if (GeoUtils.isNullCoordinate(c)) continue;
            withoutNull.add(c);
        }
        printNavigatorPanel.center(withoutNull, 1.0, optimalZoom);
        printNavigatorPanel.forceCalcTransform();
        return printNavigatorPanel.paintImage();
    }

    protected Tupel<Integer, Integer> extractWidthAndHeightFromSvg(String svg) {
        Matcher matcher = Pattern.compile("height=\"(\\d*)pt\"").matcher(svg);
        matcher.find();
        int rHeight = Integer.parseInt(matcher.group(1));
        matcher = Pattern.compile("width=\"(\\d*)pt\"").matcher(svg);
        matcher.find();
        int rWidth = Integer.parseInt(matcher.group(1));
        return new Tupel<Integer, Integer>(rWidth, rHeight);
    }

    protected String removeSvgAndEnrich(SVGGraphics2D subGraphics, double scale) throws SVGGraphics2DIOException, ParserConfigurationException, SAXException, IOException {
        StringWriter sw = new StringWriter();
        subGraphics.stream(sw);
        sw.flush();
        SAXParser saxParser = SAX_FACTORY.newSAXParser();
        int fontSize = (int)Math.round(Math.pow(scale * 100.0, 1.0));
        SvgHandler handler = new SvgHandler(true, Math.max(1, fontSize));
        String in = sw.toString();
        sw = null;
        in = this.replaceDocType(in);
        saxParser.parse((InputStream)new ByteArrayInputStream(in.getBytes()), (DefaultHandler)handler);
        String svg = handler.isEmpty() ? null : handler.getResult();
        return svg;
    }

    protected String includeIntoSvg(String fetchSvg, String toImport) throws SVGGraphics2DIOException, ParserConfigurationException, SAXException, IOException {
        SAXParser saxParser = SAX_FACTORY.newSAXParser();
        SvgHandler handler = new SvgHandler(toImport.toString());
        fetchSvg = this.replaceDocType(fetchSvg);
        saxParser.parse((InputStream)new ByteArrayInputStream(fetchSvg.getBytes()), (DefaultHandler)handler);
        fetchSvg = handler.getResult();
        return fetchSvg;
    }

    private String replaceDocType(String xml) {
        int index = xml.indexOf("<!DOCTYPE");
        if (index >= 0) {
            int lIndex = xml.indexOf(62, index);
            return xml.substring(0, index) + xml.substring(lIndex + 1);
        }
        return xml;
    }

    protected String createSvgForModel(NavigatorPanel printNavigatorPanel, Map<M, Color> models, Collection<Coordinate> coordinates, double width, double height, PrinterInformation printerInformation) {
        double left = Double.MAX_VALUE;
        double top = Double.MIN_VALUE;
        double right = Double.MIN_VALUE;
        double bottom = Double.MAX_VALUE;
        for (Coordinate coordinate : coordinates) {
            Coordinate transfromed = Wgs84Factory.INSTANCE.createCoordinate(coordinate);
            left = Math.min(transfromed.getX(), left);
            top = Math.max(transfromed.getY(), top);
            right = Math.max(transfromed.getX(), right);
            bottom = Math.min(transfromed.getY(), bottom);
        }
        Coordinate topLeft = Wgs84Factory.INSTANCE.createCoordinate(left, top);
        Coordinate bottomRight = Wgs84Factory.INSTANCE.createCoordinate(right, bottom);
        OsmSvgExportFetcher osmSvgExportFetcher = new OsmSvgExportFetcher();
        try {
            Tripel<String, Coordinate, Coordinate> tripel = osmSvgExportFetcher.fetchSvg(topLeft, bottomRight, width, height, printerInformation.getMarginX(), printerInformation.getMarginY(), printerInformation.isFillupSpace());
            String fetchSvg = tripel.getElement1();
            topLeft = tripel.getElement2();
            bottomRight = tripel.getElement3();
            Tupel<Integer, Integer> tupel = this.extractWidthAndHeightFromSvg(fetchSvg);
            Tupel<SVGGraphics2D, Double> subGraphics = this.renderSvg(printNavigatorPanel, models, tupel.getElement1(), tupel.getElement2(), topLeft, bottomRight, printerInformation);
            String removeSvgAndEnrich = this.removeSvgAndEnrich(subGraphics.getElement1(), subGraphics.getElement2());
            if (removeSvgAndEnrich != null) {
                fetchSvg = this.includeIntoSvg(fetchSvg, removeSvgAndEnrich);
            }
            return fetchSvg;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        catch (HttpException e) {
            throw new RuntimeException(e);
        }
        catch (AbstractOsmSvgExportFetcherException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        sm = new SimpleDateFormat("dd.MM.yyyy");
        SAX_FACTORY = SAXParserFactory.newInstance();
        SAX_FACTORY.setValidating(false);
    }
}

