/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.printer;

import de.datomino.pdf.printer.InfoPrintPosition;
import de.datomino.pdf.printer.PrinterInformation;
import de.datomino.peppergis.client.gui.common.font.FontResource;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.AbstractManagerMapGui;
import de.datomino.peppergis.client.manager.printer.ManagerPrintOptionPane;
import de.datomino.peppergis.client.manager.printer.ManagerPrinter;
import de.datomino.peppergis.client.util.PdfUtil;
import de.datomino.peppergis.print.PrintProperties;
import de.datomino.peppergis.type.PrintParameterKey;
import de.datomino.util.message.error.ErrorMessage;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.ExceptionMessageDialog;
import de.datomino.util.swing.SwingUtils;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractManagerPrintAction<M>
extends AbstractAction {
    private static final long serialVersionUID = -2064388350492635075L;
    private PrintActionName actionName;
    protected ManagerPrinter managerPrinter;
    protected AbstractManagerMapGui<M> mapGui;

    public AbstractManagerPrintAction(String title, PrintActionName actionName, ManagerPrinter managerPrinter, AbstractManagerMapGui<M> mapGui) {
        super(title);
        this.actionName = actionName;
        this.managerPrinter = managerPrinter;
        this.mapGui = mapGui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Tupel<Collection<Tupel<String, InputStream>>, ErrorMessages> result = this.print();
            if (result != null) {
                ErrorMessages errorMessages = result.getElement2();
                if (errorMessages.hasErrors()) {
                    JDialog.setDefaultLookAndFeelDecorated(true);
                    JTextArea textArea = new JTextArea(10, 30);
                    StringBuilder sb = new StringBuilder();
                    for (ErrorMessage errorMessage : errorMessages.getErrorMessages()) {
                        sb.append(ModelEnviroment.getMessageResolver().resolveMessage(errorMessage));
                        sb.append("\n\n");
                    }
                    textArea.setText(sb.toString());
                    JOptionPane.showMessageDialog(this.mapGui, textArea, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
                } else {
                    Collection<Tupel<String, InputStream>> prints = result.getElement1();
                    this.handleResult(prints);
                }
            }
        }
        catch (Exception e1) {
            BufferedImage image;
            e1.printStackTrace();
            try {
                image = ImageIO.read(AbstractManagerPrintAction.class.getResourceAsStream("/images/pepper.png"));
            }
            catch (IOException ioEx) {
                throw new RuntimeException(ioEx);
            }
            ExceptionMessageDialog exceptionMessageDialog = new ExceptionMessageDialog(SwingUtils.findWindowParent(this.mapGui), e1, image);
            exceptionMessageDialog.setVisible(true);
        }
        finally {
            this.managerPrinter.rebuildRenderers(this.mapGui.getNavigatorPanel());
        }
    }

    protected void handleResult(Collection<Tupel<String, InputStream>> prints) throws Exception {
        if (prints != null) {
            for (Tupel<String, InputStream> tupel : prints) {
                String name = tupel.getElement1();
                PdfUtil.showPdf("Peppergis - Tourmanager", tupel.getElement2(), ModelEnviroment.getProperties(), name, name == null || name.length() == 0, true);
            }
        }
    }

    protected abstract Tupel<Collection<Tupel<String, InputStream>>, ErrorMessages> print() throws Exception;

    protected abstract Tupel<InfoPrintPosition, String> getTypeTupel();

    protected abstract String[] getButtonItems();

    protected abstract PrinterInformation.PrintType getPrintType(int var1);

    protected abstract String getPropertyPrefix();

    protected PrinterInformation getPrintingInformation(ManagerPrintOptionPane printOptionPane) {
        return this.getPrintingInformation(printOptionPane, null);
    }

    protected PrinterInformation getPrintingInformation(ManagerPrintOptionPane printOptionPane, JComponent component) {
        if (component == null) {
            component = printOptionPane;
        }
        String title = ModelEnviroment.getMessageResolver().resolveMessage("gui.print.print", new Serializable[0]);
        Object[] items = this.getButtonItems();
        String defaultItem = items[0];
        int select = JOptionPane.showOptionDialog(this.mapGui, component, title, -1, 3, null, items, defaultItem);
        PrinterInformation.PrintType printType = this.getPrintType(select);
        Tupel<InfoPrintPosition, String> typeTupel = this.getTypeTupel();
        return new PrinterInformation(printType, printOptionPane.getFormat(), false, printOptionPane.getSpecialMessage(), typeTupel.getElement1(), typeTupel.getElement2(), null, printOptionPane.isOptimalZoom(), printOptionPane.getDpi(), printOptionPane.getScale(), printOptionPane.isVector(), printOptionPane.getXMargin().intValue(), printOptionPane.getYMargin().intValue(), printOptionPane.isFillUpSpace(), printOptionPane.getPrintFont(), printOptionPane.getPrintPlacesFont(), printOptionPane.getPrintStreetsFont(), printOptionPane.isUnderline(), printOptionPane.isWhiteBackgroundForScale(), null, printOptionPane.getLineGroupType());
    }

    protected ManagerPrintOptionPane createPrintOptionPane(boolean objectPrint, boolean isPrintSpecialMessage, boolean isAreaGen) {
        boolean propertyPrintSpecialMessage = true;
        PrintProperties printProperties = this.mapGui.getModelEnviroment().getPrintProperties();
        boolean showStreetGroup = false;
        boolean showAddresstGroup = false;
        switch (this.actionName) {
            case LEGEND: {
                showStreetGroup = true;
                showAddresstGroup = true;
                propertyPrintSpecialMessage = (Boolean)printProperties.getAreaTourProperties().get(PrintParameterKey.SPECIAL_MESSAGE);
                break;
            }
            case SCHEDULE: {
                showStreetGroup = true;
                showAddresstGroup = true;
                propertyPrintSpecialMessage = (Boolean)printProperties.getScheduleProperties().get(PrintParameterKey.SPECIAL_MESSAGE);
                break;
            }
            case TOUR: {
                propertyPrintSpecialMessage = (Boolean)printProperties.getTourProperties().get(PrintParameterKey.SPECIAL_MESSAGE);
                break;
            }
        }
        ManagerPrintOptionPane printOptionPane = new ManagerPrintOptionPane(this.mapGui.getModelEnviroment(), isPrintSpecialMessage &= propertyPrintSpecialMessage, false, objectPrint, isAreaGen, FontResource.FOP, this.getPropertyPrefix(), showStreetGroup, showAddresstGroup);
        return printOptionPane;
    }

    protected AbstractManagerMapGui<M> getMapGui() {
        return this.mapGui;
    }

    public static enum PrintActionName {
        TOUR,
        LEGEND,
        SCHEDULE,
        SCREENSHOT,
        AREA_DELIVERER_WEEK;

    }
}

