/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.model;

import de.datomino.peppergis.client.manager.model.TimeExtractor;
import de.datomino.util.swing.blocking.BusyHandler;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractTimeObjectBucketModel<S, T> {
    private TimeExtractor<S> timeExtractor;
    private Map<Tupel<Integer, T>, Set<S>> bucketTimeObjects = new HashMap<Tupel<Integer, T>, Set<S>>();
    private Map<Tupel<Integer, T>, Set<S>> notLoadedMap = new HashMap<Tupel<Integer, T>, Set<S>>();
    private int dayDimension;
    private Date origin;
    protected BusyHandler busyHandler;

    public AbstractTimeObjectBucketModel(TimeExtractor<S> timeExtractor, int dayDimension, BusyHandler busyHandler) {
        this.timeExtractor = timeExtractor;
        this.dayDimension = dayDimension;
        this.busyHandler = busyHandler;
        Calendar calendar = Calendar.getInstance();
        calendar.set(2010, 1, 1, 0, 0, 0);
        calendar.set(14, 0);
        this.origin = calendar.getTime();
    }

    protected abstract Map<T, Collection<S>> callback(Collection<T> var1, Date var2, Date var3);

    public void addObject(T t, S s) {
        Date time = this.extractTime(s);
        Integer index = this.getBucketIndex(time, time).getElement1();
        if (index != null) {
            Tupel<Integer, T> key = new Tupel<Integer, T>(index, t);
            Set<S> values = this.bucketTimeObjects.get(key);
            if (values == null) {
                Set<S> notLoaded = this.notLoadedMap.get(key);
                if (notLoaded == null) {
                    notLoaded = new HashSet<S>();
                }
                notLoaded.add(s);
                this.notLoadedMap.put(key, notLoaded);
            } else {
                values.add(s);
            }
        }
    }

    public Date extractTime(S s) {
        if (s == null) {
            return null;
        }
        return this.timeExtractor.getTime(s);
    }

    protected Map<T, Collection<S>> findBuckets(Collection<T> ts, Date startTime, Date endTime) {
        HashMap<Object, HashSet<S>> bucketMap = new HashMap<Object, HashSet<S>>();
        Tupel<Integer, Integer> indexTupel = this.getBucketIndex(startTime, endTime);
        if (indexTupel.getElement1() != null) {
            for (int index = indexTupel.getElement1().intValue(); index <= indexTupel.getElement2(); ++index) {
                HashSet<T> nullTs = new HashSet<T>();
                for (T t : ts) {
                    Tupel<Integer, T> key = new Tupel<Integer, T>(index, t);
                    Set<S> values = this.bucketTimeObjects.get(key);
                    if (values == null) {
                        nullTs.add(t);
                        continue;
                    }
                    HashSet<S> collection = (HashSet<S>)bucketMap.get(t);
                    if (collection == null) {
                        collection = new HashSet<S>();
                        bucketMap.put(t, collection);
                    }
                    collection.addAll(values);
                }
                if (nullTs.isEmpty()) continue;
                Map map = this.fetchObjects(nullTs, index);
                for (Object t : nullTs) {
                    if (!map.keySet().contains(t)) continue;
                    Tupel key = new Tupel(index, t);
                    HashSet<S> values = new HashSet<S>(map.get(t));
                    Set<S> notLoaded = this.notLoadedMap.remove(key);
                    if (notLoaded != null) {
                        values.addAll(notLoaded);
                    }
                    this.bucketTimeObjects.put(key, values);
                    HashSet<S> collection = (HashSet<S>)bucketMap.get(t);
                    if (collection == null) {
                        collection = new HashSet<S>();
                        bucketMap.put(t, collection);
                    }
                    collection.addAll(values);
                }
            }
        }
        return bucketMap;
    }

    private Tupel<Integer, Integer> getBucketIndex(Date startTime, Date endTime) {
        Tupel<Object, Object> tupel = new Tupel<Object, Object>(null, null);
        if (startTime != null && endTime != null && !endTime.before(startTime)) {
            Calendar calendar1 = Calendar.getInstance();
            calendar1.setTime(this.origin);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(this.origin);
            calendar2.add(5, this.dayDimension);
            int start = 0;
            while (startTime.before(calendar1.getTime()) || !calendar2.getTime().after(startTime)) {
                ++start;
                calendar1.add(5, this.dayDimension);
                calendar2.add(5, this.dayDimension);
            }
            int end = start;
            while (endTime.before(calendar1.getTime()) || !calendar2.getTime().after(endTime)) {
                ++end;
                calendar1.add(5, this.dayDimension);
                calendar2.add(5, this.dayDimension);
            }
            tupel.setElement1(start);
            tupel.setElement2(end);
        }
        return tupel;
    }

    private Map<T, Collection<S>> fetchObjects(Collection<T> ts, Integer index) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.origin);
        calendar.add(5, index * this.dayDimension);
        Date startTime = calendar.getTime();
        calendar.add(5, this.dayDimension);
        Date endTime = calendar.getTime();
        Map<T, Collection<S>> map = this.callback(ts, startTime, endTime);
        return map;
    }

    public boolean removeObject(S s) {
        boolean found = false;
        for (Set<S> value : this.bucketTimeObjects.values()) {
            found |= value.remove(s);
        }
        return found;
    }

    public Collection<S> getAllObject() {
        HashSet<S> ss = new HashSet<S>();
        for (Set<S> value : this.bucketTimeObjects.values()) {
            ss.addAll(value);
        }
        return ss;
    }

    public void clear() {
        this.bucketTimeObjects.clear();
    }
}

