/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.model;

import de.datomino.peppergis.client.manager.legend.BranchNode;
import de.datomino.peppergis.client.manager.legend.PoiNode;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.type.DelivererStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.ktde.util.StringUtil;

public abstract class AbstractDelivererTreeModel<M extends Model>
extends DefaultTreeModel {
    private static final long serialVersionUID = 2095194864291509099L;
    private DefaultMutableTreeNode root;

    public AbstractDelivererTreeModel(DefaultMutableTreeNode root) {
        super(root);
        this.root = root;
    }

    public abstract String getNumber(M var1);

    public abstract DelivererStatus getStatus(M var1, Date var2);

    protected abstract BranchModel getBranch(M var1);

    protected abstract PoiModel getPoi(M var1);

    public void createTreeFromDelivererList(Collection<M> deliverers, Collection<BranchModel> branches) {
        this.root.removeAllChildren();
        this.addBranchTree(deliverers, branches);
        this.reload();
    }

    private void addBranchTree(Collection<M> deliverers, Collection<BranchModel> branches) {
        Map<BranchNode, Set<M>> branchMap = this.getBranchMap(deliverers, branches);
        ArrayList<BranchNode> branchList = new ArrayList<BranchNode>(branchMap.keySet());
        Collections.sort(branchList, new Comparator<BranchNode>(){

            @Override
            public int compare(BranchNode o1, BranchNode o2) {
                if (o1.getBranch() == null) {
                    return 1;
                }
                if (o2.getBranch() == null) {
                    return -1;
                }
                return o1.toString().compareToIgnoreCase(o2.toString());
            }
        });
        for (BranchNode branchNode : branchList) {
            DefaultMutableTreeNode branchTreeNode = new DefaultMutableTreeNode(branchNode);
            this.addDeliverersToBranch(branchTreeNode, branchMap.get(branchNode));
            this.root.add(branchTreeNode);
        }
    }

    private void addDeliverersToBranch(DefaultMutableTreeNode branchTreeNode, Set<M> set) {
        ArrayList<M> delivererList = new ArrayList<M>(set);
        Collections.sort(delivererList, new Comparator<M>(){

            @Override
            public int compare(M o1, M o2) {
                return StringUtil.getNotNull(AbstractDelivererTreeModel.this.getNumber(o1)).compareToIgnoreCase(StringUtil.getNotNull(AbstractDelivererTreeModel.this.getNumber(o2)));
            }
        });
        for (Model deliverer : delivererList) {
            branchTreeNode.add(new DefaultMutableTreeNode(deliverer));
        }
    }

    private Map<BranchNode, Set<M>> getBranchMap(Collection<M> deliverers, Collection<BranchModel> branches) {
        HashMap<BranchNode, Set<M>> map = new HashMap<BranchNode, Set<M>>();
        HashSet<BranchModel> branchComplement = new HashSet<BranchModel>(branches);
        for (Model deliverer : deliverers) {
            BranchNode branchNode = new BranchNode(this.getBranch(deliverer));
            branchComplement.remove(branchNode.getBranch());
            HashSet<Model> set = (HashSet<Model>)map.get(branchNode);
            if (set == null) {
                set = new HashSet<Model>();
                map.put(branchNode, set);
            }
            set.add(deliverer);
        }
        for (BranchModel branch : branchComplement) {
            map.put(new BranchNode(branch), new HashSet());
        }
        return map;
    }

    private Map<PoiNode, Set<M>> getPoiMap(Set<M> deliverers) {
        HashMap<PoiNode, Set<M>> map = new HashMap<PoiNode, Set<M>>();
        for (Model deliverer : deliverers) {
            PoiNode poiNode = new PoiNode(this.getPoi(deliverer));
            HashSet<Model> set = (HashSet<Model>)map.get(poiNode);
            if (set == null) {
                set = new HashSet<Model>();
                map.put(poiNode, set);
            }
            set.add(deliverer);
        }
        return map;
    }

    public void insertTreeNode(DefaultMutableTreeNode child, DefaultMutableTreeNode newParent) {
        TreeNode oldParent = child.getParent();
        int insertIndex = newParent.getChildCount();
        String childNumber = StringUtil.getNotNull(this.getNumber((Model)child.getUserObject()));
        for (int i = 0; i < newParent.getChildCount(); ++i) {
            DefaultMutableTreeNode childAt = (DefaultMutableTreeNode)newParent.getChildAt(i);
            String s = StringUtil.getNotNull(this.getNumber((Model)childAt.getUserObject()));
            if (s.compareToIgnoreCase(childNumber) <= 0) continue;
            insertIndex = i;
            break;
        }
        super.insertNodeInto(child, newParent, insertIndex);
        super.reload(oldParent);
        super.reload(newParent);
    }
}

