/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.legend;

import de.datomino.logistic.dto.LogisticStopDto;
import de.datomino.logistic.dto.LogisticTourDto;
import de.datomino.logistic.dto.LogisticTourPartDto;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.logistic.util.LogisticServicesUtil;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.legend.LegendObject;
import de.datomino.peppergis.client.model.AreaTourExportModelsHolder;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.AreaTourInfoObject;
import de.datomino.peppergis.client.util.LetterModelUtil;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.LogisticTourResultObject;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import de.datomino.peppergis.client.util.PoiModelUtil;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.client.util.SubscriptionModelUtil;
import de.datomino.peppergis.helper.PointEntityId;
import de.datomino.peppergis.type.SubscriptionImportStatus;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.StringUtil;

public class LegendObjectHelper {
    private ModelEnviroment modelEnviroment;
    private boolean forRouting;

    public LegendObjectHelper(ModelEnviroment modelEnviroment) {
        this(modelEnviroment, false);
    }

    public LegendObjectHelper(ModelEnviroment modelEnviroment, boolean forRouting) {
        this.modelEnviroment = modelEnviroment;
        this.forRouting = forRouting;
    }

    public String getInfomation(Object o) {
        if (o == null) {
            return "";
        }
        Object model = o;
        String legendInfo = "";
        String routingInfo = " ";
        if (o instanceof LegendObject) {
            legendInfo = StringUtil.getNotNull(((LegendObject)o).getInfo());
            model = ((LegendObject)o).getM();
            if (this.forRouting) {
                routingInfo = routingInfo + ((LegendObject)o).getRoutingInfomation();
            }
        }
        return legendInfo + this.getModelInfo(model) + routingInfo;
    }

    private String getModelInfo(Object o) {
        String shortInformation = "";
        if (o instanceof StopModel) {
            shortInformation = StopModelUtil.getShortInformation((StopModel)o);
        } else if (o instanceof SubscriptionModel) {
            shortInformation = SubscriptionModelUtil.getDisplayString((SubscriptionModel)o);
        } else if (o instanceof ParcelModel) {
            shortInformation = ParcelModelUtil.getDisplayString((ParcelModel)o);
        } else if (o instanceof PoiModel) {
            shortInformation = PoiModelUtil.getShortInformation((PoiModel)o);
        } else if (o instanceof LetterModel) {
            shortInformation = LetterModelUtil.getDisplayString((LetterModel)o);
        }
        return shortInformation;
    }

    public List<LegendObject<? extends Model>> getLegendObjectsForModels(List<? extends Model> models, List<SubscriptionModel> subscriptionsToRender, RouteVehicleType vehicleType) {
        ArrayList<LegendObject<? extends Model>> legendObjects = new ArrayList<LegendObject<? extends Model>>(models.size());
        LegendObject<? extends Model> legendObject = null;
        int index = 1;
        for (Model model : models) {
            legendObject = this.createLegendObject(model, subscriptionsToRender, vehicleType, index);
            if (legendObject == null) continue;
            ++index;
            legendObjects.add(legendObject);
        }
        return legendObjects;
    }

    public LegendObject<? extends Model> createLegendObject(Model model, Collection<SubscriptionModel> subscriptionsToRender, RouteVehicleType vehicleType, int index) {
        LegendObject<Model> legendObject = null;
        if (model instanceof ParcelModel) {
            ParcelModel parcel = (ParcelModel)model;
            Color c = ParcelModelUtil.getColorOfParcel(parcel, subscriptionsToRender, vehicleType, Color.BLACK);
            legendObject = new LegendObject<ParcelModel>(parcel, c, index);
        } else if (model instanceof SubscriptionModel) {
            SubscriptionModel subscription = (SubscriptionModel)model;
            Color c = Color.BLACK;
            SubscriptionImportStatus importStatus = subscription.getImportStatus();
            ImmutablePoint point = SubscriptionModelUtil.getGeom(subscription);
            boolean badSegment = false;
            if (vehicleType != null) {
                SegmentModel routeSegment = LocationModelUtil.getRouteSegment(subscription.getLocation(), vehicleType, this.modelEnviroment);
                boolean bl = badSegment = routeSegment == null || routeSegment.getSegmentStatus() == null ? true : routeSegment.getSegmentStatus().isBad(vehicleType);
            }
            if (GeoUtil.isNullPoint(point) || badSegment) {
                c = Color.RED;
            } else if (importStatus != null && (importStatus == SubscriptionImportStatus.NOMATCHING || importStatus == SubscriptionImportStatus.NOTCHECKED)) {
                c = Color.RED;
                LocationModel location = subscription.getLocation();
                ParcelModel parcel = location.getParcel();
                ImportedLocationModel importedLocation = location.getImportedLocation();
                if (parcel != null) {
                    c = ParcelModelUtil.getColorOfParcel(parcel, Collections.emptyList(), vehicleType, Color.BLACK);
                } else if (importedLocation != null && importedLocation.getStatus() != null) {
                    switch (importedLocation.getStatus()) {
                        case CHANGED: 
                        case CHECKED: {
                            c = Color.BLACK;
                            break;
                        }
                    }
                }
            }
            legendObject = new LegendObject<SubscriptionModel>(subscription, c, index);
        } else if (model instanceof LetterModel) {
            LetterModel letter = (LetterModel)model;
            Color c = Color.BLACK;
            ImmutablePoint point = LetterModelUtil.getGeom(letter);
            boolean badSegment = false;
            if (vehicleType != null) {
                SegmentModel routeSegment = LocationModelUtil.getRouteSegment(letter.getLocation(), vehicleType, this.modelEnviroment);
                boolean bl = badSegment = routeSegment == null || routeSegment.getSegmentStatus() == null ? true : routeSegment.getSegmentStatus().isBad(vehicleType);
            }
            if (GeoUtil.isNullPoint(point) || badSegment) {
                c = Color.RED;
            }
            legendObject = new LegendObject<LetterModel>(letter, c, index);
        } else if (model instanceof PoiModel) {
            legendObject = LegendObjectHelper.createLegendObject(model, null, null, null, (Integer)0);
            --index;
        }
        return legendObject;
    }

    public static List<LegendObject<? extends Model>> createNewLegend(List<LegendObject<? extends Model>> objects, LogisticTourDto<PointEntityId> logisticTourDto, List<PoiModel> startPois, List<PoiModel> endPois, List<PoiModel> startPickPoints, List<PoiModel> endPickPoints) {
        Integer durationFromStart;
        Integer distanceFromStart;
        Date timeOfArrival;
        LogisticStopDto<PointEntityId> logisticStopDto;
        Integer durationFromStart2;
        Integer distanceFromStart2;
        Date timeOfArrival2;
        LogisticStopDto<PointEntityId> logisticStopDto2;
        ArrayList<LegendObject<? extends Model>> updatedModels = new ArrayList<LegendObject<? extends Model>>(objects.size());
        List<LogisticStopDto<PointEntityId>> allStops = LogisticServicesUtil.getAllStops(logisticTourDto);
        Date startTime = logisticTourDto.getStartTime();
        int index = 0;
        if (startPois != null && !startPois.isEmpty()) {
            for (PoiModel startPoi : startPois) {
                logisticStopDto2 = allStops.get(index);
                timeOfArrival2 = logisticStopDto2.getTimeOfArrival();
                distanceFromStart2 = logisticStopDto2.getStreetMileageMetersFromStart();
                durationFromStart2 = (int)(timeOfArrival2 == null || startTime == null ? 0L : (timeOfArrival2.getTime() - startTime.getTime()) / 1000L);
                updatedModels.add(LegendObjectHelper.createLegendObject(startPoi, timeOfArrival2, durationFromStart2, distanceFromStart2, (Integer)0));
                ++index;
            }
        }
        if (startPickPoints != null && !startPickPoints.isEmpty()) {
            for (PoiModel startPickPoint : startPickPoints) {
                logisticStopDto2 = allStops.get(index);
                timeOfArrival2 = logisticStopDto2.getTimeOfArrival();
                distanceFromStart2 = logisticStopDto2.getStreetMileageMetersFromStart();
                durationFromStart2 = (int)(timeOfArrival2 == null || startTime == null ? 0L : (timeOfArrival2.getTime() - startTime.getTime()) / 1000L);
                updatedModels.add(LegendObjectHelper.createLegendObject(startPickPoint, timeOfArrival2, durationFromStart2, distanceFromStart2, (Integer)0));
                ++index;
            }
        }
        int sortOrder = 1;
        ListIterator<LogisticStopDto<PointEntityId>> iter = allStops.listIterator(index);
        int endIndex = allStops.size() - endPois.size() - endPickPoints.size();
        block2: while (iter.hasNext() && iter.nextIndex() != endIndex) {
            LogisticStopDto<PointEntityId> logisticStopDto3 = iter.next();
            sortOrder = logisticStopDto3.getSortOrder() == null ? sortOrder : logisticStopDto3.getSortOrder();
            Date timeOfArrival3 = logisticStopDto3.getTimeOfArrival();
            Integer distanceFromStart3 = logisticStopDto3.getStreetMileageMetersFromStart();
            Integer durationFromStart3 = (int)(timeOfArrival3 == null || startTime == null ? 0L : (timeOfArrival3.getTime() - startTime.getTime()) / 1000L);
            for (LegendObject<? extends Model> object : objects) {
                Model m = object.getM();
                PointEntityId.PointEnityType pointEnityType = null;
                if (m instanceof LetterModel) {
                    pointEnityType = PointEntityId.PointEnityType.LETTER;
                } else if (m instanceof ParcelModel) {
                    pointEnityType = PointEntityId.PointEnityType.PARCEL;
                } else if (m instanceof SubscriptionModel) {
                    pointEnityType = PointEntityId.PointEnityType.SUBSCRIPTION;
                } else if (m instanceof StopModel) {
                    pointEnityType = PointEntityId.PointEnityType.STOP;
                } else if (m instanceof PoiModel) {
                    pointEnityType = PointEntityId.PointEnityType.POI;
                }
                if (!new EqualsBuilder().append((Object)pointEnityType, (Object)((PointEntityId)logisticStopDto3.getId()).getPointEnityType()).append(m.getTempUUID(), ((PointEntityId)logisticStopDto3.getId()).getId()).isEquals()) continue;
                updatedModels.add(LegendObjectHelper.createLegendObject(object, timeOfArrival3, durationFromStart3, distanceFromStart3, (Integer)sortOrder++));
                ++index;
                continue block2;
            }
        }
        if (endPickPoints != null && !endPickPoints.isEmpty()) {
            for (PoiModel endPickPoint : endPickPoints) {
                logisticStopDto = allStops.get(index);
                timeOfArrival = logisticStopDto.getTimeOfArrival();
                distanceFromStart = logisticStopDto.getStreetMileageMetersFromStart();
                durationFromStart = (int)(timeOfArrival == null || startTime == null ? 0L : (timeOfArrival.getTime() - startTime.getTime()) / 1000L);
                updatedModels.add(LegendObjectHelper.createLegendObject(endPickPoint, timeOfArrival, durationFromStart, distanceFromStart, (Integer)0));
                ++index;
            }
        }
        if (endPois != null && !endPois.isEmpty()) {
            for (PoiModel endPoi : endPois) {
                logisticStopDto = allStops.get(index);
                timeOfArrival = logisticStopDto.getTimeOfArrival();
                distanceFromStart = logisticStopDto.getStreetMileageMetersFromStart();
                durationFromStart = (int)(timeOfArrival == null || startTime == null ? 0L : (timeOfArrival.getTime() - startTime.getTime()) / 1000L);
                updatedModels.add(LegendObjectHelper.createLegendObject(endPoi, timeOfArrival, durationFromStart, distanceFromStart, (Integer)0));
                ++index;
            }
        }
        return updatedModels;
    }

    private static LegendObject<Model> createLegendObject(Model m, Date date, Integer duration, Integer distance, Integer sortOrder) {
        LegendObject<Model> object = new LegendObject<Model>(m, sortOrder);
        object.setEstimatedTimeOfArrival(date);
        object.setEstimatedDurationSeconds(duration);
        object.setStreetMileageMetersFromTourStart(distance);
        return object;
    }

    private static LegendObject<Model> createLegendObject(LegendObject<? extends Model> object, Date date, Integer duration, Integer distance, Integer sortOrder) {
        LegendObject<Model> newObject = new LegendObject<Model>(object.getM(), object.getColor(), sortOrder);
        newObject.setEstimatedTimeOfArrival(date);
        newObject.setEstimatedDurationSeconds(duration);
        newObject.setStreetMileageMetersFromTourStart(distance);
        return newObject;
    }

    public static double getAccessDistance(Object o, RouteVehicleType routeVehicleType, ModelEnviroment modelEnviroment) {
        double accessDistance = 0.0;
        if (o instanceof StopModel) {
            accessDistance = StopModelUtil.getAccessDistance((StopModel)o, routeVehicleType, modelEnviroment);
        } else if (o instanceof SubscriptionModel) {
            accessDistance = SubscriptionModelUtil.getAccessDistance((SubscriptionModel)o, routeVehicleType, modelEnviroment);
        } else if (o instanceof ParcelModel) {
            accessDistance = ParcelModelUtil.getAccessDistance((ParcelModel)o, routeVehicleType);
        } else if (o instanceof PoiModel) {
            accessDistance = PoiModelUtil.getAccessDistance((PoiModel)o, routeVehicleType, modelEnviroment);
        }
        return accessDistance;
    }

    public static AreaTourInfoObject getInformation(LogisticTourResultObject result, Integer sum, Integer parcelSum) {
        LogisticTourDto<PointEntityId> logisticTourDto = result.getLogisticTour();
        AreaTourInfoObject info = new AreaTourInfoObject(result.getAreaObject(), logisticTourDto.getDistanceSum(), logisticTourDto.getDurationSum(), sum, parcelSum);
        info.setAccessDistance(logisticTourDto.getAccessSum());
        info.setStreetDistance(logisticTourDto.getDistanceSum() - logisticTourDto.getAccessSum());
        return info;
    }

    public List<LegendObject<? extends Model>> creatLegend(LogisticTourDto<PointEntityId> tour, AreaTourExportModelsHolder holder) {
        ArrayList<LegendObject<? extends Model>> legendObjects = new ArrayList<LegendObject<? extends Model>>();
        Date startTime = tour.getStartTime();
        List<Model> orderedModels = holder.getOrderedModels();
        int sortOrder = 1;
        for (LogisticTourPartDto<PointEntityId> part : tour.getTourParts()) {
            block1: for (LogisticStopDto<PointEntityId> stop : part.getStopDtos()) {
                Date timeOfArrival = stop.getTimeOfArrival();
                Integer distanceFromStart = stop.getStreetMileageMetersFromStart();
                Integer durationFromStart = (int)(timeOfArrival == null || startTime == null ? 0L : (timeOfArrival.getTime() - startTime.getTime()) / 1000L);
                for (Model m : orderedModels) {
                    PointEntityId.PointEnityType pointEnityType = null;
                    if (m instanceof LetterModel) {
                        pointEnityType = PointEntityId.PointEnityType.LETTER;
                    } else if (m instanceof ParcelModel) {
                        pointEnityType = PointEntityId.PointEnityType.PARCEL;
                    } else if (m instanceof SubscriptionModel) {
                        pointEnityType = PointEntityId.PointEnityType.SUBSCRIPTION;
                    } else if (m instanceof StopModel) {
                        pointEnityType = PointEntityId.PointEnityType.STOP;
                    } else if (m instanceof PoiModel) {
                        pointEnityType = PointEntityId.PointEnityType.POI;
                    }
                    if (!new EqualsBuilder().append((Object)pointEnityType, (Object)((PointEntityId)stop.getId()).getPointEnityType()).append(m.getTempUUID(), ((PointEntityId)stop.getId()).getId()).isEquals()) continue;
                    LegendObject<? extends Model> legendObject = this.createLegendObject(m, holder.getSubscriptions(), part.getRouteVehicleType(), m instanceof PoiModel ? 0 : sortOrder++);
                    legendObject.setEstimatedTimeOfArrival(timeOfArrival);
                    legendObject.setStreetMileageMetersFromTourStart(distanceFromStart);
                    legendObject.setEstimatedDurationSeconds(durationFromStart);
                    legendObjects.add(legendObject);
                    continue block1;
                }
            }
        }
        sortOrder = 1;
        for (Model m : holder.getNullGeomModels()) {
            legendObjects.add(new LegendObject<Model>(m, Color.RED, sortOrder++));
        }
        return legendObjects;
    }
}

