/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.legend;

import de.datomino.peppergis.client.manager.legend.LegendObject;
import de.datomino.peppergis.client.manager.legend.LegendObjectHelper;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.AreaTourInfoObject;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class FilterLegendListRenderer
implements ListCellRenderer {
    private DefaultListCellRenderer renderer = new DefaultListCellRenderer();

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.renderer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.renderer.setFont(UIManager.getDefaults().getFont("TextField.font"));
        String text = "";
        if (value != null) {
            if (value instanceof LegendObject) {
                LegendObjectHelper helper = new LegendObjectHelper(null);
                String shortInformation = helper.getInfomation(value);
                LegendObject legendObject = (LegendObject)value;
                text = legendObject.getSortOrder() + ". " + shortInformation;
                this.renderer.setForeground(legendObject.getColor());
                if (legendObject.getM() instanceof StopModel && StopModelUtil.hasBadTimeWindow((StopModel)legendObject.getM())) {
                    this.renderer.setIcon(TourModelUtil.icon_bad_window);
                }
            } else {
                if (value instanceof JComponent) {
                    return (JComponent)value;
                }
                if (value instanceof AreaTourInfoObject) {
                    AreaTourInfoObject info = (AreaTourInfoObject)value;
                    JTextPane textPane = new JTextPane();
                    textPane.setEditable(false);
                    textPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                    StyleContext.NamedStyle style = new StyleContext.NamedStyle(new StyleContext());
                    StyleConstants.setLineSpacing(style, 0.3f);
                    StyleConstants.setFontSize(style, UIManager.getDefaults().getFont("TextField.font").getSize());
                    StyleConstants.setFontFamily(style, UIManager.getDefaults().getFont("TextField.font").getFamily());
                    textPane.setLogicalStyle(style);
                    textPane.setText(info.getString());
                    return textPane;
                }
                text = value.toString();
                this.renderer.setForeground(Color.BLACK);
            }
            this.renderer.setText(text);
            this.renderer.setBackground(Color.WHITE);
        }
        return this.renderer;
    }
}

