/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.handler;

import de.datomino.peppergis.client.communication.SubscriptionCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.subscription.SubscriptionLayerRenderer;
import de.datomino.peppergis.client.manager.AbstractManagerMapGui;
import de.datomino.peppergis.client.manager.util.ManagerMapUtil;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.client.util.model.subscription.SubscriptionLocationObject;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.BucketsFetchCallback;
import de.datomino.util.geo.model.DefaultGeoObjectBucketsModel;
import de.datomino.util.geo.model.GeomExtractor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.util.datatypes.Tupel;

public class ShowSubscriptionAction
extends AbstractAction {
    private static final long serialVersionUID = -1701649608934923270L;
    private AbstractManagerMapGui mapGui;
    private DefaultGeoObjectBucketsModel<SubscriptionModel, ImmutablePoint> buckets;

    public ShowSubscriptionAction(AbstractManagerMapGui mapGui) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscription", new Serializable[0]));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(123, 0));
        this.mapGui = mapGui;
        final ModelEnviroment modelEnviroment = this.mapGui.getModelEnviroment();
        CoordinateFactory coordinateFactory = modelEnviroment.getCoordinateFactory();
        this.buckets = new DefaultGeoObjectBucketsModel<SubscriptionModel, ImmutablePoint>(5000.0 * coordinateFactory.getRefScale(), coordinateFactory, this.createSubscriptionGeomExtractor());
        this.buckets.setFetchCallback(new BucketsFetchCallback<SubscriptionModel, ImmutablePoint>(){

            @Override
            public Collection<SubscriptionModel> fetch(Coordinate topLeft, Coordinate bottomRight) {
                SubscriptionCaller caller = modelEnviroment.getAllCaller().getSubscriptionCaller();
                Collection<SubscriptionLocationObject> objects = caller.fetchSubscriptionsInRectangleForLayer(topLeft, bottomRight, ShowSubscriptionAction.this.mapGui.getLayer());
                HashSet<SubscriptionModel> ss = new HashSet<SubscriptionModel>(objects.size());
                CollectionUtil.transform(objects, ss, new Transformer<SubscriptionLocationObject, SubscriptionModel>(){

                    @Override
                    public SubscriptionModel transform(SubscriptionLocationObject t) {
                        return (SubscriptionModel)t.getModel();
                    }
                });
                return ss;
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractButton button = (AbstractButton)e.getSource();
        boolean selected = button.getModel().isSelected();
        if (selected) {
            this.showSubscriptionOnMap(button);
        } else {
            this.removeSubscriptionOnMap();
        }
        this.mapGui.getNavigatorPanel().repaint();
    }

    private GeomExtractor<SubscriptionModel, ImmutablePoint> createSubscriptionGeomExtractor() {
        return new GeomExtractor<SubscriptionModel, ImmutablePoint>(){

            @Override
            public ImmutablePoint getGeom(SubscriptionModel object) {
                LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(object.getLocation());
                return locationWrapper.getGeoLocation();
            }
        };
    }

    private void removeSubscriptionOnMap() {
        List<NavigatorRenderer> renderers = this.mapGui.getNavigatorPanel().getRenderers();
        for (NavigatorRenderer renderer : renderers) {
            if (!(renderer instanceof SubscriptionLayerRenderer)) continue;
            ((SubscriptionLayerRenderer)renderer).setActive(false);
        }
    }

    private void showSubscriptionOnMap(AbstractButton button) {
        NavigatorPanel navigatorPanel;
        Component pane = this.mapGui.getPane();
        if (pane != null && pane instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)pane;
            if (!tabbedPane.getSelectedComponent().equals(this.mapGui)) {
                JOptionPane.showMessageDialog(tabbedPane.getSelectedComponent(), ModelEnviroment.getMessageResolver().resolveMessage("gui.map.message.mapInactive", new Serializable[0]));
                button.setSelected(false);
                return;
            }
            tabbedPane.setSelectedComponent(this.mapGui);
        }
        if ((navigatorPanel = this.mapGui.getNavigatorPanel()).getUpp() > AbstractManagerMapGui.MAXUPPFORPARCEL) {
            JOptionPane.showMessageDialog(this.mapGui, ModelEnviroment.getMessageResolver().resolveMessage("gui.map.message.mapTooBig", new Serializable[0]));
            button.setSelected(false);
            return;
        }
        Tupel<ImmutablePoint, ImmutablePoint> boundary = ManagerMapUtil.getBoundaryOfNavigatorPanel(navigatorPanel);
        ImmutablePoint topLeft = boundary.getElement1();
        ImmutablePoint bottomRight = boundary.getElement2();
        CoordinateFactory factory = navigatorPanel.getCoordinateFactory();
        ImmutablePoint bottomLeft = ImmutableGeoObjectFactory.createImmutablePoint(factory.createCoordinate(topLeft.getX(), bottomRight.getY()));
        ImmutablePoint topRight = ImmutableGeoObjectFactory.createImmutablePoint(factory.createCoordinate(bottomRight.getX(), topLeft.getY()));
        Collection subscriptions = this.buckets.findObjects(bottomLeft, topRight);
        List<NavigatorRenderer> renderers = navigatorPanel.getRenderers();
        for (NavigatorRenderer renderer : renderers) {
            if (!(renderer instanceof SubscriptionLayerRenderer)) continue;
            ((SubscriptionLayerRenderer)renderer).setActive(true);
            ((SubscriptionLayerRenderer)renderer).setWithIndex(false);
            ArrayList<Tupel<SubscriptionModel, Integer>> tupel = new ArrayList<Tupel<SubscriptionModel, Integer>>(subscriptions.size());
            CollectionUtil.transform(subscriptions, tupel, new Transformer<SubscriptionModel, Tupel<SubscriptionModel, Integer>>(){

                @Override
                public Tupel<SubscriptionModel, Integer> transform(SubscriptionModel t) {
                    return new Tupel<SubscriptionModel, Object>(t, null);
                }
            });
            ((SubscriptionLayerRenderer)renderer).setSubscriptions(tupel);
            break;
        }
    }
}

