/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.deliverer;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.location.ImportedLocationAddressPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.ParcelAddressPane;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.mobile.AccountModel;
import de.datomino.peppergis.client.model.tour.DelivererEmploymentModel;
import de.datomino.peppergis.client.model.tour.DelivererEmploymentModelImpl;
import de.datomino.peppergis.client.model.tour.DelivererFactorModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.DelivererRewardModel;
import de.datomino.peppergis.client.model.tour.DelivererRewardModelImpl;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Holder;

public class DelivererEmploymentDialog
extends CommonDialog {
    private static final long serialVersionUID = 553075797926733219L;
    private ModelEnviroment modelEnviroment;
    private DelivererModel deliverer;
    private boolean editable;

    public DelivererEmploymentDialog(Window parent, ModelEnviroment modelEnviroment, DelivererModel delivererModel, boolean editable) {
        super((Component)parent, ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.delivererWithNumber", new Serializable[]{StringUtil.nullToEmpty(delivererModel.getDelivererNumber()), StringUtil.nullToEmpty(delivererModel.getName())}), Dialog.ModalityType.APPLICATION_MODAL);
        this.deliverer = delivererModel;
        this.modelEnviroment = modelEnviroment;
        this.editable = editable;
        if (this.editable) {
            modelEnviroment.getUndoManager().startTransaction();
        }
        super.buildLayout();
    }

    @Override
    protected Component getMainComponent() {
        JTabbedPane mainPane = new JTabbedPane();
        mainPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]), this.createDefaultPane());
        mainPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("address.address", new Serializable[0]), this.createAddressPane());
        DelivererEmploymentModel employment = this.deliverer.getEmployment();
        DelivererRewardModel reward = this.deliverer.getReward();
        if (this.editable) {
            if (employment == null) {
                employment = new DelivererEmploymentModelImpl();
                employment.setDeliverer(this.deliverer);
            }
            if (reward == null) {
                reward = new DelivererRewardModelImpl();
                reward.setDeliverer(this.deliverer);
            }
            this.modelEnviroment.getUndoManager().finishTransaction("Initalisieren Fahrer-Einsatz - " + this.deliverer.getDelivererNumber());
            this.modelEnviroment.getUndoManager().startTransaction();
        }
        if (employment != null) {
            mainPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.deliverer.employment", new Serializable[0]), this.createEmploymentsPane());
        }
        if (reward != null) {
            mainPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.deliverer.wage", new Serializable[0]), this.createWagePane());
        }
        return mainPane;
    }

    private Component createWagePane() {
        DelivererRewardModel reward = this.deliverer.getReward();
        JPanel pane = new JPanel(new SpringLayout());
        Holder<DelivererRewardModel> object = new Holder<DelivererRewardModel>(reward);
        pane.add(this.createLabel("messages.reward.hourReward"));
        JTextField hourReward = ClientSwingUtil.createParameterTextField(10, ClientFormUtil.getNumberString(reward.getHourReward()), this.editable, "HourReward", object, this);
        pane.add(hourReward);
        SpringUtilities.makeCompactGrid(pane, 1, 2, 5, 5, 5, 5);
        return ClientSwingUtil.createPanelForComponent(pane, null, "North");
    }

    private Component createEmploymentsPane() {
        DelivererEmploymentModel employment = this.deliverer.getEmployment();
        Holder<DelivererEmploymentModel> object = new Holder<DelivererEmploymentModel>(employment);
        JPanel pane = new JPanel(new SpringLayout());
        pane.add(this.createLabel("messages.deliverer.employmentRadius"));
        JTextField radius = ClientSwingUtil.createParameterTextField(20, ClientFormUtil.getNumberString(employment.getEmploymentRadius()), this.editable, "EmploymentRadius", object, this);
        pane.add(radius);
        pane.add(this.createLabel("messages.default.humanFactor"));
        String[] factorItems = new String[employment.countFactors()];
        List<DelivererFactorModel> factorModels = DelivererModelUtil.getSortedDelivererFactors(this.deliverer);
        int i = 0;
        for (DelivererFactorModel factor : factorModels) {
            factorItems[i] = ClientFormUtil.getNumberString(factor.getFactor()) + " - " + ClientFormUtil.dateToString(factor.getLastModifiedDate());
            ++i;
        }
        JComboBox<String> factors = new JComboBox<String>(factorItems);
        pane.add(factors);
        SpringUtilities.makeCompactGrid(pane, 1, 2, 5, 5, 5, 5);
        return ClientSwingUtil.createPanelForComponent(pane, null, "North");
    }

    private Component createAddressPane() {
        LocationModel location = this.deliverer.getPoi().getLocation();
        JPanel addressComponent = location.getParcel() == null ? new ImportedLocationAddressPane(location.getImportedLocation(), this.modelEnviroment, false, true) : new ParcelAddressPane(location.getParcel(), this.modelEnviroment, false, false);
        return addressComponent;
    }

    private Component createDefaultPane() {
        Holder<DelivererModel> object = new Holder<DelivererModel>(this.deliverer);
        JPanel pane = new JPanel(new SpringLayout());
        pane.add(this.createLabel("messages.delivererNumber"));
        JTextField delivererNumber = ClientSwingUtil.createParameterTextField(40, this.deliverer.getDelivererNumber(), false, "DelivererNumber", object, this);
        pane.add(delivererNumber);
        pane.add(this.createLabel("messages.default.name"));
        JTextField name = ClientSwingUtil.createParameterTextField(20, this.deliverer.getName(), this.editable, "Name", object, this);
        pane.add(name);
        pane.add(this.createLabel("messages.default.accounts"));
        String[] accountNames = new String[this.deliverer.countMobileAccounts()];
        int i = 0;
        for (AccountModel a : this.deliverer.iterableMobileAccounts()) {
            accountNames[i] = a.getLogin();
            ++i;
        }
        JComboBox<String> accounts = new JComboBox<String>(accountNames);
        pane.add(accounts);
        pane.add(this.createLabel("messages.user.phone"));
        JTextField phone = ClientSwingUtil.createParameterTextField(20, this.deliverer.getPhoneNumber(), this.editable, "PhoneNumber", object, this);
        pane.add(phone);
        pane.add(this.createLabel("messages.mobileNumber"));
        JTextField mobile = ClientSwingUtil.createParameterTextField(20, this.deliverer.getMobileNumber(), this.editable, "MobileNumber", object, this);
        pane.add(mobile);
        pane.add(this.createLabel("messages.user.email"));
        JTextField email = ClientSwingUtil.createParameterTextField(20, this.deliverer.getEmail(), this.editable, "Email", object, this);
        pane.add(email);
        SpringUtilities.makeCompactGrid(pane, 6, 2, 5, 5, 5, 5);
        return ClientSwingUtil.createPanelForComponent(pane, null, "North");
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = -4070510918061226363L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DelivererEmploymentDialog.this.editable) {
                    String s = ModelEnviroment.getMessageResolver().resolveMessage("messages.delivererEdited", new Serializable[]{DelivererEmploymentDialog.this.deliverer.getDelivererNumber(), DelivererEmploymentDialog.this.deliverer.getName()});
                    DelivererEmploymentDialog.this.modelEnviroment.getUndoManager().finishTransaction(s);
                }
                DelivererEmploymentDialog.this.dispose();
            }
        };
    }

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = -6666981717422203934L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DelivererEmploymentDialog.this.editable) {
                    DelivererEmploymentDialog.this.modelEnviroment.getUndoManager().rollbackTransaction();
                    DelivererEmploymentDialog.this.deliverer = null;
                }
                DelivererEmploymentDialog.this.dispose();
            }
        };
    }

    private JLabel createLabel(String key) {
        JLabel label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(key, new Serializable[0]));
        label.setVerticalAlignment(1);
        return label;
    }

    public static void createAndShow(DelivererModel deliverer, ModelEnviroment modelEnviroment, boolean editable, Window parent) {
        DelivererEmploymentDialog dialog = new DelivererEmploymentDialog(parent, modelEnviroment, deliverer, editable);
        dialog.pack();
        SwingUtils.center((Window)dialog, parent);
        dialog.setVisible(true);
    }
}

