/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.deliverer;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.AreaDelivererEmploymentModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererRegularAreaModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererRegularAreaModelImpl;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.util.FormUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Holder;
import org.ktde.util.datatypes.Tupel;

public class AreaDelivererEmploymentRegularAreaPane
extends JPanel {
    private static final long serialVersionUID = 495462878254023654L;
    private AreaDelivererEmploymentModel delivererEmployment;
    private List<Tupel<AreaDelivererRegularAreaModel, SubPane>> tupelList;
    private Box regularAreaBox;
    private Window parent;
    private boolean editable;

    public AreaDelivererEmploymentRegularAreaPane(Window parent, boolean editable) {
        super(new BorderLayout());
        super.setPreferredSize(new Dimension(300, 200));
        this.parent = parent;
        this.editable = editable;
        this.tupelList = new ArrayList<Tupel<AreaDelivererRegularAreaModel, SubPane>>(){
            private static final long serialVersionUID = 6293707780561449148L;

            @Override
            public boolean add(Tupel<AreaDelivererRegularAreaModel, SubPane> e) {
                boolean b = super.add(e);
                if (b) {
                    Collections.sort(this, new Comparator<Tupel<AreaDelivererRegularAreaModel, SubPane>>(){

                        @Override
                        public int compare(Tupel<AreaDelivererRegularAreaModel, SubPane> o1, Tupel<AreaDelivererRegularAreaModel, SubPane> o2) {
                            Calendar maxTime = Calendar.getInstance();
                            maxTime.set(1, 3000);
                            Date endTime1 = o1.getElement1().getEndTime() == null ? maxTime.getTime() : o1.getElement1().getEndTime();
                            Date endTime2 = o2.getElement1().getEndTime() == null ? maxTime.getTime() : o2.getElement1().getEndTime();
                            return endTime2.compareTo(endTime1);
                        }
                    });
                }
                return b;
            }
        };
        this.initialize();
    }

    private void initialize() {
        this.regularAreaBox = Box.createVerticalBox();
        this.fillData();
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)this.regularAreaBox, "North");
        JScrollPane scrollPane = new JScrollPane(pane);
        super.add((Component)scrollPane, "Center");
        JPanel buttonPane = new JPanel(new GridLayout(1, 2));
        JButton addButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = -1120541285990896045L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AreaDelivererEmploymentRegularAreaPane.this.delivererEmployment != null) {
                    AreaDelivererRegularAreaModelImpl newModel = new AreaDelivererRegularAreaModelImpl();
                    newModel.setStartTime(new Date());
                    newModel.setEndTime(new Date());
                    AreaDelivererEmploymentRegularAreaPane.this.delivererEmployment.addRegularArea(newModel);
                    AreaDelivererEmploymentRegularAreaPane.this.tupelList.add(new Tupel<AreaDelivererRegularAreaModelImpl, SubPane>(newModel, new SubPane(newModel)));
                    AreaDelivererEmploymentRegularAreaPane.this.fillData();
                }
            }
        });
        addButton.setText("+");
        addButton.setBorder(BorderFactory.createEmptyBorder());
        buttonPane.add(addButton);
        JButton removeButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = 5618093758838171047L;

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = AreaDelivererEmploymentRegularAreaPane.this.tupelList;
                if (!list.isEmpty()) {
                    Tupel last = (Tupel)list.remove(list.size() - 1);
                    AreaDelivererEmploymentRegularAreaPane.this.delivererEmployment.removeRegularArea((AreaDelivererRegularAreaModel)last.getElement1());
                    ((AreaDelivererRegularAreaModel)last.getElement1()).delete();
                    AreaDelivererEmploymentRegularAreaPane.this.fillData();
                }
            }
        });
        removeButton.setText("-");
        removeButton.setBorder(BorderFactory.createEmptyBorder());
        buttonPane.add(removeButton);
        super.add((Component)buttonPane, "South");
    }

    public void setModel(AreaDelivererEmploymentModel delivererEmployment) {
        this.delivererEmployment = delivererEmployment;
        this.tupelList.clear();
        for (AreaDelivererRegularAreaModel regularArea : delivererEmployment.iterableRegularAreas()) {
            this.tupelList.add(new Tupel<AreaDelivererRegularAreaModel, SubPane>(regularArea, new SubPane(regularArea)));
        }
        this.fillData();
    }

    private void fillData() {
        this.regularAreaBox.removeAll();
        for (Tupel<AreaDelivererRegularAreaModel, SubPane> tupel : this.tupelList) {
            this.regularAreaBox.add(tupel.getElement2());
        }
        if (this.tupelList.size() < 5) {
            for (int i = 0; i < 5 - this.tupelList.size(); ++i) {
                this.regularAreaBox.add(new JLabel(" "));
            }
        }
        if (this.parent != null) {
            this.parent.pack();
        }
    }

    private class SubPane
    extends JPanel {
        private static final long serialVersionUID = 8410277774060088374L;

        public SubPane(AreaDelivererRegularAreaModel regularArea) {
            this.initializeSubPane(regularArea);
        }

        private void initializeSubPane(final AreaDelivererRegularAreaModel regularArea) {
            JTextField shortcut = ClientSwingUtil.createParameterTextField(20, StringUtil.getNotNull(regularArea.getShortcut()), AreaDelivererEmploymentRegularAreaPane.this.editable, "Shortcut", new Holder<AreaDelivererRegularAreaModel>(regularArea), this);
            super.add(shortcut);
            super.add(new JLabel(" - "));
            final JSpinner startTimeSpinner = new JSpinner(new SpinnerDateModel());
            JSpinner.DateEditor startEditor = new JSpinner.DateEditor(startTimeSpinner, FormUtil.DATEFORMAT);
            startTimeSpinner.setEditor(startEditor);
            startTimeSpinner.setValue(regularArea.getStartTime());
            super.add(startTimeSpinner);
            super.add(new JLabel(" " + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.to", new Serializable[0]) + " "));
            final JSpinner endTimeSpinner = new JSpinner(new SpinnerDateModel());
            JSpinner.DateEditor endEditor = new JSpinner.DateEditor(endTimeSpinner, FormUtil.DATEFORMAT);
            endTimeSpinner.setEditor(endEditor);
            endTimeSpinner.setValue(regularArea.getEndTime());
            super.add(endTimeSpinner);
            if (AreaDelivererEmploymentRegularAreaPane.this.editable) {
                startTimeSpinner.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        regularArea.setStartTime((Date)startTimeSpinner.getValue());
                    }
                });
                endTimeSpinner.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        regularArea.setEndTime((Date)endTimeSpinner.getValue());
                    }
                });
            }
        }
    }
}

