/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.deliverer;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.location.ImportedLocationAddressPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.ParcelAddressPane;
import de.datomino.peppergis.client.manager.deliverer.AreaDelivererEmploymentRegularAreaPane;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererEmploymentModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererFactorModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererRadiusAreaModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Holder;

public class AreaDelivererEmploymentDialog
extends CommonDialog {
    private static final long serialVersionUID = 553075797926733219L;
    private ModelEnviroment modelEnviroment;
    private AreaDelivererModel deliverer;
    private boolean editable;

    public AreaDelivererEmploymentDialog(Window parent, ModelEnviroment modelEnviroment, AreaDelivererModel delivererModel, boolean editable) {
        super((Component)parent, ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.delivererWithNumber", new Serializable[]{StringUtil.nullToEmpty(delivererModel.getDelivererNumber()), StringUtil.nullToEmpty(delivererModel.getName())}), Dialog.ModalityType.APPLICATION_MODAL);
        this.deliverer = delivererModel;
        this.modelEnviroment = modelEnviroment;
        this.editable = editable;
        if (this.editable) {
            modelEnviroment.getUndoManager().startTransaction();
        }
        super.buildLayout();
    }

    @Override
    protected Component getMainComponent() {
        AreaDelivererEmploymentModel employment;
        JTabbedPane mainPane = new JTabbedPane();
        mainPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]), this.createDefaultPane());
        Component addressPane = this.createAddressPane();
        if (addressPane != null) {
            mainPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("address.address", new Serializable[0]), addressPane);
        }
        if ((employment = this.deliverer.getEmployment()) != null) {
            mainPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.deliverer.employment", new Serializable[0]), this.createEmploymentsPane());
            mainPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("gui.area.areaObject", new Serializable[0]), this.createRegularAreaPane());
        }
        return mainPane;
    }

    private Component createRegularAreaPane() {
        AreaDelivererEmploymentRegularAreaPane regularAreaPane = new AreaDelivererEmploymentRegularAreaPane(this, this.editable);
        regularAreaPane.setModel(this.deliverer.getEmployment());
        return regularAreaPane;
    }

    private Component createEmploymentsPane() {
        AreaDelivererEmploymentModel employment = this.deliverer.getEmployment();
        Holder<AreaDelivererEmploymentModel> object = new Holder<AreaDelivererEmploymentModel>(employment);
        JPanel pane = new JPanel(new SpringLayout());
        pane.add(this.createLabel("messages.deliverer.employmentRadius"));
        JTextField radius = ClientSwingUtil.createParameterTextField(20, ClientFormUtil.getNumberString(employment.getEmploymentRadius()), this.editable, "EmploymentRadius", object, this);
        pane.add(radius);
        pane.add(this.createLabel("messages.deliverer.radiusAreas"));
        String[] areaItems = new String[employment.countRadiusAreas()];
        int i = 0;
        for (AreaDelivererRadiusAreaModel factor : employment.iterableRadiusAreas()) {
            areaItems[i] = factor.getShortcut();
            ++i;
        }
        JComboBox<String> areas = new JComboBox<String>(areaItems);
        pane.add(areas);
        pane.add(this.createLabel("messages.default.humanFactor"));
        String[] factorItems = new String[employment.countFactors()];
        List<AreaDelivererFactorModel> factorModels = DelivererModelUtil.getSortedDelivererFactors(this.deliverer);
        i = 0;
        for (AreaDelivererFactorModel factor : factorModels) {
            factorItems[i] = ClientFormUtil.getNumberString(factor.getFactor()) + " - " + ClientFormUtil.dateToString(factor.getLastModifiedDate());
            ++i;
        }
        JComboBox<String> factors = new JComboBox<String>(factorItems);
        pane.add(factors);
        SpringUtilities.makeCompactGrid(pane, 3, 2, 5, 5, 5, 5);
        return ClientSwingUtil.createPanelForComponent(pane, null, "North");
    }

    private Component createAddressPane() {
        LocationModel location = this.deliverer.getPoi() == null ? null : this.deliverer.getPoi().getLocation();
        JPanel addressComponent = null;
        if (location != null) {
            addressComponent = location.getParcel() == null ? new ImportedLocationAddressPane(location.getImportedLocation(), this.modelEnviroment, false, true) : new ParcelAddressPane(location.getParcel(), this.modelEnviroment, false, false);
        }
        return addressComponent;
    }

    private Component createDefaultPane() {
        Holder<AreaDelivererModel> object = new Holder<AreaDelivererModel>(this.deliverer);
        JPanel pane = new JPanel(new SpringLayout());
        pane.add(this.createLabel("messages.delivererNumber"));
        JTextField delivererNumber = ClientSwingUtil.createParameterTextField(40, this.deliverer.getDelivererNumber(), false, "DelivererNumber", object, this);
        pane.add(delivererNumber);
        pane.add(this.createLabel("messages.default.name"));
        JTextField name = ClientSwingUtil.createParameterTextField(20, this.deliverer.getName(), this.editable, "Name", object, this);
        pane.add(name);
        pane.add(this.createLabel("messages.user.phone"));
        JTextField phone = ClientSwingUtil.createParameterTextField(20, this.deliverer.getPhoneNumber(), this.editable, "PhoneNumber", object, this);
        pane.add(phone);
        pane.add(this.createLabel("messages.mobileNumber"));
        JTextField mobile = ClientSwingUtil.createParameterTextField(20, this.deliverer.getMobileNumber(), this.editable, "MobileNumber", object, this);
        pane.add(mobile);
        pane.add(this.createLabel("messages.user.email"));
        JTextField email = ClientSwingUtil.createParameterTextField(20, this.deliverer.getEmail(), this.editable, "Email", object, this);
        pane.add(email);
        SpringUtilities.makeCompactGrid(pane, 5, 2, 5, 5, 5, 5);
        return ClientSwingUtil.createPanelForComponent(pane, null, "North");
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = -4070510918061226363L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AreaDelivererEmploymentDialog.this.editable) {
                    String s = ModelEnviroment.getMessageResolver().resolveMessage("messages.delivererEdited", new Serializable[]{AreaDelivererEmploymentDialog.this.deliverer.getDelivererNumber(), AreaDelivererEmploymentDialog.this.deliverer.getName()});
                    AreaDelivererEmploymentDialog.this.modelEnviroment.getUndoManager().finishTransaction(s);
                }
                AreaDelivererEmploymentDialog.this.dispose();
            }
        };
    }

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = -6666981717422203934L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AreaDelivererEmploymentDialog.this.editable) {
                    AreaDelivererEmploymentDialog.this.modelEnviroment.getUndoManager().rollbackTransaction();
                    AreaDelivererEmploymentDialog.this.deliverer = null;
                }
                AreaDelivererEmploymentDialog.this.dispose();
            }
        };
    }

    private JLabel createLabel(String key) {
        JLabel label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(key, new Serializable[0]));
        label.setVerticalAlignment(1);
        return label;
    }

    public static void createAndShow(AreaDelivererModel deliverer, ModelEnviroment modelEnviroment, boolean editable, Window parent) {
        AreaDelivererEmploymentDialog dialog = new AreaDelivererEmploymentDialog(parent, modelEnviroment, deliverer, editable);
        dialog.pack();
        SwingUtils.center((Window)dialog, parent);
        dialog.setVisible(true);
    }
}

