/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.branch;

import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.common.AbstractModelComboBox;
import de.datomino.peppergis.client.gui.common.TableCellComponentEditor;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.MultiLineHeaderRenderer;
import de.datomino.peppergis.client.manager.branch.AbstractBranchDialog;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import de.datomino.peppergis.type.BranchType;
import de.datomino.peppergis.util.StringComparator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.ktde.util.datatypes.Tupel;

public class BranchDeletionDialog
extends AbstractBranchDialog {
    private static final long serialVersionUID = -2085055779905407015L;
    private BranchModel branch;
    private List<AreaDelivererModel> areaDeliverers;
    private List<DelivererModel> deliverers;
    private List<BranchModel> regularBranchs;
    private List<BranchModel> areaBranchs;
    private BranchModel regularMainBranch;
    private BranchModel areaMainBranch;
    private Map<DelivererModel, Tupel<BranchModel, Boolean>> delivererBranchMap = new HashMap<DelivererModel, Tupel<BranchModel, Boolean>>();
    private Map<AreaDelivererModel, Tupel<BranchModel, Boolean>> areaDelivererBranchMap = new HashMap<AreaDelivererModel, Tupel<BranchModel, Boolean>>();
    private static final int COL_BRANCH = 1;
    private static final int COL_DELETION = 2;
    private static final int COL_COUNT = 3;

    public BranchDeletionDialog(BranchModel branch, ModelEnviroment modelEnviroment, Component parent, boolean deleteInOwnTransaction) {
        super(parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.branch.delete", new Serializable[0]) + " - " + branch.getName(), modelEnviroment);
        this.branch = branch;
        TourCaller tourCaller = this.modelEnviroment.getAllCaller().getTourCaller();
        this.deliverers = tourCaller.fetchDeliverersByBranch(this.branch);
        this.areaDeliverers = tourCaller.fetchAreaDeliverersByBranch(this.branch);
        if (this.deliverers.isEmpty() && this.areaDeliverers.isEmpty()) {
            if (deleteInOwnTransaction) {
                this.modelEnviroment.getUndoManager().startTransaction();
            }
            this.branch.delete();
            if (deleteInOwnTransaction) {
                this.modelEnviroment.getUndoManager().finishTransaction("");
            }
            return;
        }
        this.regularBranchs = new ArrayList<BranchModel>();
        this.areaBranchs = new ArrayList<BranchModel>();
        List<BranchModel> allBranchs = tourCaller.fetchAllBranchs();
        for (BranchModel b : allBranchs) {
            BranchType branchType = b.getBranchType();
            if (b == this.branch || b.isDeleted() || branchType == null) continue;
            switch (branchType) {
                case AREA_TOUR_DELIVERER: {
                    this.areaBranchs.add(b);
                    if (!b.getName().equals("Zusteller-Hauptstandort")) break;
                    this.areaMainBranch = b;
                    break;
                }
                case REGULAR_TOUR_DELIVERER: {
                    this.regularBranchs.add(b);
                    if (!b.getName().equals("Hauptstandort")) break;
                    this.regularMainBranch = b;
                    break;
                }
            }
        }
        StringComparator<BranchModel> comparator = new StringComparator<BranchModel>(true){

            @Override
            protected String getString(BranchModel o) {
                return o.getName();
            }
        };
        Collections.sort(this.regularBranchs, comparator);
        Collections.sort(this.areaBranchs, comparator);
        this.buildLayout();
        this.pack();
        this.center();
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = 7130222717945369023L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchModel newBranch;
                Tupel tupel;
                for (Model deliverer : BranchDeletionDialog.this.delivererBranchMap.keySet()) {
                    tupel = (Tupel)BranchDeletionDialog.this.delivererBranchMap.get(deliverer);
                    if (((Boolean)tupel.getElement2()).booleanValue()) {
                        DelivererModelUtil.setDelivererDeleted((DelivererModel)deliverer);
                        continue;
                    }
                    newBranch = (BranchModel)tupel.getElement1();
                    deliverer.setBranch(newBranch == null ? BranchDeletionDialog.this.regularMainBranch : newBranch);
                }
                for (Model deliverer : BranchDeletionDialog.this.areaDelivererBranchMap.keySet()) {
                    tupel = (Tupel)BranchDeletionDialog.this.areaDelivererBranchMap.get(deliverer);
                    if (((Boolean)tupel.getElement2()).booleanValue()) {
                        DelivererModelUtil.setDelivererDeleted((AreaDelivererModel)deliverer);
                        continue;
                    }
                    newBranch = (BranchModel)tupel.getElement1();
                    deliverer.setBranch(newBranch == null ? BranchDeletionDialog.this.areaMainBranch : newBranch);
                }
                BranchDeletionDialog.this.branch.delete();
                BranchDeletionDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        JPanel dPanel = null;
        if (!this.deliverers.isEmpty()) {
            JTable dTable = this.createTable(this.deliverers, this.delivererBranchMap, this.regularBranchs, false);
            dPanel = new JPanel(new BorderLayout());
            JLabel label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.branch.delete.question.moveDeliverers", new Serializable[0]));
            label.setBorder(new EmptyBorder(10, 10, 10, 10));
            dPanel.add((Component)label, "North");
            dPanel.add((Component)new JScrollPane(dTable), "Center");
        }
        JPanel aPanel = null;
        if (!this.areaDeliverers.isEmpty()) {
            JTable aTable = this.createTable(this.areaDeliverers, this.areaDelivererBranchMap, this.areaBranchs, true);
            aPanel = new JPanel(new BorderLayout());
            JLabel label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.branch.delete.question.moveAreaDeliverers", new Serializable[0]));
            label.setBorder(new EmptyBorder(10, 10, 10, 10));
            aPanel.add((Component)label, "North");
            aPanel.add((Component)new JScrollPane(aTable), "Center");
        }
        if (this.deliverers.isEmpty()) {
            return aPanel;
        }
        if (this.areaDeliverers.isEmpty()) {
            return dPanel;
        }
        JTabbedPane tab = new JTabbedPane();
        tab.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.deliverer.deliverers", new Serializable[0]), dPanel);
        tab.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.areaDeliverers.areaDeliverers", new Serializable[0]), aPanel);
        return tab;
    }

    private <T extends Model> JTable createTable(final List<T> deliverers, final Map<T, Tupel<BranchModel, Boolean>> delivererMap, List<BranchModel> branches, final boolean area) {
        final DefaultTableModel dm = new DefaultTableModel();
        dm.setDataVector(this.createDataVector(deliverers, delivererMap), this.createColumnHeader(area));
        final JTable table = new JTable(dm){
            private static final long serialVersionUID = -7265584914253527164L;

            @Override
            public Class<?> getColumnClass(int column) {
                switch (column) {
                    case 2: {
                        return Boolean.class;
                    }
                }
                return super.getColumnClass(column);
            }
        };
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedColumn = table.getSelectedColumn();
                int selectedRow = table.getSelectedRow();
                if (selectedColumn == 2 && selectedRow >= 0 && selectedRow < deliverers.size()) {
                    Model selectedDeliverer = (Model)deliverers.get(selectedRow);
                    Tupel tupel = (Tupel)delivererMap.get(selectedDeliverer);
                    Object o = table.getValueAt(selectedRow, selectedColumn);
                    if (((Boolean)o).booleanValue()) {
                        tupel.setElement2(true);
                    } else {
                        tupel.setElement2(false);
                    }
                }
            }
        });
        final TableCellComponentEditor<JComboBox> branchEditor = new TableCellComponentEditor<JComboBox>(table);
        int row = 0;
        for (final Model deliverer : deliverers) {
            final AbstractModelComboBox<BranchModel> comboBox = new AbstractModelComboBox<BranchModel>(branches, false){
                private static final long serialVersionUID = -2605349333349456598L;

                @Override
                protected String getStringRepresentation(BranchModel t) {
                    return t.getName();
                }
            };
            comboBox.setAction(new AbstractAction(){
                private static final long serialVersionUID = 8983148176738395443L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((Tupel)delivererMap.get(deliverer)).setElement1(comboBox.getSelectedItem());
                }
            });
            comboBox.setSelectedItem(delivererMap.get(deliverer).getElement1());
            branchEditor.setEditorAt(row, comboBox);
            ++row;
        }
        this.setTableStyle(table, branchEditor);
        table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if ((e.getModifiers() & 2) <= 0) {
                    this.setAllDelection(false);
                } else if (e.getButton() == 1 && e.getClickCount() == 1) {
                    this.setAllDelection(true);
                }
            }

            private void setAllDelection(boolean b) {
                for (Tupel tupel : delivererMap.values()) {
                    tupel.setElement2(b);
                }
                dm.setDataVector(BranchDeletionDialog.this.createDataVector(deliverers, delivererMap), BranchDeletionDialog.this.createColumnHeader(area));
                BranchDeletionDialog.this.setTableStyle(table, branchEditor);
            }
        });
        return table;
    }

    private void setTableStyle(JTable table, final TableCellComponentEditor<JComboBox> branchEditor) {
        table.setCellSelectionEnabled(false);
        table.setRowHeight(40);
        table.setRowMargin(5);
        MultiLineHeaderRenderer headerRenderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> columns = table.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            column.setHeaderRenderer(headerRenderer);
            switch (column.getModelIndex()) {
                case 1: {
                    column.setCellEditor(branchEditor);
                    column.setCellRenderer(new TableCellRenderer(){

                        @Override
                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            return branchEditor.getEditorAt(row);
                        }
                    });
                    break;
                }
            }
        }
    }

    private <T extends Model> Object[][] createDataVector(List<T> deliverers, Map<T, Tupel<BranchModel, Boolean>> delivererMap) {
        Object[][] data = new Object[deliverers.size()][3];
        int row = 0;
        for (Model deliverer : deliverers) {
            Tupel<BranchModel, Boolean> tupel = delivererMap.get(deliverer);
            if (tupel == null) {
                BranchModel lMainBranch = null;
                if (deliverer instanceof DelivererModel) {
                    lMainBranch = this.regularMainBranch == null ? (this.regularBranchs.isEmpty() ? null : this.regularBranchs.get(0)) : this.regularMainBranch;
                } else if (deliverer instanceof AreaDelivererModel) {
                    lMainBranch = this.areaMainBranch == null ? (this.areaBranchs.isEmpty() ? null : this.areaBranchs.get(0)) : this.areaMainBranch;
                }
                tupel = new Tupel<BranchModel, Boolean>(lMainBranch, false);
                delivererMap.put(deliverer, tupel);
            }
            data[row] = this.createRowData(deliverer, tupel.getElement1(), tupel.getElement2());
            ++row;
        }
        return data;
    }

    private <T extends Model> Object[] createRowData(T deliverer, BranchModel branch, Boolean b) {
        Object[] data = new Object[3];
        if (deliverer instanceof DelivererModel) {
            data[0] = ((DelivererModel)deliverer).getDelivererNumber();
        } else if (deliverer instanceof AreaDelivererModel) {
            data[0] = ((AreaDelivererModel)deliverer).getDelivererNumber();
        }
        data[1] = branch;
        data[2] = b;
        return data;
    }

    private String[] createColumnHeader(boolean area) {
        String[] columnHeader = new String[]{" \n" + ModelEnviroment.getMessageResolver().resolveMessage(area ? "messages.areaDelivererNumber" : "messages.delivererNumber", new Serializable[0]) + "\n \n", " \n" + ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.chooseBranch", new Serializable[0]), " \n" + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.resign", new Serializable[0])};
        return columnHeader;
    }

    public static void createAndShow(BranchModel branch, ModelEnviroment modelEnviroment, Component parent, boolean deleteInOwnTransaction) {
        BranchDeletionDialog d = new BranchDeletionDialog(branch, modelEnviroment, parent, deleteInOwnTransaction);
        if (!branch.isDeleted()) {
            d.setVisible(true);
        }
    }
}

