/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.branch;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.common.DialogDisposeAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.type.UserRole;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.ErrorMessageDialog;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.Action;
import org.ktde.util.StringUtil;

public abstract class AbstractBranchDialog
extends CommonDialog {
    private static final long serialVersionUID = -4684993229842094491L;
    protected ModelEnviroment modelEnviroment;
    protected boolean editable;

    public AbstractBranchDialog(Component parent, String title, ModelEnviroment modelEnviroment) {
        super(parent, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.modelEnviroment = modelEnviroment;
        this.editable = ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.DISPONENT_SUPER);
    }

    @Override
    public void setVisible(boolean b) {
        if (b && this.editable) {
            this.modelEnviroment.getUndoManager().finishTransaction("");
            this.modelEnviroment.getUndoManager().startTransaction();
        }
        super.setVisible(b);
    }

    @Override
    protected Action getCancelAction() {
        return new DialogDisposeAction(this){
            private static final long serialVersionUID = 370336883779263625L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager undoManager = AbstractBranchDialog.this.modelEnviroment.getUndoManager();
                if (undoManager.hasCurrentTransactionChanges()) {
                    undoManager.rollbackTransaction();
                }
                AbstractBranchDialog.this.dispose();
            }
        };
    }

    protected boolean checkValidity(Collection<BranchModel> branchs1, Collection<BranchModel> branchs2) {
        ErrorMessages errorMessages = new ErrorMessages();
        block0: for (BranchModel b1 : branchs1) {
            if (b1.getBranchType() == null) {
                errorMessages.addErrorMessage("errors.branch.emptyType", new Serializable[]{b1.getName()});
            }
            if (StringUtil.isBlank(b1.getName())) {
                errorMessages.addErrorMessage("errors.branch.emptyName", new Serializable[0]);
                continue;
            }
            for (BranchModel b2 : branchs2) {
                if (b1.getBranchType() == null || b2.getBranchType() == null || b1.equals(b2) || b1.getBranchType() != b2.getBranchType() || !StringUtil.getNotNull(b1.getName()).equals(b2.getName())) continue;
                errorMessages.addErrorMessage("errors.branch.multipleName", new Serializable[]{b1.getName()});
                continue block0;
            }
        }
        if (errorMessages.hasErrors()) {
            Window window = SwingUtils.findWindowParent(this);
            ErrorMessageDialog errorMessageDialog = new ErrorMessageDialog(window, ModelEnviroment.getMessageResolver(), errorMessages, this.getImageIcon());
            errorMessageDialog.setVisible(true);
            return false;
        }
        return true;
    }
}

