/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager;

import de.datomino.peppergis.client.gui.renderer.MultiLineHeaderRenderer;
import de.datomino.peppergis.client.manager.util.WeekdayName;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.util.time.TimeUtil;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractWeekPlanTable<M> {
    protected JTable planTable;
    private Map<M, Tupel<Integer, Integer>> selectedObjects = new HashMap<M, Tupel<Integer, Integer>>();
    protected String[] columnHeader;
    protected int rowCount;
    private GregorianCalendar calendar;

    protected abstract void addContentToTable();

    protected abstract TableCellRenderer getTableCellRenderer();

    public JComponent createPlanPane(String title, int rowCount) {
        this.initialize(title, rowCount);
        return new JScrollPane(this.planTable);
    }

    private void initialize(String title, int rowCount) {
        this.columnHeader = this.createColumnHeader(title);
        this.planTable = new JTable(new DefaultTableModel()){
            private static final long serialVersionUID = -1415665928155765727L;

            @Override
            public boolean isCellEditable(int rowIndex, int colIndex) {
                return false;
            }
        };
        this.planTable.setPreferredScrollableViewportSize(ClientFormUtil.SIZEOFPLANTABLE);
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel(){
            private static final long serialVersionUID = -5796592163675977810L;

            @Override
            public void moveColumn(int columnIndex, int newIndex) {
            }
        };
        this.planTable.setColumnModel(columnModel);
        this.planTable.setCellSelectionEnabled(false);
        this.planTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int viewColumn;
                JTableHeader h;
                TableColumnModel columnModel;
                int selectedColumn;
                if ((e.getModifiers() & 2) <= 0) {
                    AbstractWeekPlanTable.this.clearSelectedObjects();
                }
                if (e.getButton() == 1 && e.getClickCount() == 1 && (selectedColumn = (columnModel = (h = (JTableHeader)e.getSource()).getColumnModel()).getColumn(viewColumn = columnModel.getColumnIndexAtX(e.getX())).getModelIndex()) > -1) {
                    AbstractWeekPlanTable.this.clearSelectedObjects();
                    if (selectedColumn == 0) {
                        for (int i = 1; i < columnModel.getColumnCount(); ++i) {
                            AbstractWeekPlanTable.this.addObjectsAtSelectedColumn(i);
                        }
                    } else {
                        AbstractWeekPlanTable.this.addObjectsAtSelectedColumn(selectedColumn);
                    }
                }
                AbstractWeekPlanTable.this.planTable.repaint(10L);
            }
        });
        this.setRowHeight(rowCount);
        this.planTable.setRowMargin(5);
        this.createPlanTable();
    }

    protected void setRowHeight(final int cellRowCount) {
        if (!NavigatorPanel.HEADLESS) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Graphics2D g = (Graphics2D)AbstractWeekPlanTable.this.planTable.getGraphics();
                    Font font = AbstractWeekPlanTable.this.planTable.getFont();
                    Rectangle2D maxCharBounds = font.getMaxCharBounds(g.getFontRenderContext());
                    int height = (int)Math.round(maxCharBounds.getHeight());
                    AbstractWeekPlanTable.this.planTable.setRowHeight((height + 10) * Math.max(2, cellRowCount));
                }
            });
        } else {
            this.planTable.setRowHeight(80);
        }
    }

    public void createPlanTable() {
        this.createNullPlanTable();
        this.createMultiHeader();
        this.addContentToTable();
        this.planTable.repaint(10L);
    }

    private void createMultiHeader() {
        MultiLineHeaderRenderer headerRenderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = this.planTable.getColumnModel().getColumns();
        TableCellRenderer tableCellRenderer = this.getTableCellRenderer();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(headerRenderer);
            tableColumn.setCellRenderer(tableCellRenderer);
        }
    }

    private void addObjectsAtSelectedColumn(int selectedColumn) {
        for (int row = 0; row < this.planTable.getRowCount(); ++row) {
            Object o = this.planTable.getValueAt(row, selectedColumn);
            if (o == null) continue;
            try {
                Object m = o;
                this.selectedObjects.put(m, new Tupel<Integer, Integer>(row, selectedColumn));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void createNullPlanTable() {
        DefaultTableModel tableModel = (DefaultTableModel)this.planTable.getModel();
        Object[][] datas = new Object[this.rowCount][this.columnHeader.length];
        tableModel.setDataVector(datas, this.columnHeader);
    }

    private String[] createColumnHeader(String title) {
        this.calendar = new GregorianCalendar();
        int dayOfWeek = this.calendar.get(7);
        if (dayOfWeek == 1) {
            dayOfWeek = 8;
        }
        this.calendar.add(5, 1 - dayOfWeek);
        String[] columnHeader = new String[]{" \n \n" + title + "\n \n", this.getFormatedString(WeekdayName.D1.getName()), this.getFormatedString(WeekdayName.D2.getName()), this.getFormatedString(WeekdayName.D3.getName()), this.getFormatedString(WeekdayName.D4.getName()), this.getFormatedString(WeekdayName.D5.getName()), this.getFormatedString(WeekdayName.D6.getName()), this.getFormatedString(WeekdayName.D7.getName())};
        return columnHeader;
    }

    private String getFormatedString(String string) {
        this.calendar.add(5, 1);
        return " \n" + string + "\n" + this.calendar.get(5) + " - " + (this.calendar.get(2) + 1) + " - " + this.calendar.get(1) + "\n \n";
    }

    public boolean isInTable(Point location) {
        Point pointTable = this.planTable.getLocationOnScreen();
        int width = this.planTable.getWidth();
        int height = this.planTable.getRowHeight() * this.planTable.getRowCount();
        return location.x > pointTable.x && location.x < pointTable.x + width && location.y > pointTable.y && location.y < pointTable.y + height;
    }

    public Object getSelObject() {
        int selectedRow = this.planTable.getSelectedRow();
        int selectedColumn = this.planTable.getSelectedColumn();
        return this.getObjectInTable(selectedRow, selectedColumn);
    }

    public Object getObjectInTable(int row, int col) {
        if (row == -1 || col == -1) {
            return null;
        }
        return this.planTable.getValueAt(row, col);
    }

    public JTable getPlanTable() {
        return this.planTable;
    }

    public String[] getColumnHeader() {
        return this.columnHeader;
    }

    public void updateMarkSet(M m, int row, int column) {
        if (this.selectedObjects == null) {
            this.selectedObjects = new HashMap<M, Tupel<Integer, Integer>>();
        }
        if (this.selectedObjects.containsKey(m)) {
            this.selectedObjects.remove(m);
        } else {
            this.selectedObjects.put(m, new Tupel<Integer, Integer>(row, column));
        }
    }

    public void clearSelectedObjects() {
        this.selectedObjects.clear();
    }

    public Map<M, Tupel<Integer, Integer>> getSelectedObjects() {
        if (this.selectedObjects == null) {
            this.selectedObjects = new HashMap<M, Tupel<Integer, Integer>>();
        }
        return Collections.unmodifiableMap(this.selectedObjects);
    }

    public int getColumnIndex(Date date) {
        int dayOfWeek = TimeUtil.getDayOfWeek(date);
        if (dayOfWeek == 1) {
            dayOfWeek = 8;
        }
        return dayOfWeek - 1;
    }

    public Date getDateFromColumn(int col) {
        String stringInColHeader = this.getColumnHeader()[col];
        String[] date = stringInColHeader.split("\n")[2].split(" - ");
        Calendar calendar = Calendar.getInstance();
        calendar.set(Integer.parseInt(date[2]), Integer.parseInt(date[1]) - 1, Integer.parseInt(date[0]), 0, 0, 0);
        return calendar.getTime();
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }
}

