/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager;

import de.datomino.peppergis.client.manager.CalendarGui;
import de.datomino.peppergis.client.manager.DelivererTreeRenderer;
import de.datomino.peppergis.client.manager.model.AbstractDelivererTreeModel;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.type.DelivererStatus;
import de.datomino.peppergis.util.FormUtil;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class AbstractDelivererTreeGui<M extends Model> {
    private JTree delivererTree;
    private AbstractDelivererTreeModel<M> delivererTreeModel;
    private List<M> allDeliverers;
    private Collection<AreaDelivererModel> filteredDeliverers;
    private Collection<BranchModel> branches;
    private CalendarGui calendarGui;

    public JScrollPane createDelivererGui(List<M> deliverers, Collection<BranchModel> branches, AbstractDelivererTreeModel<M> delivererTreeModel, CalendarGui calendarGui) {
        this.allDeliverers = deliverers;
        this.branches = branches;
        this.delivererTreeModel = delivererTreeModel;
        this.calendarGui = calendarGui;
        this.createDelivererTree(calendarGui.getCurrentDate());
        this.delivererTree = new JTree(this.delivererTreeModel);
        this.delivererTree.getSelectionModel().setSelectionMode(1);
        this.delivererTree.setCellRenderer(new DelivererTreeRenderer(calendarGui));
        JScrollPane treeView = new JScrollPane(this.delivererTree);
        treeView.setPreferredSize(FormUtil.SIZEOFLISTANDTREE);
        return treeView;
    }

    public boolean isInTree(Point location) {
        Point retangleList = this.delivererTree.getLocationOnScreen();
        int width = this.delivererTree.getWidth();
        int height = this.delivererTree.getHeight();
        return location.x > retangleList.x && location.x < retangleList.x + width && location.y > retangleList.y && location.y < retangleList.y + height;
    }

    public JTree getDelivererJTree() {
        return this.delivererTree;
    }

    public int getDelivererCount() {
        return this.allDeliverers.size();
    }

    public Object getSelectedObject() {
        int selRow = this.delivererTree.getLeadSelectionRow();
        if (selRow < 1) {
            return null;
        }
        DefaultMutableTreeNode treeMode = (DefaultMutableTreeNode)this.delivererTree.getLastSelectedPathComponent();
        return treeMode.getUserObject();
    }

    public List<M> getAllDeliverers() {
        return this.allDeliverers;
    }

    public void addNewDeliverer(M newDeliverer) {
        this.allDeliverers.add(newDeliverer);
        this.createDelivererTree(this.calendarGui.getCurrentDate());
    }

    public void createDelivererTree(Date date) {
        List<M> activeDeliverers = this.getActiveDeliverers(date);
        this.delivererTreeModel.createTreeFromDelivererList(activeDeliverers, this.branches);
    }

    public List<M> getActiveDeliverers(Date date) {
        ArrayList<Model> activeDeliverers = new ArrayList<Model>();
        for (Model deliverer : this.allDeliverers) {
            DelivererStatus status = this.delivererTreeModel.getStatus(deliverer, date);
            if (this.delivererTreeModel.getNumber(deliverer) == null || deliverer.isDeleted() || status == DelivererStatus.DELETED || this.filteredDeliverers != null && !this.filteredDeliverers.contains(deliverer)) continue;
            activeDeliverers.add(deliverer);
        }
        return activeDeliverers;
    }

    public void setFilteredDeliverers(Collection<AreaDelivererModel> filteredDeliverers) {
        this.filteredDeliverers = filteredDeliverers;
    }
}

