/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.importer;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.importer.Importer;
import de.datomino.peppergis.dto.importer.ContentImportDto;
import de.datomino.util.assistant.model.CsvContentGuesser;
import de.datomino.util.assistant.model.Fieldset;
import de.datomino.util.assistant.model.FileField;
import de.datomino.util.assistant.model.Page;
import de.datomino.util.assistant.model.Wizard;
import de.datomino.util.callback.CallBack;
import de.datomino.util.message.MessageResolver;
import java.awt.Window;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FileUtils;

public abstract class AbstractXmlImporter<D extends ContentImportDto>
implements Importer {
    protected FileField fileField;

    public AbstractXmlImporter() {
        this(Collections.singletonList(new FileNameExtensionFilter("CSV", "csv", "CSV")));
    }

    public AbstractXmlImporter(List<FileNameExtensionFilter> fileNameExtensionFilters) {
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        this.fileField = new FileField(messageResolver.resolveMessage("messages.parameter.file", new Serializable[0]), null, (List<? extends FileFilter>)fileNameExtensionFilters);
    }

    @Override
    public Wizard getWizard() {
        Wizard wizard = new Wizard(this.getTitle());
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        Page file = new Page(messageResolver.resolveMessage("messages.page.file.title", new Serializable[0]));
        Fieldset fileParams = new Fieldset(messageResolver.resolveMessage("messages.parameter.file.title", new Serializable[0]));
        fileParams.addField(this.fileField);
        file.addFieldset(fileParams);
        List<Fieldset> additionalFileFieldSets = this.getAdditionalFileFieldSets();
        if (additionalFileFieldSets != null) {
            for (Fieldset fieldset : additionalFileFieldSets) {
                file.addFieldset(fieldset);
            }
        }
        wizard.addPage(file);
        List<Page> addPages = this.getAdditionalPages();
        if (addPages != null) {
            for (Page page : addPages) {
                wizard.addPage(page);
            }
        }
        return wizard;
    }

    protected List<Fieldset> getAdditionalFileFieldSets() {
        return null;
    }

    protected List<Page> getAdditionalPages() {
        return null;
    }

    protected List<CallBack<Boolean, Window>> getAdditonalFileLeaveActions(CsvContentGuesser contentGuesser) {
        return Collections.emptyList();
    }

    public abstract String getTitle();

    protected void writeToDto(D dto) {
        byte[] content;
        try {
            content = FileUtils.readFileToByteArray((File)this.fileField.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ((ContentImportDto)dto).setContent(content);
    }
}

