/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.importer;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.importer.AbstractAddressCsvImporter;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.dto.importer.GenericCsvDto;
import de.datomino.peppergis.dto.location.RangeType;
import de.datomino.util.assistant.model.CsvColumnChoiceField;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.international.country.Country;
import de.datomino.util.international.country.CountryUtil;
import de.datomino.util.message.MessageResolver;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAddressRangeCsvImporter<D extends GenericCsvDto>
extends AbstractAddressCsvImporter<D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAddressRangeCsvImporter.class);
    private CsvColumnChoiceField housenumberToField;
    private CsvColumnChoiceField housenumberExtToField;

    public AbstractAddressRangeCsvImporter(boolean alloptional) {
        super(alloptional);
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        this.housenumberToField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.HOUSENUMBER_TO), (Serializable)((Object)GenericCsvDto.AddressColumns.HOUSENUMBER_TO), "^(?:Hausnummer|hausnr|housenumber) bis$", true);
        this.housenumberExtToField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.HOUSENUMBER_TO_EXTENSION), (Serializable)((Object)GenericCsvDto.AddressColumns.HOUSENUMBER_TO_EXTENSION), "^(?:Hausnummererweiterung|Hausnummerzusatz|zusatz|Hausnummer erw|housenumber_ext) bis$", true);
    }

    @Override
    protected void addCsvFields(List<CsvColumnChoiceField> choiceFields) {
        super.addCsvFields(choiceFields);
        choiceFields.add(this.housenumberToField);
        choiceFields.add(this.housenumberExtToField);
    }

    public static Map<GenericCsvDto.AddressColumns, String> getParcelFromLine(Map<Object, String> parcelDefinition) {
        HashMap<GenericCsvDto.AddressColumns, String> definition = null;
        String street = parcelDefinition.get((Object)GenericCsvDto.AddressColumns.STREET);
        if (!StringUtil.isBlank(street)) {
            definition = new HashMap<GenericCsvDto.AddressColumns, String>();
            for (GenericCsvDto.AddressColumns key : GenericCsvDto.AddressColumns.values()) {
                String value = parcelDefinition.get((Object)key);
                if (value == null) continue;
                definition.put(key, value);
            }
        }
        return definition;
    }

    public static Collection<Tupel<Tupel<ParcelModel, ImmutablePoint>, Double>> getParcelFromDefinition(ModelEnviroment modelEnviroment, Map<GenericCsvDto.AddressColumns, String> parcelDefinition) {
        Country country;
        String countryString = parcelDefinition.get((Object)GenericCsvDto.AddressColumns.COUNTRY);
        String street = parcelDefinition.get((Object)GenericCsvDto.AddressColumns.STREET);
        String postcode = parcelDefinition.get((Object)GenericCsvDto.AddressColumns.POSTCODE);
        String city = parcelDefinition.get((Object)GenericCsvDto.AddressColumns.CITY);
        String district = parcelDefinition.get((Object)GenericCsvDto.AddressColumns.DISTRICT);
        String houseNumber = parcelDefinition.get((Object)GenericCsvDto.AddressColumns.HOUSENUMBER);
        String houseNumberExt = parcelDefinition.get((Object)GenericCsvDto.AddressColumns.HOUSENUMBER_EXTENSION);
        String houseNumberTo = parcelDefinition.get((Object)GenericCsvDto.AddressColumns.HOUSENUMBER_TO);
        String houseNumberToExt = parcelDefinition.get((Object)GenericCsvDto.AddressColumns.HOUSENUMBER_TO_EXTENSION);
        String rangeTypeString = parcelDefinition.get((Object)GenericCsvDto.AddressColumns.HOUSENUMBER_RANGETYPE);
        RangeType rangeType = StringUtil.isBlank(rangeTypeString) ? RangeType.BOTH : RangeType.valueOf(rangeTypeString);
        Country country2 = country = StringUtil.isBlank(countryString) ? null : CountryUtil.searchCountryFuzzy(countryString);
        if (!StringUtil.isBlank(houseNumberTo) || !StringUtil.isBlank(houseNumberToExt)) {
            LOGGER.debug("try to find parcel range");
            LOGGER.debug(country + "-" + postcode + " " + city + "-" + district + " " + street + " " + houseNumber + "" + houseNumberExt + "-" + houseNumberTo + "" + houseNumberToExt);
            if (StringUtil.isBlank(houseNumberTo)) {
                houseNumberTo = houseNumber;
            }
            return modelEnviroment.getAllCaller().getStreetNetCaller().searchParcelOrCoordinateRange(country, postcode, city, district, street, houseNumber, houseNumberExt, houseNumberTo, houseNumberToExt, rangeType);
        }
        LOGGER.debug("try to find single parcel");
        LOGGER.debug(country + "-" + postcode + " " + city + "-" + district + " " + street + " " + houseNumber + "" + houseNumberExt);
        return modelEnviroment.getAllCaller().getStreetNetCaller().searchParcelOrCoordinateRange(country, postcode, city, district, street, houseNumber, houseNumberExt, houseNumber, houseNumberExt, rangeType);
    }
}

