/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.tour;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.util.WeekdayName;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractTimeWindowDialog
extends CommonDialog {
    private static final long serialVersionUID = -652521611684091110L;
    protected Date startTime;
    protected Date endTime;
    protected Set<WeekdayName> exclusiveWeekdays = new HashSet<WeekdayName>();
    protected Component topComponent;
    private boolean selectWeekday;
    private String format;

    public AbstractTimeWindowDialog(Component parent, String titleKey, Date defaultTime, String format) {
        this(parent, null, titleKey, defaultTime, format, true);
    }

    public AbstractTimeWindowDialog(Component parent, Component topComponent, String titleKey, Date defaultTime, String format, boolean selectWeekday) {
        super(parent, ModelEnviroment.getMessageResolver().resolveMessage(titleKey, new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.topComponent = topComponent;
        this.format = format;
        this.selectWeekday = selectWeekday;
        if (defaultTime == null) {
            defaultTime = new Date();
        }
        this.startTime = defaultTime;
        Calendar c = Calendar.getInstance();
        c.setTime(defaultTime);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        this.endTime = c.getTime();
        super.buildLayout();
        super.pack();
        SwingUtils.center((Window)this, super.getParent());
    }

    protected abstract void setTimeWindow(Set<Tupel<Date, Date>> var1);

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = 5187575194447321094L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractTimeWindowDialog.this.createTimeWindows();
                AbstractTimeWindowDialog.this.dispose();
            }
        };
    }

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = 8877989085688124151L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractTimeWindowDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        JPanel timewindowPane = new JPanel(new FlowLayout());
        final JSpinner startTimeSpinner = new JSpinner(new SpinnerDateModel(this.startTime, null, null, 5));
        JSpinner.DateEditor startTimeEditor = new JSpinner.DateEditor(startTimeSpinner, this.format);
        startTimeSpinner.setEditor(startTimeEditor);
        JFormattedTextField startTimeField = ((JSpinner.DefaultEditor)startTimeSpinner.getEditor()).getTextField();
        startTimeField.setHorizontalAlignment(2);
        final JSpinner endTimeSpinner = new JSpinner(new SpinnerDateModel(this.endTime, null, null, 5));
        JSpinner.DateEditor endTimeEditor = new JSpinner.DateEditor(endTimeSpinner, this.format);
        endTimeSpinner.setEditor(endTimeEditor);
        JFormattedTextField endTimeField = ((JSpinner.DefaultEditor)endTimeSpinner.getEditor()).getTextField();
        endTimeField.setHorizontalAlignment(2);
        startTimeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Date value = (Date)startTimeSpinner.getValue();
                if (value.after(AbstractTimeWindowDialog.this.endTime)) {
                    endTimeSpinner.setValue(value);
                }
                AbstractTimeWindowDialog.this.startTime = value;
            }
        });
        endTimeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Date value = (Date)endTimeSpinner.getValue();
                if (value.before(AbstractTimeWindowDialog.this.startTime)) {
                    startTimeSpinner.setValue(value);
                }
                AbstractTimeWindowDialog.this.endTime = value;
            }
        });
        timewindowPane.add(startTimeSpinner);
        timewindowPane.add(new JLabel(" " + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.to", new Serializable[0]) + " "));
        timewindowPane.add(endTimeSpinner);
        timewindowPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel weekDayPane = new JPanel(new BorderLayout());
        weekDayPane.add((Component)new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.exclusive", new Serializable[0])), "North");
        JPanel subWeekDayPane = new JPanel(new FlowLayout());
        subWeekDayPane.add(this.createCheckBox(WeekdayName.D1));
        subWeekDayPane.add(this.createCheckBox(WeekdayName.D2));
        subWeekDayPane.add(this.createCheckBox(WeekdayName.D3));
        subWeekDayPane.add(this.createCheckBox(WeekdayName.D4));
        subWeekDayPane.add(this.createCheckBox(WeekdayName.D5));
        subWeekDayPane.add(this.createCheckBox(WeekdayName.D6));
        subWeekDayPane.add(this.createCheckBox(WeekdayName.D7));
        weekDayPane.add((Component)subWeekDayPane, "Center");
        Box box = Box.createVerticalBox();
        box.add(timewindowPane);
        if (this.selectWeekday) {
            box.add(weekDayPane);
        }
        if (this.topComponent != null) {
            JPanel pane = new JPanel(new BorderLayout());
            pane.add(this.topComponent, "North");
            pane.add((Component)box, "Center");
            return pane;
        }
        return box;
    }

    private JCheckBox createCheckBox(final WeekdayName weekdayName) {
        return new JCheckBox(new AbstractAction(weekdayName.getShortName()){
            private static final long serialVersionUID = -8239053061099867704L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Object o = e.getSource();
                if (o instanceof JCheckBox) {
                    JCheckBox checkBox = (JCheckBox)o;
                    if (checkBox.isSelected()) {
                        AbstractTimeWindowDialog.this.exclusiveWeekdays.add(weekdayName);
                    } else {
                        AbstractTimeWindowDialog.this.exclusiveWeekdays.remove((Object)weekdayName);
                    }
                }
            }
        });
    }

    private void createTimeWindows() {
        Date d2;
        HashSet<Tupel<Date, Date>> timeWindows = new HashSet<Tupel<Date, Date>>();
        Date d1 = this.startTime;
        block0: while (true) {
            d2 = this.endTime;
            Calendar c = Calendar.getInstance();
            c.setTime(d1);
            while (true) {
                if (this.exclusiveWeekdays.contains((Object)WeekdayName.getWeekDayName(d1))) {
                    this.nextDay(c);
                    d1 = c.getTime();
                    continue;
                }
                this.nextDay(c);
                if (c.getTime().after(this.endTime)) break block0;
                if (this.exclusiveWeekdays.contains((Object)WeekdayName.getWeekDayName(c.getTime()))) break;
            }
            d2 = c.getTime();
            timeWindows.add(new Tupel<Date, Date>(d1, d2));
            timeWindows.add(new Tupel<Date, Date>(d1, d2));
            d1 = d2;
        }
        timeWindows.add(new Tupel<Date, Date>(d1, d2));
        this.setTimeWindow(timeWindows);
    }

    private void nextDay(Calendar c) {
        c.add(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
    }
}

