/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.tour;

import de.datomino.peppergis.client.gui.common.DatePicker;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.tour.AbstractTimeWindowDialog;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.time.TimeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractDelivererTimeIntervalDialog
extends AbstractTimeWindowDialog {
    private static final long serialVersionUID = -2082416202294819780L;

    public AbstractDelivererTimeIntervalDialog(Component parent, Component topComponent, String titleKey) {
        super(parent, topComponent, titleKey, null, FormUtil.DATEFORMAT, false);
    }

    @Override
    protected Component getMainComponent() {
        JPanel timeIntervalPane = new JPanel(new FlowLayout());
        this.startTime = TimeUtil.getDayTupel(this.startTime).getElement1();
        final DatePicker startDate = new DatePicker(this.startTime);
        final DatePicker endDate = new DatePicker(this.endTime);
        startDate.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Date value = startDate.getSelectedItem();
                if (value.after(AbstractDelivererTimeIntervalDialog.this.endTime)) {
                    endDate.setSelectedItem(value);
                }
                AbstractDelivererTimeIntervalDialog.this.startTime = value;
            }
        });
        endDate.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Date value = endDate.getSelectedItem();
                if (value.before(AbstractDelivererTimeIntervalDialog.this.startTime)) {
                    startDate.setSelectedItem(value);
                }
                AbstractDelivererTimeIntervalDialog.this.endTime = value;
            }
        });
        timeIntervalPane.add(startDate);
        timeIntervalPane.add(new JLabel(" " + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.to", new Serializable[0]) + " "));
        timeIntervalPane.add(endDate);
        timeIntervalPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Box box = Box.createVerticalBox();
        box.add(timeIntervalPane);
        if (this.topComponent != null) {
            JPanel pane = new JPanel(new BorderLayout());
            pane.add(this.topComponent, "North");
            pane.add((Component)box, "Center");
            return pane;
        }
        return box;
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = 5187575194447321094L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Date startTime = AbstractDelivererTimeIntervalDialog.this.startTime;
                Date endTime = TimeUtil.getEndOfDay(AbstractDelivererTimeIntervalDialog.this.endTime);
                AbstractDelivererTimeIntervalDialog.this.setTimeWindow(Collections.singleton(new Tupel<Date, Date>(startTime, endTime)));
                AbstractDelivererTimeIntervalDialog.this.dispose();
            }
        };
    }
}

