/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.subscription;

import de.datomino.peppergis.client.gui.common.table.DateTableCellEditor;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.SubscriptionBreakTimeModel;
import de.datomino.peppergis.client.model.base.SubscriptionBreakTimeModelImpl;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.util.time.TimeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.ktde.util.datatypes.Quad;

public class SubscriptionBreakTimePane
extends JPanel {
    private static final long serialVersionUID = -6668878934412157001L;
    private static final Comparator<Quad<SubscriptionBreakTimeModel, Date, Date, SubscriptionModel>> BREAK_TIME_COMPARATOR = new Comparator<Quad<SubscriptionBreakTimeModel, Date, Date, SubscriptionModel>>(){

        @Override
        public int compare(Quad<SubscriptionBreakTimeModel, Date, Date, SubscriptionModel> o1, Quad<SubscriptionBreakTimeModel, Date, Date, SubscriptionModel> o2) {
            return o1.getElement2().compareTo(o2.getElement2());
        }
    };
    private JTable breakTimeTable;
    private SubscriptionModel subscriptionModel;
    private boolean enabled;
    private List<Quad<SubscriptionBreakTimeModel, Date, Date, SubscriptionModel>> breakTimes;
    private Set<SubscriptionBreakTimeModel> toDelete = new HashSet<SubscriptionBreakTimeModel>();
    private Action addAction;
    private Action removeAction;

    public SubscriptionBreakTimePane(SubscriptionModel subscriptionModel) {
        super(new BorderLayout());
        this.subscriptionModel = subscriptionModel;
        this.breakTimes = this.getBreakTimes(subscriptionModel);
        this.breakTimeTable = new JTable(new BreakTimeTableModel());
        this.breakTimeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SubscriptionBreakTimePane.this.removeAction.setEnabled(SubscriptionBreakTimePane.this.enabled && SubscriptionBreakTimePane.this.breakTimeTable.getSelectedRowCount() >= 0);
            }
        });
        this.breakTimeTable.setDefaultRenderer(SubscriptionModel.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 443994533467294224L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                SubscriptionModel subscriptionModel = (SubscriptionModel)value;
                String r = subscriptionModel == null ? "" : subscriptionModel.getSubscriptionNumber();
                return super.getTableCellRendererComponent(table, r, isSelected, hasFocus, row, column);
            }
        });
        this.breakTimeTable.setDefaultRenderer(Date.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 443994533467294224L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String r;
                Date date = (Date)value;
                if (date != null) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    r = format.format(date);
                } else {
                    r = "";
                }
                return super.getTableCellRendererComponent(table, r, isSelected, hasFocus, row, column);
            }
        });
        this.breakTimeTable.setDefaultEditor(Date.class, new DateTableCellEditor("yyyy-MM-dd"));
        this.add((Component)new JScrollPane(this.breakTimeTable), "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.removeAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.remove", new Serializable[0])){
            private static final long serialVersionUID = 8832236314197289660L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = SubscriptionBreakTimePane.this.breakTimeTable.getSelectedRows();
                for (int i = selectedRows.length - 1; i >= 0; --i) {
                    Quad remove = (Quad)SubscriptionBreakTimePane.this.breakTimes.remove(selectedRows[i]);
                    SubscriptionBreakTimeModel breakTimeModel = (SubscriptionBreakTimeModel)remove.getElement1();
                    if (breakTimeModel == null) continue;
                    SubscriptionBreakTimePane.this.toDelete.add(breakTimeModel);
                }
                ((BreakTimeTableModel)SubscriptionBreakTimePane.this.breakTimeTable.getModel()).fireTableChanged();
            }
        };
        JButton button = new JButton(this.removeAction);
        this.removeAction.setEnabled(false);
        buttonPanel.add(button);
        this.addAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0])){
            private static final long serialVersionUID = -844896009898732892L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Date now = new Date();
                SubscriptionBreakTimePane.this.breakTimes.add(new Quad<Object, Date, Date, Object>(null, now, now, null));
                ((BreakTimeTableModel)SubscriptionBreakTimePane.this.breakTimeTable.getModel()).fireTableChanged();
            }
        };
        button = new JButton(this.addAction);
        buttonPanel.add(button);
        this.add((Component)buttonPanel, "South");
    }

    private List<Quad<SubscriptionBreakTimeModel, Date, Date, SubscriptionModel>> getBreakTimes(SubscriptionModel subscriptionModel) {
        ArrayList<Quad<SubscriptionBreakTimeModel, Date, Date, SubscriptionModel>> subscriptionBreakTimeModels = new ArrayList<Quad<SubscriptionBreakTimeModel, Date, Date, SubscriptionModel>>(subscriptionModel.countBreakTimes());
        for (SubscriptionBreakTimeModel subscriptionBreakTimeModel : subscriptionModel.iterableBreakTimes()) {
            subscriptionBreakTimeModels.add(new Quad<SubscriptionBreakTimeModel, Date, Date, SubscriptionModel>(subscriptionBreakTimeModel, subscriptionBreakTimeModel.getStartDate(), subscriptionBreakTimeModel.getEndDate(), subscriptionBreakTimeModel.getLendSubscription()));
        }
        Collections.sort(subscriptionBreakTimeModels, BREAK_TIME_COMPARATOR);
        return subscriptionBreakTimeModels;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        super.setEnabled(enabled);
        this.addAction.setEnabled(enabled);
        this.removeAction.setEnabled(enabled);
        ((BreakTimeTableModel)this.breakTimeTable.getModel()).fireTableChanged();
    }

    public void adaptValuesToModel() {
        this.breakTimeTable.editingStopped(new ChangeEvent(this.breakTimeTable));
        for (Quad<SubscriptionBreakTimeModel, Date, Date, SubscriptionModel> breakTime : this.breakTimes) {
            SubscriptionBreakTimeModel subscriptionBreakTimeModel = breakTime.getElement1();
            if (subscriptionBreakTimeModel == null) {
                subscriptionBreakTimeModel = new SubscriptionBreakTimeModelImpl();
                subscriptionBreakTimeModel.setSubscription(this.subscriptionModel);
            }
            Date start = breakTime.getElement2();
            start = TimeUtil.normalize(start);
            subscriptionBreakTimeModel.setStartDate(start);
            Date end = breakTime.getElement3();
            end = TimeUtil.setTime(end, 23, 59, 59);
            subscriptionBreakTimeModel.setEndDate(end);
            subscriptionBreakTimeModel.setLendSubscription(breakTime.getElement4());
        }
        for (SubscriptionBreakTimeModel el : this.toDelete) {
            el.setSubscription(null);
            el.delete();
        }
    }

    private class BreakTimeTableModel
    implements TableModel {
        private List<TableModelListener> listeners = new LinkedList<TableModelListener>();

        private BreakTimeTableModel() {
        }

        @Override
        public int getRowCount() {
            return SubscriptionBreakTimePane.this.breakTimes.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.breakTime.start", new Serializable[0]);
                }
                case 1: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.breakTime.end", new Serializable[0]);
                }
                case 2: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.breakTime.lendSubscription", new Serializable[0]);
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 1: {
                    return Date.class;
                }
                case 2: {
                    return SubscriptionModel.class;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return SubscriptionBreakTimePane.this.enabled && (columnIndex == 0 || columnIndex == 1);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Quad subscriptionBreakTimeModel = (Quad)SubscriptionBreakTimePane.this.breakTimes.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return subscriptionBreakTimeModel.getElement2();
                }
                case 1: {
                    return subscriptionBreakTimeModel.getElement3();
                }
                case 2: {
                    return subscriptionBreakTimeModel.getElement4();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Quad subscriptionBreakTimeModel = (Quad)SubscriptionBreakTimePane.this.breakTimes.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    subscriptionBreakTimeModel.setElement2((Date)aValue);
                    break;
                }
                case 1: {
                    subscriptionBreakTimeModel.setElement3((Date)aValue);
                    break;
                }
                case 2: {
                    subscriptionBreakTimeModel.setElement4((SubscriptionModel)aValue);
                }
            }
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        void fireTableChanged() {
            TableModelEvent e = new TableModelEvent(this);
            for (TableModelListener listener : this.listeners) {
                listener.tableChanged(e);
            }
        }
    }
}

