/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.subscription;

import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.type.LetterDeliveryType;
import de.datomino.peppergis.type.SubscriptionDeliveryType;
import de.datomino.peppergis.type.SubscriptionStatus;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.WidthUnifier;
import java.awt.GridLayout;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpringLayout;

public class ObjectCalculationOptionsPane
extends JPanel {
    private static final long serialVersionUID = -6803398779355274436L;
    private JSpinner dateSpinner;
    private EnumComboBox<SubscriptionStatus> statusCombox;
    private EnumComboBox<SubscriptionDeliveryType> subscriptionTypeComBox;
    private EnumComboBox<LetterDeliveryType> letterDeliveryTypeComboBox;
    private int rowCount;

    public ObjectCalculationOptionsPane(WidthUnifier labelWidthUnifier, WidthUnifier widgetUnifier) {
        this(null, true, true, true, labelWidthUnifier, widgetUnifier);
    }

    public ObjectCalculationOptionsPane(boolean subscription, boolean letter) {
        this(null, subscription, letter);
    }

    public ObjectCalculationOptionsPane(JPanel parentPanel, boolean subscription, boolean letter) {
        this(parentPanel, subscription, letter, false, null, null);
    }

    private ObjectCalculationOptionsPane(JPanel parentPanel, boolean subscription, boolean letter, boolean x4, WidthUnifier labelWidthUnifier, WidthUnifier widgetUnifier) {
        super(x4 ? new SpringLayout() : new GridLayout(1 + (subscription ? 2 : 0) + (letter ? 1 : 0), 2));
        this.initialize(parentPanel, subscription, letter, x4, labelWidthUnifier, widgetUnifier);
    }

    private void initialize(JPanel parentPanel, boolean subscription, boolean letter, boolean x4, WidthUnifier labelWidthUnifier, WidthUnifier widgetUnifier) {
        this.dateSpinner = new JSpinner(new SpinnerDateModel(new Date(), null, null, 5));
        if (parentPanel == null && !x4) {
            this.dateSpinner.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        }
        JSpinner.DateEditor editor = new JSpinner.DateEditor(this.dateSpinner, FormUtil.DATEFORMAT);
        this.dateSpinner.setEditor(editor);
        JLabel label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.date", new Serializable[0]));
        if (parentPanel == null) {
            this.add(label);
            this.add(this.dateSpinner);
            if (x4) {
                labelWidthUnifier.add(label);
                widgetUnifier.add(this.dateSpinner);
            }
        } else {
            parentPanel.add(label);
            parentPanel.add(this.dateSpinner);
        }
        this.statusCombox = new EnumComboBox<SubscriptionStatus>(SubscriptionStatus.class, false);
        this.subscriptionTypeComBox = new EnumComboBox<SubscriptionDeliveryType>(SubscriptionDeliveryType.class, false);
        if (subscription) {
            if (parentPanel == null && !x4) {
                this.statusCombox.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
            }
            label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("de.datomino.peppergis.type.SubscriptionStatus", new Serializable[0]));
            if (parentPanel == null) {
                this.add(label);
                this.add(this.statusCombox);
                if (x4) {
                    labelWidthUnifier.add(label);
                    widgetUnifier.add(this.statusCombox);
                }
            } else {
                parentPanel.add(label);
                parentPanel.add(this.statusCombox);
            }
            if (parentPanel == null && !x4) {
                this.subscriptionTypeComBox.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
            }
            label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("de.datomino.peppergis.type.SubscriptionDeliveryType", new Serializable[0]));
            if (parentPanel == null) {
                this.add(label);
                this.add(this.subscriptionTypeComBox);
                if (x4) {
                    labelWidthUnifier.add(label);
                    widgetUnifier.add(this.subscriptionTypeComBox);
                }
            } else {
                parentPanel.add(label);
                parentPanel.add(this.subscriptionTypeComBox);
            }
        }
        this.letterDeliveryTypeComboBox = new EnumComboBox<LetterDeliveryType>(LetterDeliveryType.class, false);
        if (letter) {
            if (parentPanel == null && !x4) {
                this.letterDeliveryTypeComboBox.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
            }
            label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(LetterDeliveryType.class.getName(), new Serializable[0]));
            if (parentPanel == null) {
                this.add(label);
                this.add(this.letterDeliveryTypeComboBox);
                if (x4) {
                    labelWidthUnifier.add(label);
                    widgetUnifier.add(this.letterDeliveryTypeComboBox);
                }
            } else {
                parentPanel.add(label);
                parentPanel.add(this.letterDeliveryTypeComboBox);
            }
        }
        if (x4) {
            SpringUtilities.makeCompactGrid(this, 2, 4, 2, 2, 5, 5);
            this.rowCount = 2;
        } else {
            this.rowCount = 1 + (subscription ? 2 : 0) + (letter ? 1 : 0);
        }
    }

    public void setOptionEnabled(boolean subscriptionsEnabled, boolean letterEnabled) {
        ClientSwingUtil.setSpinnerEnable(this.dateSpinner, subscriptionsEnabled || letterEnabled);
        this.statusCombox.setEnabled(subscriptionsEnabled);
        this.subscriptionTypeComBox.setEnabled(subscriptionsEnabled);
        this.letterDeliveryTypeComboBox.setEnabled(letterEnabled);
    }

    public Date getDate() {
        return (Date)this.dateSpinner.getValue();
    }

    public Set<SubscriptionStatus> getSubscriptionStatuses() {
        HashSet<SubscriptionStatus> statuses = new HashSet<SubscriptionStatus>();
        SubscriptionStatus selectedValue = this.statusCombox.getSelectedValue();
        if (selectedValue == SubscriptionStatus.ALL) {
            for (SubscriptionStatus status : SubscriptionStatus.values()) {
                if (status == SubscriptionStatus.ALL) continue;
                statuses.add(status);
            }
        } else {
            statuses.add(selectedValue);
        }
        return statuses;
    }

    public Set<SubscriptionDeliveryType> getSubscriptionTypes() {
        HashSet<SubscriptionDeliveryType> types = new HashSet<SubscriptionDeliveryType>();
        if (this.subscriptionTypeComBox.getSelectedValue() == SubscriptionDeliveryType.ALL) {
            for (SubscriptionDeliveryType type : SubscriptionDeliveryType.values()) {
                types.add(type);
            }
        } else {
            types.add(this.subscriptionTypeComBox.getSelectedValue());
        }
        return types;
    }

    public void setDate(Date date) {
        if (date != null) {
            this.dateSpinner.setValue(date);
        }
    }

    public void setSubscriptionStatus(Collection<SubscriptionStatus> statuses) {
        if (statuses != null) {
            if (statuses.size() == 1) {
                this.statusCombox.setSelectedValue((SubscriptionStatus)((Enum)statuses.iterator().next()));
            } else {
                this.statusCombox.setSelectedValue(SubscriptionStatus.ALL);
            }
        }
    }

    public void setSubscriptionType(Collection<SubscriptionDeliveryType> types) {
        if (types != null) {
            if (types.size() == 1) {
                this.subscriptionTypeComBox.setSelectedValue((SubscriptionDeliveryType)((Enum)types.iterator().next()));
            } else {
                this.subscriptionTypeComBox.setSelectedValue(SubscriptionDeliveryType.ALL);
            }
        }
    }

    public void setLetterType(Collection<LetterDeliveryType> types) {
        if (types != null) {
            if (types.size() == 1) {
                this.letterDeliveryTypeComboBox.setSelectedValue((LetterDeliveryType)((Enum)types.iterator().next()));
            } else {
                this.letterDeliveryTypeComboBox.setSelectedValue(LetterDeliveryType.ALL);
            }
        }
    }

    public Set<LetterDeliveryType> getLetterTypes() {
        HashSet<LetterDeliveryType> types = new HashSet<LetterDeliveryType>();
        if (this.letterDeliveryTypeComboBox.getSelectedValue() == LetterDeliveryType.ALL) {
            for (LetterDeliveryType type : LetterDeliveryType.values()) {
                types.add(type);
            }
        } else {
            types.add(this.letterDeliveryTypeComboBox.getSelectedValue());
        }
        return types;
    }

    public int getRowCount() {
        return this.rowCount;
    }
}

