/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.renderer.editor;

import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.renderer.editor.ValueEditor;

public abstract class AbstractEnumValueEditor<T extends Enum<T>>
extends ValueEditor<T> {
    private static final long serialVersionUID = -1578200897432571853L;
    private EnumComboBox<T> comboBox;

    public AbstractEnumValueEditor(T value, boolean withEmpty) {
        this.comboBox = new EnumComboBox<T>(this.getEnumClass(), withEmpty);
        this.add(this.comboBox, "Center");
    }

    @Override
    public void setValue(T value) {
        this.comboBox.setSelectedValue(value);
    }

    @Override
    public T getValue() {
        return this.comboBox.getSelectedValue();
    }

    @Override
    public String getSerializedValue() {
        Object t = this.getValue();
        return t == null ? "" : ((Enum)t).name();
    }

    @Override
    public void setSerializedValue(String value) {
        T t = this.getValueFromString(value);
        this.setValue(t);
    }

    protected abstract Class<T> getEnumClass();

    protected abstract T getValueFromString(String var1);
}

