/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.renderer.common;

import de.datomino.util.geo.ImmutablePoint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ktde.math.projection.OpenStreetmapViewFactory;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.swing.navigator.listener.NavigatorRendererActivateEvent;
import org.ktde.swing.navigator.listener.NavigatorRendererActiveListener;

public abstract class AbstractSimplePointRenderer<T>
implements NavigatorRenderer {
    private Collection<T> points;
    private NavigatorPanel navigatorPanel;
    private List<NavigatorRendererActiveListener> listeners = new ArrayList<NavigatorRendererActiveListener>();
    private int sortOrder = Integer.MAX_VALUE;

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        if (this.points != null) {
            for (T point : this.points) {
                this.drawPoint(g2d, realBoundaryBottomLeft, realBoundaryTopRight, upp, point);
            }
        }
        return Collections.emptyList();
    }

    protected abstract void drawPoint(Graphics2D var1, Point2D.Double var2, Point2D.Double var3, double var4, T var6);

    protected void drawPoint(Graphics2D g2d, double upp, ImmutablePoint point, Color color) {
        ImmutablePoint tPoint = (ImmutablePoint)point.getTransformed(OpenStreetmapViewFactory.INSTANCE);
        Stroke setStroke = g2d.getStroke();
        Color setColor = g2d.getColor();
        g2d.setColor(color);
        g2d.setStroke(new BasicStroke((float)upp));
        double aRadius = 5.0 * upp;
        Ellipse2D.Double ellipse = new Ellipse2D.Double(tPoint.getX() - aRadius, tPoint.getY() - aRadius, aRadius * 2.0, aRadius * 2.0);
        g2d.fill(ellipse);
        g2d.setColor(Color.BLACK);
        g2d.draw(ellipse);
        g2d.setColor(setColor);
        g2d.setStroke(setStroke);
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void setNavigatorPanel(NavigatorPanel navigatorPanel) {
        this.navigatorPanel = navigatorPanel;
    }

    @Override
    public void addNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        this.listeners.add(navigatorPanelActiveListener);
    }

    @Override
    public void removeNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        this.listeners.remove(navigatorPanelActiveListener);
    }

    protected void fireNavigatorRendererActivateEvent(NavigatorRendererActivateEvent e) {
        for (NavigatorRendererActiveListener listener : this.listeners) {
            listener.valueChanged(e);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }

    protected NavigatorPanel getNavigatorPanel() {
        return this.navigatorPanel;
    }

    public void setPoint(T point) {
        this.points = point == null ? null : Collections.singletonList(point);
    }

    public void setPoints(Collection<T> points) {
        this.points = points;
    }

    public Collection<T> getPoint() {
        return this.points;
    }
}

