/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.renderer;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.util.geo.util.GeoUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.swing.navigator.AbstractNavigatorRenderer;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.application.DynamicAttributedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapScaleRenderer
extends AbstractNavigatorRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapScaleRenderer.class);
    private MeasureType measureType;
    private int preferredPixelSize;
    private Orientation orientation;
    private int yMargin;
    private int xMargin;
    private int[] nextSizesRow;
    private double thickness = 3.0;
    private float fontFactor = 1.0f;
    private boolean drawWhiteBackGround = false;

    public MapScaleRenderer(String name) {
        super(name);
        DynamicAttributedProperties properties = ModelEnviroment.getProperties();
        try {
            this.measureType = MeasureType.valueOf(properties.getProperty("navigator.mapScale.measureTyp"));
        }
        catch (Exception ex) {
            this.measureType = MeasureType.METRIC;
        }
        try {
            this.preferredPixelSize = Integer.parseInt(properties.getProperty("navigator.mapScale.preferredPixelSize"));
        }
        catch (Exception ex) {
            this.preferredPixelSize = 200;
        }
        try {
            this.orientation = Orientation.valueOf(properties.getProperty("navigator.mapScale.orientation"));
        }
        catch (Exception ex) {
            this.orientation = Orientation.SOUTH_EAST;
        }
        try {
            this.yMargin = Integer.parseInt(properties.getProperty("navigator.mapScale.yMargin"));
        }
        catch (Exception ex) {
            this.yMargin = 50;
        }
        try {
            this.xMargin = Integer.parseInt(properties.getProperty("navigator.mapScale.xMargin"));
        }
        catch (Exception ex) {
            this.xMargin = 50;
        }
        try {
            String[] nextSizesRowStrings = properties.getProperty("navigator.mapScale.sizeRow").split(",");
            this.nextSizesRow = new int[nextSizesRowStrings.length];
            for (int i = 0; i < nextSizesRowStrings.length; ++i) {
                this.nextSizesRow[i] = Integer.parseInt(nextSizesRowStrings[i]);
            }
        }
        catch (Exception ex) {
            this.nextSizesRow = new int[]{1, 10, 50, 100, 500, 1000, 5000, 10000, 50000, 100000, 500000, 1000000, 5000000};
        }
    }

    public MapScaleRenderer(String name, MeasureType measureType, int preferredPixelSize, Orientation orientation, int yMargin, int xMargin, int[] nextSizesRow) {
        super(name);
        this.measureType = measureType;
        this.preferredPixelSize = preferredPixelSize;
        this.orientation = orientation;
        this.yMargin = yMargin;
        this.xMargin = xMargin;
        this.nextSizesRow = nextSizesRow;
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        NavigatorPanel panel = this.getPanel();
        double realMiddleY = (realBoundaryTopRight.getY() + realBoundaryBottomLeft.getY()) / 2.0;
        CoordinateFactory coordinateFactory = this.getCoordinateFactory();
        Coordinate leftMiddle = coordinateFactory.createCoordinate(realBoundaryBottomLeft.getX(), realMiddleY);
        Coordinate rightMiddle = coordinateFactory.createCoordinate(realBoundaryTopRight.getX(), realMiddleY);
        double realLength = this.getMiddleLength(leftMiddle, rightMiddle);
        Point2D.Double pixelBottomLeft = panel.getPixel(realBoundaryBottomLeft);
        Point2D.Double pixelTopRight = panel.getPixel(realBoundaryTopRight);
        double pixelLength = pixelTopRight.getX() - pixelBottomLeft.getX();
        double rel = pixelLength / (double)this.preferredPixelSize;
        double prefferedRealLength = realLength / rel;
        double roundedLength = this.findRoundedLength(prefferedRealLength);
        double coordLength = realBoundaryTopRight.getX() - realBoundaryBottomLeft.getX();
        double lengthToDraw = coordLength / realLength * roundedLength;
        this.drawMapScale(g2d, lengthToDraw, realBoundaryBottomLeft, realBoundaryTopRight, upp, roundedLength);
        return Collections.emptyList();
    }

    private double getMiddleLength(Coordinate leftM, Coordinate rightM) {
        Coordinate leftWgs84 = Wgs84Factory.INSTANCE.createCoordinate(leftM);
        Coordinate rightWgs84 = Wgs84Factory.INSTANCE.createCoordinate(rightM);
        double rawDistance = rightWgs84.getX() - leftWgs84.getX();
        if (rawDistance > 180.0) {
            return 4.0E7;
        }
        return GeoUtils.getDistanceInMeter(leftM, rightM);
    }

    private void drawMapScale(Graphics2D g2d, double coordLength, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp, double lengthInUnit) {
        NavigatorPanel panel = this.getPanel();
        Point2D.Double center = null;
        switch (this.orientation) {
            case CENTER: {
                center = panel.getReal(panel.getCenterPixel());
                break;
            }
            case EAST: {
                center = new Point2D.Double(realBoundaryTopRight.getX() - (double)this.xMargin * upp - coordLength / 2.0, panel.getReal(panel.getCenterPixel()).getY());
                break;
            }
            case NORTH: {
                center = new Point2D.Double(panel.getReal(panel.getCenterPixel()).getX(), realBoundaryTopRight.getY() - (double)this.yMargin * upp);
                break;
            }
            case SOUTH: {
                center = new Point2D.Double(panel.getReal(panel.getCenterPixel()).getX(), realBoundaryBottomLeft.getY() + (double)this.yMargin * upp);
                break;
            }
            case WEST: {
                center = new Point2D.Double(realBoundaryBottomLeft.getX() + (double)this.xMargin * upp + coordLength / 2.0, panel.getReal(panel.getCenterPixel()).getY());
                break;
            }
            case NORTH_EAST: {
                center = new Point2D.Double(realBoundaryTopRight.getX() - (double)this.xMargin * upp - coordLength / 2.0, realBoundaryTopRight.getY() - (double)this.yMargin * upp);
                break;
            }
            case NORTH_WEST: {
                center = new Point2D.Double(realBoundaryBottomLeft.getX() + (double)this.xMargin * upp + coordLength / 2.0, realBoundaryTopRight.getY() - (double)this.yMargin * upp);
                break;
            }
            case SOUTH_EAST: {
                center = new Point2D.Double(realBoundaryTopRight.getX() - (double)this.xMargin * upp - coordLength / 2.0, realBoundaryBottomLeft.getY() + (double)this.yMargin * upp);
                break;
            }
            case SOUTH_WEST: {
                center = new Point2D.Double(realBoundaryBottomLeft.getX() + (double)this.xMargin * upp + coordLength / 2.0, realBoundaryBottomLeft.getY() + (double)this.yMargin * upp);
            }
        }
        this.drawMapScale(g2d, coordLength, upp, center, lengthInUnit);
    }

    protected void drawMapScale(Graphics2D g2d, double coordLength, double upp, Point2D.Double center, double lengthInUnit) {
        double cY = center.getY();
        double cX = center.getX();
        BasicStroke stroke = new BasicStroke((float)(upp * this.thickness));
        g2d.setStroke(stroke);
        g2d.setColor(Color.BLACK);
        Path2D.Double path = new Path2D.Double();
        double half = coordLength / 2.0;
        double left = cX - half;
        double right = cX + half;
        double uGap = 10.0 * upp + cY;
        path.moveTo(left, uGap);
        path.lineTo(left, cY);
        path.lineTo(right, cY);
        path.lineTo(right, uGap);
        Path2D.Double rect = null;
        if (this.drawWhiteBackGround) {
            rect = new Path2D.Double();
            double g = 6.0;
            double fHeight = 30.0 * (double)this.fontFactor;
            ((Path2D)rect).moveTo(left - g * upp, uGap + fHeight * upp);
            ((Path2D)rect).lineTo(left - g * upp, cY - g * upp);
            ((Path2D)rect).lineTo(right + g * upp, cY - g * upp);
            ((Path2D)rect).lineTo(right + g * upp, uGap + fHeight * upp);
        }
        try {
            if (rect != null) {
                g2d.setColor(Color.WHITE);
                g2d.fill(rect);
                g2d.setColor(Color.BLACK);
            }
            g2d.draw(path);
            AffineTransform affineTransform = g2d.getTransform();
            Font font = g2d.getFont();
            Font drawFont = font.deriveFont((float)font.getSize() * this.fontFactor);
            g2d.setFont(drawFont);
            String rName = this.createName(lengthInUnit);
            double scaleX = affineTransform.getScaleX() / 1.5;
            double scaleY = affineTransform.getScaleY() / 1.5;
            AffineTransform flip = AffineTransform.getScaleInstance(1.0 / scaleX, 1.0 / scaleY);
            g2d.transform(flip);
            FontMetrics fontMetrics = g2d.getFontMetrics();
            double height = fontMetrics.getHeight();
            double width = fontMetrics.stringWidth(rName);
            Point2D.Double dst = new Point2D.Double();
            AffineTransform.getScaleInstance(scaleX, scaleY).transform(new Point2D.Double(cX, cY), dst);
            g2d.drawString(rName, (float)(dst.getX() - width / 2.0), (float)(dst.getY() - height / 2.0));
            g2d.setFont(font);
            g2d.setTransform(affineTransform);
        }
        catch (Throwable ex) {
            LOGGER.warn(ex.getMessage(), ex);
        }
    }

    private String createName(double roundedLength) {
        switch (this.measureType) {
            case METRIC: {
                int places = (int)Math.floor(Math.log10(roundedLength));
                if (places >= 3) {
                    return (int)(roundedLength / 1000.0) + " km";
                }
                return (int)roundedLength + " m";
            }
            case MILE: {
                throw new RuntimeException();
            }
        }
        return null;
    }

    private double findRoundedLength(double preferredRealLength) {
        switch (this.measureType) {
            case METRIC: {
                return this.findRoundedLengthMetric(preferredRealLength);
            }
            case MILE: {
                throw new RuntimeException();
            }
        }
        return 0.0;
    }

    private double findRoundedLengthMetric(double preferredRealLength) {
        double high;
        double low;
        if (this.nextSizesRow == null || this.nextSizesRow.length == 0) {
            int places = (int)Math.floor(Math.log10(preferredRealLength));
            low = Math.pow(10.0, places);
            high = Math.pow(10.0, places + 1);
            if (low < 1.0) {
                low = 1.0;
            }
        } else {
            high = low = (double)this.nextSizesRow[0];
            if (preferredRealLength > low) {
                for (int i = 1; i < this.nextSizesRow.length && !(preferredRealLength < (high = (double)this.nextSizesRow[i])); ++i) {
                    low = high;
                }
            }
        }
        double distLow = Math.abs(preferredRealLength - low);
        double distHigh = Math.abs(preferredRealLength - high);
        return distLow < distHigh ? low : high;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setFontFactor(float fontFactor) {
        this.fontFactor = fontFactor;
    }

    public float getFontFactor() {
        return this.fontFactor;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MapScaleRenderer mapScaleRenderer = new MapScaleRenderer(this.getName(), this.measureType, this.preferredPixelSize, this.orientation, this.yMargin, this.xMargin, this.nextSizesRow);
        return mapScaleRenderer;
    }

    public void setDrawWhiteBackGround(boolean drawWhiteBackGround) {
        this.drawWhiteBackGround = drawWhiteBackGround;
    }

    public static enum Orientation {
        NORTH_WEST,
        NORTH,
        NORTH_EAST,
        EAST,
        SOUTH_EAST,
        SOUTH,
        SOUTH_WEST,
        WEST,
        CENTER;

    }

    public static enum MeasureType {
        METRIC,
        MILE;

    }
}

