/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.renderer;

import de.datomino.peppergis.client.gui.renderer.AbstractLineRenderer;
import de.datomino.util.geo.ImmutableLineString;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.datatypes.Tupel;

public class DashLineColorRenderer
extends AbstractLineRenderer {
    public DashLineColorRenderer(double upp, boolean isWithArrow, CoordinateFactory factory) {
        super(upp, isWithArrow, factory);
    }

    @Override
    public void render(Graphics2D g2d, ImmutableLineString lineString, Tupel<Color, Color> colorTupel, float scale) {
        g2d.setColor(colorTupel.getElement1());
        BasicStroke stroke = new BasicStroke(this.getLineWidth() * scale);
        g2d.setStroke(stroke);
        this.drawLineString(g2d, lineString);
        g2d.setColor(colorTupel.getElement2());
        float f = (float)(Math.log10(this.upp) / Math.log10(2.0));
        if (f < 5.0f) {
            f = 5.0f;
        }
        BasicStroke strokeDash = new BasicStroke(this.getLineWidth() * scale, 0, 1, 0.0f, new float[]{f, f}, 0.0f);
        g2d.setStroke(strokeDash);
        this.drawLineString(g2d, lineString);
    }
}

