/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.renderer;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractLineRenderer
implements Cloneable {
    public static Double DEFAULTWIDTH;
    protected double upp;
    private boolean isWithArrow;
    private CoordinateFactory factory;

    public AbstractLineRenderer(double upp, boolean isWithArrow, CoordinateFactory factory) {
        this.upp = upp;
        this.isWithArrow = isWithArrow;
        this.factory = factory;
    }

    public abstract void render(Graphics2D var1, ImmutableLineString var2, Tupel<Color, Color> var3, float var4);

    public void drawLineString(Graphics2D g2d, ImmutableLineString lineString) {
        ImmutableLineString reformed = (ImmutableLineString)lineString.getTransformed(this.factory);
        double interval = 750.0 * Math.log10(this.upp) / Math.log10(2.0);
        if (interval < 750.0) {
            interval = 750.0;
        }
        if (reformed.getLength() < interval) {
            interval = 50.0 + reformed.getLength() / 2.0;
        }
        double length = 0.0;
        Line2D.Double line = null;
        for (ImmutablePoint immutablePoint : reformed.getCoordinates()) {
            if (line == null) {
                line = new Line2D.Double();
                line.x2 = immutablePoint.getCoordinate().getX();
                line.y2 = immutablePoint.getCoordinate().getY();
                continue;
            }
            line.x1 = line.x2;
            line.y1 = line.y2;
            line.x2 = immutablePoint.getCoordinate().getX();
            line.y2 = immutablePoint.getCoordinate().getY();
            g2d.draw(line);
            if (!this.isWithArrow || !((length += Math.sqrt(Math.pow(line.x2 - line.x1, 2.0) + Math.pow(line.y2 - line.y1, 2.0))) >= interval)) continue;
            this.drawArrowOfLine(g2d, line);
            length = 0.0;
        }
    }

    private void drawArrowOfLine(Graphics2D g2d, Line2D.Double line) {
        double dy;
        double dx;
        double lineLength;
        Path2D.Double path = new Path2D.Double();
        double x = 0.0;
        double y = 0.0;
        double arrowLength = 25.0 * Math.pow(this.upp, -0.4) * this.upp;
        if (arrowLength > (lineLength = Math.sqrt((dx = line.x2 - line.x1) * dx + (dy = line.y2 - line.y1) + dy))) {
            return;
        }
        double angle = Math.atan2(dy, dx);
        double middleX = (line.x2 + line.x1) / 2.0;
        double middleY = (line.y2 + line.y1) / 2.0;
        x = arrowLength * Math.cos(angle + 0.5);
        y = arrowLength * Math.sin(angle + 0.5);
        path.moveTo(middleX - x, middleY - y);
        path.lineTo(middleX, middleY);
        x = arrowLength * Math.cos(angle - 0.5);
        y = arrowLength * Math.sin(angle - 0.5);
        path.lineTo(middleX - x, middleY - y);
        g2d.draw(path);
    }

    protected float getLineWidth() {
        return (float)(DEFAULTWIDTH * Math.pow(this.upp, -0.1) * this.upp);
    }

    static {
        try {
            DEFAULTWIDTH = ClientFormUtil.getNumber(ModelEnviroment.getProperties().getProperty("tour.line.width")).doubleValue();
        }
        catch (Exception e) {
            DEFAULTWIDTH = 6.0;
        }
    }

    public static enum LineType {
        DASH,
        SOLID,
        DASH_COLOR;

    }
}

