/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.renderer;

import de.datomino.peppergis.client.gui.filter.pattern.legend.listener.PatterLegendSelectionEvent;
import de.datomino.peppergis.client.gui.filter.pattern.legend.listener.PatternLegendSelectionListener;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.util.LocationObject;
import de.datomino.peppergis.client.util.filter.AbstractFilterPatternSetupRendererSelektor;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutableMultiPolygon;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.MarkerMode;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.swing.ObjectMarkerNavigatorRenderer;
import de.datomino.util.geo.swing.renderer.AreaRenderer;
import de.datomino.util.geo.swing.renderer.LineRenderer;
import de.datomino.util.geo.swing.renderer.PointRenderer;
import de.datomino.util.geo.swing.renderer.Renderer;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import de.datomino.util.swing.blocking.BusyHandler;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ktde.math.projection.Coordinate;
import org.ktde.model.ValueChangeEvent;
import org.ktde.model.ValueChangeListener;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.datatypes.Tripel;

public abstract class AbstractFilterableMarkerNavigatorRenderer<M extends Model, S extends LocationObject<M>, T extends ImmutableGeoObject, U extends RendererProperties, V extends RendererProperties, W extends RendererProperties, X extends Model>
extends ObjectMarkerNavigatorRenderer<S, T>
implements PatternLegendSelectionListener<X> {
    private static final long serialVersionUID = -5181658288676823252L;
    private AreaRenderer<U, S> areaRenderer;
    private LineRenderer<V, S> lineRenderer;
    private PointRenderer<W, S> pointRenderer;
    private Map<S, Collection<Tripel<AreaRenderer<U, S>, LineRenderer<V, S>, PointRenderer<W, S>>>> rendererCache = new HashMap<S, Collection<Tripel<AreaRenderer<U, S>, LineRenderer<V, S>, PointRenderer<W, S>>>>();
    private boolean active;
    private boolean emphasizeSelected = true;
    private BusyHandler busyHandler;

    public AbstractFilterableMarkerNavigatorRenderer(String name, String title, NavigatorPanel navigatorPanel, AreaRenderer<U, S> areaRenderer, LineRenderer<V, S> lineRenderer, PointRenderer<W, S> pointRenderer, Double maxUpp, GeoObjectBucketsModel<S, T> bucketsModel, boolean active) {
        super(name, navigatorPanel, null, maxUpp, title, bucketsModel, new HashSet(), true);
        this.lineRenderer = lineRenderer;
        this.areaRenderer = areaRenderer;
        this.pointRenderer = pointRenderer;
        this.active = active;
    }

    public abstract void showMarked(Collection<S> var1);

    protected abstract void showClicked(Collection<S> var1);

    protected abstract AbstractFilterPatternSetupRendererSelektor<?, M, ?, ?, ?, ?, ?, ?, ?> getFilterPatternSetupRendererSelektor();

    protected abstract void paintSpecialElements(Graphics2D var1, Point2D.Double var2, Point2D.Double var3, double var4);

    protected abstract void drawHover(Graphics2D var1, Point2D.Double var2, Point2D.Double var3, Collection<S> var4, double var5);

    protected abstract boolean isToDrawObject(S var1);

    public void showMarked() {
        this.showMarked(this.getMarkedObjects());
    }

    @Override
    protected void mouseClicked(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
        if (this.isActive()) {
            super.mouseClicked(x, y, clickCount, modifiers, mouseButton);
            this.showMarked(this.getMarkedObjects());
            Collection clickedSet = this.getClickedSet();
            if (!clickedSet.isEmpty()) {
                this.showClicked(clickedSet);
                clickedSet.clear();
            }
        }
    }

    @Override
    protected void mouseDragFinished(int x, int y, Coordinate startMark, Coordinate endMark, List<Coordinate> tracePoints, MarkerMode markerMode, int modifiers) {
        super.mouseDragFinished(x, y, startMark, endMark, tracePoints, markerMode, modifiers);
        this.showMarked(this.getMarkedObjects());
    }

    @Override
    protected void turnedOff() {
        this.showMarked(null);
        super.turnedOff();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        if (!this.isActive() || !super.checkUpp()) {
            return Collections.emptyList();
        }
        try {
            if (this.busyHandler != null) {
                this.busyHandler.start();
            }
            super.paintOnto(g2d, realBoundaryBottomLeft, realBoundaryTopRight, upp);
            this.paintSpecialElements(g2d, realBoundaryBottomLeft, realBoundaryTopRight, upp);
        }
        finally {
            if (this.busyHandler != null) {
                this.busyHandler.stop();
            }
        }
        this.drawHover(g2d, realBoundaryBottomLeft, realBoundaryTopRight, CollectionUtil.buildHashSet((LocationObject)this.getHover()), upp);
        return Collections.emptyList();
    }

    @Override
    public void render(S object, Graphics2D g2d, double upp, Color color) {
        Object geom;
        if (this.isToDrawObject(object) && (geom = this.getBucketsModel().extractGeom(object)) != null) {
            geom = geom.getTransformed(this.getNavigatorPanel().getCoordinateFactory()).snapToGrid(upp);
            int cycle = this.getCycles();
            Collection<Tripel<AreaRenderer<U, S>, LineRenderer<V, S>, PointRenderer<W, S>>> renderers = this.getRenderersForModel(object, cycle);
            for (Tripel<AreaRenderer<U, S>, LineRenderer<V, S>, PointRenderer<W, S>> tupel : renderers) {
                PointRenderer<W, S> pointRenderer;
                RendererProperties pointRendererProperties;
                LineRenderer<V, S> lineRenderer;
                RendererProperties lineRendererProperties;
                RendererProperties areaRendererProperties;
                AreaRenderer<U, S> areaRenderer = tupel.getElement1();
                RendererProperties rendererProperties = areaRendererProperties = areaRenderer == null ? null : (RendererProperties)areaRenderer.createRendererProperties(object);
                if (areaRendererProperties != null) {
                    areaRendererProperties.setUpp(upp);
                }
                RendererProperties rendererProperties2 = lineRendererProperties = (lineRenderer = tupel.getElement2()) == null ? null : (RendererProperties)lineRenderer.createRendererProperties(object);
                if (lineRendererProperties != null) {
                    lineRendererProperties.setUpp(upp);
                }
                RendererProperties rendererProperties3 = pointRendererProperties = (pointRenderer = tupel.getElement3()) == null ? null : (RendererProperties)pointRenderer.createRendererProperties(object);
                if (pointRendererProperties != null) {
                    pointRendererProperties.setUpp(upp);
                }
                if (geom instanceof ImmutablePoint) {
                    this.drawPoint(g2d, object, (ImmutablePoint)geom, pointRenderer, pointRendererProperties, cycle);
                    continue;
                }
                if (geom instanceof ImmutableLineString) {
                    this.drawLineString(g2d, object, (ImmutableLineString)geom, lineRenderer, lineRendererProperties, cycle);
                    continue;
                }
                if (geom instanceof ImmutablePolygonKind) {
                    this.drawPolygon(g2d, object, (ImmutablePolygonKind)geom, areaRenderer, areaRendererProperties, lineRenderer, lineRendererProperties, cycle);
                    continue;
                }
                throw new IllegalArgumentException("Not supported geoObject: " + geom);
            }
        }
    }

    private void drawPolygon(Graphics2D g2d, S model, ImmutablePolygonKind geom, AreaRenderer<U, S> areaRenderer, U areaRendererProperties, LineRenderer<V, S> lineRenderer, V lineRendererProperties, int cycle) {
        if (areaRenderer != null) {
            areaRenderer.render(g2d, (ImmutablePolygonKind)model, geom, (S)areaRendererProperties);
        }
        if (lineRenderer != null) {
            AbstractList borders = null;
            if (geom instanceof ImmutablePolygon) {
                ImmutablePolygon polygon = (ImmutablePolygon)geom;
                List<ImmutableLineString> holes = polygon.getHoles();
                borders = new ArrayList(holes.size() + 1);
                borders.addAll(holes);
                borders.add(polygon.getShell());
            } else if (geom instanceof ImmutableMultiPolygon) {
                ImmutableMultiPolygon polygon = (ImmutableMultiPolygon)geom;
                borders = new LinkedList();
                for (ImmutablePolygon part : polygon.getParts()) {
                    borders.add(part.getShell());
                    borders.addAll(part.getHoles());
                }
            }
            if (borders != null) {
                lineRenderer.render(g2d, model, borders, lineRendererProperties);
            }
        }
    }

    private void drawLineString(Graphics2D g2d, S model, ImmutableLineString geom, LineRenderer<V, S> lineRenderer, V lineRendererProperties, int cycle) {
        if (lineRenderer != null) {
            lineRenderer.render(g2d, (ImmutableLineString)model, geom, lineRendererProperties);
        }
    }

    private void drawPoint(Graphics2D g2d, S model, ImmutablePoint geom, PointRenderer<W, S> pointRenderer, W rendererProperties, int cycle) {
        if (pointRenderer != null) {
            pointRenderer.render(g2d, (ImmutablePoint)model, geom, rendererProperties);
        }
    }

    private Collection<Tripel<AreaRenderer<U, S>, LineRenderer<V, S>, PointRenderer<W, S>>> getRenderersForModel(S s, int cycle) {
        Collection<Tripel<AreaRenderer<U, S>, LineRenderer<V, S>, PointRenderer<W, S>>> renderers = null;
        AbstractFilterPatternSetupRendererSelektor<?, M, ?, ?, ?, ?, ?, ?, ?> filterPatternSetupRendererSelektor = this.getFilterPatternSetupRendererSelektor();
        if (filterPatternSetupRendererSelektor == null) {
            renderers = Collections.singleton(new Tripel<AreaRenderer<U, S>, LineRenderer<V, S>, PointRenderer<W, S>>(this.areaRenderer, this.lineRenderer, this.pointRenderer));
        } else {
            renderers = this.rendererCache.get(s);
            if (renderers == null) {
                List rs = filterPatternSetupRendererSelektor.getRenderers(s.getModel());
                renderers = new ArrayList<Tripel<AreaRenderer<U, S>, LineRenderer<V, S>, PointRenderer<W, S>>>(rs.size());
                for (Renderer renderer : rs) {
                    if (renderer == null) continue;
                    AreaRenderer areaRenderer = (AreaRenderer)(renderer instanceof AreaRenderer ? renderer : null);
                    if (this.emphasizeSelected && areaRenderer != null) {
                        System.out.println("E2");
                        areaRenderer.emphazise(s);
                    }
                    LineRenderer lineRenderer = (LineRenderer)(renderer instanceof LineRenderer ? renderer : null);
                    PointRenderer pointRenderer = (PointRenderer)(renderer instanceof PointRenderer ? renderer : null);
                    renderers.add(new Tripel<AreaRenderer, LineRenderer, PointRenderer>(areaRenderer, lineRenderer, pointRenderer));
                }
                this.rendererCache.put(s, renderers);
                Iterable<Model> dependentModels = this.getChangeListeningModels(s);
                ValueChangeListener valueChangeListener = new ValueChangeListener((LocationObject)s, dependentModels){
                    final /* synthetic */ LocationObject val$s;
                    final /* synthetic */ Iterable val$dependentModels;
                    {
                        this.val$s = locationObject;
                        this.val$dependentModels = iterable;
                    }

                    @Override
                    public void valueChanged(ValueChangeEvent e) {
                        AbstractFilterableMarkerNavigatorRenderer.this.rendererCache.remove(this.val$s);
                        this.val$s.removeValueChangeListener(this);
                        for (Model model : this.val$dependentModels) {
                            model.removeValueChangeListener(this);
                        }
                        AbstractFilterableMarkerNavigatorRenderer.this.getNavigatorPanel().repaint(10L);
                    }
                };
                s.addValueChangeListener(valueChangeListener);
                for (Model model : dependentModels) {
                    model.addValueChangeListener(valueChangeListener);
                }
            }
        }
        return renderers;
    }

    protected abstract Iterable<? extends Model> getChangeListeningModels(S var1);

    public void removeFromRendererCache(M model) {
        this.rendererCache.remove(model);
    }

    protected void clearRendererCache() {
        this.rendererCache.clear();
    }

    protected LineRenderer<?, S> getLineRenderer() {
        return this.lineRenderer;
    }

    protected PointRenderer<?, S> getPointRenderer() {
        return this.pointRenderer;
    }

    protected void setPointRenderer(PointRenderer<W, S> pointRenderer) {
        this.pointRenderer = pointRenderer;
    }

    protected int getCycles() {
        return 1;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setBusyHandler(BusyHandler busyHandler) {
        this.busyHandler = busyHandler;
    }

    public void setEmphasizeSelected(boolean emphasizeSelected) {
        this.emphasizeSelected = emphasizeSelected;
    }

    public boolean isEmphasizeSelected() {
        return this.emphasizeSelected;
    }

    public abstract RenderObjectType getRenderObjectType();

    @Override
    public void defaultSelectionChanged(PatterLegendSelectionEvent<X> event) {
        this.clearRendererCache();
    }

    @Override
    public void filterSelectionChanged(PatterLegendSelectionEvent<X> event) {
        this.clearRendererCache();
    }

    public static enum RenderObjectType {
        PARCELRENDERER,
        PARCELAREARENDERER,
        SUBSCRIPTIONRENDERER,
        POIRENDERER,
        STOPRENDERER,
        AREAOBJECTRENDERER,
        LETTERRENDERER;

    }
}

