/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.poi.search;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.poi.search.PoiSearchPane;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.type.PoiSearchType;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;

public class PoiSearchDialog
extends CommonDialog {
    private static final long serialVersionUID = 8078594433991023109L;
    private ModelEnviroment modelEnviroment;
    private PoiSearchType[] poiTypes;
    private boolean showPoiType;
    private boolean poiTypesWithEmpty;
    protected PoiSearchPane poiSearchPane;
    protected PoiModel selectedPoiModel;

    public PoiSearchDialog(Window parent, String title, ModelEnviroment modelEnviroment, PoiSearchType[] poiTypes, boolean showPoiType) {
        this(parent, title, modelEnviroment, poiTypes, showPoiType, true);
    }

    public PoiSearchDialog(Window parent, String title, ModelEnviroment modelEnviroment, PoiSearchType[] poiTypes, boolean showPoiType, boolean poiTypesWithEmpty) {
        super((Component)parent, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.modelEnviroment = modelEnviroment;
        this.poiTypes = poiTypes;
        this.showPoiType = showPoiType;
        this.poiTypesWithEmpty = poiTypesWithEmpty;
        this.buildLayout();
        this.pack();
        SwingUtils.center((Window)this, parent);
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = -4338928664667771854L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PoiModel poi = PoiSearchDialog.this.poiSearchPane.getSelectedPoi();
                if (poi == null) {
                    JOptionPane.showMessageDialog(PoiSearchDialog.this, ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.search.noPoiSelected", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.warning", new Serializable[0]), 2);
                } else {
                    PoiSearchDialog.this.selectedPoiModel = poi;
                    PoiSearchDialog.this.doAfterOk();
                    PoiSearchDialog.this.dispose();
                }
            }
        };
    }

    protected void doAfterOk() {
    }

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = -4338928664667771854L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PoiSearchDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        this.poiSearchPane = new PoiSearchPane(this.modelEnviroment, this.poiTypes, this.showPoiType, this.poiTypesWithEmpty);
        return this.poiSearchPane;
    }

    @Override
    protected Action[] getAdditionalActions() {
        Action[] actions2 = super.getAdditionalActions();
        Action[] newActions = new Action[1 + actions2.length];
        System.arraycopy(actions2, 0, newActions, 0, actions2.length);
        newActions[actions2.length] = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.search", new Serializable[0])){
            private static final long serialVersionUID = -4338928664667771854L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PoiSearchDialog.this.poiSearchPane.search();
            }
        };
        return newActions;
    }

    public PoiModel getSelectedPoiModel() {
        return this.selectedPoiModel;
    }
}

