/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.poi;

import de.datomino.logistic.type.StopType;
import de.datomino.peppergis.client.gui.area.AreaLayerComboBox;
import de.datomino.peppergis.client.gui.area.AreaObjectCompletableTextField;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.poi.search.PoiSearchDialog;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.PoiSearchType;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class PoiSelectionPanel
extends JPanel {
    private static final long serialVersionUID = -7141132679390205714L;
    private JTextField poiNumber;
    private JTextField areaName;
    private PoiModel poiModel;
    private SetPoiAction setPoiAction;
    private RemovePoiAction removePoiAction;
    private ModelEnviroment modelEnviroment;
    private PoiSearchType[] poiTypes;
    private boolean areaPickPointSelection;
    private Tupel<AreaObjectModel, StopType> areaPickPointTupel = new Tupel<Object, Object>(null, null);

    public PoiSelectionPanel(ModelEnviroment modelEnviroment, PoiSearchType[] poiTypes) {
        this(modelEnviroment, poiTypes, null);
    }

    public PoiSelectionPanel(ModelEnviroment modelEnviroment, PoiSearchType[] poiTypes, PoiModel poiModel) {
        this(modelEnviroment, poiTypes, poiModel, false);
    }

    public PoiSelectionPanel(ModelEnviroment modelEnviroment, PoiSearchType[] poiTypes, PoiModel poiModel, boolean areaPickPointSelection) {
        super(new SpringLayout());
        this.poiModel = poiModel;
        this.modelEnviroment = modelEnviroment;
        this.poiTypes = poiTypes;
        this.areaPickPointSelection = areaPickPointSelection;
        this.buildLayout();
        this.fillValues();
    }

    private void fillValues() {
        this.poiNumber.setText(this.poiModel == null ? "" : (this.poiModel.getPoiNumber() + " - " + this.poiModel == null ? "" : this.poiModel.getName()));
        String areaString = AreaObjectModelUtil.getShortcutAndDisplayname(this.areaPickPointTupel.getElement1());
        String stopTypeString = this.areaPickPointTupel.getElement2() == null ? "" : ModelEnviroment.getMessageResolver().resolveMessageForEnum(this.areaPickPointTupel.getElement2());
        this.areaName.setText(StringUtil.isEmpty(areaString) ? "" : areaString + " - " + stopTypeString);
    }

    private void buildLayout() {
        int cols = 3;
        this.poiNumber = new JTextField(20);
        this.poiNumber.setEditable(false);
        this.add(this.poiNumber);
        this.areaName = new JTextField(20);
        this.areaName.setEditable(false);
        if (this.areaPickPointSelection) {
            this.add(this.areaName);
            ++cols;
        }
        this.setPoiAction = new SetPoiAction();
        JButton button = new JButton(this.setPoiAction);
        this.add(button);
        this.removePoiAction = new RemovePoiAction();
        button = new JButton(this.removePoiAction);
        this.add(button);
        SpringUtilities.makeCompactGrid(this, 1, cols, 2, 2, 2, 2);
    }

    public PoiModel getPoiModel() {
        return this.poiModel;
    }

    public Tupel<AreaObjectModel, StopType> getAreaPickPointTupel() {
        return this.areaPickPointTupel;
    }

    public void setEditable(boolean editable) {
        this.setPoiAction.setEnabled(editable);
        this.removePoiAction.setEnabled(editable);
    }

    private class SetPoiAction
    extends AbstractAction {
        private static final long serialVersionUID = -2431534686424356675L;

        public SetPoiAction() {
            super("...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PoiSearchDialog poiSearchDialog = new PoiSearchDialog(SwingUtils.findWindowParent(PoiSelectionPanel.this), ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.search", new Serializable[0]), PoiSelectionPanel.this.modelEnviroment, PoiSelectionPanel.this.poiTypes, false){
                private static final long serialVersionUID = 6155796719677412745L;

                @Override
                protected Action getOkAction() {
                    return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
                        private static final long serialVersionUID = -4338928664667771854L;

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (PoiSelectionPanel.this.areaPickPointTupel.getElement1() == null || PoiSelectionPanel.this.areaPickPointTupel.getElement2() == null) {
                                PoiSelectionPanel.this.poiModel = poiSearchPane.getSelectedPoi();
                                if (PoiSelectionPanel.this.poiModel == null) {
                                    JOptionPane.showMessageDialog(poiSearchPane, ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.search.noPoiSelected", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.warning", new Serializable[0]), 2);
                                    return;
                                }
                            } else {
                                PoiSelectionPanel.this.poiModel = null;
                            }
                            this.dispose();
                            PoiSelectionPanel.this.fillValues();
                        }
                    };
                }

                @Override
                protected Component getMainComponent() {
                    JPanel pane = new JPanel(new BorderLayout());
                    pane.add(super.getMainComponent(), "Center");
                    if (PoiSelectionPanel.this.areaPickPointSelection) {
                        JPanel areaPane = new JPanel(new SpringLayout());
                        areaPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.areaSelection1", new Serializable[0])));
                        areaPane.add(new JLabel("----------------------------"));
                        areaPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.layer", new Serializable[0])));
                        AreaObjectGenInfoDiscriminator[] ds = new AreaObjectGenInfoDiscriminator[]{AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT, AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_FREEHAND};
                        final AreaLayerComboBox layerComboBox = new AreaLayerComboBox(PoiSelectionPanel.this.modelEnviroment, true, ds, false, false);
                        areaPane.add(layerComboBox);
                        areaPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.area", new Serializable[0])));
                        final AreaObjectCompletableTextField areaObjectTextField = new AreaObjectCompletableTextField(PoiSelectionPanel.this.modelEnviroment.getAllCaller().getAreaCaller(), this){
                            private static final long serialVersionUID = 982839234245028864L;

                            @Override
                            public void makeSelection() {
                                super.makeSelection();
                                PoiSelectionPanel.this.areaPickPointTupel.setElement1(super.getSelectedObject());
                            }
                        };
                        areaObjectTextField.setFont(UIManager.getDefaults().getFont("TextField.font"));
                        areaPane.add(areaObjectTextField);
                        layerComboBox.addItemListener(new ItemListener(){

                            @Override
                            public void itemStateChanged(ItemEvent e) {
                                if (e.getStateChange() == 1) {
                                    areaObjectTextField.setAreaLayer(layerComboBox.getLayer());
                                }
                            }
                        });
                        areaPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.pickPoint", new Serializable[0])));
                        final EnumComboBox stopType = new EnumComboBox(StopType.class, true, (Enum[])new StopType[]{StopType.FIX_START, StopType.FIX_END});
                        stopType.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                PoiSelectionPanel.this.areaPickPointTupel.setElement2(stopType.getSelectedValue());
                            }
                        });
                        areaPane.add(stopType);
                        SpringUtilities.makeCompactGrid(areaPane, 4, 2, 5, 5, 5, 5);
                        pane.add((Component)areaPane, "South");
                    }
                    return pane;
                }
            };
            poiSearchDialog.setVisible(true);
        }
    }

    private class RemovePoiAction
    extends AbstractAction {
        private static final long serialVersionUID = -5134842250586394620L;

        public RemovePoiAction() {
            super("X");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PoiSelectionPanel.this.poiModel = null;
            PoiSelectionPanel.this.areaPickPointTupel = new Tupel<Object, Object>(null, null);
            PoiSelectionPanel.this.fillValues();
        }
    }
}

