/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.poi;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.location.ImportedLocationAddressPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.ParcelAddressPane;
import de.datomino.peppergis.client.gui.poi.BasicPoiPane;
import de.datomino.peppergis.client.gui.poi.PoiAttributeValuePane;
import de.datomino.peppergis.client.gui.poi.PoiDialogAreaObjectPane;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.base.AttributeGroupModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.type.AttributeGroupType;
import de.datomino.peppergis.type.PoiType;
import de.datomino.peppergis.type.UserRole;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicArrowButton;

public class PoiDialog
extends CommonDialog {
    private static final long serialVersionUID = 7701393906002917081L;
    private List<PoiModel> pois;
    private int currentIndex = 0;
    private ModelEnviroment modelEnviroment;
    private BasicPoiPane basicPoiPane;
    private List<PoiAttributeValuePane> poiAttributeValuePanes;
    private ImportedLocationAddressPane importedLocationAddressPane;
    private ParcelAddressPane parcelAddressPane;
    private PoiDialogAreaObjectPane poiDialogAreaObjectPane;

    public PoiDialog(Window parent, List<PoiModel> pois, ModelEnviroment modelEnviroment) {
        super((Component)parent, "", Dialog.ModalityType.APPLICATION_MODAL);
        this.pois = pois;
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
        if (this.pois.size() > 1) {
            this.add((Component)this.createControlPanel(), "First");
        }
        this.pack();
        this.setDefaultCloseOperation(2);
        SwingUtils.centerDialog(this, parent);
        if (this.importedLocationAddressPane != null) {
            this.importedLocationAddressPane.centerCoord();
        }
        if (this.parcelAddressPane != null) {
            this.parcelAddressPane.centerCoord();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setTitle(this.pois.get(this.currentIndex).getPoiNumber());
        if (visible) {
            this.modelEnviroment.getUndoManager().startTransaction();
        }
        super.setVisible(true);
    }

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = 4578396289778907053L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PoiDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        JPanel addressComponent;
        JTabbedPane tabbedPane = new JTabbedPane();
        PoiModel poiModel = this.pois.get(this.currentIndex);
        this.basicPoiPane = new BasicPoiPane(poiModel, this.modelEnviroment);
        boolean enabled = ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER);
        this.basicPoiPane.setEnabled(enabled);
        tabbedPane.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.poi", new Serializable[0]), this.basicPoiPane);
        LocationModel lm = poiModel.getLocation();
        ParcelModel parcel = lm.getParcel();
        if (parcel == null) {
            this.importedLocationAddressPane = new ImportedLocationAddressPane(lm.getImportedLocation(), this.modelEnviroment, false, true);
            addressComponent = this.importedLocationAddressPane;
        } else {
            addressComponent = this.parcelAddressPane = new ParcelAddressPane(parcel, this.modelEnviroment, false, false);
        }
        tabbedPane.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.address", new Serializable[0]), addressComponent);
        Collection<AttributeGroupModel> groups = this.modelEnviroment.getAllCaller().getBaseCaller().getAttributeGroupForType(AttributeGroupType.POI);
        this.poiAttributeValuePanes = new ArrayList<PoiAttributeValuePane>(groups.size());
        for (AttributeGroupModel group : groups) {
            PoiAttributeValuePane poiAttributeValuePane = new PoiAttributeValuePane(poiModel, Collections.singleton(group), this.modelEnviroment, enabled);
            this.poiAttributeValuePanes.add(poiAttributeValuePane);
            poiAttributeValuePane.fillValues(poiModel);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)poiAttributeValuePane, "North");
            tabbedPane.add(group.getName(), new JScrollPane(panel));
        }
        if (poiModel.getPoiType() == PoiType.AREAOBJECT_LOCATION) {
            this.poiDialogAreaObjectPane = new PoiDialogAreaObjectPane(poiModel);
            tabbedPane.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.areaRelation", new Serializable[0]), this.poiDialogAreaObjectPane);
        }
        return tabbedPane;
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = -6675080622780941906L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PoiDialog.this.basicPoiPane.adaptValuesToModel();
                for (PoiAttributeValuePane poiAttributeValuePane : PoiDialog.this.poiAttributeValuePanes) {
                    poiAttributeValuePane.adaptValuesToModel((Model)PoiDialog.this.pois.get(PoiDialog.this.currentIndex));
                }
                if (PoiDialog.this.importedLocationAddressPane != null) {
                    PoiDialog.this.importedLocationAddressPane.adaptValuesToModel();
                }
                if (PoiDialog.this.parcelAddressPane != null) {
                    try {
                        PoiDialog.this.parcelAddressPane.adaptValuesToModel(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                PoiDialog.this.modelEnviroment.getUndoManager().finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.attributesChanged", new Serializable[]{((PoiModel)PoiDialog.this.pois.get(PoiDialog.this.currentIndex)).getPoiNumber()}));
                PoiDialog.this.dispose();
            }
        };
    }

    private JPanel createControlPanel() {
        this.setTitle(this.pois.get(this.currentIndex).getPoiNumber());
        JPanel controlPanel = new JPanel(new FlowLayout());
        BasicArrowButton leftButton = new BasicArrowButton(7);
        leftButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        leftButton.setAction(new AbstractAction(){
            private static final long serialVersionUID = -8946496325538682806L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PoiDialog.this.nextPoi(-1);
            }
        });
        controlPanel.add(leftButton);
        JLabel indexLabel = new JLabel(this.currentIndex + 1 + "/" + this.pois.size());
        controlPanel.add(indexLabel);
        BasicArrowButton rightButton = new BasicArrowButton(3);
        rightButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        rightButton.setAction(new AbstractAction(){
            private static final long serialVersionUID = -8946496325538682806L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PoiDialog.this.nextPoi(1);
            }
        });
        controlPanel.add(rightButton);
        return controlPanel;
    }

    private void nextPoi(int step) {
        this.currentIndex += step;
        if (this.currentIndex < 0) {
            this.currentIndex = this.pois.size() - 1;
        } else if (this.currentIndex > this.pois.size() - 1) {
            this.currentIndex = 0;
        }
        this.getContentPane().removeAll();
        this.buildLayout();
        this.add((Component)this.createControlPanel(), "First");
        this.pack();
    }
}

