/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.poi;

import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.image.ImageComboBoxChooserPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.type.PoiType;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.ktde.util.StringUtil;

public class BasicPoiPane
extends JPanel {
    private static final long serialVersionUID = 7024522832204719450L;
    private JTextField poiNumber;
    private ImageComboBoxChooserPane image;
    private JTextField name;
    private JTextArea information;
    private EnumComboBox<PoiType> poiType;
    private PoiModel poiModel;
    private ModelEnviroment modelEnviroment;

    public BasicPoiPane(PoiModel poiModel, ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.poiModel = poiModel;
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
        this.fillValues();
    }

    private void fillValues() {
        this.poiNumber.setText(this.poiModel.getPoiNumber());
        this.image.setSelectedItem(this.poiModel.getImage());
        this.information.setText(StringUtil.nullToEmpty(this.poiModel.getInformation()));
        this.name.setText(StringUtil.nullToEmpty(this.poiModel.getName()));
        this.poiType.setSelectedValue(this.poiModel.getPoiType());
    }

    public void adaptValuesToModel() {
        this.poiModel.setImage(this.image.getSelectedItem());
        this.poiModel.setInformation(this.information.getText());
        this.poiModel.setName(this.name.getText());
        this.poiModel.setPoiType(this.poiType.getSelectedValue());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.image.setEnabled(enabled);
        this.information.setEditable(enabled);
        this.name.setEditable(enabled);
    }

    private void buildLayout() {
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.poiNumber", new Serializable[0])));
        this.poiNumber = new JTextField(30);
        this.poiNumber.setEditable(false);
        panel.add(this.poiNumber);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0])));
        this.name = new JTextField(30);
        panel.add(this.name);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.type", new Serializable[0])));
        this.poiType = new EnumComboBox<PoiType>(PoiType.class, false);
        this.poiType.setEnabled(false);
        panel.add(this.poiType);
        JLabel label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.image", new Serializable[0]));
        label.setVerticalAlignment(1);
        panel.add(label);
        this.image = new ImageComboBoxChooserPane("West", this.modelEnviroment);
        panel.add(this.image);
        label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]));
        label.setVerticalAlignment(1);
        panel.add(label);
        this.information = new JTextArea(5, 30);
        panel.add(new JScrollPane(this.information));
        SpringUtilities.makeCompactGrid(panel, 5, 2, 5, 5, 2, 2);
        this.add((Component)panel, "North");
    }

    private Collection<PoiType> getValidPoiTypes() {
        LinkedList<PoiType> poiTypes = new LinkedList<PoiType>(Arrays.asList(PoiType.values()));
        poiTypes.remove((Object)PoiType.ORIGIN);
        poiTypes.remove((Object)PoiType.END_POINT);
        poiTypes.remove((Object)PoiType.REMOVED);
        return poiTypes;
    }
}

