/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.pdf;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.common.DialogDisposeAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.pdf.PdfListChooserPane;
import de.datomino.peppergis.client.model.base.PdfModel;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.Action;

public class PdfChooserDialog
extends CommonDialog {
    private static final long serialVersionUID = -6567115468668910583L;
    private ModelEnviroment modelEnviroment;
    private PdfListChooserPane pdfChooserPane;
    private CallBack callBack;
    private boolean editable;

    public PdfChooserDialog(Window parent, ModelEnviroment modelEnviroment, boolean editable) {
        super((Component)parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.pdfs", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.modelEnviroment = modelEnviroment;
        this.editable = editable;
        this.buildLayout();
        this.pack();
        SwingUtils.centerDialog(this, parent);
    }

    @Override
    protected Action getCancelAction() {
        return new DialogDisposeAction(this){
            private static final long serialVersionUID = -802907189365257162L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PdfChooserDialog.this.callBack != null) {
                    PdfChooserDialog.this.callBack.executeAfterCancel();
                }
                super.actionPerformed(e);
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        this.pdfChooserPane = new PdfListChooserPane(this.modelEnviroment, this.editable);
        return this.pdfChooserPane;
    }

    @Override
    protected Action getOkAction() {
        return new DialogDisposeAction(this, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = 7920085483611142036L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PdfChooserDialog.this.callBack != null) {
                    PdfChooserDialog.this.callBack.executeAfterOk();
                }
                super.actionPerformed(e);
            }
        };
    }

    public Long getSelectedPdfModelId() {
        return this.pdfChooserPane.getSelectedPdfModelId();
    }

    public void setCallBack(CallBack callBack) {
        this.callBack = callBack;
    }

    public PdfModel getSelectedPdf() {
        return this.pdfChooserPane.getSelectedPdf();
    }

    public static interface CallBack {
        public void executeAfterOk();

        public void executeAfterCancel();
    }
}

