/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.parcel;

import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.gui.AbstractLayerRenderer;
import de.datomino.peppergis.client.gui.DefaultPointRenderer;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.ParcelDialog;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.datatypes.Tripel;

public class ParcelLayerRenderer
extends AbstractLayerRenderer {
    private List<ParcelModel> parcels;

    public ParcelLayerRenderer(Component parent, ModelEnviroment modelEnviroment, boolean active) {
        this(parent, modelEnviroment, active, false);
    }

    public ParcelLayerRenderer(Component parent, ModelEnviroment modelEnviroment, boolean active, boolean withIndex) {
        super(active, withIndex, parent, modelEnviroment);
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        if (this.parcels == null || this.parcels.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<ImmutablePoint, Set<Tripel<ImmutableLineString, ImmutableLineString, ImmutableLineString>>> map = new HashMap<ImmutablePoint, Set<Tripel<ImmutableLineString, ImmutableLineString, ImmutableLineString>>>();
        ArrayList<ParcelModel> filtered = new ArrayList<ParcelModel>(this.parcels.size());
        for (ParcelModel parcel : this.parcels) {
            if (parcel.isDeleted()) continue;
            SegmentModel motorSegment = ParcelModelUtil.getRouteSegment(parcel, RouteVehicleType.MOTORCAR);
            ImmutableLineString motorLineString = motorSegment == null ? null : motorSegment.getGeom();
            SegmentModel footSegment = ParcelModelUtil.getRouteSegment(parcel, RouteVehicleType.FOOT);
            ImmutableLineString footLineString = footSegment == null ? null : footSegment.getGeom();
            SegmentModel bikeSegment = ParcelModelUtil.getRouteSegment(parcel, RouteVehicleType.BIKE);
            ImmutableLineString bikeLineString = bikeSegment == null ? null : bikeSegment.getGeom();
            HashSet<Tripel<ImmutableLineString, ImmutableLineString, ImmutableLineString>> set = (HashSet<Tripel<ImmutableLineString, ImmutableLineString, ImmutableLineString>>)map.get(parcel.getGeom());
            if (set == null) {
                set = new HashSet<Tripel<ImmutableLineString, ImmutableLineString, ImmutableLineString>>();
                map.put(parcel.getGeom(), set);
            }
            set.add(new Tripel<ImmutableLineString, ImmutableLineString, ImmutableLineString>(motorLineString, footLineString, bikeLineString));
            filtered.add(parcel);
        }
        this.drawSegments(map, g2d, upp);
        DefaultPointRenderer pointRenderer = new DefaultPointRenderer(g2d, upp, this.navigatorPanel.getCoordinateFactory());
        double margin = 10.0 * Math.pow(upp, -0.2) * upp;
        if (this.parcels != null) {
            pointRenderer.drawBuildings(filtered, margin, this.navigatorPanel.getCoordinateFactory(), Color.WHITE, this.withIndex, null);
        }
        this.postPaintOnto(g2d, realBoundaryBottomLeft, realBoundaryTopRight, upp);
        return Collections.emptyList();
    }

    @Override
    public void mouseClickFinished(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
        if (this.modelEnviroment != null && this.parcels != null && clickCount > 1) {
            Point2D.Double pixelPosition;
            Point2D.Double point = this.navigatorPanel.getReal(x, y);
            ParcelModel nearestParcel = null;
            double nearestDistance = Double.MAX_VALUE;
            for (ParcelModel parcel : this.parcels) {
                ImmutablePoint position = parcel.getGeom();
                double distance = point.distance(position.getX(), position.getY());
                if (!(distance < nearestDistance)) continue;
                nearestDistance = distance;
                nearestParcel = parcel;
            }
            if (nearestParcel != null && (pixelPosition = this.navigatorPanel.getPixel(nearestParcel.getGeom().getCoordinate())).distance(x, y) < 10.0) {
                ParcelDialog parcelDialog = new ParcelDialog(super.getParentWindow(), nearestParcel, Dialog.ModalityType.APPLICATION_MODAL, this.modelEnviroment, false){

                    @Override
                    protected boolean isExternalEditEnabled() {
                        return super.isExternalEditEnabled();
                    }
                };
                parcelDialog.setVisible(true);
            }
        }
    }

    public void setParcels(List<ParcelModel> parcels) {
        this.parcels = parcels;
    }

    @Override
    public String getName() {
        return "ParcelLayerRenderer";
    }

    @Override
    public void close() {
    }
}

