/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.parcel;

import de.datomino.peppergis.client.data.DataManagerAccess;
import de.datomino.peppergis.client.gui.Pausable;
import de.datomino.peppergis.client.gui.PausableInternalFrame;
import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.ParcelAddressPane;
import de.datomino.peppergis.client.gui.parcel.ParcelAreaRelationPane;
import de.datomino.peppergis.client.gui.parcel.ParcelAttributeValuePane;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.base.AttributeGroupModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import de.datomino.peppergis.type.AttributeGroupType;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.ktde.model.ValueChangeEvent;
import org.ktde.model.ValueChangeListener;
import org.ktde.swing.DesktopClientApplication;
import org.ktde.swing.InternalFrame;
import org.ktde.util.StringUtil;

public class ParcelDialog
extends CommonDialog
implements Pausable {
    private static final long serialVersionUID = -5108162019955430934L;
    private ModelEnviroment modelEnviroment;
    private boolean basicEnabled;
    private ParcelAddressPane basicParcelPane;
    private List<ParcelAttributeValuePane> parcelAttributeValuePanes;
    private ParcelModel parcelModel;
    private ParcelAreaRelationPane parcelAreaRelationPane;
    private boolean updateCoordinates;
    private PausableInternalFrame internalFrame;
    private ValueChangeListener valueChangeListener;

    public ParcelDialog(Window parent, ParcelModel parcelModel, Dialog.ModalityType modalityType, ModelEnviroment modelEnviroment, boolean basicEnabled) {
        this(parent, parcelModel, modalityType, modelEnviroment, basicEnabled, true);
    }

    public ParcelDialog(Window parent, ParcelModel parcelModel, Dialog.ModalityType modalityType, ModelEnviroment modelEnviroment, boolean basicEnabled, boolean updateCoordinates) {
        super((Component)parent, ParcelModelUtil.getAddress(parcelModel), modalityType);
        this.modelEnviroment = modelEnviroment;
        this.basicEnabled = basicEnabled;
        this.parcelModel = parcelModel;
        this.updateCoordinates = updateCoordinates;
        this.valueChangeListener = null;
        this.buildLayout();
    }

    @Override
    public void setVisible(boolean visible) {
        this.pack();
        this.setDefaultCloseOperation(2);
        SwingUtils.centerDialog(this, this.getParent());
        super.setVisible(visible);
        if (visible) {
            this.modelEnviroment.getUndoManager().startTransaction();
        }
    }

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = -4397484801573284278L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager undoManager = ParcelDialog.this.modelEnviroment.getUndoManager();
                undoManager.rollbackTransaction();
                ParcelDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        JTabbedPane tabbedPane = new JTabbedPane();
        this.basicParcelPane = new ParcelAddressPane(this.parcelModel, this.modelEnviroment, this.basicEnabled, this.basicEnabled);
        this.basicParcelPane.setEnabled(this.basicEnabled);
        tabbedPane.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.common", new Serializable[0]), this.basicParcelPane);
        Collection<AttributeGroupModel> groups = this.modelEnviroment.getAllCaller().getBaseCaller().getAttributeGroupForType(AttributeGroupType.PARCEL);
        this.parcelAttributeValuePanes = new ArrayList<ParcelAttributeValuePane>(groups.size());
        for (AttributeGroupModel group : groups) {
            ParcelAttributeValuePane parcelAttributeValuePane = new ParcelAttributeValuePane(this.parcelModel, Collections.singleton(group), this.modelEnviroment);
            parcelAttributeValuePane.fillValues(this.parcelModel);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)parcelAttributeValuePane, "North");
            tabbedPane.add(group.getName(), new JScrollPane(panel));
            this.parcelAttributeValuePanes.add(parcelAttributeValuePane);
        }
        this.parcelAreaRelationPane = new ParcelAreaRelationPane(this.parcelModel, this.modelEnviroment);
        tabbedPane.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.parcelAreaRelation", new Serializable[0]), this.parcelAreaRelationPane);
        this.valueChangeListener = new ValueChangeListener(){

            @Override
            public void valueChanged(ValueChangeEvent e) {
                if (ParcelDialog.this.basicParcelPane != null) {
                    ParcelDialog.this.basicParcelPane.setParcel(ParcelDialog.this.parcelModel);
                }
            }
        };
        this.parcelModel.addValueChangeListener(this.valueChangeListener);
        return tabbedPane;
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = -840373007899274035L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager undoManager = ParcelDialog.this.modelEnviroment.getUndoManager();
                undoManager.joinTransaction();
                undoManager.startTransaction();
                try {
                    ParcelDialog.this.basicParcelPane.adaptValuesToModel(ParcelDialog.this.updateCoordinates);
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(ParcelDialog.this, ModelEnviroment.getMessageResolver().resolveMessage("errors.import.coordsNotValid", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
                    return;
                }
                for (ParcelAttributeValuePane parcelAttributeValuePane : ParcelDialog.this.parcelAttributeValuePanes) {
                    parcelAttributeValuePane.adaptValuesToModel(ParcelDialog.this.parcelModel);
                }
                undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.attributesChanged", new Serializable[]{ParcelModelUtil.getAddress(ParcelDialog.this.parcelModel)}));
                ParcelDialog.this.dispose();
            }
        };
    }

    private static String createTitle(ParcelModel parcelModel) {
        StreetModel streetModel = parcelModel.getStreet();
        PostcodeDistrictRelationModel postcodeDistrictRelationModel = streetModel == null ? null : streetModel.getPostcodeDistrictRelation();
        DistrictModel districtModel = postcodeDistrictRelationModel == null ? null : postcodeDistrictRelationModel.getDistrict();
        PostcodeModel postcode = postcodeDistrictRelationModel == null ? null : postcodeDistrictRelationModel.getPostcode();
        StringBuilder sb = new StringBuilder(streetModel == null || streetModel.getName() == null ? "" : streetModel.getName()).append(" ");
        sb.append(parcelModel.getHouseNumber()).append(parcelModel.getHouseNumberExtension()).append(", ");
        if (postcode != null) {
            sb.append(postcode.getName()).append(" ");
        }
        if (districtModel != null) {
            sb.append(districtModel.getCity().getName());
            if (!StringUtil.isBlank(districtModel.getName())) {
                sb.append(" - ").append(districtModel.getName());
            }
        }
        return sb.toString();
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.basicParcelPane.setEnabled(this.basicEnabled && b);
        for (ParcelAttributeValuePane parcelAttributeValuePane : this.parcelAttributeValuePanes) {
            parcelAttributeValuePane.setEnabled(b);
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 200) {
            UndoManager undoManager = this.modelEnviroment.getUndoManager();
            undoManager.joinTransaction();
            undoManager.startTransaction();
        }
        super.processWindowEvent(e);
    }

    @Override
    protected Action[] getAdditionalActions() {
        Action[] actions2;
        Action[] superActions = super.getAdditionalActions();
        if (this.isExternalEditEnabled() && DataManagerAccess.isModelAllowedToEdit()) {
            actions2 = new Action[superActions.length + 1];
            System.arraycopy(superActions, 0, actions2, 0, superActions.length);
            actions2[actions2.length - 1] = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.edit", new Serializable[0])){
                private static final long serialVersionUID = 1508001147833279482L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesktopClientApplication<? extends InternalFrame> desktopClientApplication = ModelEnviroment.getDesktopClientApplication();
                    if (ParcelDialog.this.internalFrame != null) {
                        ParcelDialog.this.internalFrame.pause(ParcelDialog.this);
                    }
                    DataManagerAccess.showModel(desktopClientApplication, ParcelDialog.this.parcelModel);
                    if (ParcelDialog.this.internalFrame != null) {
                        ParcelDialog.this.internalFrame.unlockResume();
                    }
                }
            };
        } else {
            actions2 = superActions;
        }
        return actions2;
    }

    public void setInternalFrame(PausableInternalFrame internalFrame) {
        this.internalFrame = internalFrame;
    }

    protected boolean isExternalEditEnabled() {
        return true;
    }

    @Override
    public void pause() {
        this.setVisible(false);
    }

    @Override
    public void resume() {
        this.setVisible(true);
    }

    @Override
    protected boolean close() {
        if (this.valueChangeListener != null) {
            this.parcelModel.removeValueChangeListener(this.valueChangeListener);
        }
        return super.close();
    }
}

