/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.osm;

import de.datomino.peppergis.client.gui.osm.OsmTileQueue;
import de.datomino.peppergis.client.gui.osm.OsmUtil;
import de.datomino.util.Job;
import de.datomino.util.JobQueue;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleOsmTileLoadQueue
extends JobQueue<LoaderJob> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleOsmTileLoadQueue.class);
    private static final int DEFAULT_FETCH_PARENTS = 0;
    private static final int DEFAULT_PARALLEL_THREADS = 8;
    private static final int DEFAULT_INPUTSTREAM_TIMEOUT = 5000;
    private int fetchParents;
    private int inputStreamTimeout;
    private volatile int trackId = 1;
    private Object trackLock = new Object();
    private File localCache;
    private static volatile InvalidImageCleanerThread invalidImageCleanerThread;
    private OsmUtil.FetchMode fetchMode;

    public SimpleOsmTileLoadQueue(Properties properties) {
        this(properties, 8, 0);
    }

    public SimpleOsmTileLoadQueue(Properties properties, int parallelThreads, int fetchParents) {
        super(parallelThreads);
        this.fetchParents = fetchParents;
        this.inputStreamTimeout = 5000;
        this.localCache = OsmUtil.extractLocalcache(properties);
        SimpleOsmTileLoadQueue.startCleanerThread();
        this.fetchMode = OsmUtil.extractFetchMode(properties);
    }

    private static synchronized void startCleanerThread() {
        if (invalidImageCleanerThread == null) {
            invalidImageCleanerThread = new InvalidImageCleanerThread();
            invalidImageCleanerThread.start();
        }
    }

    public synchronized void enqueueWish(OsmTileQueue.OsmTile tile) {
        this.enqueueWish(tile, this.fetchParents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void enqueueWish(OsmTileQueue.OsmTile tile, int addParents) {
        OsmTileQueue.OsmTile parent;
        if (addParents > 0 && (parent = tile.getParent()) != null) {
            this.enqueueWish(parent, addParents - 1);
        }
        if (tile.getImage() == null) {
            int myTrackId;
            Object object = this.trackLock;
            synchronized (object) {
                myTrackId = this.trackId++;
            }
            this.enqueueJob(new LoaderJob(tile, myTrackId));
        }
    }

    protected boolean loadImage(Image image) throws InterruptedException {
        return true;
    }

    public int getInputStreamTimeout() {
        return this.inputStreamTimeout;
    }

    protected void repaint(long tm) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<LoaderJob> removeCut(Set<OsmTileQueue.OsmTile> tilesToLoad) {
        Object object = this.getQueueLock();
        synchronized (object) {
            LinkedHashSet queue = this.getQueuedJobs();
            HashSet<LoaderJob> toRemove = new HashSet<LoaderJob>();
            for (LoaderJob job : queue) {
                if (tilesToLoad.contains(job.getTile())) continue;
                toRemove.add(job);
            }
            queue.removeAll(toRemove);
            return toRemove;
        }
    }

    private static class InvalidTileElement {
        private OsmTileQueue.OsmTile osmTile;
        private long timeToWait;
        private SimpleOsmTileLoadQueue loadQueue;

        public InvalidTileElement(OsmTileQueue.OsmTile osmTile, long timeToWait, SimpleOsmTileLoadQueue loadQueue) {
            this.osmTile = osmTile;
            this.timeToWait = timeToWait;
            this.loadQueue = loadQueue;
        }

        public OsmTileQueue.OsmTile getOsmTile() {
            return this.osmTile;
        }

        public long getTimeToWait() {
            return this.timeToWait;
        }

        public SimpleOsmTileLoadQueue getLoadQueue() {
            return this.loadQueue;
        }
    }

    private static class InvalidImageCleanerThread
    extends Thread {
        private Queue<InvalidTileElement> queue = new LinkedList<InvalidTileElement>();
        private boolean shutdown = false;

        public InvalidImageCleanerThread() {
            super(InvalidImageCleanerThread.class.getName());
        }

        public synchronized void addTile(OsmTileQueue.OsmTile tile, SimpleOsmTileLoadQueue loadQueue) {
            this.queue.add(new InvalidTileElement(tile, System.currentTimeMillis(), loadQueue));
        }

        @Override
        public void run() {
            super.run();
            do {
                Tupel<Long, Collection<SimpleOsmTileLoadQueue>> tupel;
                Long timeToWait;
                if ((timeToWait = (tupel = this.checkQueue()).getElement1()) == null) {
                    timeToWait = 1000L;
                }
                tupel.getElement2().forEach(l -> l.repaint(10L));
                try {
                    Thread.sleep(timeToWait);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!this.shutdown);
        }

        private synchronized Tupel<Long, Collection<SimpleOsmTileLoadQueue>> checkQueue() {
            long timeToNext;
            long currentTime = System.currentTimeMillis();
            IdentityHashMap<SimpleOsmTileLoadQueue, Boolean> toRepaint = new IdentityHashMap<SimpleOsmTileLoadQueue, Boolean>();
            while (true) {
                InvalidTileElement peek;
                if ((peek = this.queue.peek()) == null) {
                    return new Tupel(null, toRepaint.keySet());
                }
                timeToNext = peek.getTimeToWait() + 1000L - currentTime;
                if (timeToNext > 0L) break;
                peek.getOsmTile().setImage(null);
                toRepaint.put(peek.getLoadQueue(), Boolean.TRUE);
                this.queue.poll();
            }
            return new Tupel<Long, Collection<SimpleOsmTileLoadQueue>>(timeToNext, toRepaint.keySet());
        }

        public void shutDown() {
            this.shutdown = true;
        }
    }

    protected class LoaderJob
    implements Job {
        private final OsmTileQueue.OsmTile tile;
        private int trackId;

        private LoaderJob(OsmTileQueue.OsmTile tile, int trackId) {
            this.tile = tile;
            this.trackId = trackId;
        }

        @Override
        public void run() {
            if (this.tile.getImage() != null) {
                return;
            }
            int zoom = this.tile.getZoom();
            int tx = this.tile.getX();
            int ty = this.tile.getY();
            boolean imageWasOk = false;
            Image image = null;
            try {
                image = OsmUtil.loadTile(tx, ty, zoom, SimpleOsmTileLoadQueue.this.localCache);
                imageWasOk = SimpleOsmTileLoadQueue.this.loadImage(image);
            }
            catch (Exception exception) {
                LOGGER.error("Exception while loadind " + this.tile, exception);
            }
            if (imageWasOk) {
                this.tile.setImage(image);
                SimpleOsmTileLoadQueue.this.repaint(100L);
            } else {
                File imageFileDir;
                File imageFile;
                if (SimpleOsmTileLoadQueue.this.localCache != null && (imageFile = new File((imageFileDir = new File(SimpleOsmTileLoadQueue.this.localCache, zoom + "/" + tx)) + "/" + ty + ".png")).exists()) {
                    LOGGER.error("delete " + imageFile);
                    imageFile.delete();
                }
                String filename = "";
                if (SimpleOsmTileLoadQueue.this.localCache != null) {
                    filename = SimpleOsmTileLoadQueue.this.localCache + "/" + zoom + "/" + tx + "/" + ty + ".png";
                }
                String urlname = zoom + "/" + tx + "/" + ty;
                this.tile.setImage(this.createErrorImage(filename, urlname));
                invalidImageCleanerThread.addTile(this.tile, SimpleOsmTileLoadQueue.this);
            }
        }

        private Image createErrorImage(String filename, String urlname) {
            BufferedImage image = new BufferedImage(256, 256, 1);
            Graphics2D g2d = image.createGraphics();
            g2d.setColor(Color.MAGENTA.brighter().brighter());
            g2d.fillRect(0, 0, 256, 256);
            g2d.setColor(Color.BLACK);
            g2d.drawString(filename, 10, 100);
            g2d.drawString(urlname, 10, 140);
            return image;
        }

        @Override
        public Exception getException() {
            return null;
        }

        @Override
        public String getName() {
            return "LoaderThread " + this.tile;
        }

        @Override
        public void kill() {
        }

        @Override
        public boolean success() {
            return true;
        }

        public String toString() {
            return this.getName();
        }

        public int hashCode() {
            return this.tile.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof LoaderJob && this.tile.equals(((LoaderJob)obj).tile);
        }

        public OsmTileQueue.OsmTile getTile() {
            return this.tile;
        }
    }
}

