/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.osm;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.dto.mapdata.TileDto;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.ktde.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OsmUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(OsmUtil.class);
    private static final ModelEnviroment OSM_MODEL_ENVIROMENT = new ModelEnviroment(null);

    public static Image loadTile(int tx, int ty, int zoom, File localcache) throws IOException {
        File expireFile2;
        TileDto tileDto;
        File imageFile;
        boolean writeExp;
        boolean writeFileToCache;
        Image image;
        block19: {
            boolean loadedLocal;
            image = null;
            writeFileToCache = false;
            writeExp = false;
            if (localcache != null) {
                imageFile = OsmUtil.getImageFile(tx, ty, zoom, localcache);
                if (!imageFile.exists()) {
                    tileDto = OSM_MODEL_ENVIROMENT.getAllCaller().getMapDataCaller().fetchTile(tx, ty, zoom);
                    loadedLocal = false;
                    writeFileToCache = true;
                    writeExp = true;
                } else {
                    expireFile2 = new File(imageFile.getParent(), imageFile.getName() + ".exp");
                    Date expired = null;
                    try {
                        expired = new Date(Long.parseLong(FileUtils.readFileToString(expireFile2)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    byte[] bytes = FileUtils.readFileToByteArray(imageFile);
                    if (expired == null || expired.before(new Date())) {
                        String hash = StringUtil.getMd5String(bytes);
                        tileDto = OSM_MODEL_ENVIROMENT.getAllCaller().getMapDataCaller().fetchTileOnlyIfModified(tx, ty, zoom, hash);
                        if (tileDto.isNotModified() || tileDto.getData() == null) {
                            tileDto.setData(bytes);
                            loadedLocal = true;
                        } else {
                            writeFileToCache = true;
                            loadedLocal = false;
                        }
                        writeExp = true;
                    } else {
                        tileDto = new TileDto();
                        tileDto.setData(bytes);
                        tileDto.setExpires(expired);
                        tileDto.setNotModified(true);
                        loadedLocal = true;
                    }
                }
            } else {
                tileDto = OSM_MODEL_ENVIROMENT.getAllCaller().getMapDataCaller().fetchTile(tx, ty, zoom);
                loadedLocal = false;
            }
            try {
                image = Toolkit.getDefaultToolkit().createImage(tileDto.getData());
            }
            catch (Exception ex) {
                if (!loadedLocal) break block19;
                tileDto = OSM_MODEL_ENVIROMENT.getAllCaller().getMapDataCaller().fetchTile(tx, ty, zoom);
                try {
                    image = Toolkit.getDefaultToolkit().createImage(tileDto.getData());
                }
                catch (Exception expireFile2) {
                    // empty catch block
                }
            }
        }
        if (image != null && localcache != null && writeFileToCache) {
            imageFile = OsmUtil.getImageFile(tx, ty, zoom, localcache);
            FileUtils.writeByteArrayToFile(imageFile, tileDto.getData());
            if (writeExp) {
                expireFile2 = new File(imageFile.getParent(), imageFile.getName() + ".exp");
                Date expires = tileDto.getExpires();
                if (expires == null) {
                    if (expireFile2.exists()) {
                        expireFile2.delete();
                    }
                } else {
                    FileUtils.writeStringToFile(expireFile2, Long.toString(expires.getTime()));
                }
            }
        }
        return image;
    }

    private static File getImageFile(int tx, int ty, int zoom, File localcache) {
        File imageFileDir = new File(localcache, zoom + "/" + tx);
        if (!imageFileDir.exists()) {
            imageFileDir.mkdirs();
        }
        File imageFile = new File(imageFileDir + "/" + ty + ".png");
        return imageFile;
    }

    public static File extractLocalcache(Properties properties) {
        String dirname;
        File localCache = null;
        if (properties != null && !StringUtil.isBlank(properties.getProperty("tileserver.localcache")) && !(localCache = new File(dirname = properties.getProperty("tileserver.localcache").replaceAll("~", System.getProperty("user.home")))).exists()) {
            LOGGER.debug("create tile cache dir " + localCache.getAbsolutePath());
            if (!localCache.mkdirs()) {
                localCache = null;
            }
        }
        return localCache;
    }

    public static FetchMode extractFetchMode(Properties properties) {
        FetchMode fetchMode = FetchMode.REGULAR;
        try {
            fetchMode = FetchMode.valueOf(properties.getProperty("tileserver.fetchMode"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fetchMode;
    }

    public static enum FetchMode {
        REGULAR,
        PREFER_LOCAL_CACHE;

    }

    public static enum TileFetchMethod {
        FILE,
        FORK,
        HOST;

    }
}

