/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.osm;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import java.awt.Image;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.StringUtil;
import org.ktde.util.application.DynamicAttributedProperties;
import org.ktde.util.datatypes.Tripel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmTileQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(OsmTileQueue.class);
    private int maxQueueDepth = 256;
    private int truncQueueCount = 256;
    private Set<OsmTile> tiles = new LinkedHashSet<OsmTile>();
    private Map<Tripel<Integer, Integer, Integer>, OsmTile> tileHash = new HashMap<Tripel<Integer, Integer, Integer>, OsmTile>();

    public OsmTileQueue() {
        this(null, null);
    }

    public OsmTileQueue(Integer maxQueueDepth, Integer truncQueueCount) {
        DynamicAttributedProperties properties = ModelEnviroment.getProperties();
        if (maxQueueDepth != null) {
            this.maxQueueDepth = maxQueueDepth;
        } else {
            String maxQueueDepthString = properties.getProperty("tileserver.maxQueueDepth");
            if (!StringUtil.isBlank(maxQueueDepthString)) {
                try {
                    this.maxQueueDepth = Integer.parseInt(maxQueueDepthString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (truncQueueCount != null) {
            this.truncQueueCount = truncQueueCount;
        } else {
            String truncQueueCountString = properties.getProperty("tileserver.truncQueueCount");
            if (!StringUtil.isBlank(truncQueueCountString)) {
                try {
                    this.truncQueueCount = Integer.parseInt(truncQueueCountString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized OsmTile createTile(int x, int y, int z) {
        Tripel<Integer, Integer, Integer> tripel;
        OsmTile osmTile;
        if (this.tiles.size() >= this.maxQueueDepth) {
            LOGGER.debug("truncate osm queue to " + this.truncQueueCount);
            Iterator<OsmTile> iter = this.tiles.iterator();
            int toDelete = this.tiles.size() - this.truncQueueCount;
            for (int i = 0; i < toDelete && iter.hasNext(); ++i) {
                OsmTile osmTile2 = iter.next();
                this.tileHash.remove(osmTile2.tripel);
                osmTile2.image = null;
                iter.remove();
            }
        }
        if ((osmTile = this.tileHash.get(tripel = new Tripel<Integer, Integer, Integer>(x, y, z))) == null) {
            osmTile = new OsmTile(tripel);
            this.tileHash.put(tripel, osmTile);
        }
        return osmTile;
    }

    public synchronized void touch(OsmTile tile) {
        this.tiles.remove(tile);
        this.tiles.add(tile);
        this.tileHash.put(tile.tripel, tile);
    }

    static double tile2lon(int x, double z) {
        double n = Math.pow(2.0, z);
        return (double)x / n * 360.0 - 180.0;
    }

    static double tile2lat(int y, double z) {
        double n = Math.pow(2.0, z);
        double lat_rad = Math.atan(Math.sinh(Math.PI * (1.0 - 2.0 * (double)y / n)));
        return Math.toDegrees(lat_rad);
    }

    public class OsmTile {
        private OsmTile parent;
        private Image image;
        private Tripel<Integer, Integer, Integer> tripel;
        private double westWgs;
        private double northWgs;
        private double eastWgs;
        private double southWgs;
        private Coordinate coordNorthWest;
        private Coordinate coordSouthEast;

        private OsmTile(Tripel<Integer, Integer, Integer> tripel) {
            this.tripel = tripel;
            this.image = null;
            int x = this.tripel.getElement1();
            int y = this.tripel.getElement2();
            int z = this.tripel.getElement3();
            this.westWgs = OsmTileQueue.tile2lon(x, z);
            this.northWgs = OsmTileQueue.tile2lat(y, z);
            this.eastWgs = OsmTileQueue.tile2lon(x + 1, z);
            this.southWgs = OsmTileQueue.tile2lat(y + 1, z);
            this.coordNorthWest = Wgs84Factory.INSTANCE.createCoordinate(this.westWgs, this.northWgs);
            this.coordSouthEast = Wgs84Factory.INSTANCE.createCoordinate(this.eastWgs, this.southWgs);
        }

        public Image getImage() {
            return this.image;
        }

        public OsmTile getParent() {
            int z;
            if (this.parent == null && (z = this.tripel.getElement3().intValue()) > 0) {
                int x = this.tripel.getElement1();
                int y = this.tripel.getElement2();
                this.parent = OsmTileQueue.this.createTile(x / 2, y / 2, z - 1);
            }
            return this.parent;
        }

        public Coordinate getCoordNorthWest() {
            return this.coordNorthWest;
        }

        public Coordinate getCoordSouthEast() {
            return this.coordSouthEast;
        }

        public void setImage(Image image) {
            OsmTileQueue.this.touch(this);
            this.image = image;
        }

        public int getZoom() {
            return this.tripel.getElement3();
        }

        public int getX() {
            return this.tripel.getElement1();
        }

        public int getY() {
            return this.tripel.getElement2();
        }

        public String toString() {
            return "Tile x:" + this.getX() + " y:" + this.getY() + " z:" + this.getZoom();
        }

        public int hashCode() {
            return this.tripel.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof OsmTile && this.tripel.equals(((OsmTile)obj).tripel);
        }
    }
}

