/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.osm;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.osm.AbstractOsmSvgExportFetcherException;
import de.datomino.peppergis.client.gui.osm.OsmSvgExportFetcherMapTooLargeException;
import de.datomino.peppergis.client.gui.osm.OsmSvgExportFetcherServerTooBusyException;
import de.datomino.util.communication.HttpResponse;
import de.datomino.util.communication.HttpUtil;
import java.io.IOException;
import org.apache.http.HttpException;
import org.ktde.math.helper.ComputeTrigonometrics;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmSvgExportFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(OsmSvgExportFetcher.class);
    private String url = "http://parent.tile.openstreetmap.org/cgi-bin/export?";
    private static final double ROUNDING_FACTOR = 1000.0;
    private static final int MAX_SVG_SIZE = 0x1900000;

    public Tripel<String, Coordinate, Coordinate> fetchSvg(Coordinate topLeft, Coordinate bottomRight, double widthMM, double heightMM, double marginX, double marginY, boolean fillUpSpace) throws IOException, HttpException, AbstractOsmSvgExportFetcherException {
        double distY;
        double rDistY;
        Coordinate topLeftWgs = this.normalize(Wgs84Factory.INSTANCE.createCoordinate(topLeft), true, false, marginX, marginY);
        Coordinate bottomRightWgs = this.normalize(Wgs84Factory.INSTANCE.createCoordinate(bottomRight), false, true, marginX, marginY);
        if (fillUpSpace) {
            Tupel<Coordinate, Coordinate> tupel = this.fillupSpace(topLeftWgs, bottomRightWgs, widthMM, heightMM);
            topLeftWgs = tupel.getElement1();
            bottomRightWgs = tupel.getElement2();
        }
        Coordinate topRightWgs = Wgs84Factory.INSTANCE.createCoordinate(bottomRightWgs.getX(), topLeftWgs.getY());
        Coordinate bottomLeftWgs = Wgs84Factory.INSTANCE.createCoordinate(topLeftWgs.getX(), bottomRightWgs.getY());
        double distX = ComputeTrigonometrics.getSphericalDistance(topLeftWgs, topRightWgs);
        double rDistX = distX / widthMM;
        double scale = rDistX > (rDistY = (distY = ComputeTrigonometrics.getSphericalDistance(topLeftWgs, bottomLeftWgs)) / heightMM) ? distX * 1000.0 / widthMM : distY * 1000.0 / heightMM;
        scale *= 1.0 + Math.log10(scale) / 2.0;
        LOGGER.info("Scale: " + scale);
        StringBuilder urlBuilder = new StringBuilder(this.url);
        urlBuilder.append("bbox=");
        urlBuilder.append(this.formatDouble(topLeftWgs.getX())).append(",");
        urlBuilder.append(this.formatDouble(bottomRightWgs.getY())).append(",");
        urlBuilder.append(this.formatDouble(bottomRightWgs.getX())).append(",");
        urlBuilder.append(this.formatDouble(topLeftWgs.getY()));
        urlBuilder.append("&scale=").append(Math.round(scale));
        urlBuilder.append("&format=svg");
        String request = urlBuilder.toString();
        int retryCount = 20;
        try {
            retryCount = Integer.parseInt(ModelEnviroment.getProperties().getProperty("print.area.svgRetryCount"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        long gap = 500L;
        try {
            gap = Long.parseLong(ModelEnviroment.getProperties().getProperty("print.area.svgRetryGap"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int tryCount = 1;
        while (true) {
            LOGGER.info("Requesting (" + tryCount + "): " + request);
            HttpResponse httpResponse = HttpUtil.get(request);
            boolean ok = true;
            try {
                String contentType = httpResponse.getHeaders().get("Content-Type");
                if (!contentType.equals("image/svg+xml")) {
                    this.throwException(httpResponse.getContentAsString());
                }
            }
            catch (OsmSvgExportFetcherServerTooBusyException ex) {
                ok = false;
                if (tryCount == retryCount) {
                    throw ex;
                }
                try {
                    Thread.sleep(gap);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (ok) {
                String content = httpResponse.getContentAsString();
                LOGGER.info("Svg - fetched (" + content.length() / 1024 + "k)");
                if (content.length() > 0x1900000) {
                    throw new OsmSvgExportFetcherMapTooLargeException();
                }
                return new Tripel<String, Coordinate, Coordinate>(content, topLeftWgs, bottomRightWgs);
            }
            ++tryCount;
        }
    }

    private void throwException(String contentAsString) throws AbstractOsmSvgExportFetcherException {
        LOGGER.warn(contentAsString);
        if (contentAsString.contains("Map too large")) {
            throw new OsmSvgExportFetcherMapTooLargeException();
        }
        throw new OsmSvgExportFetcherServerTooBusyException();
    }

    private Tupel<Coordinate, Coordinate> fillupSpace(Coordinate topLeftWgs, Coordinate bottomRightWgs, double widthMM, double heightMM) {
        Coordinate topRightWgs = Wgs84Factory.INSTANCE.createCoordinate(bottomRightWgs.getX(), topLeftWgs.getY());
        Coordinate bottomLeftWgs = Wgs84Factory.INSTANCE.createCoordinate(topLeftWgs.getX(), bottomRightWgs.getY());
        double distX = ComputeTrigonometrics.getSphericalDistance(topLeftWgs, topRightWgs);
        double distY = ComputeTrigonometrics.getSphericalDistance(topLeftWgs, bottomLeftWgs);
        double lx = topLeftWgs.getX();
        double rx = bottomRightWgs.getX();
        double cDistX = rx - lx;
        double ty = topLeftWgs.getY();
        double by = bottomRightWgs.getY();
        double cDistY = ty - by;
        double rWidth = distX / widthMM;
        double rHeight = distY / heightMM;
        if (rWidth > rHeight) {
            double growY = rWidth / rHeight * distY;
            double dist = growY - distY;
            dist = dist / distY * cDistY;
            ty += (dist /= 2.0);
            by -= dist;
            ty = Math.ceil(ty * 1000.0) / 1000.0;
            by = Math.floor(by * 1000.0) / 1000.0;
        } else if (rHeight > rWidth) {
            double growX = rHeight / rWidth * distX;
            double dist = growX - distX;
            dist = dist / distX * cDistX;
            lx -= (dist /= 2.0);
            rx += dist;
            lx = Math.floor(lx * 1000.0) / 1000.0;
            rx = Math.ceil(rx * 1000.0) / 1000.0;
        }
        return new Tupel<Coordinate, Coordinate>(Wgs84Factory.INSTANCE.createCoordinate(lx, ty), Wgs84Factory.INSTANCE.createCoordinate(rx, by));
    }

    private Coordinate normalize(Coordinate coordinate, boolean lowerX, boolean lowerY, double marginX, double marginY) {
        double x = coordinate.getX();
        double y = coordinate.getY();
        Coordinate refX = Wgs84Factory.INSTANCE.createCoordinate(x + 0.1, y);
        double xDist = ComputeTrigonometrics.getSphericalDistance(coordinate, refX);
        double rMarginX = 0.1 / xDist * marginX;
        Coordinate refY = Wgs84Factory.INSTANCE.createCoordinate(x, y + 0.1);
        double yDist = ComputeTrigonometrics.getSphericalDistance(coordinate, refY);
        double rMarginY = 0.1 / yDist * marginY;
        x += lowerX ? -rMarginX : rMarginX;
        y += lowerY ? -rMarginY : rMarginY;
        x = lowerX ? Math.floor(x) : Math.ceil(x *= 1000.0);
        y = lowerY ? Math.floor(y) : Math.ceil(y *= 1000.0);
        return Wgs84Factory.INSTANCE.createCoordinate(x / 1000.0, y / 1000.0);
    }

    private String formatDouble(double value) {
        if (value == 0.0) {
            return "0";
        }
        long newValue = Math.round(value * 1000.0);
        String string = Long.toString(newValue);
        int length = string.length() - (int)Math.log10(1000.0);
        return string.substring(0, length) + "." + string.substring(length);
    }
}

