/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.osm;

import de.datomino.peppergis.client.gui.osm.OsmTileLoadQueue;
import de.datomino.peppergis.client.gui.osm.OsmTileQueue;
import de.datomino.peppergis.client.gui.osm.SimpleOsmTileLoadQueue;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.swing.ImageLoaderListener;
import org.ktde.swing.navigator.AbstractNavigatorRenderer;
import org.ktde.swing.navigator.MapNavigatorRenderer;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOsmNavigatorRenderer
extends AbstractNavigatorRenderer
implements ImageLoaderListener,
MapNavigatorRenderer {
    private static Logger LOGGER = LoggerFactory.getLogger(AbstractOsmNavigatorRenderer.class);
    private OsmTileQueue osmTileQueue = new OsmTileQueue();
    private OsmTileLoadQueue osmTileLoadQueue;
    private SimpleOsmTileLoadQueue osmCacheTileLoadQueue;
    private int maxZoom = 18;
    private int minZoom = 0;
    private Point2D.Double blPoint;
    private Point2D.Double trPoint;
    private boolean forceReload = false;
    protected Properties properties;
    private boolean moveToCacheQueue;
    private boolean drawFilePath;

    public AbstractOsmNavigatorRenderer(String name, Properties properties) {
        super(name);
        this.properties = properties;
        this.readProperties(properties);
        if (this.moveToCacheQueue) {
            this.osmCacheTileLoadQueue = new SimpleOsmTileLoadQueue(properties, 2, 0);
        }
    }

    private void readProperties(Properties properties) {
        String moveToCacheQueueString;
        int maxzoomValue;
        String maxzoomProp = properties.getProperty("tileserver.maxzoom");
        if (maxzoomProp != null && (maxzoomValue = Integer.parseInt(maxzoomProp)) > this.minZoom) {
            this.maxZoom = maxzoomValue;
        }
        this.moveToCacheQueue = (moveToCacheQueueString = properties.getProperty("tileserver.moveToCacheQueue")) == null || StringUtil.isTrue(moveToCacheQueueString);
        this.drawFilePath = StringUtil.isTrue(properties.getProperty("tileserver.drawFilePath"));
    }

    @Override
    public synchronized void loadImage() {
        if (this.isActive()) {
            NavigatorPanel navigatorPanel = this.getPanel();
            Point2D.Double blPointNow = navigatorPanel.getRealBoundaryBottomLeft();
            Point2D.Double trPointNow = navigatorPanel.getRealBoundaryTopRight();
            boolean loadImages = false;
            if (this.forceReload || blPointNow != this.blPoint || trPointNow != this.trPoint) {
                loadImages = true;
                this.blPoint = blPointNow;
                this.trPoint = trPointNow;
            }
            HashSet<OsmTileQueue.OsmTile> tilesToLoad = new HashSet<OsmTileQueue.OsmTile>();
            block0: while (loadImages) {
                this.forceReload = false;
                loadImages = false;
                if (this.blPoint == null || this.trPoint == null) {
                    return;
                }
                CoordinateFactory navFactory = this.getCoordinateFactory();
                Coordinate bl = Wgs84Factory.INSTANCE.createCoordinate(navFactory.createCoordinate(this.blPoint.getX(), this.blPoint.getY()));
                Coordinate tr = Wgs84Factory.INSTANCE.createCoordinate(navFactory.createCoordinate(this.trPoint.getX(), this.trPoint.getY()));
                int zoom = this.computeZoom(navigatorPanel.getUpp());
                Tripel<Integer, Integer, Integer> helperMin = AbstractOsmNavigatorRenderer.getTileNumber(bl.getX(), tr.getY(), zoom);
                Tripel<Integer, Integer, Integer> helperMax = AbstractOsmNavigatorRenderer.getTileNumber(tr.getX(), bl.getY(), zoom);
                int mintx = helperMin.getElement2();
                int maxtx = helperMax.getElement2();
                int minty = helperMin.getElement3();
                int maxty = helperMax.getElement3();
                int maxtile = 1 << zoom;
                if (mintx < 0) {
                    mintx = 0;
                }
                if (maxtx >= maxtile) {
                    maxtx = maxtile - 1;
                }
                if (maxtx < mintx) {
                    maxtx = mintx;
                }
                if (minty < 0) {
                    minty = 0;
                }
                if (maxty >= maxtile) {
                    maxty = maxtile - 1;
                }
                if (maxty < minty) {
                    maxty = minty;
                }
                for (int tx = mintx; tx <= maxtx; ++tx) {
                    for (int ty = minty; ty <= maxty; ++ty) {
                        blPointNow = navigatorPanel.getRealBoundaryBottomLeft();
                        trPointNow = navigatorPanel.getRealBoundaryTopRight();
                        if (blPointNow != this.blPoint || trPointNow != this.trPoint) {
                            loadImages = true;
                            this.blPoint = blPointNow;
                            this.trPoint = trPointNow;
                            continue block0;
                        }
                        OsmTileQueue.OsmTile tile = this.osmTileQueue.createTile(tx, ty, zoom);
                        this.osmTileLoadQueue.enqueueWish(tile);
                        tilesToLoad.add(tile);
                    }
                }
                loadImages |= this.forceReload;
            }
            Collection<SimpleOsmTileLoadQueue.LoaderJob> removeCut = this.osmTileLoadQueue.removeCut(tilesToLoad);
            if (this.moveToCacheQueue) {
                this.osmCacheTileLoadQueue.enqueueJobs(removeCut);
            }
        }
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        this.loadImage();
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        Point2D.Double blPoint = realBoundaryBottomLeft;
        Point2D.Double trPoint = realBoundaryTopRight;
        CoordinateFactory navFactory = this.getCoordinateFactory();
        Coordinate bl = Wgs84Factory.INSTANCE.createCoordinate(navFactory.createCoordinate(blPoint.getX(), blPoint.getY()));
        Coordinate tr = Wgs84Factory.INSTANCE.createCoordinate(navFactory.createCoordinate(trPoint.getX(), trPoint.getY()));
        int zoom = this.computeZoom(upp);
        Tripel<Integer, Integer, Integer> helperMin = AbstractOsmNavigatorRenderer.getTileNumber(bl.getX(), tr.getY(), zoom);
        Tripel<Integer, Integer, Integer> helperMax = AbstractOsmNavigatorRenderer.getTileNumber(tr.getX(), bl.getY(), zoom);
        int mintx = helperMin.getElement2();
        int maxtx = helperMax.getElement2();
        int minty = helperMin.getElement3();
        int maxty = helperMax.getElement3();
        HashMap<Integer, HashSet<OsmTileQueue.OsmTile>> todraw = new HashMap<Integer, HashSet<OsmTileQueue.OsmTile>>();
        TreeSet<Integer> zoomlevels = new TreeSet<Integer>();
        for (int tx = mintx; tx <= maxtx; ++tx) {
            for (int ty = minty; ty <= maxty; ++ty) {
                OsmTileQueue.OsmTile tile = this.osmTileQueue.createTile(tx, ty, zoom);
                Image image = tile.getImage();
                int MAX_ZOOM_DELTA = 0;
                for (int check = 0; check < MAX_ZOOM_DELTA && image == null; ++check) {
                    this.forceReload = true;
                    OsmTileQueue.OsmTile parent = tile.getParent();
                    if (parent == null) break;
                    tile = parent;
                    image = tile.getImage();
                }
                if (image == null) continue;
                int knownzoom = tile.getZoom();
                zoomlevels.add(knownzoom);
                HashSet<OsmTileQueue.OsmTile> list = (HashSet<OsmTileQueue.OsmTile>)todraw.get(knownzoom);
                if (list == null) {
                    list = new HashSet<OsmTileQueue.OsmTile>();
                    todraw.put(knownzoom, list);
                }
                list.add(tile);
            }
        }
        for (Integer zoomlevel : zoomlevels) {
            for (OsmTileQueue.OsmTile tile : (Set)todraw.get(zoomlevel)) {
                this.osmTileQueue.touch(tile);
                Image image = tile.getImage();
                Coordinate nwNav = navFactory.createCoordinate(tile.getCoordNorthWest());
                Coordinate seNav = navFactory.createCoordinate(tile.getCoordSouthEast());
                g2d.drawImage(image, (int)nwNav.getX(), (int)nwNav.getY(), (int)seNav.getX(), (int)seNav.getY(), 0, 0, 256, 256, null);
                if (this.drawFilePath) {
                    AffineTransform affineTransform = g2d.getTransform();
                    Color color = Color.RED;
                    g2d.setColor(color);
                    double scaleX = affineTransform.getScaleX() / 1.5;
                    double scaleY = affineTransform.getScaleY() / 1.5;
                    AffineTransform flip = AffineTransform.getScaleInstance(1.0 / scaleX, 1.0 / scaleY);
                    g2d.transform(flip);
                    FontMetrics fontMetrics = g2d.getFontMetrics();
                    Point2D.Double dst = new Point2D.Double();
                    double realX = nwNav.getX();
                    double realY = nwNav.getY();
                    AffineTransform.getScaleInstance(scaleX, scaleY).transform(new Point2D.Double(realX, realY), dst);
                    g2d.drawString(tile.getZoom() + "/" + tile.getX() + "/" + tile.getY(), (float)(dst.getX() + 10.0), (float)(dst.getY() + 30.0));
                    g2d.setTransform(affineTransform);
                }
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.trace("g2d.drawImage(image, " + (int)nwNav.getX() + ", " + (int)nwNav.getY() + ", " + (int)seNav.getX() + ", " + (int)seNav.getY() + ", 0, 0, 256, 256, null);");
            }
        }
        return Collections.emptyList();
    }

    public static Tripel<Integer, Integer, Integer> getTileNumber(double lon, double lat, int zoom) {
        int maxtile = 1 << zoom;
        int xtile = (int)Math.floor((lon + 180.0) / 360.0 * (double)maxtile);
        int ytile = (int)Math.floor((1.0 - Math.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) / 2.0 * (double)maxtile);
        return new Tripel<Integer, Integer, Integer>(zoom, xtile, ytile);
    }

    private int computeZoom(double upp) {
        double upp0 = 140625.0;
        double zoomD = Math.log(upp0 / upp) / Math.log(2.0);
        int zoom = Math.min(Math.max((int)zoomD, this.minZoom), this.maxZoom);
        return zoom;
    }

    @Override
    public void close() {
        super.close();
    }

    protected void joinOsmTileLoadQueue() {
        this.osmTileLoadQueue.join();
    }

    protected void setOsmTileLoadQueue(OsmTileLoadQueue osmTileLoadQueue) {
        this.osmTileLoadQueue = osmTileLoadQueue;
    }

    protected void setOsmTileQueue(OsmTileQueue osmTileQueue) {
        this.osmTileQueue = osmTileQueue;
    }
}

